/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.GUIAdapter;
import ftjava.gui.PlotEnvelope;
import ftjava.gui.Preferences;
import ftjava.gui.StarMap;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.AntiMatterTorpedoLauncher;
import ftjava.std.BeamBattery;
import ftjava.std.GameEngine;
import ftjava.std.Graser;
import ftjava.std.KineticGun;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.PulseTorpedo;
import ftjava.std.Pulser;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Ship;
import ftjava.std.SubmunitionPack;
import ftjava.std.Weapon;
import ftjava.util.MovementSteps;
import ftjava.util.PointContainer;
import ftjava.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ShipGUIAdapter
implements GUIAdapter,
Comparable {
    public static int minimumRank = 0;
    public static int maximumRank = 0;
    public static final int ARCNONE = -1;
    public static final int ARCRANGE = 0;
    public static final int ARCBEAM = 1;
    public static final int ARCPTORP = 2;
    public static final int ARCSPACK = 3;
    public static final int PLOTENVELOPE = 4;
    public static final int GHOSTPLOT = 5;
    public static final int CLEARDISPLAY = 6;
    public static final int LOCKONS = 7;
    public static final int GHOSTTRAIL = 8;
    public static final int ARCKGUN = 9;
    public static final int ARCSALVO = 10;
    public static final int ARCPLASMA = 11;
    public static final int ARCPULSER = 12;
    public static final int ARCPDEFENSE = 13;
    public static final int ARCSCATTER = 14;
    public static final int ARCSENSOR = 15;
    public static final int ARCGRASER = 16;
    public static final int ARCAMT = 17;
    public static BufferedImage Explosion = null;
    public static BufferedImage Explosion1 = null;
    public static BufferedImage Explosion2 = null;
    public static BufferedImage Explosion3 = null;
    public static BufferedImage Explosion4 = null;
    public static BufferedImage Explosion5 = null;
    public static BufferedImage Explosion6 = null;
    public static BufferedImage Explosion7 = null;
    public static BufferedImage Explosion8 = null;
    public static BufferedImage Explosion9 = null;
    public static BufferedImage Explosion10 = null;
    public static BufferedImage Explosion11 = null;
    public static BufferedImage Explosion12 = null;
    public static BufferedImage Jump1 = null;
    public static BufferedImage Jump2 = null;
    public static BufferedImage Jump3 = null;
    public static BufferedImage Jump4 = null;
    public static BufferedImage Jump5 = null;
    public static BufferedImage Jump6 = null;
    public static BufferedImage Arrival1 = null;
    public static BufferedImage Arrival2 = null;
    public static BufferedImage Arrival3 = null;
    public static BufferedImage Arrival4 = null;
    public static BufferedImage Arrival5 = null;
    public static BufferedImage Arrival6 = null;
    private Ship ship;
    private GameEngine engine;
    private int rank;
    private BufferedImage Icon = null;
    private BufferedImage Arrival = null;
    private boolean removed;
    private MovementSteps movementSteps;
    private double plottedX;
    private double plottedY;
    private int plottedHeading;
    private boolean plottedRoll;
    private double pastX;
    private double pastY;
    private int pastHeading;
    private int arcOption = 0;
    private boolean showPlotEnvelope = false;
    private boolean showGhostPlot = false;
    private boolean showGhostTrail = false;
    private boolean showLockOns = false;
    private BufferedImage[] cachedImages = new BufferedImage[13];
    public static final int F = 0;
    public static final int FP = 1;
    public static final int FS = 2;
    public static final int AP = 3;
    public static final int AS = 4;
    public static final int A = 5;
    public static final int[] arcAngles;
    private ArrayList rangeList;
    private double[] arcRange = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private int[][] beamRange = new int[6][6];
    private int[][] rolledBeamRange = new int[6][6];
    private boolean beamRangeFilled = false;
    private int[][] pulseTorpedoRange = new int[6][6];
    private int[][] rolledPulseTorpedoRange = new int[6][6];
    private boolean pulseTorpedoRangeFilled = false;
    private int[][] graserRange = new int[6][6];
    private int[][] rolledGraserRange = new int[6][6];
    private boolean graserRangeFilled = false;
    private int[][] antiMatterTorpedoRange = new int[6][1];
    private boolean antiMatterTorpedoRangeFilled = false;
    private int[][] kGunRange = new int[6][6];
    private int[][] rolledKGunRange = new int[6][6];
    private boolean kGunRangeFilled = false;
    private int[][] salvoMissileRange = new int[6][2];
    private int[][] rolledSalvoMissileRange = new int[6][2];
    private boolean salvoMissileRangeFilled = false;
    private int[][] plasmaBoltRange = new int[6][1];
    private int[][] rolledPlasmaBoltRange = new int[6][1];
    private boolean plasmaBoltRangeFilled = false;
    private int[][] pulserRange = new int[6][3];
    private int[][] rolledPulserRange = new int[6][3];
    private boolean pulserRangeFilled = false;
    private int[][] submunitionPackRange = new int[6][6];
    private int[][] rolledSubmunitionPackRange = new int[6][6];
    private boolean submunitionPackRangeFilled = false;
    private StarMap map = null;

    public ShipGUIAdapter(GameEngine e, Ship s, int initialRank) {
        this.ship = s;
        this.engine = e;
        this.rank = minimumRank;
        this.Icon = null;
        this.removed = false;
        String BasePath = "Images/ShipIcons/";
        String Path2 = null;
        String shipRace = null;
        String shipClass = null;
        String shipName = null;
        this.movementSteps = s.getMovementSteps();
        this.resetPlotPosition();
        this.pastX = s.getPastX();
        this.pastY = s.getPastY();
        this.pastHeading = s.getPastHeading();
        for (int i = 0; i < 13; ++i) {
            this.cachedImages[i] = null;
        }
        String iconPath = this.ship.getIconFamily();
        shipRace = this.ship.getRace();
        if (shipRace.equals("Kra'Vak")) {
            shipRace = "Kravak";
        }
        shipRace = StringUtils.scrubAlienName(shipRace);
        shipClass = StringUtils.scrubAlienName(this.ship.getClassName());
        shipName = StringUtils.scrubAlienName(this.ship.getName());
        String t = Preferences.getPreferences().getProperty("Use Phalon Icons");
        if (t.equals("false") && shipRace.equals("Phalon")) {
            shipRace = "Papa";
        }
        if (iconPath != null) {
            String baseIconPath = BasePath + iconPath + "/";
            Path2 = baseIconPath + shipName;
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
            if (this.Icon == null) {
                Path2 = baseIconPath + shipClass;
                this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
            }
            if (this.Icon == null) {
                Path2 = baseIconPath + this.ship.getClassAbbrev();
                this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
            }
        }
        if (this.Icon == null) {
            Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + shipRace + "/" + shipName;
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + shipRace + "/" + shipClass;
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + shipRace + "/" + this.ship.getClassAbbrev();
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + this.engine.getOptions().getVariant() + "/Generic/" + this.ship.getClassAbbrev();
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + "/Generic/" + shipRace + "/" + this.ship.getClassAbbrev();
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + "Generic/" + this.ship.getClassAbbrev();
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon == null) {
            Path2 = BasePath + "Generic/GenericShipIcon";
            this.Icon = ImageUtilities.getShipImage(Path2, this.ship.getPlayer().getColor());
        }
        if (this.Icon != null) {
            this.Icon.getRGB(0, 0);
        }
    }

    public void setRemoved() {
        this.removed = true;
    }

    public boolean getRemoved() {
        return this.removed;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int r) {
        this.rank = r;
    }

    public int getArcOption() {
        return this.arcOption;
    }

    public void setShowArcOption(int arc) {
        if (this.ship.isDestroyed() || this.ship.hasJumped()) {
            arc = -1;
        }
        this.arcOption = arc;
    }

    public String toString() {
        return this.getShip().toString();
    }

    public int compareTo(Object o) {
        ShipGUIAdapter s = (ShipGUIAdapter)o;
        int c = this.getShip().getPlayer().getName().compareTo(s.getShip().getPlayer().getName());
        if (c == 0) {
            c = this.getShip().getName().compareTo(s.getShip().getName());
        }
        return c;
    }

    public boolean getShowPlotEnvelope() {
        return this.showPlotEnvelope;
    }

    public void setShowPlotEnvelope(boolean show) {
        if (this.ship.isDestroyed() || this.ship.hasJumped()) {
            show = false;
        }
        this.showPlotEnvelope = show;
    }

    public void showPlotEnvelope() {
        this.setShowPlotEnvelope(true);
    }

    public void hidePlotEnvelope() {
        this.setShowPlotEnvelope(false);
    }

    public boolean getShowGhostPlot() {
        return this.showGhostPlot;
    }

    public void setShowGhostPlot(boolean show) {
        if (this.ship.isDestroyed() || this.ship.hasJumped()) {
            show = false;
        }
        this.showGhostPlot = show;
    }

    public void showGhostPlot() {
        this.setShowGhostPlot(true);
    }

    public void hideGhostPlot() {
        this.setShowGhostPlot(false);
    }

    public boolean getShowGhostTrail() {
        return this.showGhostTrail;
    }

    public void setShowGhostTrail(boolean show) {
        if (this.ship.isDestroyed() || this.ship.hasJumped()) {
            show = false;
        }
        if (this.pastHeading == 13) {
            show = false;
        }
        this.showGhostTrail = show;
    }

    public void showGhostTrail() {
        this.setShowGhostTrail(true);
    }

    public void hideGhostTrail() {
        this.setShowGhostTrail(false);
    }

    public boolean getShowLockOns() {
        return this.showLockOns;
    }

    public void setShowLockOns(boolean show) {
        if (this.ship.isDestroyed() || this.ship.hasJumped()) {
            show = false;
        }
        this.showLockOns = show;
    }

    public void showLockOns() {
        this.setShowLockOns(true);
    }

    public void hideLockOns() {
        this.setShowLockOns(false);
    }

    public GameEngine getGameEngine() {
        return this.engine;
    }

    public Ship getShip() {
        return this.ship;
    }

    public int getId() {
        return this.ship.getId();
    }

    public JMenu getMenu() {
        double range;
        double band = this.engine.getOptions().getBeamRangeBand();
        JMenu shipMenu = new JMenu(this.ship.getName());
        JMenuItem item = new JMenuItem("Clear All Information");
        item.addActionListener(new ClearAll());
        shipMenu.add(item);
        JMenu menu = new JMenu("Arcs");
        shipMenu.add(menu);
        JMenu subMenu = new JMenu("All");
        menu.add(subMenu);
        item = new JMenuItem("Clear");
        item.addActionListener(new ClearArcRange());
        subMenu.add(item);
        for (range = band; range < band * 5.0; range += band) {
            item = new JMenuItem(Double.toString(range));
            item.addActionListener(new SetArcRange(-1, range));
            subMenu.add(item);
        }
        for (int arc = 0; arc < 6; ++arc) {
            JMenu arcMenu = new JMenu(this.getArcName(arc));
            menu.add(arcMenu);
            item = new JMenuItem("Off");
            item.addActionListener(new SetArcRange(arc, 0.0));
            arcMenu.add(item);
            for (range = band; range < band * 5.0; range += band) {
                item = new JMenuItem(Double.toString(range));
                item.addActionListener(new SetArcRange(arc, range));
                arcMenu.add(item);
            }
        }
        item = new JMenuItem("Plot Envelope");
        item.addActionListener(new TogglePlotEnvelope());
        shipMenu.add(item);
        item = new JMenuItem("Ghost Plot");
        item.addActionListener(new ToggleGhostPlot());
        shipMenu.add(item);
        item = new JMenuItem("Ghost Trail");
        item.addActionListener(new ToggleGhostTrail());
        shipMenu.add(item);
        item = new JMenuItem("Lock Ons");
        item.addActionListener(new ToggleLockOns());
        shipMenu.add(item);
        item = new JMenuItem("Sensors");
        item.addActionListener(new SetArcSensor());
        shipMenu.add(item);
        shipMenu.addSeparator();
        if (this.ship.hasBeams()) {
            item = new JMenuItem("Beam");
            item.addActionListener(new SetArcBeam());
            shipMenu.add(item);
        }
        if (this.ship.hasPulseTorps()) {
            item = new JMenuItem("Pulse Torpedo");
            item.addActionListener(new SetArcPTorp());
            shipMenu.add(item);
        }
        if (this.ship.hasGrasers()) {
            item = new JMenuItem("Graser");
            item.addActionListener(new SetArcGraser());
            shipMenu.add(item);
        }
        if (this.ship.hasAntiMatterTorpedos()) {
            item = new JMenuItem("AntiMatter Torpedo");
            item.addActionListener(new SetArcAntiMatter());
            shipMenu.add(item);
        }
        if (this.ship.hasSalvoMissiles()) {
            item = new JMenuItem("Salvo Missiles");
            item.addActionListener(new SetArcSalvo());
            shipMenu.add(item);
        }
        if (this.ship.hasSubPacks()) {
            item = new JMenuItem("Submunition Pack");
            item.addActionListener(new SetArcSPack());
            shipMenu.add(item);
        }
        if (this.ship.hasPointDefense()) {
            item = new JMenuItem("Point Defense");
            item.addActionListener(new SetArcPDefense());
            shipMenu.add(item);
        }
        if (this.ship.hasKineticGuns()) {
            item = new JMenuItem("Kinetic Guns");
            item.addActionListener(new SetArcKGun());
            shipMenu.add(item);
        }
        if (this.ship.hasScatterguns()) {
            item = new JMenuItem("Scatterguns");
            item.addActionListener(new SetArcScattergun());
            shipMenu.add(item);
        }
        if (this.ship.hasPlasmaBolts()) {
            item = new JMenuItem("Plasma Bolts");
            item.addActionListener(new SetArcPlasma());
            shipMenu.add(item);
        }
        if (this.ship.hasPulsers()) {
            item = new JMenuItem("Pulser");
            item.addActionListener(new SetArcPulser());
            shipMenu.add(item);
        }
        return shipMenu;
    }

    public MovementSteps getGhostPlot() {
        return this.movementSteps;
    }

    public double getPlottedX() {
        return this.plottedX;
    }

    public double getPlottedY() {
        return this.plottedY;
    }

    public int getPlottedHeading() {
        return this.plottedHeading;
    }

    public double getPastX() {
        return this.pastX;
    }

    public double getPastY() {
        return this.pastY;
    }

    public int getPastHeading() {
        return this.pastHeading;
    }

    public void resetPlotPosition() {
        this.movementSteps = this.ship.getMovementSteps();
        this.plottedX = this.ship.getXPosition() + this.movementSteps.First[0] + this.movementSteps.Second[0];
        this.plottedY = this.ship.getYPosition() + this.movementSteps.First[1] + this.movementSteps.Second[1];
        this.plottedHeading = this.movementSteps.Heading[1];
        if (this.plottedHeading <= 0) {
            this.plottedHeading += 12;
        }
        if (this.plottedHeading > 12) {
            this.plottedHeading -= 12;
        }
        this.plottedRoll = this.ship.getRolled();
        boolean combatPhase = this.engine.isCombatPhase();
        if (this.movementSteps.Roll && !combatPhase) {
            this.plottedRoll = !this.ship.getRolled();
        }
    }

    public PointContainer getPlotEnvelope() {
        if (this.engine.getOptions().getCinematicMovement()) {
            return PlotEnvelope.getPlotEnvelopeCinematic(this.ship);
        }
        return PlotEnvelope.getPlotEnvelopeVector(this.ship);
    }

    private String getArcName(int i) {
        switch (i) {
            case 0: {
                return "Fore";
            }
            case 1: {
                return "Fore Port";
            }
            case 2: {
                return "Fore Starboard";
            }
            case 3: {
                return "Aft Port";
            }
            case 4: {
                return "Aft Starboard";
            }
            case 5: {
                return "Aft";
            }
        }
        return "Aft";
    }

    public BufferedImage getArrivalImage() {
        int selection = Math.abs(this.ship.getRace().hashCode()) % 6 + 1;
        if (this.Arrival == null) {
            switch (selection) {
                case 1: {
                    this.Arrival = Arrival1;
                    break;
                }
                case 2: {
                    this.Arrival = Arrival2;
                    break;
                }
                case 3: {
                    this.Arrival = Arrival3;
                    break;
                }
                case 4: {
                    this.Arrival = Arrival4;
                    break;
                }
                case 5: {
                    this.Arrival = Arrival5;
                    break;
                }
                case 6: {
                    this.Arrival = Arrival6;
                    break;
                }
                default: {
                    this.Arrival = Arrival1;
                }
            }
        }
        return this.Arrival;
    }

    public BufferedImage getImage() {
        return this.getImage(this.ship.getHeading());
    }

    public BufferedImage getImage(int heading) {
        if (this.ship.isDestroyed()) {
            switch (heading) {
                case 1: {
                    return Explosion1;
                }
                case 2: {
                    return Explosion2;
                }
                case 3: {
                    return Explosion3;
                }
                case 4: {
                    return Explosion4;
                }
                case 5: {
                    return Explosion5;
                }
                case 6: {
                    return Explosion6;
                }
                case 7: {
                    return Explosion7;
                }
                case 8: {
                    return Explosion8;
                }
                case 9: {
                    return Explosion9;
                }
                case 10: {
                    return Explosion10;
                }
                case 11: {
                    return Explosion11;
                }
                case 12: {
                    return Explosion12;
                }
            }
            return Explosion;
        }
        if (this.ship.hasJumped()) {
            switch (heading) {
                case 1: 
                case 7: {
                    return Jump1;
                }
                case 2: 
                case 8: {
                    return Jump2;
                }
                case 3: 
                case 9: {
                    return Jump3;
                }
                case 4: 
                case 10: {
                    return Jump4;
                }
                case 5: 
                case 11: {
                    return Jump5;
                }
            }
            return Jump6;
        }
        double angle = 90.0 - this.getHeadingInDegrees(heading);
        while (heading <= 0) {
            heading += 12;
        }
        while (heading > 12) {
            heading -= 12;
        }
        if (this.cachedImages[heading] != null) {
            return this.cachedImages[heading];
        }
        AffineTransform trans = AffineTransform.getRotateInstance(Math.toRadians(angle), (double)this.Icon.getWidth() / 2.0, (double)this.Icon.getHeight() / 2.0);
        double w = this.Icon.getWidth();
        double wPrime = 0.0;
        double h = this.Icon.getHeight();
        double hPrime = 0.0;
        wPrime = hPrime = Math.sqrt(w * w + h * h);
        trans.preConcatenate(AffineTransform.getTranslateInstance(wPrime / 2.0 - w / 2.0, hPrime / 2.0 - h / 2.0));
        AffineTransformOp op = new AffineTransformOp(trans, 2);
        BufferedImage TranslatedIcon = new BufferedImage((int)wPrime, (int)hPrime, this.Icon.getType());
        this.cachedImages[heading] = op.filter(this.Icon, TranslatedIcon);
        return this.cachedImages[heading];
    }

    public double getHeadingInDegrees() {
        return this.getHeadingInDegrees(this.ship.getHeading());
    }

    public double getHeadingInDegrees(int heading) {
        double a = (double)(3 - heading) * 30.0;
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }

    public double getArcStart(int arc) {
        return this.getHeadingInDegrees() + (double)arcAngles[arc];
    }

    public double getArcAngle(int arc) {
        return this.getHeadingInDegrees() + (double)arcAngles[arc] + 30.0;
    }

    public double getArcStart(int heading, int arc) {
        return this.getHeadingInDegrees(heading) + (double)arcAngles[arc];
    }

    public double getArcAngle(int heading, int arc) {
        return this.getHeadingInDegrees(heading) + (double)arcAngles[arc] + 30.0;
    }

    public double getArcRange(int i) {
        return this.arcRange[i];
    }

    public void setArcRange(int i, double r) {
        this.arcRange[i] = r;
    }

    public ArrayList getRangeList() {
        return this.rangeList;
    }

    public int[][] getBeamRange() {
        if (!this.plottedRoll) {
            return this.beamRange;
        }
        return this.rolledBeamRange;
    }

    public void fillBeamRange() {
        if (this.beamRangeFilled) {
            return;
        }
        this.beamRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.beamRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            BeamBattery beam;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof BeamBattery) || !(beam = (BeamBattery)w).isOperational()) continue;
            int rating = beam.getRating();
            for (int r = 0; r < rating; ++r) {
                if (beam.fireForeArc()) {
                    int[] nArray = this.beamRange[0];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray2 = this.rolledBeamRange[0];
                    int n2 = r;
                    nArray2[n2] = nArray2[n2] + (rating - r);
                }
                if (beam.fireForeStarboardArc()) {
                    int[] nArray = this.beamRange[2];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray3 = this.rolledBeamRange[1];
                    int n3 = r;
                    nArray3[n3] = nArray3[n3] + (rating - r);
                }
                if (beam.fireAftStarboardArc()) {
                    int[] nArray = this.beamRange[4];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray4 = this.rolledBeamRange[3];
                    int n4 = r;
                    nArray4[n4] = nArray4[n4] + (rating - r);
                }
                if (beam.fireForePortArc()) {
                    int[] nArray = this.beamRange[1];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray5 = this.rolledBeamRange[2];
                    int n5 = r;
                    nArray5[n5] = nArray5[n5] + (rating - r);
                }
                if (beam.fireAftPortArc()) {
                    int[] nArray = this.beamRange[3];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray6 = this.rolledBeamRange[4];
                    int n6 = r;
                    nArray6[n6] = nArray6[n6] + (rating - r);
                }
                if (!beam.fireAftArc()) continue;
                int[] nArray = this.beamRange[5];
                int n = r;
                nArray[n] = nArray[n] + (rating - r);
                int[] nArray7 = this.rolledBeamRange[5];
                int n7 = r;
                nArray7[n7] = nArray7[n7] + (rating - r);
            }
        }
    }

    public int[][] getPulseTorpedoRange() {
        if (!this.plottedRoll) {
            return this.pulseTorpedoRange;
        }
        return this.rolledPulseTorpedoRange;
    }

    public void fillPulseTorpedoRange() {
        if (this.pulseTorpedoRangeFilled) {
            return;
        }
        this.pulseTorpedoRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.pulseTorpedoRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            PulseTorpedo torp;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PulseTorpedo) || !(torp = (PulseTorpedo)w).isOperational()) continue;
            for (int r = 0; r < 5; ++r) {
                if (torp.fireForeArc()) {
                    int[] nArray = this.pulseTorpedoRange[0];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.rolledPulseTorpedoRange[0];
                    int n2 = r;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                if (torp.fireForeStarboardArc()) {
                    int[] nArray = this.pulseTorpedoRange[2];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = this.rolledPulseTorpedoRange[1];
                    int n3 = r;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                if (torp.fireAftStarboardArc()) {
                    int[] nArray = this.pulseTorpedoRange[4];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray4 = this.rolledPulseTorpedoRange[3];
                    int n4 = r;
                    nArray4[n4] = nArray4[n4] + 1;
                }
                if (torp.fireForePortArc()) {
                    int[] nArray = this.pulseTorpedoRange[1];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray5 = this.rolledPulseTorpedoRange[2];
                    int n5 = r;
                    nArray5[n5] = nArray5[n5] + 1;
                }
                if (torp.fireAftPortArc()) {
                    int[] nArray = this.pulseTorpedoRange[3];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray6 = this.rolledPulseTorpedoRange[4];
                    int n6 = r;
                    nArray6[n6] = nArray6[n6] + 1;
                }
                if (!torp.fireAftArc()) continue;
                int[] nArray = this.pulseTorpedoRange[5];
                int n = r;
                nArray[n] = nArray[n] + 1;
                int[] nArray7 = this.rolledPulseTorpedoRange[5];
                int n7 = r;
                nArray7[n7] = nArray7[n7] + 1;
            }
        }
    }

    public int[][] getGraserRange() {
        if (!this.plottedRoll) {
            return this.graserRange;
        }
        return this.rolledGraserRange;
    }

    public void fillGraserRange() {
        if (this.graserRangeFilled) {
            return;
        }
        this.graserRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.graserRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Graser graser;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof Graser) || !(graser = (Graser)w).isOperational()) continue;
            int rating = graser.getRating();
            for (int r = 0; r < rating; ++r) {
                if (graser.fireForeArc()) {
                    int[] nArray = this.graserRange[0];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray2 = this.rolledGraserRange[0];
                    int n2 = r;
                    nArray2[n2] = nArray2[n2] + (rating - r);
                }
                if (graser.fireForeStarboardArc()) {
                    int[] nArray = this.graserRange[2];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray3 = this.rolledGraserRange[1];
                    int n3 = r;
                    nArray3[n3] = nArray3[n3] + (rating - r);
                }
                if (graser.fireAftStarboardArc()) {
                    int[] nArray = this.graserRange[4];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray4 = this.rolledGraserRange[3];
                    int n4 = r;
                    nArray4[n4] = nArray4[n4] + (rating - r);
                }
                if (graser.fireForePortArc()) {
                    int[] nArray = this.graserRange[1];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray5 = this.rolledGraserRange[2];
                    int n5 = r;
                    nArray5[n5] = nArray5[n5] + (rating - r);
                }
                if (graser.fireAftPortArc()) {
                    int[] nArray = this.graserRange[3];
                    int n = r;
                    nArray[n] = nArray[n] + (rating - r);
                    int[] nArray6 = this.rolledGraserRange[4];
                    int n6 = r;
                    nArray6[n6] = nArray6[n6] + (rating - r);
                }
                if (!graser.fireAftArc()) continue;
                int[] nArray = this.graserRange[5];
                int n = r;
                nArray[n] = nArray[n] + (rating - r);
                int[] nArray7 = this.rolledGraserRange[5];
                int n7 = r;
                nArray7[n7] = nArray7[n7] + (rating - r);
            }
        }
    }

    public int[][] getAntiMatterTorpedoRange() {
        return this.antiMatterTorpedoRange;
    }

    public void fillAntiMatterTorpedoRange() {
        if (this.antiMatterTorpedoRangeFilled) {
            return;
        }
        this.antiMatterTorpedoRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                this.antiMatterTorpedoRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            AntiMatterTorpedoLauncher amtl;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof AntiMatterTorpedoLauncher) || !(amtl = (AntiMatterTorpedoLauncher)w).isOperational() || amtl.isExpended()) continue;
            int[] nArray = this.antiMatterTorpedoRange[0];
            nArray[0] = nArray[0] + 1;
            int[] nArray2 = this.antiMatterTorpedoRange[2];
            nArray2[0] = nArray2[0] + 1;
            int[] nArray3 = this.antiMatterTorpedoRange[1];
            nArray3[0] = nArray3[0] + 1;
        }
    }

    public int[][] getKGunRange() {
        if (!this.plottedRoll) {
            return this.kGunRange;
        }
        return this.rolledKGunRange;
    }

    public void fillKGunRange() {
        if (this.kGunRangeFilled) {
            return;
        }
        this.kGunRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.kGunRange[i][j] = 0;
                this.rolledKGunRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            KineticGun kGun;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof KineticGun) || !(kGun = (KineticGun)w).isOperational()) continue;
            for (int r = 0; r < 5; ++r) {
                if (kGun.fireForeArc()) {
                    int[] nArray = this.kGunRange[0];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.rolledKGunRange[0];
                    int n2 = r;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                if (kGun.fireForeStarboardArc()) {
                    int[] nArray = this.kGunRange[2];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = this.rolledKGunRange[1];
                    int n3 = r;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                if (kGun.fireAftStarboardArc()) {
                    int[] nArray = this.kGunRange[4];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray4 = this.rolledKGunRange[3];
                    int n4 = r;
                    nArray4[n4] = nArray4[n4] + 1;
                }
                if (kGun.fireForePortArc()) {
                    int[] nArray = this.kGunRange[1];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray5 = this.rolledKGunRange[2];
                    int n5 = r;
                    nArray5[n5] = nArray5[n5] + 1;
                }
                if (kGun.fireAftPortArc()) {
                    int[] nArray = this.kGunRange[3];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray6 = this.rolledKGunRange[4];
                    int n6 = r;
                    nArray6[n6] = nArray6[n6] + 1;
                }
                if (!kGun.fireAftArc()) continue;
                int[] nArray = this.kGunRange[5];
                int n = r;
                nArray[n] = nArray[n] + 1;
                int[] nArray7 = this.rolledKGunRange[5];
                int n7 = r;
                nArray7[n7] = nArray7[n7] + 1;
            }
        }
    }

    public int[][] getSalvoMissileRange() {
        if (!this.plottedRoll) {
            return this.salvoMissileRange;
        }
        return this.rolledSalvoMissileRange;
    }

    public void fillSalvoMissileRange() {
        Weapon w;
        if (this.salvoMissileRangeFilled) {
            return;
        }
        this.salvoMissileRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.salvoMissileRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        boolean hasStandardSalvos = false;
        boolean hasExtendedSalvos = false;
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            SalvoMissileMagazine smm;
            w = (Weapon)iterator.next();
            if (!(w instanceof SalvoMissileMagazine) || !(smm = (SalvoMissileMagazine)w).isOperational()) continue;
            if (smm.isOneAvailable("Standard Salvo")) {
                hasStandardSalvos = true;
            }
            if (!smm.isOneAvailable("Extended Range Salvo")) continue;
            hasStandardSalvos = true;
            hasExtendedSalvos = true;
        }
        Weapons = this.ship.getWeaponSystems();
        iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            SalvoMissileRack smr;
            w = (Weapon)iterator.next();
            if (w instanceof SalvoMissileLauncher) {
                SalvoMissileLauncher sml = (SalvoMissileLauncher)w;
                if (sml.isOperational() && hasStandardSalvos) {
                    if (sml.fireForeArc()) {
                        int[] nArray = this.salvoMissileRange[0];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray2 = this.rolledSalvoMissileRange[0];
                        nArray2[0] = nArray2[0] + 1;
                    }
                    if (sml.fireForeStarboardArc()) {
                        int[] nArray = this.salvoMissileRange[2];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray3 = this.rolledSalvoMissileRange[1];
                        nArray3[0] = nArray3[0] + 1;
                    }
                    if (sml.fireAftStarboardArc()) {
                        int[] nArray = this.salvoMissileRange[4];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray4 = this.rolledSalvoMissileRange[3];
                        nArray4[0] = nArray4[0] + 1;
                    }
                    if (sml.fireForePortArc()) {
                        int[] nArray = this.salvoMissileRange[1];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray5 = this.rolledSalvoMissileRange[2];
                        nArray5[0] = nArray5[0] + 1;
                    }
                    if (sml.fireAftPortArc()) {
                        int[] nArray = this.salvoMissileRange[3];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray6 = this.rolledSalvoMissileRange[4];
                        nArray6[0] = nArray6[0] + 1;
                    }
                    if (sml.fireAftArc()) {
                        int[] nArray = this.salvoMissileRange[5];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray7 = this.rolledSalvoMissileRange[5];
                        nArray7[0] = nArray7[0] + 1;
                    }
                }
                if (sml.isOperational() && hasExtendedSalvos) {
                    if (sml.fireForeArc()) {
                        int[] nArray = this.salvoMissileRange[0];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray8 = this.rolledSalvoMissileRange[0];
                        nArray8[1] = nArray8[1] + 1;
                    }
                    if (sml.fireForeStarboardArc()) {
                        int[] nArray = this.salvoMissileRange[2];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray9 = this.rolledSalvoMissileRange[1];
                        nArray9[1] = nArray9[1] + 1;
                    }
                    if (sml.fireAftStarboardArc()) {
                        int[] nArray = this.salvoMissileRange[4];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray10 = this.rolledSalvoMissileRange[3];
                        nArray10[1] = nArray10[1] + 1;
                    }
                    if (sml.fireForePortArc()) {
                        int[] nArray = this.salvoMissileRange[1];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray11 = this.rolledSalvoMissileRange[2];
                        nArray11[1] = nArray11[1] + 1;
                    }
                    if (sml.fireAftPortArc()) {
                        int[] nArray = this.salvoMissileRange[3];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray12 = this.rolledSalvoMissileRange[4];
                        nArray12[1] = nArray12[1] + 1;
                    }
                    if (sml.fireAftArc()) {
                        int[] nArray = this.salvoMissileRange[5];
                        nArray[1] = nArray[1] + 1;
                        int[] nArray13 = this.rolledSalvoMissileRange[5];
                        nArray13[1] = nArray13[1] + 1;
                    }
                }
            }
            if (!(w instanceof SalvoMissileRack) || !(smr = (SalvoMissileRack)w).isOperational()) continue;
            if (smr.fireForeArc()) {
                int[] nArray = this.salvoMissileRange[0];
                nArray[0] = nArray[0] + 1;
                int[] nArray14 = this.rolledSalvoMissileRange[0];
                nArray14[0] = nArray14[0] + 1;
            }
            if (smr.fireForeStarboardArc()) {
                int[] nArray = this.salvoMissileRange[2];
                nArray[0] = nArray[0] + 1;
                int[] nArray15 = this.rolledSalvoMissileRange[1];
                nArray15[0] = nArray15[0] + 1;
            }
            if (smr.fireAftStarboardArc()) {
                int[] nArray = this.salvoMissileRange[4];
                nArray[0] = nArray[0] + 1;
                int[] nArray16 = this.rolledSalvoMissileRange[3];
                nArray16[0] = nArray16[0] + 1;
            }
            if (smr.fireForePortArc()) {
                int[] nArray = this.salvoMissileRange[1];
                nArray[0] = nArray[0] + 1;
                int[] nArray17 = this.rolledSalvoMissileRange[2];
                nArray17[0] = nArray17[0] + 1;
            }
            if (smr.fireAftPortArc()) {
                int[] nArray = this.salvoMissileRange[3];
                nArray[0] = nArray[0] + 1;
                int[] nArray18 = this.rolledSalvoMissileRange[4];
                nArray18[0] = nArray18[0] + 1;
            }
            if (smr.fireAftArc()) {
                int[] nArray = this.salvoMissileRange[5];
                nArray[0] = nArray[0] + 1;
                int[] nArray19 = this.rolledSalvoMissileRange[5];
                nArray19[0] = nArray19[0] + 1;
            }
            if (!smr.getType().equals("Extended Range Salvo")) continue;
            if (smr.fireForeArc()) {
                int[] nArray = this.salvoMissileRange[0];
                nArray[1] = nArray[1] + 1;
                int[] nArray20 = this.rolledSalvoMissileRange[0];
                nArray20[1] = nArray20[1] + 1;
            }
            if (smr.fireForeStarboardArc()) {
                int[] nArray = this.salvoMissileRange[2];
                nArray[1] = nArray[1] + 1;
                int[] nArray21 = this.rolledSalvoMissileRange[1];
                nArray21[1] = nArray21[1] + 1;
            }
            if (smr.fireAftStarboardArc()) {
                int[] nArray = this.salvoMissileRange[4];
                nArray[1] = nArray[1] + 1;
                int[] nArray22 = this.rolledSalvoMissileRange[3];
                nArray22[1] = nArray22[1] + 1;
            }
            if (smr.fireForePortArc()) {
                int[] nArray = this.salvoMissileRange[1];
                nArray[1] = nArray[1] + 1;
                int[] nArray23 = this.rolledSalvoMissileRange[2];
                nArray23[1] = nArray23[1] + 1;
            }
            if (smr.fireAftPortArc()) {
                int[] nArray = this.salvoMissileRange[3];
                nArray[1] = nArray[1] + 1;
                int[] nArray24 = this.rolledSalvoMissileRange[4];
                nArray24[1] = nArray24[1] + 1;
            }
            if (!smr.fireAftArc()) continue;
            int[] nArray = this.salvoMissileRange[5];
            nArray[1] = nArray[1] + 1;
            int[] nArray25 = this.rolledSalvoMissileRange[5];
            nArray25[1] = nArray25[1] + 1;
        }
    }

    public int[][] getPlasmaBoltRange() {
        if (!this.plottedRoll) {
            return this.plasmaBoltRange;
        }
        return this.rolledPlasmaBoltRange;
    }

    public void fillPlasmaBoltRange() {
        if (this.plasmaBoltRangeFilled) {
            return;
        }
        this.plasmaBoltRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 1; ++j) {
                this.plasmaBoltRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            PlasmaBoltLauncher pbl;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PlasmaBoltLauncher) || !(pbl = (PlasmaBoltLauncher)w).isOperational()) continue;
            if (pbl.fireForeArc()) {
                int[] nArray = this.plasmaBoltRange[0];
                nArray[0] = nArray[0] + 1;
                int[] nArray2 = this.rolledPlasmaBoltRange[0];
                nArray2[0] = nArray2[0] + 1;
            }
            if (pbl.fireForeStarboardArc()) {
                int[] nArray = this.plasmaBoltRange[2];
                nArray[0] = nArray[0] + 1;
                int[] nArray3 = this.rolledPlasmaBoltRange[1];
                nArray3[0] = nArray3[0] + 1;
            }
            if (pbl.fireAftStarboardArc()) {
                int[] nArray = this.plasmaBoltRange[4];
                nArray[0] = nArray[0] + 1;
                int[] nArray4 = this.rolledPlasmaBoltRange[3];
                nArray4[0] = nArray4[0] + 1;
            }
            if (pbl.fireForePortArc()) {
                int[] nArray = this.plasmaBoltRange[1];
                nArray[0] = nArray[0] + 1;
                int[] nArray5 = this.rolledPlasmaBoltRange[2];
                nArray5[0] = nArray5[0] + 1;
            }
            if (pbl.fireAftPortArc()) {
                int[] nArray = this.plasmaBoltRange[3];
                nArray[0] = nArray[0] + 1;
                int[] nArray6 = this.rolledPlasmaBoltRange[4];
                nArray6[0] = nArray6[0] + 1;
            }
            if (!pbl.fireAftArc()) continue;
            int[] nArray = this.plasmaBoltRange[5];
            nArray[0] = nArray[0] + 1;
            int[] nArray7 = this.rolledPlasmaBoltRange[5];
            nArray7[0] = nArray7[0] + 1;
        }
    }

    public int[][] getPulserRange() {
        if (!this.plottedRoll) {
            return this.pulserRange;
        }
        return this.rolledPulserRange;
    }

    public void fillPulserRange() {
        if (this.pulserRangeFilled) {
            return;
        }
        this.pulserRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.pulserRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            int n;
            Pulser p;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof Pulser) || !(p = (Pulser)w).isOperational()) continue;
            char mode = p.getRangeMode();
            if (mode == 'C') {
                if (p.fireForeArc()) {
                    int[] nArray = this.pulserRange[0];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray2 = this.rolledPulserRange[0];
                    nArray2[0] = nArray2[0] + 6;
                }
                if (p.fireForeStarboardArc()) {
                    int[] nArray = this.pulserRange[2];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray3 = this.rolledPulserRange[1];
                    nArray3[0] = nArray3[0] + 6;
                }
                if (p.fireAftStarboardArc()) {
                    int[] nArray = this.pulserRange[4];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray4 = this.rolledPulserRange[3];
                    nArray4[0] = nArray4[0] + 6;
                }
                if (p.fireForePortArc()) {
                    int[] nArray = this.pulserRange[1];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray5 = this.rolledPulserRange[2];
                    nArray5[0] = nArray5[0] + 6;
                }
                if (p.fireAftPortArc()) {
                    int[] nArray = this.pulserRange[3];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray6 = this.rolledPulserRange[4];
                    nArray6[0] = nArray6[0] + 6;
                }
                if (p.fireAftArc()) {
                    int[] nArray = this.pulserRange[5];
                    nArray[0] = nArray[0] + 6;
                    int[] nArray7 = this.rolledPulserRange[5];
                    nArray7[0] = nArray7[0] + 6;
                }
            }
            if (mode == 'M') {
                for (n = 0; n < 2; ++n) {
                    if (p.fireForeArc()) {
                        int[] nArray = this.pulserRange[0];
                        int n2 = n;
                        nArray[n2] = nArray[n2] + 2;
                        int[] nArray8 = this.rolledPulserRange[0];
                        int n3 = n;
                        nArray8[n3] = nArray8[n3] + 2;
                    }
                    if (p.fireForeStarboardArc()) {
                        int[] nArray = this.pulserRange[2];
                        int n4 = n;
                        nArray[n4] = nArray[n4] + 2;
                        int[] nArray9 = this.rolledPulserRange[1];
                        int n5 = n;
                        nArray9[n5] = nArray9[n5] + 2;
                    }
                    if (p.fireAftStarboardArc()) {
                        int[] nArray = this.pulserRange[4];
                        int n6 = n;
                        nArray[n6] = nArray[n6] + 2;
                        int[] nArray10 = this.rolledPulserRange[3];
                        int n7 = n;
                        nArray10[n7] = nArray10[n7] + 2;
                    }
                    if (p.fireForePortArc()) {
                        int[] nArray = this.pulserRange[1];
                        int n8 = n;
                        nArray[n8] = nArray[n8] + 2;
                        int[] nArray11 = this.rolledPulserRange[2];
                        int n9 = n;
                        nArray11[n9] = nArray11[n9] + 2;
                    }
                    if (p.fireAftPortArc()) {
                        int[] nArray = this.pulserRange[3];
                        int n10 = n;
                        nArray[n10] = nArray[n10] + 2;
                        int[] nArray12 = this.rolledPulserRange[4];
                        int n11 = n;
                        nArray12[n11] = nArray12[n11] + 2;
                    }
                    if (!p.fireAftArc()) continue;
                    int[] nArray = this.pulserRange[5];
                    int n12 = n;
                    nArray[n12] = nArray[n12] + 2;
                    int[] nArray13 = this.rolledPulserRange[5];
                    int n13 = n;
                    nArray13[n13] = nArray13[n13] + 2;
                }
            }
            if (mode != 'L') continue;
            for (n = 0; n < 3; ++n) {
                if (p.fireForeArc()) {
                    int[] nArray = this.pulserRange[0];
                    int n14 = n;
                    nArray[n14] = nArray[n14] + 1;
                    int[] nArray14 = this.rolledPulserRange[0];
                    int n15 = n;
                    nArray14[n15] = nArray14[n15] + 1;
                }
                if (p.fireForeStarboardArc()) {
                    int[] nArray = this.pulserRange[2];
                    int n16 = n;
                    nArray[n16] = nArray[n16] + 1;
                    int[] nArray15 = this.rolledPulserRange[1];
                    int n17 = n;
                    nArray15[n17] = nArray15[n17] + 1;
                }
                if (p.fireAftStarboardArc()) {
                    int[] nArray = this.pulserRange[4];
                    int n18 = n;
                    nArray[n18] = nArray[n18] + 1;
                    int[] nArray16 = this.rolledPulserRange[3];
                    int n19 = n;
                    nArray16[n19] = nArray16[n19] + 1;
                }
                if (p.fireForePortArc()) {
                    int[] nArray = this.pulserRange[1];
                    int n20 = n;
                    nArray[n20] = nArray[n20] + 1;
                    int[] nArray17 = this.rolledPulserRange[2];
                    int n21 = n;
                    nArray17[n21] = nArray17[n21] + 1;
                }
                if (p.fireAftPortArc()) {
                    int[] nArray = this.pulserRange[3];
                    int n22 = n;
                    nArray[n22] = nArray[n22] + 1;
                    int[] nArray18 = this.rolledPulserRange[4];
                    int n23 = n;
                    nArray18[n23] = nArray18[n23] + 1;
                }
                if (!p.fireAftArc()) continue;
                int[] nArray = this.pulserRange[5];
                int n24 = n;
                nArray[n24] = nArray[n24] + 1;
                int[] nArray19 = this.rolledPulserRange[5];
                int n25 = n;
                nArray19[n25] = nArray19[n25] + 1;
            }
        }
    }

    public int[][] getSubmunitionPackRange() {
        if (!this.plottedRoll) {
            return this.submunitionPackRange;
        }
        return this.rolledSubmunitionPackRange;
    }

    public void fillSubmunitionPackRange() {
        if (this.submunitionPackRangeFilled) {
            return;
        }
        this.submunitionPackRangeFilled = true;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.submunitionPackRange[i][j] = 0;
            }
        }
        if (!this.ship.canFire()) {
            return;
        }
        ArrayList Weapons = this.ship.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            SubmunitionPack spack;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof SubmunitionPack) || !(spack = (SubmunitionPack)w).isOperational()) continue;
            for (int r = 0; r < 3; ++r) {
                if (spack.fireForeArc()) {
                    int[] nArray = this.submunitionPackRange[0];
                    int n = r;
                    nArray[n] = nArray[n] + (3 - r);
                    int[] nArray2 = this.rolledSubmunitionPackRange[0];
                    int n2 = r;
                    nArray2[n2] = nArray2[n2] + (3 - r);
                }
                if (spack.fireForeStarboardArc()) {
                    int[] nArray = this.submunitionPackRange[2];
                    int n = r;
                    nArray[n] = nArray[n] + (3 - r);
                    int[] nArray3 = this.rolledSubmunitionPackRange[1];
                    int n3 = r;
                    nArray3[n3] = nArray3[n3] + (3 - r);
                }
                if (spack.fireAftStarboardArc()) {
                    int[] nArray = this.submunitionPackRange[4];
                    int n = r;
                    nArray[n] = nArray[n] + (3 - r);
                    int[] nArray4 = this.rolledSubmunitionPackRange[3];
                    int n4 = r;
                    nArray4[n4] = nArray4[n4] + (3 - r);
                }
                if (spack.fireForePortArc()) {
                    int[] nArray = this.submunitionPackRange[1];
                    int n = r;
                    nArray[n] = nArray[n] + (3 - r);
                    int[] nArray5 = this.rolledSubmunitionPackRange[2];
                    int n5 = r;
                    nArray5[n5] = nArray5[n5] + (3 - r);
                }
                if (spack.fireAftPortArc()) {
                    int[] nArray = this.submunitionPackRange[3];
                    int n = r;
                    nArray[n] = nArray[n] + (3 - r);
                    int[] nArray6 = this.rolledSubmunitionPackRange[4];
                    int n6 = r;
                    nArray6[n6] = nArray6[n6] + (3 - r);
                }
                if (!spack.fireAftArc()) continue;
                int[] nArray = this.submunitionPackRange[5];
                int n = r;
                nArray[n] = nArray[n] + (3 - r);
                int[] nArray7 = this.rolledSubmunitionPackRange[5];
                int n7 = r;
                nArray7[n7] = nArray7[n7] + (3 - r);
            }
        }
    }

    public ActionListener getPlotListener(JTextField t) {
        return new PlotListener(t);
    }

    public DocumentListener getPlotDocListener(JTextField t) {
        return new PlotDocListener(t);
    }

    public void clearDisplay() {
        this.arcOption = 0;
        for (int arc = 0; arc < 6; ++arc) {
            this.setArcRange(arc, 0.0);
        }
        this.hidePlotEnvelope();
        this.hideGhostPlot();
        this.hideGhostTrail();
        this.hideLockOns();
    }

    public void setStarMap(StarMap m) {
        this.map = m;
    }

    static {
        JButton b = new JButton();
        Explosion = ImageUtilities.getImage("Images/explode.gif", b);
        Explosion1 = ImageUtilities.getImage("Images/explode1.gif", b);
        Explosion2 = ImageUtilities.getImage("Images/explode2.gif", b);
        Explosion3 = ImageUtilities.getImage("Images/explode3.gif", b);
        Explosion4 = ImageUtilities.getImage("Images/explode4.gif", b);
        Explosion5 = ImageUtilities.getImage("Images/explode5.gif", b);
        Explosion6 = ImageUtilities.getImage("Images/explode6.gif", b);
        Explosion7 = ImageUtilities.getImage("Images/explode7.gif", b);
        Explosion8 = ImageUtilities.getImage("Images/explode8.gif", b);
        Explosion9 = ImageUtilities.getImage("Images/explode9.gif", b);
        Explosion10 = ImageUtilities.getImage("Images/explode10.gif", b);
        Explosion11 = ImageUtilities.getImage("Images/explode11.gif", b);
        Explosion12 = ImageUtilities.getImage("Images/explode12.gif", b);
        Jump1 = ImageUtilities.getImage("Images/jump7.png", b);
        Jump2 = ImageUtilities.getImage("Images/jump8.png", b);
        Jump3 = ImageUtilities.getImage("Images/jump9.png", b);
        Jump4 = ImageUtilities.getImage("Images/jump10.png", b);
        Jump5 = ImageUtilities.getImage("Images/jump11.png", b);
        Jump6 = ImageUtilities.getImage("Images/jump12.png", b);
        Arrival1 = ImageUtilities.getImage("Images/arrival1.png", b);
        Arrival2 = ImageUtilities.getImage("Images/arrival2.png", b);
        Arrival3 = ImageUtilities.getImage("Images/arrival3.png", b);
        Arrival4 = ImageUtilities.getImage("Images/arrival4.png", b);
        Arrival5 = ImageUtilities.getImage("Images/arrival5.png", b);
        Arrival6 = ImageUtilities.getImage("Images/arrival6.png", b);
        arcAngles = new int[]{-30, 30, -90, 90, -150, -210};
    }

    public class ClearArcRange
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            for (int arc = 0; arc < 6; ++arc) {
                ShipGUIAdapter.this.setArcRange(arc, 0.0);
            }
        }
    }

    public class PlotDocListener
    implements DocumentListener {
        private JTextField pe;

        PlotDocListener() {
            this.pe = null;
        }

        PlotDocListener(JTextField t) {
            this.pe = t;
        }

        public void insertUpdate(DocumentEvent e) {
            int len = e.getDocument().getLength();
            try {
                String s = e.getDocument().getText(0, len);
                ShipGUIAdapter.this.ship.setOrders(s);
            }
            catch (Exception ed) {
                System.out.println("Plot entry box error");
            }
            ShipGUIAdapter.this.resetPlotPosition();
            if (this.pe != null) {
                if (!ShipGUIAdapter.this.ship.areOrdersValid()) {
                    String prop = "Illegal Orders Color";
                    String illegalTriple = Preferences.getPreferences().getProperty(prop);
                    Color illegalColor = Preferences.parseColor(illegalTriple);
                    this.pe.setBackground(illegalColor);
                } else {
                    this.pe.setBackground(Color.white);
                }
                if (!this.pe.isEnabled()) {
                    this.pe.setBackground(Color.gray);
                }
            }
            if (ShipGUIAdapter.this.map != null) {
                ShipGUIAdapter.this.map.repaint();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            int len = e.getDocument().getLength();
            try {
                String s = e.getDocument().getText(0, len);
                ShipGUIAdapter.this.ship.setOrders(s);
            }
            catch (Exception ed) {
                System.out.println("Plot entry box error");
            }
            ShipGUIAdapter.this.resetPlotPosition();
            if (this.pe != null) {
                if (!ShipGUIAdapter.this.ship.areOrdersValid()) {
                    String prop = "Illegal Orders Color";
                    String illegalTriple = Preferences.getPreferences().getProperty(prop);
                    Color illegalColor = Preferences.parseColor(illegalTriple);
                    this.pe.setBackground(illegalColor);
                } else {
                    this.pe.setBackground(Color.white);
                }
                if (!this.pe.isEnabled()) {
                    this.pe.setBackground(Color.gray);
                }
            }
            if (ShipGUIAdapter.this.map != null) {
                ShipGUIAdapter.this.map.repaint();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    public class PlotListener
    implements ActionListener {
        private JTextField pe;

        PlotListener() {
            this.pe = null;
        }

        PlotListener(JTextField t) {
            this.pe = t;
        }

        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.ship.setOrders(e.getActionCommand());
            ShipGUIAdapter.this.resetPlotPosition();
            if (this.pe != null) {
                if (!ShipGUIAdapter.this.ship.areOrdersValid()) {
                    String prop = "Illegal Orders Color";
                    String illegalTriple = Preferences.getPreferences().getProperty(prop);
                    Color illegalColor = Preferences.parseColor(illegalTriple);
                    this.pe.setBackground(illegalColor);
                } else {
                    this.pe.setBackground(Color.white);
                }
                if (!this.pe.isEnabled()) {
                    this.pe.setBackground(Color.gray);
                }
            }
            if (ShipGUIAdapter.this.map != null) {
                ShipGUIAdapter.this.map.repaint();
            }
            this.pe.getParent().getParent().requestFocus();
        }
    }

    public class ClearAll
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.clearDisplay();
        }
    }

    public class SetArcRange
    implements ActionListener {
        double range;
        int arc;

        public SetArcRange(int a, double r) {
            if (ShipGUIAdapter.this.ship.isDestroyed() || ShipGUIAdapter.this.ship.hasJumped()) {
                r = 0.0;
            }
            this.range = r;
            this.arc = a;
        }

        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 0;
            if (this.arc != -1) {
                ShipGUIAdapter.this.setArcRange(this.arc, this.range);
            } else {
                for (int i = 0; i < 6; ++i) {
                    ShipGUIAdapter.this.setArcRange(i, this.range);
                }
            }
        }
    }

    public class SetArcSPack
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 3;
        }
    }

    public class SetArcPulser
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 12;
        }
    }

    public class SetArcPlasma
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 11;
        }
    }

    public class SetArcSalvo
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 10;
        }
    }

    public class SetArcKGun
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 9;
        }
    }

    public class SetArcSensor
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (ShipGUIAdapter.this.ship.isDestroyed() || ShipGUIAdapter.this.ship.hasJumped()) {
                ShipGUIAdapter.this.arcOption = -1;
            } else {
                ShipGUIAdapter.this.arcOption = 15;
            }
        }
    }

    public class SetArcScattergun
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 14;
        }
    }

    public class SetArcPDefense
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 13;
        }
    }

    public class SetArcAntiMatter
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 17;
        }
    }

    public class SetArcGraser
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 16;
        }
    }

    public class SetArcPTorp
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 2;
        }
    }

    public class ToggleLockOns
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.setShowLockOns(!ShipGUIAdapter.this.getShowLockOns());
        }
    }

    public class ToggleGhostTrail
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.setShowGhostTrail(!ShipGUIAdapter.this.getShowGhostTrail());
        }
    }

    public class ToggleGhostPlot
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.setShowGhostPlot(!ShipGUIAdapter.this.getShowGhostPlot());
        }
    }

    public class TogglePlotEnvelope
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.setShowPlotEnvelope(!ShipGUIAdapter.this.getShowPlotEnvelope());
        }
    }

    public class SetArcBeam
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShipGUIAdapter.this.arcOption = 1;
        }
    }
}

