/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ScenarioEditor;
import ftjava.std.GameEngine;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ScenarioGameEditor {
    JDialog dialog;
    JTextField nameField;
    JTextArea briefingArea;
    JCheckBox aftArcFireButton;
    JComboBox cinematicMovementOption;
    JCheckBox coreSystemsButton;
    JCheckBox penetratingDamageButton;
    JSlider sensorRangeBandSlider;
    JComboBox sensorRulesOption;
    JComboBox sensorLevelOption;
    JCheckBox shipRollButton;
    JCheckBox simultaneousFireButton;
    JComboBox targetResolutionOption;
    JCheckBox thresholdDamagedSystemsButton;
    JSlider areaDefenseActivationRangeSlider;
    JSlider beamRangeBandSlider;
    JSlider kineticGunRangeBandSlider;
    JSlider pointDefenseRangeSlider;
    JSlider pulseTorpedoRangeBandSlider;
    JSlider multipleKineticPenetratorPackRangeSlider;
    JSlider needleBeamRangeSlider;
    JSlider salvoMissileRangeSlider;
    JSlider salvoMissileExtendedRangeSlider;
    JSlider salvoMissileLockOnSlider;
    JSlider scattergunRangeSlider;
    JSlider submunitionPackRangeBandSlider;
    protected GameEngine scenario;
    protected ScenarioEditor editor;

    public ScenarioGameEditor(GameEngine inscenario, ScenarioEditor ineditor) {
        Vector<String> v = new Vector<String>();
        this.scenario = inscenario;
        this.editor = ineditor;
        this.dialog = new JDialog();
        this.dialog.setTitle(this.scenario.getName());
        this.dialog.setModal(true);
        JTabbedPane tabs = new JTabbedPane();
        this.dialog.getContentPane().add((Component)tabs, "Center");
        Box box = new Box(1);
        box.add(new JLabel("Name:"));
        this.nameField = new JTextField(this.scenario.getName(), 20);
        box.add(this.nameField);
        box.add(new JLabel("Briefing:"));
        this.briefingArea = new JTextArea(this.scenario.getScenarioBriefing(), 5, 20);
        box.add(this.briefingArea);
        box.add(Box.createVerticalGlue());
        box.validate();
        tabs.add("Info", box);
        box = new Box(1);
        JPanel panel = new JPanel(new GridLayout(0, 2));
        this.aftArcFireButton = new JCheckBox("Aft Arc File", this.scenario.getOptions().getAftArcFire());
        panel.add(this.aftArcFireButton);
        this.coreSystemsButton = new JCheckBox("Core Systems", this.scenario.getOptions().getCoreSystems());
        panel.add(this.coreSystemsButton);
        this.penetratingDamageButton = new JCheckBox("Penetrating Damage", this.scenario.getOptions().getPenetratingDamage());
        panel.add(this.penetratingDamageButton);
        this.shipRollButton = new JCheckBox("Ship Rolls", this.scenario.getOptions().getShipRoll());
        panel.add(this.shipRollButton);
        this.thresholdDamagedSystemsButton = new JCheckBox("Threshold Damaged Systems", this.scenario.getOptions().getThresholdDamagedSystems());
        panel.add(this.thresholdDamagedSystemsButton);
        this.simultaneousFireButton = new JCheckBox("Simultaneous Fire", this.scenario.getOptions().getSimultaneousFire());
        panel.add(this.simultaneousFireButton);
        box.add(panel);
        panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Movement:"));
        v = new Vector();
        v.add("Cinematic");
        v.add("Vector");
        this.cinematicMovementOption = new JComboBox(v);
        if (this.scenario.getOptions().getCinematicMovement()) {
            this.cinematicMovementOption.setSelectedIndex(0);
        } else {
            this.cinematicMovementOption.setSelectedIndex(1);
        }
        panel.add(this.cinematicMovementOption);
        panel.add(new JLabel("Target Resolution Mode:"));
        v = new Vector();
        v.add("Priority");
        v.add("Targeted");
        this.targetResolutionOption = new JComboBox(v);
        this.targetResolutionOption.setSelectedIndex(this.scenario.getOptions().getTargetResolution() - 1);
        panel.add(this.targetResolutionOption);
        box.add(panel);
        box.add(Box.createVerticalGlue());
        tabs.add("Variations", box);
        panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Sensor Range Band:"));
        this.sensorRangeBandSlider = new JSlider(0, 60, (int)this.scenario.getOptions().getSensorRangeBand());
        this.sensorRangeBandSlider.setMajorTickSpacing(6);
        this.sensorRangeBandSlider.setPaintTicks(true);
        this.sensorRangeBandSlider.setPaintLabels(true);
        panel.add(this.sensorRangeBandSlider);
        panel.add(new JLabel("Fog Of War:"));
        v = new Vector();
        v.add("Off");
        v.add("Fixed");
        v.add("Ranged");
        this.sensorRulesOption = new JComboBox(v);
        this.sensorRulesOption.setSelectedIndex(this.scenario.getOptions().getSensorRules());
        panel.add(this.sensorRulesOption);
        panel.add(new JLabel("Fog of War Mode:"));
        v = new Vector();
        v.add("Everything");
        v.add("Full, No System Status");
        v.add("Mass, Drives, Screens ");
        v.add("Mass Only");
        v.add("Bogey Only");
        this.sensorLevelOption = new JComboBox(v);
        if (this.scenario.getOptions().getSensorLevel() < 3) {
            this.scenario.getOptions().setSensorLevel(3);
        }
        this.sensorLevelOption.setSelectedIndex(this.scenario.getOptions().getSensorLevel() - 3);
        panel.add(this.sensorLevelOption);
        tabs.add("Fog Of War", panel);
        tabs.add("Range Bands", this.makeRangeBands());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioGameEditor.this.OKPressed();
            }
        });
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioGameEditor.this.ApplyPressed();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioGameEditor.this.CancelPressed();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(apply);
        this.dialog.getRootPane().setDefaultButton(ok);
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void CancelPressed() {
        this.dialog.setVisible(false);
    }

    public void ApplyPressed() {
        this.scenario.setName(this.nameField.getText());
        this.scenario.setScenarioBriefing(this.briefingArea.getText());
        this.scenario.getOptions().setAftArcFire(this.aftArcFireButton.isSelected());
        this.scenario.getOptions().setCinematicMovement(1 == this.cinematicMovementOption.getSelectedIndex());
        this.scenario.getOptions().setCoreSystems(this.coreSystemsButton.isSelected());
        this.scenario.getOptions().setPenetratingDamage(this.penetratingDamageButton.isSelected());
        this.scenario.getOptions().setSensorRangeBand(this.sensorRangeBandSlider.getValue());
        this.scenario.getOptions().setSensorRules(this.sensorRulesOption.getSelectedIndex());
        this.scenario.getOptions().setSensorLevel(this.sensorLevelOption.getSelectedIndex());
        this.scenario.getOptions().setShipRoll(this.shipRollButton.isSelected());
        this.scenario.getOptions().setSimultaneousFire(this.simultaneousFireButton.isSelected());
        this.scenario.getOptions().setTargetResolution(this.targetResolutionOption.getSelectedIndex() + 1);
        this.scenario.getOptions().setThresholdDamagedSystems(this.thresholdDamagedSystemsButton.isSelected());
        this.scenario.getOptions().setAreaDefenseActivationRange(this.areaDefenseActivationRangeSlider.getValue());
        this.scenario.getOptions().setBeamRangeBand(this.beamRangeBandSlider.getValue());
        this.scenario.getOptions().setKineticGunRangeBand(this.kineticGunRangeBandSlider.getValue());
        this.scenario.getOptions().setPointDefenseRange(this.pointDefenseRangeSlider.getValue());
        this.scenario.getOptions().setPulseTorpedoRangeBand(this.pulseTorpedoRangeBandSlider.getValue());
        this.scenario.getOptions().setMultipleKineticPenetratorPackRange(this.multipleKineticPenetratorPackRangeSlider.getValue());
        this.scenario.getOptions().setNeedleBeamRange(this.needleBeamRangeSlider.getValue());
        this.scenario.getOptions().setSalvoMissileRange(this.salvoMissileRangeSlider.getValue());
        this.scenario.getOptions().setSalvoMissileExtendedRange(this.salvoMissileExtendedRangeSlider.getValue());
        this.scenario.getOptions().setSalvoMissileLockOn(this.salvoMissileLockOnSlider.getValue());
        this.scenario.getOptions().setScattergunRange(this.scattergunRangeSlider.getValue());
        this.scenario.getOptions().setSubmunitionPackRangeBand(this.submunitionPackRangeBandSlider.getValue());
    }

    public void OKPressed() {
        this.ApplyPressed();
        this.dialog.setVisible(false);
    }

    public JSlider makeSlider(int i, int j, double k) {
        return this.makeSlider(i, j, (int)k);
    }

    public JSlider makeSlider(int i, int j, int k) {
        JSlider s = new JSlider(i, j, k);
        s.setMajorTickSpacing(6);
        s.setPaintTicks(true);
        s.setPaintLabels(true);
        s.setAlignmentX(0.0f);
        return s;
    }

    JPanel makeRangeBands() {
        GridBagLayout bag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(bag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("ADF:"), c);
        this.areaDefenseActivationRangeSlider = this.makeSlider(0, 24, this.scenario.getOptions().getAreaDefenseActivationRange());
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.areaDefenseActivationRangeSlider, c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Beam:"), c);
        this.beamRangeBandSlider = this.makeSlider(0, 36, this.scenario.getOptions().getBeamRangeBand());
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.beamRangeBandSlider, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("K-Gen:"), c);
        this.kineticGunRangeBandSlider = this.makeSlider(0, 36, this.scenario.getOptions().getKineticGunRangeBand());
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.kineticGunRangeBandSlider, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("PDF:"), c);
        this.pointDefenseRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getPointDefenseRange());
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.pointDefenseRangeSlider, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Pulse Torp:"), c);
        this.pulseTorpedoRangeBandSlider = this.makeSlider(0, 36, this.scenario.getOptions().getPulseTorpedoRangeBand());
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.pulseTorpedoRangeBandSlider, c);
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("K-Pack:"), c);
        this.multipleKineticPenetratorPackRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getMultipleKineticPenetratorPackRange());
        c.gridx = 3;
        c.gridy = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.multipleKineticPenetratorPackRangeSlider, c);
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Needle Beam:"), c);
        this.needleBeamRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getNeedleBeamRange());
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.needleBeamRangeSlider, c);
        c.gridx = 2;
        c.gridy = 3;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Salve Missile:"), c);
        this.salvoMissileRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getSalvoMissileRange());
        c.gridx = 3;
        c.gridy = 3;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.salvoMissileRangeSlider, c);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("ER Missile:"), c);
        this.salvoMissileExtendedRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getSalvoMissileExtendedRange());
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.salvoMissileExtendedRangeSlider, c);
        c.gridx = 2;
        c.gridy = 4;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Missile Lock On:"), c);
        this.salvoMissileLockOnSlider = this.makeSlider(0, 36, this.scenario.getOptions().getSalvoMissileLockOn());
        c.gridx = 3;
        c.gridy = 4;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.salvoMissileLockOnSlider, c);
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Scattergun:"), c);
        this.scattergunRangeSlider = this.makeSlider(0, 36, this.scenario.getOptions().getScattergunRange());
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.scattergunRangeSlider, c);
        c.gridx = 2;
        c.gridy = 5;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel("Sub Pack:"), c);
        this.submunitionPackRangeBandSlider = this.makeSlider(0, 36, this.scenario.getOptions().getSubmunitionPackRangeBand());
        c.gridx = 3;
        c.gridy = 5;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.submunitionPackRangeBandSlider, c);
        panel.validate();
        return panel;
    }
}

