/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ColorButtonListener;
import ftjava.gui.Preferences;
import ftjava.gui.PreferencesToolTips;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class PreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static String[] fonts = new String[]{"Serif", "SansSerif", "Monospaced"};
    static String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    static String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "Bold-Italic"};

    PreferencesPanel(String[][] keys, Properties preferences, Hashtable hash) {
        Hashtable toolTips = PreferencesToolTips.getToolTips();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(6, 6, 6, 6);
        c.ipadx = 3;
        c.ipady = 0;
        for (int i = 0; i < keys.length; ++i) {
            JComponent f;
            String key = keys[i][0];
            String keycode = keys[i][1];
            String value = preferences.getProperty(key);
            String tip = (String)toolTips.get(key);
            JLabel l = new JLabel(key);
            l.setToolTipText(tip);
            this.add((Component)l, c);
            if (keycode.equals("text")) {
                c.fill = 2;
                f = new JTextField(15);
                ((JTextComponent)f).setText(value);
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                hash.put(key, f);
            } else if (keycode.equals("password")) {
                c.fill = 2;
                f = new JPasswordField(15);
                ((JPasswordField)f).setText(value);
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                hash.put(key, f);
            } else if (keycode.equals("font")) {
                c.fill = 2;
                f = new JComboBox<String>(fonts);
                ((JComboBox)f).setSelectedItem(value);
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                hash.put(key, f);
            } else if (keycode.equals("fontstyle")) {
                c.fill = 0;
                f = new JComboBox<String>(fontStyles);
                ((JComboBox)f).setSelectedItem(value);
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                hash.put(key, f);
            } else if (keycode.equals("fontsize")) {
                c.fill = 0;
                f = new JComboBox<String>(fontSizes);
                ((JComboBox)f).setSelectedItem(value);
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                hash.put(key, f);
            } else if (keycode.equals("boolean")) {
                c.weightx = 150.0;
                c.fill = 2;
                f = new JCheckBox();
                if (value.equals("true")) {
                    ((AbstractButton)f).setSelected(true);
                }
                f.setToolTipText(tip);
                ++c.gridx;
                this.add((Component)f, c);
                c.weightx = 10.0;
                hash.put(key, f);
            } else if (keycode.equals("color")) {
                c.weightx = 150.0;
                c.fill = 0;
                Color buttonColor = Preferences.parseColor(value);
                JButton f2 = new JButton();
                f2.setToolTipText(tip);
                f2.setMinimumSize(new Dimension(30, 20));
                f2.setPreferredSize(new Dimension(30, 20));
                f2.setBackground(buttonColor);
                f2.setForeground(buttonColor);
                f2.addActionListener(new ColorButtonListener(this, f2, key, buttonColor));
                ++c.gridx;
                this.add((Component)f2, c);
                hash.put(key, f2);
                c.weightx = 10.0;
            }
            c.gridx = 0;
            ++c.gridy;
        }
        c.weightx = 100.0;
        c.weighty = 100.0;
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        this.add((Component)left, c);
        ++c.gridy;
        this.add((Component)right, c);
    }
}

