/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.Preferences;
import ftjava.std.Message;
import ftjava.std.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageComposer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JComboBox toCombo;
    private String from;
    private JTextArea jt;
    private MessageComposer mySelf;

    MessageComposer(String from, Vector boxLabels) {
        this(null, from, boxLabels);
    }

    MessageComposer(final Player player, String from, Vector boxLabels) {
        this.from = from;
        this.mySelf = this;
        this.setTitle("Message Composer");
        this.setSize(500, 400);
        this.setResizable(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenWidth = d.width;
        int frameWidth = this.getWidth();
        this.setLocation(screenWidth / 2 - frameWidth / 2, 0);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel south = new JPanel();
        JButton okBut = new JButton(" Send ");
        JButton clearBut = new JButton(" Clear ");
        JButton cancelBut = new JButton(" Close ");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String text = "Message added to Orders.";
                Message msg = MessageComposer.this.composeMessage();
                if (player != null) {
                    player.addOutgoingMessage(msg);
                }
                MessageComposer.this.jt.setText("");
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(MessageComposer.this.mySelf, text);
                }
            }
        });
        clearBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String text = "Message cleared.";
                MessageComposer.this.jt.setText("");
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(MessageComposer.this.mySelf, text);
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MessageComposer.this.dispose();
            }
        });
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(okBut);
        b.add(Box.createHorizontalStrut(20));
        b.add(clearBut);
        b.add(Box.createHorizontalStrut(20));
        b.add(cancelBut);
        b.add(Box.createHorizontalGlue());
        south.add(b);
        JPanel center = new JPanel();
        center.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 100.0;
        c.weighty = 100.0;
        JLabel toLab = new JLabel(" To: ");
        JLabel fromLab = new JLabel(" From: ");
        this.toCombo = new JComboBox(boxLabels);
        JLabel fromWho = new JLabel(from);
        this.jt = new JTextArea();
        this.jt.setFont(new Font("Dialog", 0, 12));
        JScrollPane scroller = new JScrollPane(this.jt);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 5.0;
        c.weighty = 5.0;
        c.anchor = 17;
        center.add((Component)toLab, c);
        ++c.gridx;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 100.0;
        center.add((Component)this.toCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 5.0;
        c.weighty = 5.0;
        c.anchor = 17;
        center.add((Component)fromLab, c);
        ++c.gridx;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 100.0;
        center.add((Component)fromWho, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.gridwidth = 2;
        c.fill = 1;
        center.add((Component)scroller, c);
        cp.add((Component)center, "Center");
        cp.add((Component)south, "South");
    }

    public Message composeMessage() {
        String to = (String)this.toCombo.getSelectedItem();
        String from = this.from;
        String msg = this.jt.getText();
        return new Message(to, from, msg);
    }

    public static void main(String[] args) {
        Vector<String> t = new Vector<String>();
        t.add("All Players");
        t.add("GameMaster");
        t.add("Team: Kali Khanate");
        t.add("Team: TJorian Confederation");
        t.add("Team: Sylvian Nomad");
        t.add("Jon Henry");
        t.add("Tom Houston");
        t.add("Billy Bob Clark");
        t.add("Ranger Smith");
        MessageComposer mcd = new MessageComposer("Jon Henry", t);
        mcd.setLocation(200, 300);
        mcd.setVisible(true);
    }
}

