/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.FTJava;
import ftjava.gui.GUIAdapter;
import ftjava.gui.Preferences;
import ftjava.gui.ShipGUIAdapter;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.gui.StarMap;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.HeavenlyBody;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.PulseTorpedo;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;
import ftjava.std.Weapon;
import ftjava.util.MathUtil;
import ftjava.util.MovementSteps;
import ftjava.util.PointContainer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class MapPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final Color ENVELOPE_FILL_COLOR = new Color(0.0f, 0.0f, 0.4f);
    private static final Color ATTACK_RANGE_FILL_COLOR = new Color(0.5f, 0.0f, 0.0f);
    private static final Color ARC_FILL_COLOR = new Color(0.8f, 0.2f, 0.2f);
    private static final Color KGUN_FILL_COLOR = new Color(0.5f, 0.7f, 1.0f);
    private static final Color SALVO_MISSILE_FILL_COLOR = new Color(1.0f, 0.65f, 0.0f);
    private static final Color PLASMA_BOLT_FILL_COLOR = new Color(0.8f, 0.65f, 0.2f);
    private static final Color SUB_PACK_FILL_COLOR = new Color(1.0f, 0.2f, 0.2f);
    private static final Color ADFC_RANGE_COLOR = new Color(0.6f, 1.0f, 0.6f);
    private static final Color SENSOR_RANGE_COLOR = new Color(0.2f, 0.6f, 0.2f);
    private static final Color SCREEN_LEVEL_BAR_COLOR = new Color(255, 255, 102);
    private static final Color HULL_GOOD_BAR_COLOR = new Color(0, 212, 0);
    private static final Color HULL_BAD_BAR_COLOR = new Color(0, 98, 0);
    private static final float[] GHOST_DASH = new float[]{8.0f, 4.0f};
    private static final BasicStroke GHOST_PLOT_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, GHOST_DASH, 0.0f);
    private static final BasicStroke GHOST_TRAIL_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, GHOST_DASH, 0.0f);
    int mx = 0;
    int my = 0;
    private JPopupMenu popupMenu;
    private ClientProgram client;
    private JMenu shipMenu = null;
    private JComponent parent = null;
    private TreeSet allAdapters = new TreeSet();
    private TreeSet shipAdapters = new TreeSet();
    private TreeSet spaceObjectAdapters = new TreeSet();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double centerX;
    private double centerY;
    private double scale = 10.0;
    private double mapWidth;
    private double mapHeight;
    private int screenWidth;
    private int screenHeight;
    private GameEngine gameEngine;
    private StarMap starMap;
    private Image backImage;
    private Image markImage;
    private Image plasmaImage;
    private TexturePaint novaPaint;
    private ConvolveOp convOpOuter;
    private ConvolveOp convOpInner;
    private boolean markDefined = false;
    private double[] currentMark = new double[2];
    private Hashtable scaleHash = new Hashtable();
    private ArrayList shipMenus = new ArrayList();

    public MapPanel(GameEngine ge, ClientProgram inClient, StarMap sMap) {
        this.client = inClient;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.screenWidth = d.width;
        this.screenHeight = d.height;
        this.gameEngine = ge;
        this.starMap = sMap;
        this.markDefined = false;
        this.setPreferredSize(new Dimension(this.screenWidth, this.screenHeight));
        this.setSize(new Dimension(this.screenWidth, this.screenHeight));
        this.setDoubleBuffered(true);
        this.revalidate();
        this.addListeners();
        this.loadAdapters();
        String imageFile = "Images/" + Preferences.getPreferences().getProperty("Background Image");
        this.backImage = ImageUtilities.getImage(imageFile, this);
        if (this.backImage == null) {
            this.backImage = ImageUtilities.getImage("Images/star_field7.gif", this);
        }
        this.markImage = ImageUtilities.getImage("Images/crosshair.gif", this);
        this.plasmaImage = ImageUtilities.getImage("Images/explosion13.gif", this);
        BufferedImage bImage = new BufferedImage(64, 64, 1);
        Graphics2D gWrite = bImage.createGraphics();
        gWrite.drawImage(this.plasmaImage, 0, 0, this);
        this.novaPaint = new TexturePaint(bImage, new Rectangle(0, 0, 128, 128));
        this.popupMenu = new JPopupMenu("Ship options");
        JMenuItem SSDMenuItem = new JMenuItem("SSD");
        SSDMenuItem.addActionListener(new RaiseClientWindow());
        this.popupMenu.add(SSDMenuItem);
        JMenuItem ClearMenuItem = new JMenuItem("Clear");
        ClearMenuItem.addActionListener(new ClearDisplay());
        this.popupMenu.add(ClearMenuItem);
        JMenu MapMenu = new JMenu("Map");
        this.popupMenu.add(MapMenu);
        JMenuItem Scale2 = new JMenuItem("1:5");
        Scale2.addActionListener(new Scale(0.2, "1:5"));
        MapMenu.add(Scale2);
        this.scaleHash.put("1:5", Scale2);
        Scale2 = new JMenuItem("1:1");
        Scale2.addActionListener(new Scale(1.0, "1:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("1:1", Scale2);
        Scale2 = new JMenuItem("2.5:1");
        Scale2.addActionListener(new Scale(2.5, "2.5:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("2.5:1", Scale2);
        Scale2 = new JMenuItem("5:1");
        Scale2.addActionListener(new Scale(5.0, "5:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("5:1", Scale2);
        Scale2 = new JMenuItem("10:1");
        Scale2.addActionListener(new Scale(10.0, "10:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("10:1", Scale2);
        Scale2 = new JMenuItem("20:1");
        Scale2.addActionListener(new Scale(20.0, "20:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("20:1", Scale2);
        Scale2 = new JMenuItem("40:1");
        Scale2.addActionListener(new Scale(40.0, "40:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("40:1", Scale2);
        Scale2 = new JMenuItem("80:1");
        Scale2.addActionListener(new Scale(80.0, "80:1"));
        MapMenu.add(Scale2);
        this.scaleHash.put("80:1", Scale2);
        JMenuItem CenterMenuItem = new JMenuItem("Center");
        CenterMenuItem.addActionListener(new CenterMapWindow());
        this.popupMenu.add(CenterMenuItem);
        JMenuItem MarkMenuItem = new JMenuItem("Set Mark");
        MarkMenuItem.addActionListener(new MarkMapWindow());
        this.popupMenu.add(MarkMenuItem);
        this.popupMenu.add(new JPopupMenu.Separator());
        this.addMouseListener(this);
        float[] kernelData = new float[49];
        for (int i = 0; i < 49; ++i) {
            kernelData[i] = 1.0f;
        }
        this.convOpOuter = new ConvolveOp(new Kernel(7, 7, kernelData));
        this.convOpInner = new ConvolveOp(new Kernel(5, 5, kernelData));
    }

    private void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MapPanel.this.mx = e.getX();
                MapPanel.this.my = e.getY();
                MapPanel.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                if (FTJava.isMacOSX() ? e.isMetaDown() : e.isAltDown()) {
                    if (e.isShiftDown()) {
                        MapPanel.this.zoomOut();
                    } else {
                        MapPanel.this.zoomIn();
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (MapPanel.this.popupMenu != null && !MapPanel.this.popupMenu.isVisible()) {
                    JScrollPane pane = (JScrollPane)MapPanel.this.parent;
                    JScrollBar hBar = pane.getHorizontalScrollBar();
                    JScrollBar vBar = pane.getVerticalScrollBar();
                    hBar.setValue(hBar.getValue() + (MapPanel.this.mx - e.getX()));
                    vBar.setValue(vBar.getValue() + (MapPanel.this.my - e.getY()));
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MapPanel.this.repaint();
            }

            public void componentShown(ComponentEvent e) {
                MapPanel.this.repaint();
            }
        });
    }

    public double getMapWidth() {
        return this.mapWidth;
    }

    public double getMapHeight() {
        return this.mapHeight;
    }

    public void loadAdapters() {
        this.loadAdapters(true);
    }

    public void loadAdapters(boolean calcBounds) {
        Iterator it;
        int count = this.gameEngine.getNumberOfShips();
        for (int i = 0; i < count; ++i) {
            boolean found = false;
            it = this.shipAdapters.iterator();
            while (it.hasNext()) {
                ShipGUIAdapter sga = (ShipGUIAdapter)it.next();
                if (sga.getShip() != this.gameEngine.getShip(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ShipGUIAdapter a = new ShipGUIAdapter(this.gameEngine, this.gameEngine.getShip(i), i);
            this.allAdapters.add(a);
            this.shipAdapters.add(a);
        }
        it = this.shipAdapters.iterator();
        while (it.hasNext()) {
            ShipGUIAdapter sga = (ShipGUIAdapter)it.next();
            if (this.gameEngine.getShips().contains(sga.getShip())) continue;
            it.remove();
        }
        ArrayList allObjects = this.gameEngine.getActiveObjects();
        for (int i = 0; i < allObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjects.get(i);
            if (so instanceof Ship) continue;
            boolean found = false;
            it = this.spaceObjectAdapters.iterator();
            while (it.hasNext()) {
                SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)it.next();
                if (soga.getSpaceObject() != so) continue;
                found = true;
                break;
            }
            if (found) continue;
            SpaceObjectGUIAdapter a = new SpaceObjectGUIAdapter(this.gameEngine, so, i);
            this.allAdapters.add(a);
            this.spaceObjectAdapters.add(a);
        }
        it = this.spaceObjectAdapters.iterator();
        while (it.hasNext()) {
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)it.next();
            if (this.gameEngine.getActiveObjects().contains(soga.getSpaceObject())) continue;
            it.remove();
        }
        if (calcBounds) {
            this.calculateBounds();
        }
    }

    public void setScale(double s, String l) {
        this.starMap.setStarMapTitle(l);
        this.scale = s;
    }

    public double getScale() {
        return this.scale;
    }

    public TreeSet getAllAdapters() {
        return this.allAdapters;
    }

    public TreeSet getShipAdapters() {
        return this.shipAdapters;
    }

    public TreeSet getSpaceObjectAdapters() {
        return this.spaceObjectAdapters;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.doPopup(e);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void clearDisplay() {
        Iterator i = this.shipAdapters.iterator();
        while (i.hasNext()) {
            ((ShipGUIAdapter)i.next()).clearDisplay();
        }
        Iterator j = this.spaceObjectAdapters.iterator();
        while (j.hasNext()) {
            ((SpaceObjectGUIAdapter)j.next()).clearDisplay();
        }
        this.repaint();
    }

    public void zoomIn() {
        if (this.scale < 0.2) {
            this.setScale(0.2, "1:5");
        } else if (this.scale >= 0.2 && this.scale < 1.0) {
            this.setScale(1.0, "1:1");
        } else if (this.scale >= 1.0 && this.scale < 2.5) {
            this.setScale(2.5, "2.5:1");
        } else if (this.scale >= 2.5 && this.scale < 5.0) {
            this.setScale(5.0, "5:1");
        } else if (this.scale >= 5.0 && this.scale < 10.0) {
            this.setScale(10.0, "10:1");
        } else if (this.scale >= 10.0 && this.scale < 20.0) {
            this.setScale(20.0, "20:1");
        } else if (this.scale >= 20.0 && this.scale < 40.0) {
            this.setScale(40.0, "40:1");
        } else if (this.scale >= 40.0 && this.scale < 80.0) {
            this.setScale(80.0, "80:1");
        } else {
            return;
        }
        this.calculateBounds();
        if (this.starMap.getCenterOnShip()) {
            this.centerOnShip(this.starMap.getActiveSelection());
        }
        this.revalidate();
        this.repaint();
    }

    public void zoomOut() {
        if (this.scale > 80.0) {
            this.setScale(80.0, "80:1");
        } else if (this.scale > 40.0 && this.scale <= 80.0) {
            this.setScale(40.0, "40:1");
        } else if (this.scale > 20.0 && this.scale <= 40.0) {
            this.setScale(20.0, "20:1");
        } else if (this.scale > 10.0 && this.scale <= 20.0) {
            this.setScale(10.0, "10:1");
        } else if (this.scale > 5.0 && this.scale <= 10.0) {
            this.setScale(5.0, "5:1");
        } else if (this.scale > 2.5 && this.scale <= 5.0) {
            this.setScale(2.5, "2.5:1");
        } else if (this.scale > 1.0 && this.scale <= 2.5) {
            this.setScale(1.0, "1:1");
        } else if (this.scale > 0.2 && this.scale <= 1.0) {
            this.setScale(0.2, "1:5");
        } else {
            return;
        }
        this.calculateBounds();
        if (this.starMap.getCenterOnShip()) {
            this.centerOnShip(this.starMap.getActiveSelection());
        }
        this.revalidate();
        this.repaint();
    }

    public Point getCurrentCenter() {
        JScrollPane pane = (JScrollPane)this.parent;
        Rectangle r = pane.getViewport().getViewRect();
        Point p = new Point();
        p.x = r.x + (int)((double)r.width / 2.0);
        p.y = r.y + (int)((double)r.height / 2.0);
        return p;
    }

    public void centerAtShipCoords(double x, double y) {
        this.centerAtMapCoords(this.X(x), this.Y(y));
    }

    public void centerAtMapCoords(int x, int y) {
        JScrollPane pane = (JScrollPane)this.parent;
        Rectangle r = pane.getViewport().getViewRect();
        Point p = new Point();
        p.x = x - (int)((double)r.width / 2.0);
        p.y = y - (int)((double)r.height / 2.0);
        if ((double)p.x < 0.0) {
            p.x = 0;
        }
        if ((double)p.x > (double)r.width + this.mapWidth) {
            p.x = (int)(this.mapWidth - (double)r.width);
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if ((double)p.y > (double)r.height + this.mapHeight) {
            p.y = (int)(this.mapHeight - (double)r.width);
        }
        pane.getViewport().setViewPosition(p);
    }

    public void centerOnShip(GUIAdapter ga) {
        if (ga instanceof ShipGUIAdapter) {
            ShipGUIAdapter sga = (ShipGUIAdapter)ga;
            this.centerAtShipCoords(sga.getShip().getXPosition(), sga.getShip().getYPosition());
            return;
        }
        if (ga instanceof SpaceObjectGUIAdapter) {
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)ga;
            this.centerAtShipCoords(soga.getSpaceObject().getXPosition(), soga.getSpaceObject().getYPosition());
            return;
        }
    }

    private void doPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Iterator i = this.shipMenus.iterator();
            while (i.hasNext()) {
                this.popupMenu.remove((JMenuItem)i.next());
            }
            this.shipMenus.clear();
            double x = this.getShipX(e.getX());
            double y = this.getShipY(e.getY());
            ArrayList list = this.findShipsByCoords(x, y);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                GUIAdapter s;
                Object o = it.next();
                if (o instanceof ShipGUIAdapter) {
                    s = (ShipGUIAdapter)o;
                    this.shipMenu = ((ShipGUIAdapter)s).getMenu();
                } else if (o instanceof SpaceObjectGUIAdapter) {
                    s = (SpaceObjectGUIAdapter)o;
                    this.shipMenu = ((SpaceObjectGUIAdapter)s).getMenu();
                }
                this.shipMenus.add(this.shipMenu);
                this.popupMenu.add(this.shipMenu);
            }
            int mouseX = e.getX();
            int mouseY = e.getY();
            int sizeX = this.popupMenu.getWidth();
            int sizeY = this.popupMenu.getHeight();
            int menuX = mouseX;
            int menuY = mouseY;
            JScrollPane jp = (JScrollPane)this.parent;
            int scrollX = jp.getHorizontalScrollBar().getValue();
            int scrollY = jp.getVerticalScrollBar().getValue();
            int paneX = this.parent.getLocationOnScreen().x;
            int doubleTaskBar = 50;
            int paneY = this.parent.getLocationOnScreen().y;
            if (mouseY + sizeY + doubleTaskBar + paneY - scrollY > this.screenHeight) {
                menuY -= sizeY;
            }
            if (mouseX + sizeX + paneX - scrollX > this.screenWidth) {
                menuX -= sizeX;
            }
            this.popupMenu.show(this, menuX, menuY);
        }
    }

    public ArrayList findShipsByCoords(double x, double y) {
        double dy;
        double dx;
        GUIAdapter a;
        ArrayList<GUIAdapter> Ships = new ArrayList<GUIAdapter>();
        Iterator i = this.shipAdapters.iterator();
        while (i.hasNext()) {
            a = (ShipGUIAdapter)i.next();
            Ship s = ((ShipGUIAdapter)a).getShip();
            if (s.isDestroyed() || s.hasJumped() || !((dx = s.getXPosition() - x) * dx + (dy = s.getYPosition() - y) * dy < 10.0)) continue;
            Ships.add(a);
        }
        i = this.spaceObjectAdapters.iterator();
        while (i.hasNext()) {
            a = (SpaceObjectGUIAdapter)i.next();
            SpaceObject so = ((SpaceObjectGUIAdapter)a).getSpaceObject();
            dx = so.getXPosition() - x;
            if (!(dx * dx + (dy = so.getYPosition() - y) * dy < 10.0)) continue;
            Ships.add(a);
        }
        return Ships;
    }

    public void setParent(JComponent c) {
        this.parent = c;
    }

    public void calculateBounds() {
        double h;
        double w;
        double avgX = 0.0;
        double avgY = 0.0;
        boolean anyBounds = false;
        this.minY = 999999.0;
        this.minX = 999999.0;
        this.maxY = -999999.0;
        this.maxX = -999999.0;
        int count = this.gameEngine.getActiveObjects().size();
        Ship s = null;
        ArrayList all = this.gameEngine.getActiveObjects();
        for (int i = 0; i < count; ++i) {
            SpaceObject so = (SpaceObject)all.get(i);
            double x = so.getXPosition();
            double y = so.getYPosition();
            double delta = 36.0;
            if (so instanceof Ship) {
                s = (Ship)so;
                if (s.isDestroyed()) continue;
                x = s.getXPosition();
                y = s.getYPosition();
                double v = Math.max((double)s.getSpeed(), s.getVectorSpeed());
                double t = s.getCurrentThrust();
                delta = v + t;
            }
            avgX += x;
            avgY += y;
            if (x - delta < this.minX) {
                this.minX = x - delta;
            }
            if (x + delta > this.maxX) {
                this.maxX = x + delta;
            }
            if (y - delta < this.minY) {
                this.minY = y - delta;
            }
            if (y + delta > this.maxY) {
                this.maxY = y + delta;
            }
            anyBounds = true;
        }
        if (count != 0) {
            avgX = (this.maxX + this.minX) / 2.0;
            avgY = (this.maxY + this.minY) / 2.0;
        }
        if (!anyBounds) {
            this.minY = 0.0;
            this.minX = 0.0;
            this.maxY = 80.0;
            this.maxX = 80.0;
            avgY = 40.0;
            avgX = 40.0;
        }
        if (this.parent != null) {
            w = this.parent.getWidth();
            h = this.parent.getHeight();
        } else {
            w = this.getWidth();
            h = this.getHeight();
        }
        if (this.scale == -1.0) {
            double s1 = w / ((this.maxX - this.minX) * 1.1);
            double s2 = h / ((this.maxY - this.minY) * 1.1);
            this.scale = s1 < s2 ? s2 : s1;
        }
        this.mapWidth = (this.maxX - this.minX) * this.scale * 1.5;
        this.mapHeight = (this.maxY - this.minY) * this.scale * 1.5;
        if (this.mapWidth < w) {
            this.mapWidth = w;
        }
        if (this.mapHeight < h) {
            this.mapHeight = h;
        }
        this.centerX = avgX;
        this.centerY = avgY;
        this.setPreferredSize(new Dimension((int)this.mapWidth, (int)this.mapHeight));
        this.revalidate();
    }

    public int X(double inX) {
        int outX = (int)(this.mapWidth / 2.0 + this.scale * (inX - this.centerX));
        return outX;
    }

    public int Y(double inY) {
        int outY = (int)(this.mapHeight / 2.0 + this.scale * (-inY + this.centerY));
        return outY;
    }

    public double getShipX(double inX) {
        return (inX - this.mapWidth / 2.0) / this.scale + this.centerX;
    }

    public double getShipY(double inY) {
        return -1.0 * ((inY - this.mapHeight / 2.0) / this.scale - this.centerY);
    }

    public boolean isMarkDefined() {
        return this.markDefined;
    }

    public void setCurrentMark(double x, double y) {
        this.markDefined = true;
        this.currentMark[0] = x;
        this.currentMark[1] = y;
    }

    public double[] getCurrentMark() {
        if (!this.isMarkDefined()) {
            throw new RuntimeException("Undefined Map Mark");
        }
        return this.currentMark;
    }

    public int[] getMapMark() {
        if (!this.isMarkDefined()) {
            throw new RuntimeException("Undefined Map Mark");
        }
        int[] mapMark = new int[]{this.X(this.currentMark[0]), this.Y(this.currentMark[1])};
        return mapMark;
    }

    public void paintGhostPlot(Graphics2D g, ShipGUIAdapter adapter) {
        if (!adapter.getShowGhostPlot()) {
            return;
        }
        Ship s = adapter.getShip();
        MovementSteps ms = adapter.getGhostPlot();
        Stroke oldStroke = g.getStroke();
        g.setStroke(GHOST_PLOT_STROKE);
        double sx = s.getXPosition();
        double sy = s.getYPosition();
        g.setColor(Color.white);
        g.drawLine(this.X(sx), this.Y(sy), this.X(sx + ms.First[0]), this.Y(sy + ms.First[1]));
        g.drawLine(this.X(sx + ms.First[0]), this.Y(sy + ms.First[1]), this.X(sx + ms.First[0] + ms.Second[0]), this.Y(sy + ms.First[1] + ms.Second[1]));
        g.setStroke(oldStroke);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        BufferedImage Icon2 = adapter.getImage(ms.Heading[1]);
        int xOffset = (int)((double)Icon2.getWidth() / 2.0);
        int yOffset = (int)((double)Icon2.getHeight() / 2.0);
        g.drawImage((Image)Icon2, this.X(sx + ms.First[0] + ms.Second[0]) - xOffset, this.Y(sy + ms.First[1] + ms.Second[1]) - yOffset, null);
        g.setComposite(oldComposite);
    }

    public void paintMissileGhostPlot(Graphics2D g, SpaceObjectGUIAdapter adapter) {
        SpaceObject s = adapter.getSpaceObject();
        if (!(s instanceof Missile)) {
            return;
        }
        Missile m = (Missile)s;
        MovementSteps ms = m.getMovementSteps();
        Stroke oldStroke = g.getStroke();
        g.setStroke(GHOST_PLOT_STROKE);
        double sx = s.getXPosition();
        double sy = s.getYPosition();
        g.setColor(Color.white);
        g.drawLine(this.X(sx), this.Y(sy), this.X(sx + ms.First[0]), this.Y(sy + ms.First[1]));
        g.drawLine(this.X(sx + ms.First[0]), this.Y(sy + ms.First[1]), this.X(sx + ms.First[0] + ms.Second[0]), this.Y(sy + ms.First[1] + ms.Second[1]));
        g.setStroke(oldStroke);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        BufferedImage Icon2 = adapter.getImage(ms.Heading[1], this.scale);
        int xOffset = (int)((double)Icon2.getWidth() / 2.0);
        int yOffset = (int)((double)Icon2.getHeight() / 2.0);
        g.drawImage((Image)Icon2, this.X(sx + ms.First[0] + ms.Second[0]) - xOffset, this.Y(sy + ms.First[1] + ms.Second[1]) - yOffset, null);
        g.setComposite(oldComposite);
    }

    public void paintGhostTrail(Graphics2D g, ShipGUIAdapter adapter) {
        if (!adapter.getShowGhostTrail()) {
            return;
        }
        Ship s = adapter.getShip();
        Stroke oldStroke = g.getStroke();
        g.setStroke(GHOST_TRAIL_STROKE);
        double sx = s.getXPosition();
        double sy = s.getYPosition();
        double px = s.getPastX();
        double py = s.getPastY();
        int ph = s.getPastHeading();
        g.setColor(Color.white);
        g.drawLine(this.X(sx), this.Y(sy), this.X(px), this.Y(py));
        g.setStroke(oldStroke);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        BufferedImage Icon2 = adapter.getImage(ph);
        int xOffset = (int)((double)Icon2.getWidth() / 2.0);
        int yOffset = (int)((double)Icon2.getHeight() / 2.0);
        g.drawImage((Image)Icon2, this.X(px) - xOffset, this.Y(py) - yOffset, null);
        g.setComposite(oldComposite);
    }

    public void paintLockOns(Graphics2D g, ShipGUIAdapter adapter) {
        if (!adapter.getShowLockOns()) {
            return;
        }
        Ship s = adapter.getShip();
        Stroke oldStroke = g.getStroke();
        float[] dash1 = new float[]{2.0f, 6.0f};
        float[] dash2 = new float[]{4.0f, 4.0f};
        BasicStroke stroke1 = null;
        BasicStroke stroke2 = null;
        stroke1 = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
        stroke2 = new BasicStroke(1.0f, 0, 0, 1.0f, dash2, 0.0f);
        double sx = s.getXPosition();
        double sy = s.getYPosition();
        g.setStroke(stroke1);
        ArrayList wList = s.getWeaponSystems();
        for (int i = 0; i < wList.size(); ++i) {
            Weapon w = (Weapon)wList.get(i);
            if (!w.isPointDefense() || !w.isOperational() || w.getTarget() == null) continue;
            SpaceObject pd = w.getTarget();
            double spx = pd.getXPosition();
            double spy = pd.getYPosition();
            g.setColor(Color.white);
            g.drawLine(this.X(sx), this.Y(sy), this.X(spx), this.Y(spy));
        }
        g.setStroke(stroke2);
        SpaceObject o = s.getPrimaryTarget();
        if (o != null && !o.getStatus().equals("Destroyed")) {
            double s1x = o.getXPosition();
            double s1y = o.getYPosition();
            g.setColor(Color.red);
            g.drawLine(this.X(sx), this.Y(sy), this.X(s1x), this.Y(s1y));
        }
        if ((o = s.getSecondaryTarget()) != null && !o.getStatus().equals("Destroyed")) {
            double s2x = o.getXPosition();
            double s2y = o.getYPosition();
            g.setColor(Color.yellow);
            g.drawLine(this.X(sx), this.Y(sy), this.X(s2x), this.Y(s2y));
        }
        if ((o = s.getTertiaryTarget()) != null && !o.getStatus().equals("Destroyed")) {
            double s3x = o.getXPosition();
            double s3y = o.getYPosition();
            g.setColor(Color.green);
            g.drawLine(this.X(sx), this.Y(sy), this.X(s3x), this.Y(s3y));
        }
        g.setStroke(oldStroke);
    }

    public void paintLockOns(Graphics gin, SpaceObjectGUIAdapter adapter) {
        if (!adapter.getShowLockOns()) {
            return;
        }
        Graphics2D g = (Graphics2D)gin;
        SpaceObject o = adapter.getSpaceObject();
        if (o instanceof PlasmaBolt) {
            return;
        }
        int targetId = 0;
        if (o instanceof MissileSalvo) {
            targetId = ((MissileSalvo)o).getTargetId();
        }
        if (o instanceof AntiMatterTorpedo) {
            targetId = ((AntiMatterTorpedo)o).getTargetId();
        }
        if (o instanceof FighterGroup) {
            targetId = ((FighterGroup)o).getTargetId();
            int count = ((FighterGroup)o).getCount();
            boolean onBoard = ((FighterGroup)o).isOnBoard();
            if (count == 0 || onBoard) {
                return;
            }
        }
        if (targetId == 0) {
            return;
        }
        SpaceObject t = this.gameEngine.getObjectById(targetId);
        if (t == null) {
            return;
        }
        double sx = o.getXPosition();
        double sy = o.getYPosition();
        double s1x = t.getXPosition();
        double s1y = t.getYPosition();
        g.setColor(Color.yellow);
        g.drawLine(this.X(sx), this.Y(sy), this.X(s1x), this.Y(s1y));
    }

    public void paintFighterEnvelope(Graphics gin, SpaceObjectGUIAdapter adapter) {
        if (!adapter.getShowMoveRangeBand()) {
            return;
        }
        Graphics2D g = (Graphics2D)gin;
        SpaceObject o = adapter.getSpaceObject();
        if (!(o instanceof FighterGroup)) {
            return;
        }
        FighterGroup fg = (FighterGroup)o;
        int count = fg.getCount();
        boolean onBoard = fg.isOnBoard();
        if (count == 0 || onBoard) {
            return;
        }
        double xP = fg.getPastX();
        double yP = fg.getPastY();
        double normalBand = fg.getSpeed();
        double maxBand = normalBand + this.gameEngine.getOptions().getFighterSecondaryRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double temp = normalBand * this.scale;
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(ENVELOPE_FILL_COLOR);
        g.fillArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        g.setComposite(oldComposite);
        g.setColor(Color.white);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        temp = maxBand * this.scale;
        g.setColor(Color.white);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
    }

    public void paintMovementEnvelope(Graphics gin, ShipGUIAdapter adapter) {
        if (!adapter.getShowPlotEnvelope()) {
            return;
        }
        Graphics2D g = (Graphics2D)gin;
        double[] x = null;
        double[] y = null;
        PointContainer pc = adapter.getPlotEnvelope();
        x = pc.x;
        y = pc.y;
        Polygon p = new Polygon();
        for (int i = 0; i < x.length; ++i) {
            p.addPoint(this.X(x[i]), this.Y(y[i]));
        }
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(ENVELOPE_FILL_COLOR);
        g.fillPolygon(p);
        g.setComposite(oldComposite);
        g.setColor(Color.white);
        g.drawPolygon(p);
    }

    public void paintMissileEnvelope(Graphics gin, SpaceObjectGUIAdapter adapter) {
        if (!adapter.getShowMoveRangeBand()) {
            return;
        }
        Graphics2D g = (Graphics2D)gin;
        SpaceObject o = adapter.getSpaceObject();
        if (!(o instanceof Missile)) {
            return;
        }
        Missile m = (Missile)o;
        double xP = m.getPastX();
        double yP = m.getPastY();
        double normalBand = m.getSpeed();
        double heading = MathUtil.angleFromHeading(m.getHeading());
        double px = this.X(xP);
        double py = this.Y(yP);
        double temp = normalBand * this.scale;
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(ENVELOPE_FILL_COLOR);
        g.fillArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)(heading - 60.0), (int)(heading + 60.0));
        g.setComposite(oldComposite);
        g.setColor(Color.white);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)(heading - 60.0), (int)(heading + 60.0));
    }

    public void paintArcs(Graphics g, ShipGUIAdapter adapter) {
        if (adapter.getArcOption() == 0) {
            this.paintRangeArcs(g, adapter);
        }
        if (adapter.getArcOption() == 15) {
            this.paintSensorArcs(g, adapter);
        }
        if (adapter.getArcOption() == 1) {
            this.paintBeamArcs(g, adapter);
        }
        if (adapter.getArcOption() == 2) {
            this.paintPTorpArcs(g, adapter);
        }
        if (adapter.getArcOption() == 9) {
            this.paintKGunArcs(g, adapter);
        }
        if (adapter.getArcOption() == 3) {
            this.paintSubPackArcs(g, adapter);
        }
        if (adapter.getArcOption() == 10) {
            this.paintSalvoMissileArcs(g, adapter);
        }
        if (adapter.getArcOption() == 11) {
            this.paintPlasmaBoltArcs(g, adapter);
        }
        if (adapter.getArcOption() == 12) {
            this.paintPulserArcs(g, adapter);
        }
        if (adapter.getArcOption() == 13) {
            this.paintPointDefenseArcs(g, adapter);
        }
        if (adapter.getArcOption() == 14) {
            this.paintScattergunArcs(g, adapter);
        }
        if (adapter.getArcOption() == 16) {
            this.paintGraserArcs(g, adapter);
        }
        if (adapter.getArcOption() == 17) {
            this.paintAntiMatterTorpedoArcs(g, adapter);
        }
    }

    public void paintArcs(Graphics g, SpaceObjectGUIAdapter adapter) {
        if (adapter.getShowRangeBand()) {
            this.paintRangeArcs((Graphics2D)g, adapter);
        }
        if (adapter.getShowSensorRangeBand()) {
            this.paintSensorArcs(g, adapter);
        }
    }

    public void paintRangeArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getBeamRangeBand();
        double line_offset = 0.25;
        double px = this.X(xP);
        double py = this.Y(yP);
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = adapter.getArcRange(i);
            if (range == 0.0) continue;
            int j = 0;
            double a = angle;
            while (a <= angle + 60.0) {
                if (j % 3 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.darkGray);
                }
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
                a += 20.0;
                ++j;
            }
            j = 1;
            double r = band / 2.0;
            while (r <= range) {
                double temp = r * this.scale;
                if (j % 2 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.darkGray);
                }
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                r += band / 2.0;
                ++j;
            }
        }
    }

    public void paintRangeArcs(Graphics2D g, SpaceObjectGUIAdapter adapter) {
        SpaceObject o = adapter.getSpaceObject();
        double xP = o.getXPosition();
        double yP = o.getYPosition();
        double band = 0.0;
        if (o instanceof MissileSalvo) {
            band = this.gameEngine.getOptions().getSalvoMissileLockOn();
        }
        if (o instanceof PlasmaBolt) {
            band = this.gameEngine.getOptions().getPlasmaBoltBlastRange();
        }
        if (o instanceof AntiMatterTorpedo) {
            band = this.gameEngine.getOptions().getAntiMatterTorpedoLockOnRange();
        }
        if (o instanceof FighterGroup) {
            band = this.gameEngine.getOptions().getFighterRange();
            FighterGroup fg = (FighterGroup)o;
            int count = fg.getCount();
            boolean onBoard = fg.isOnBoard();
            if (count == 0 || onBoard) {
                return;
            }
        }
        double px = this.X(xP);
        double py = this.Y(yP);
        double temp = band * this.scale;
        g.setColor(Color.red);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(ATTACK_RANGE_FILL_COLOR);
        g.fillArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        g.setComposite(oldComposite);
    }

    public void paintBeamArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getBeamRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(Color.white);
        adapter.fillBeamRange();
        int[][] beamRange = adapter.getBeamRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 6 && beamRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 0.5 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.5 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.setColor(Color.yellow);
                g.drawString(Integer.toString(beamRange[i][j]), (int)textX, (int)textY);
                g.setColor(Color.white);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintPTorpArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        PulseTorpedo pt = null;
        ArrayList Weapons = s.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PulseTorpedo)) continue;
            pt = (PulseTorpedo)w;
            break;
        }
        if (pt == null) {
            return;
        }
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = pt.getRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(Color.yellow);
        adapter.fillPulseTorpedoRange();
        int[][] pulseTorpedoRange = adapter.getPulseTorpedoRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 6 && pulseTorpedoRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 0.5 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.5 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.setColor(Color.yellow);
                g.drawString(Integer.toString(pulseTorpedoRange[i][j]), (int)textX, (int)textY);
                g.setColor(Color.yellow);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintGraserArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getGraserRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(ARC_FILL_COLOR);
        adapter.fillGraserRange();
        int[][] graserRange = adapter.getGraserRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 6 && graserRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 0.5 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.5 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.setColor(Color.yellow);
                g.drawString(Integer.toString(graserRange[i][j]), (int)textX, (int)textY);
                g.setColor(ARC_FILL_COLOR);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintAntiMatterTorpedoArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        double band = this.gameEngine.getOptions().getAntiMatterTorpedoRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(ARC_FILL_COLOR);
        adapter.fillAntiMatterTorpedoRange();
        int[][] antiMatterTorpedoRange = adapter.getAntiMatterTorpedoRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 1 && antiMatterTorpedoRange[i][j] != 0; ++j) {
                range = band;
                double textX = px + this.scale * (range - 0.5 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.5 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.drawString(Integer.toString(antiMatterTorpedoRange[i][j]), (int)textX, (int)textY);
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintKGunArcs(Graphics g, ShipGUIAdapter adapter) {
        double angle;
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (!s.hasKineticGuns()) {
            return;
        }
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getKineticGunRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(KGUN_FILL_COLOR);
        adapter.fillKGunRange();
        int[][] kGunRange = adapter.getKGunRange();
        for (int i = 0; i < 6; ++i) {
            angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 6 && kGunRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
            }
        }
        for (double a = angle = adapter.getArcStart(h, 0); a <= angle + 60.0; a += 60.0) {
            double radians = MathUtil.toRadians(a);
            double startX = px + this.scale * line_offset * band * Math.cos(radians);
            double startY = py - this.scale * line_offset * band * Math.sin(radians);
            double endX = px + this.scale * 5.0 * band * Math.cos(radians);
            double endY = py - this.scale * 5.0 * band * Math.sin(radians);
            g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
        }
    }

    public void paintSalvoMissileArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        double band = this.gameEngine.getOptions().getSalvoMissileRange();
        double extendedBand = this.gameEngine.getOptions().getSalvoMissileExtendedRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(SALVO_MISSILE_FILL_COLOR);
        adapter.fillSalvoMissileRange();
        int[][] salvoMissileRange = adapter.getSalvoMissileRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 2 && salvoMissileRange[i][j] != 0; ++j) {
                range = band;
                if (j == 1) {
                    range = extendedBand;
                }
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 6.0) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 6.0) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.drawString(Integer.toString(salvoMissileRange[i][j]), (int)textX, (int)textY);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintPlasmaBoltArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        double band = this.gameEngine.getOptions().getPlasmaBoltRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(PLASMA_BOLT_FILL_COLOR);
        adapter.fillPlasmaBoltRange();
        int[][] plasmaBoltRange = adapter.getPlasmaBoltRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 1 && plasmaBoltRange[i][j] != 0; ++j) {
                range = band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintPulserArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getPulserRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(Color.white);
        adapter.fillPulserRange();
        int[][] pulserRange = adapter.getPulserRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 3 && pulserRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 0.5 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.5 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.setColor(Color.yellow);
                g.drawString(Integer.toString(pulserRange[i][j]), (int)textX, (int)textY);
                g.setColor(Color.white);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintSubPackArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int h = s.getHeading();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
            h = adapter.getPlottedHeading();
        }
        double band = this.gameEngine.getOptions().getSubmunitionPackRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        double line_offset = 0.25;
        g.setColor(SUB_PACK_FILL_COLOR);
        adapter.fillSubmunitionPackRange();
        int[][] submunitionPackRange = adapter.getSubmunitionPackRange();
        for (int i = 0; i < 6; ++i) {
            double angle = adapter.getArcStart(h, i);
            double range = 0.0;
            for (int j = 0; j < 6 && submunitionPackRange[i][j] != 0; ++j) {
                range = (double)(j + 1) * band;
                double temp = range * this.scale;
                g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), (int)angle, 60);
                double textX = px + this.scale * (range - 0.3 * band) * Math.cos(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                double textY = py - this.scale * (range - 0.3 * band) * Math.sin(MathUtil.toRadians(adapter.getArcAngle(h, i)));
                g.setColor(SUB_PACK_FILL_COLOR);
                g.drawString(Integer.toString(submunitionPackRange[i][j]), (int)textX, (int)textY);
                g.setColor(SUB_PACK_FILL_COLOR);
            }
            if (range == 0.0) continue;
            for (double a = angle; a <= angle + 60.0; a += 60.0) {
                double radians = MathUtil.toRadians(a);
                double startX = px + this.scale * line_offset * band * Math.cos(radians);
                double startY = py - this.scale * line_offset * band * Math.sin(radians);
                double endX = px + this.scale * range * Math.cos(radians);
                double endY = py - this.scale * range * Math.sin(radians);
                g.drawLine((int)startX, (int)startY, (int)endX, (int)endY);
            }
        }
    }

    public void paintPointDefenseArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
        }
        double band = this.gameEngine.getOptions().getPointDefenseRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double temp = band * this.scale;
        g.setColor(Color.white);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        if (s.getNumberOfActiveAreaDefenseFireControls() > 0) {
            temp = (band += this.gameEngine.getOptions().getAreaDefenseActivationRange()) * this.scale;
            g.setColor(ADFC_RANGE_COLOR);
            g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
        }
    }

    public void paintScattergunArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
        }
        double band = this.gameEngine.getOptions().getScattergunRange();
        double px = this.X(xP);
        double py = this.Y(yP);
        double temp = band * this.scale;
        g.setColor(Color.white);
        g.drawArc((int)(px - temp), (int)(py - temp), (int)(2.0 * temp), (int)(2.0 * temp), 0, 360);
    }

    public void paintSensorArcs(Graphics g, ShipGUIAdapter adapter) {
        Ship s = adapter.getShip();
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        if (adapter.getShowGhostPlot()) {
            xP = adapter.getPlottedX();
            yP = adapter.getPlottedY();
        }
        double band = this.gameEngine.getOptions().getSensorRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        int limit = 6;
        if (this.gameEngine.getOptions().getSensorRules() == 2) {
            limit = 5;
        }
        double[] ranges = new double[]{band, 2.0 * band, 3.0 * band, 4.0 * band, 5.0 * band, 10.0 * band};
        for (int i = 0; i < limit; ++i) {
            double range = ranges[i] * this.scale;
            g.setColor(SENSOR_RANGE_COLOR);
            g.drawArc((int)(px - range), (int)(py - range), (int)(2.0 * range), (int)(2.0 * range), 0, 360);
        }
    }

    public void paintSensorArcs(Graphics g, SpaceObjectGUIAdapter adapter) {
        SpaceObject so = adapter.getSpaceObject();
        if (!(so instanceof FighterGroup)) {
            return;
        }
        double xP = so.getXPosition();
        double yP = so.getYPosition();
        double band = this.gameEngine.getOptions().getSensorRangeBand();
        double px = this.X(xP);
        double py = this.Y(yP);
        int limit = 6;
        if (this.gameEngine.getOptions().getSensorRules() == 2) {
            limit = 5;
        }
        double[] ranges = new double[]{band, 2.0 * band, 3.0 * band, 4.0 * band, 5.0 * band, 10.0 * band};
        for (int i = 0; i < limit; ++i) {
            double range = ranges[i] * this.scale;
            g.setColor(SENSOR_RANGE_COLOR);
            g.drawArc((int)(px - range), (int)(py - range), (int)(2.0 * range), (int)(2.0 * range), 0, 360);
        }
    }

    public void paintBackground(Graphics g) {
        int i = 0;
        int j = 0;
        int imageWidth = this.backImage.getWidth(this);
        int imageHeight = this.backImage.getHeight(this);
        i = 0;
        while ((double)(i * imageWidth) <= this.mapWidth) {
            j = 0;
            while ((double)(j * imageHeight) <= this.mapHeight) {
                g.drawImage(this.backImage, i * imageWidth, j * imageHeight, null);
                ++j;
            }
            ++i;
        }
        imageWidth *= i;
        imageHeight *= j;
        String t = Preferences.getPreferences().getProperty("Grid Lines");
        if (t.equals("true")) {
            double di;
            double spacing = 10.0;
            if (spacing * this.scale < 50.0) {
                spacing = 50.0 / this.scale;
            }
            String colorTriple = Preferences.getPreferences().getProperty("Grid Lines Color");
            Color gridColor = Preferences.parseColor(colorTriple);
            g.setColor(gridColor);
            double maxx = this.getShipX(imageWidth);
            double maxy = this.getShipY(0.0);
            for (double minx = 0.0; minx > this.getShipX(0.0); minx -= spacing) {
            }
            for (double miny = 0.0; miny > this.getShipY(imageHeight); miny -= spacing) {
            }
            for (di = miny += spacing; di < maxy; di += spacing) {
                i = this.Y(di);
                g.drawLine(0, i, imageWidth, i);
            }
            for (di = minx; di < maxx; di += spacing) {
                i = this.X(di);
                g.drawLine(i, 0, i, imageHeight);
            }
            String coords = Preferences.getPreferences().getProperty("Grid Coordinates");
            if (coords.equals("true")) {
                Font fs = new Font("SansSerif", 0, 9);
                g.setFont(fs);
                for (double dj = miny; dj < maxy; dj += spacing) {
                    for (di = minx; di < maxx; di += spacing) {
                        i = this.X(di);
                        j = this.Y(dj);
                        g.drawString(Math.round(di) + "," + Math.round(dj), i + 2, j - 2);
                    }
                }
            }
        }
        if (this.gameEngine.getOptions().hasActiveExtent()) {
            g.setColor(Color.red);
            int minI = this.X(this.gameEngine.getOptions().getXMin());
            int maxI = this.X(this.gameEngine.getOptions().getXMax());
            int minJ = this.Y(this.gameEngine.getOptions().getYMin());
            int maxJ = this.Y(this.gameEngine.getOptions().getYMax());
            g.drawLine(minI, minJ, maxI, minJ);
            g.drawLine(maxI, minJ, maxI, maxJ);
            g.drawLine(maxI, maxJ, minI, maxJ);
            g.drawLine(minI, maxJ, minI, minJ);
        }
    }

    public void paintMark(Graphics g) {
        if (this.isMarkDefined()) {
            int[] mMark = this.getMapMark();
            int itsX = mMark[0] - this.markImage.getWidth(this) / 2;
            int itsY = mMark[1] - this.markImage.getHeight(this) / 2;
            g.drawImage(this.markImage, itsX, itsY, null);
        }
    }

    public void paintComponent(Graphics gin) {
        ShipGUIAdapter adapter;
        SpaceObject so;
        SpaceObjectGUIAdapter spaceObjectAdapter;
        super.paintComponent(gin);
        Graphics2D g = (Graphics2D)gin;
        this.paintBackground(g);
        Properties props = Preferences.getPreferences();
        Font fs = Preferences.parseFont(props.getProperty("StarMap Font"), props.getProperty("StarMap Font Style"), props.getProperty("StarMap Font Size"));
        g.setFont(fs);
        Iterator spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            so = spaceObjectAdapter.getSpaceObject();
            if (!(so instanceof HeavenlyBody)) continue;
            this.paintIcon((Graphics)g, spaceObjectAdapter);
        }
        Iterator shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved() || !adapter.getShip().isDestroyed()) continue;
            this.paintIcon((Graphics)g, adapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved() || !adapter.getShowPlotEnvelope()) continue;
            this.paintMovementEnvelope(g, adapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved()) continue;
            this.paintLockOns(g, adapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved()) continue;
            this.paintArcs((Graphics)g, adapter);
        }
        spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            this.paintFighterEnvelope(g, spaceObjectAdapter);
            this.paintMissileEnvelope(g, spaceObjectAdapter);
        }
        spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            this.paintArcs((Graphics)g, spaceObjectAdapter);
        }
        spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            this.paintLockOns((Graphics)g, spaceObjectAdapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved() || !adapter.getShowGhostPlot()) continue;
            this.paintGhostPlot(g, adapter);
        }
        spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            this.paintMissileGhostPlot(g, spaceObjectAdapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved() || !adapter.getShowGhostTrail()) continue;
            this.paintGhostTrail(g, adapter);
        }
        spaceObjectIterator = this.spaceObjectAdapters.iterator();
        while (spaceObjectIterator.hasNext()) {
            spaceObjectAdapter = (SpaceObjectGUIAdapter)spaceObjectIterator.next();
            so = spaceObjectAdapter.getSpaceObject();
            if (so instanceof HeavenlyBody) continue;
            this.paintIcon((Graphics)g, spaceObjectAdapter);
        }
        shipIterator = this.shipAdapters.iterator();
        while (shipIterator.hasNext()) {
            adapter = (ShipGUIAdapter)shipIterator.next();
            if (adapter.getRemoved() || adapter.getShip().isDestroyed()) continue;
            this.paintIcon((Graphics)g, adapter);
        }
        this.paintMark(g);
    }

    private void paintIcon(Graphics g, ShipGUIAdapter adapter) {
        Properties props = Preferences.getPreferences();
        Color oldColor = Preferences.parseColor(props.getProperty("StarMap Font Color"));
        Font selectedFont = Preferences.parseFont(props.getProperty("Selected Ship Font"), props.getProperty("Selected Ship Font Style"), props.getProperty("Selected Ship Font Size"));
        Color selectedColor = Preferences.parseColor(props.getProperty("Selected Ship Text Color"));
        Font destroyedFont = Preferences.parseFont(props.getProperty("Destroyed Ship Font"), props.getProperty("Destroyed Ship Font Style"), props.getProperty("Destroyed Ship Font Size"));
        Color destroyedColor = Preferences.parseColor(props.getProperty("Destroyed Ship Text Color"));
        Font oldFont = g.getFont();
        Ship s = adapter.getShip();
        int turnDestroyed = s.getTurnDestroyed();
        int turnJumped = s.getTurnJumped();
        int currentTurn = s.getGameEngine().getGameTurn();
        if (s.isDestroyed() && turnDestroyed + 1 < currentTurn) {
            return;
        }
        if (s.hasJumped() && turnJumped + 1 < currentTurn && turnJumped >= 0) {
            return;
        }
        double xP = s.getXPosition();
        double yP = s.getYPosition();
        int px = this.X(xP);
        int py = this.Y(yP);
        BufferedImage Icon2 = adapter.getImage();
        int xOffset = (int)((double)Icon2.getWidth() / 2.0);
        int yOffset = (int)((double)Icon2.getHeight() / 2.0);
        int sx = px - xOffset;
        int sy = py - yOffset;
        if (!s.isDestroyed()) {
            g.setColor(oldColor);
            if (adapter.equals(this.starMap.getActiveSelection())) {
                g.setColor(selectedColor);
                g.setFont(selectedFont);
                BufferedImage out = this.convOpOuter.filter(Icon2, null);
                BufferedImage in = this.convOpInner.filter(Icon2, null);
                for (int i = 0; i < out.getWidth(); ++i) {
                    for (int j = 0; j < out.getHeight(); ++j) {
                        out.setRGB(i, j, out.getRGB(i, j) - in.getRGB(i, j));
                    }
                }
                g.drawImage(out, sx, sy, null);
            }
        } else {
            g.setColor(destroyedColor);
            g.setFont(destroyedFont);
        }
        if (s.hasArrivedThisTurn() && s.getGameEngine().isCombatPhase()) {
            g.drawImage(adapter.getArrivalImage(), sx - 2, sy - 8, null);
        }
        g.drawImage(adapter.getImage(), sx, sy, null);
        g.drawString(s.getName(), sx + 32, sy);
        g.setFont(oldFont);
        boolean displayStatus = Preferences.getPreferences().getProperty("Graphical Status Bar").equals("true");
        if (!s.isDestroyed() && displayStatus) {
            int midX;
            int startX = sx + 32;
            int startY = sy + 4;
            int barLength = 20;
            int count = s.getNumberOfActiveScreens();
            if (count > 0) {
                g.setColor(SCREEN_LEVEL_BAR_COLOR);
                g.drawLine(startX, startY, startX + count * barLength / 2, startY++);
            }
            if ((midX = (int)(s.getHullPercentage() * (double)barLength)) == 0) {
                ++midX;
            }
            for (int kbar = 0; kbar < 3; ++kbar) {
                g.setColor(HULL_GOOD_BAR_COLOR);
                g.drawLine(startX, startY, startX + midX, startY);
                if (midX != barLength) {
                    g.setColor(HULL_BAD_BAR_COLOR);
                    g.drawLine(startX + midX + 1, startY, startX + barLength, startY);
                }
                ++startY;
            }
        }
    }

    private void paintIcon(Graphics g, SpaceObjectGUIAdapter adapter) {
        Properties props = Preferences.getPreferences();
        Color oldColor = Preferences.parseColor(props.getProperty("StarMap Font Color"));
        Font selectedFont = Preferences.parseFont(props.getProperty("Selected Ship Font"), props.getProperty("Selected Ship Font Style"), props.getProperty("Selected Ship Font Size"));
        Color selectedColor = Preferences.parseColor(props.getProperty("Selected Ship Text Color"));
        Font oldFont = g.getFont();
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 200.0f, Color.yellow, true);
        GradientPaint gp1 = new GradientPaint(0.0f, 178.0f, Color.red, 100.0f, 0.0f, Color.yellow, true);
        GradientPaint gp2 = new GradientPaint(0.0f, 100.0f, Color.red, 178.0f, 0.0f, Color.yellow, true);
        GradientPaint gp3 = new GradientPaint(0.0f, 0.0f, Color.red, 200.0f, 0.0f, Color.yellow, true);
        GradientPaint gp4 = new GradientPaint(0.0f, 0.0f, Color.red, 178.0f, 100.0f, Color.yellow, true);
        GradientPaint gp5 = new GradientPaint(0.0f, 0.0f, Color.red, 100.0f, 178.0f, Color.yellow, true);
        SpaceObject so = adapter.getSpaceObject();
        if (so instanceof FighterGroup) {
            int count = ((FighterGroup)so).getCount();
            boolean onBoard = ((FighterGroup)so).isOnBoard();
            if (count == 0 || onBoard) {
                return;
            }
        }
        double xP = so.getXPosition();
        double yP = so.getYPosition();
        int h = so.getHeading();
        int px = this.X(xP);
        int py = this.Y(yP);
        BufferedImage Icon2 = adapter.getImage(h, this.scale);
        int xOffset = (int)((double)Icon2.getWidth() / 2.0);
        int yOffset = (int)((double)Icon2.getHeight() / 2.0);
        int sx = px - xOffset;
        int sy = py - yOffset;
        if (so instanceof NovaCannonBolt) {
            double dh;
            int i;
            double radius;
            Graphics2D g2d = (Graphics2D)g;
            NovaCannonBolt ncb = (NovaCannonBolt)so;
            double length = 18.0;
            if (ncb.getAge() > 1) {
                length = 24.0;
            }
            if ((radius = (double)ncb.getAge() * 2.0) < 0.1) {
                radius = 2.0;
            }
            double xE = xP + length * MathUtil.X(h);
            double yE = yP + length * MathUtil.Y(h);
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g.setColor(new Color(244, 248, 124));
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(this.novaPaint);
            switch (h) {
                case 0: 
                case 6: 
                case 12: {
                    g2d.setPaint(gp0);
                    break;
                }
                case 1: 
                case 7: {
                    g2d.setPaint(gp1);
                    break;
                }
                case 2: 
                case 8: {
                    g2d.setPaint(gp2);
                    break;
                }
                case 3: 
                case 9: {
                    g2d.setPaint(gp3);
                    break;
                }
                case 4: 
                case 10: {
                    g2d.setPaint(gp4);
                    break;
                }
                case 5: 
                case 11: {
                    g2d.setPaint(gp5);
                }
            }
            int index = 0;
            int[] xPoints = new int[400];
            int[] yPoints = new int[400];
            xPoints[index] = this.X(xP + radius * MathUtil.X(h - 3));
            yPoints[index++] = this.Y(yP + radius * MathUtil.Y(h - 3));
            for (i = 1; i < 180; ++i) {
                dh = (double)h - 3.0 - (double)i * 0.03333333333333333;
                xPoints[index] = this.X(xP + radius * MathUtil.X(dh));
                yPoints[index++] = this.Y(yP + radius * MathUtil.Y(dh));
            }
            xPoints[index] = this.X(xP + radius * MathUtil.X(h + 3));
            yPoints[index++] = this.Y(yP + radius * MathUtil.Y(h + 3));
            xPoints[index] = this.X(xE + radius * MathUtil.X(h + 3));
            yPoints[index++] = this.Y(yE + radius * MathUtil.Y(h + 3));
            for (i = 1; i < 180; ++i) {
                dh = (double)h + 3.0 - (double)i * 0.03333333333333333;
                xPoints[index] = this.X(xE + radius * MathUtil.X(dh));
                yPoints[index++] = this.Y(yE + radius * MathUtil.Y(dh));
            }
            xPoints[index] = this.X(xE + radius * MathUtil.X(h - 3));
            yPoints[index++] = this.Y(yE + radius * MathUtil.Y(h - 3));
            g.fillPolygon(xPoints, yPoints, 362);
            g2d.setComposite(oldComposite);
            g2d.setPaint(oldPaint);
            g.setColor(oldColor);
        } else if (so instanceof WaveGunBolt) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g.setColor(new Color(244, 248, 124));
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(this.novaPaint);
            switch (h) {
                case 0: 
                case 6: 
                case 12: {
                    g2d.setPaint(gp0);
                    break;
                }
                case 1: 
                case 7: {
                    g2d.setPaint(gp1);
                    break;
                }
                case 2: 
                case 8: {
                    g2d.setPaint(gp2);
                    break;
                }
                case 3: 
                case 9: {
                    g2d.setPaint(gp3);
                    break;
                }
                case 4: 
                case 10: {
                    g2d.setPaint(gp4);
                    break;
                }
                case 5: 
                case 11: {
                    g2d.setPaint(gp5);
                }
            }
            int index = 0;
            int[] xPoints = new int[40];
            int[] yPoints = new int[40];
            double length = 12.0;
            xPoints[index] = this.X(xP + MathUtil.X(h - 3));
            yPoints[index++] = this.Y(yP + MathUtil.Y(h - 3));
            xPoints[index] = this.X(xP + MathUtil.X(h - 3) + length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + MathUtil.Y(h - 3) + length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 1.5 * MathUtil.X(h - 3) + length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 1.5 * MathUtil.Y(h - 3) + length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 1.5 * MathUtil.X(h - 3) + 2.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 1.5 * MathUtil.Y(h - 3) + 2.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 2.0 * MathUtil.X(h - 3) + 2.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 2.0 * MathUtil.Y(h - 3) + 2.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 2.0 * MathUtil.X(h - 3) + 3.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 2.0 * MathUtil.Y(h - 3) + 3.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 2.0 * MathUtil.X(h + 3) + 3.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 2.0 * MathUtil.Y(h + 3) + 3.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 2.0 * MathUtil.X(h + 3) + 2.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 2.0 * MathUtil.Y(h + 3) + 2.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 1.5 * MathUtil.X(h + 3) + 2.0 * length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 1.5 * MathUtil.Y(h + 3) + 2.0 * length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + 1.5 * MathUtil.X(h + 3) + length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + 1.5 * MathUtil.Y(h + 3) + length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + MathUtil.X(h + 3) + length * MathUtil.X(h));
            yPoints[index++] = this.Y(yP + MathUtil.Y(h + 3) + length * MathUtil.Y(h));
            xPoints[index] = this.X(xP + MathUtil.X(h + 3));
            yPoints[index++] = this.Y(yP + MathUtil.Y(h + 3));
            g.fillPolygon(xPoints, yPoints, index);
            g2d.setComposite(oldComposite);
            g2d.setPaint(oldPaint);
            g.setColor(oldColor);
        } else {
            g.setColor(oldColor);
            if (adapter.equals(this.starMap.getActiveSelection())) {
                g.setColor(selectedColor);
                g.setFont(selectedFont);
                BufferedImage out = this.convOpOuter.filter(Icon2, null);
                BufferedImage in = this.convOpInner.filter(Icon2, null);
                for (int i = 0; i < out.getWidth(); ++i) {
                    for (int j = 0; j < out.getHeight(); ++j) {
                        out.setRGB(i, j, out.getRGB(i, j) - in.getRGB(i, j));
                    }
                }
                g.drawImage(out, sx, sy, null);
            }
            g.drawImage(adapter.getImage(h, this.scale), sx, sy, null);
        }
        g.drawString(so.getName(), sx + 32, sy);
        g.setFont(oldFont);
    }

    public class ClearDisplay
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Iterator i = MapPanel.this.shipAdapters.iterator();
            while (i.hasNext()) {
                ((ShipGUIAdapter)i.next()).clearDisplay();
            }
            Iterator j = MapPanel.this.spaceObjectAdapters.iterator();
            while (j.hasNext()) {
                ((SpaceObjectGUIAdapter)j.next()).clearDisplay();
            }
            MapPanel.this.markDefined = false;
        }
    }

    public class MarkMapWindow
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MapPanel.this.setCurrentMark(MapPanel.this.getShipX(MapPanel.this.mx), MapPanel.this.getShipY(MapPanel.this.my));
            MapPanel.this.repaint();
        }
    }

    public class CenterMapWindow
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MapPanel.this.centerAtMapCoords(MapPanel.this.mx, MapPanel.this.my);
            MapPanel.this.repaint();
        }
    }

    public class RaiseClientWindow
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (MapPanel.this.client != null) {
                MapPanel.this.client.setVisible(true);
            }
        }
    }

    public class Scale
    implements ActionListener {
        double scale;
        String label;

        public void actionPerformed(ActionEvent e) {
            Point p = MapPanel.this.getCurrentCenter();
            double x = MapPanel.this.getShipX(p.x);
            double y = MapPanel.this.getShipY(p.y);
            MapPanel.this.setScale(this.scale, this.label);
            MapPanel.this.calculateBounds();
            MapPanel.this.repaint();
            MapPanel.this.centerAtShipCoords(x, y);
            p = MapPanel.this.getCurrentCenter();
            x = MapPanel.this.getShipX(p.x);
            y = MapPanel.this.getShipY(p.y);
        }

        public Scale(double s, String l) {
            this.scale = s;
            this.label = l;
        }
    }
}

