/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.MapPanel;
import ftjava.gui.ShipStatusDisplay;
import ftjava.gui.StarMap;
import ftjava.std.AntiMatterTorpedo;
import ftjava.std.AntiMatterTorpedoLauncher;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.Missile;
import ftjava.std.MissileLauncher;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannon;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.Player;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGun;
import ftjava.std.WaveGunBolt;
import ftjava.std.Weapon;
import ftjava.util.MathUtil;
import ftjava.util.MovementSteps;
import ftjava.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LaunchDialog {
    private ClientProgram client;
    private Ship ship;
    private GameEngine engine;
    private JDialog dialog;

    public LaunchDialog(ClientProgram theClient, GameEngine engine, Ship ship, ShipStatusDisplay ssd, boolean reset) {
        Insets targetDialogInsets;
        this.client = theClient;
        this.engine = engine;
        this.ship = ship;
        this.dialog = new JDialog();
        String title = ship.getName();
        if (ship.getRolled()) {
            title = title + "  [Rolled]";
        }
        this.dialog.setTitle(title);
        this.dialog.setResizable(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        this.dialog.setLocation(0, screenHeight / 2);
        ArrayList weapons = ship.getWeaponSystems();
        JPanel launchPanel = new JPanel();
        launchPanel.setLayout(new BoxLayout(launchPanel, 1));
        JPanel table = new JPanel();
        table.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int left = 17;
        int center = 10;
        c.insets = targetDialogInsets = new Insets(2, 6, 2, 6);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = center;
        table.add((Component)new JLabel(" Weapon"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Status"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Launch"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Cancel"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Type"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Launch ID"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = left;
        table.add((Component)new JLabel("Message            "), c);
        for (int i = 0; i < weapons.size(); ++i) {
            Weapon theWeapon = (Weapon)weapons.get(i);
            if (!theWeapon.isLaunchedFire() || theWeapon instanceof SalvoMissileMagazine) continue;
            boolean enabled = true;
            c.weightx = 1.0;
            ++c.gridy;
            c.gridx = 0;
            c.anchor = left;
            table.add((Component)new JLabel(theWeapon.getSystemName()), c);
            ++c.gridx;
            c.anchor = left;
            table.add((Component)new JLabel(theWeapon.getSystemStatus()), c);
            ++c.gridx;
            c.anchor = left;
            JButton launchButton = new JButton("Launch");
            LaunchAction theLaunchAction = null;
            if (theWeapon instanceof SalvoMissileLauncher || theWeapon instanceof SalvoMissileRack) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new MissileSalvo());
            } else if (theWeapon instanceof PlasmaBoltLauncher) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new PlasmaBolt());
            } else if (theWeapon instanceof AntiMatterTorpedoLauncher) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new AntiMatterTorpedo());
            } else if (theWeapon instanceof MissileLauncher) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new Missile());
            } else if (theWeapon instanceof NovaCannon) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new NovaCannonBolt());
            } else if (theWeapon instanceof WaveGun) {
                theLaunchAction = new LaunchAction(this, ship, theWeapon, new WaveGunBolt());
            } else if (theWeapon instanceof FighterBay) {
                FighterBay theBay = (FighterBay)theWeapon;
                FighterGroup theGroup = theBay.getLandedFighterGroup();
                theLaunchAction = new LaunchAction(this, ship, theWeapon, theGroup);
                if (theGroup == null) {
                    enabled = false;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            launchButton.addActionListener(theLaunchAction);
            table.add((Component)launchButton, c);
            ++c.gridx;
            c.anchor = left;
            JButton cancelLaunchButton = new JButton("Abort");
            cancelLaunchButton.addActionListener(new AbortAction(theLaunchAction));
            table.add((Component)cancelLaunchButton, c);
            ++c.gridx;
            c.anchor = left;
            if (theWeapon instanceof SalvoMissileRack) {
                SalvoMissileRack smr = (SalvoMissileRack)theWeapon;
                if (enabled) {
                    table.add((Component)new JLabel(smr.getType()), c);
                }
            } else if (theWeapon instanceof MissileLauncher) {
                MissileLauncher ml = (MissileLauncher)theWeapon;
                if (enabled) {
                    table.add((Component)new JLabel(ml.getType()), c);
                }
            } else if (theWeapon instanceof SalvoMissileLauncher) {
                SalvoMissileLauncher sml = (SalvoMissileLauncher)theWeapon;
                Weapon mag = ship.getWeaponById(sml.getSalvoMagazineId());
                if (!mag.getSystemStatus().equals("Operational")) {
                    enabled = false;
                }
                SalvoMissileMagazine smm = (SalvoMissileMagazine)mag;
                ArrayList salvos = smm.getSalvos();
                ArrayList status = smm.getSalvoStatus();
                JComboBox<String> magContents = new JComboBox<String>();
                if (salvos.size() == 0) {
                    magContents.addItem("<None>");
                } else {
                    for (int m = 0; m < salvos.size(); ++m) {
                        String smType = (String)salvos.get(m);
                        String smStatus = (String)status.get(m);
                        if (!smStatus.equals("Available")) continue;
                        magContents.addItem(smType);
                    }
                }
                if (!enabled) {
                    magContents.setEnabled(false);
                }
                theLaunchAction.setComboBox(magContents);
                table.add(magContents, c);
            } else if (theWeapon instanceof FighterBay) {
                FighterBay theBay = (FighterBay)theWeapon;
                FighterGroup theGroup = theBay.getLandedFighterGroup();
                if (enabled) {
                    table.add((Component)new JLabel(theGroup.getType().toString()), c);
                }
            }
            ++c.gridx;
            c.anchor = left;
            JLabel idField = new JLabel(" ");
            theLaunchAction.setIdLabel(idField);
            table.add((Component)idField, c);
            ++c.gridx;
            c.anchor = left;
            JLabel messageField = new JLabel(" ");
            theLaunchAction.setMessageLabel(messageField);
            table.add((Component)messageField, c);
            if (!theWeapon.getSystemStatus().equals("Operational")) {
                enabled = false;
            }
            if (!theWeapon.isRecharged()) {
                enabled = false;
                String rechargeMessage = theWeapon.getRecharge() > 0 ? "Weapon is recharging (" + StringUtils.turns(theWeapon.getRecharge()) + ")" : "Weapon is disabled";
                theLaunchAction.publishMessage(rechargeMessage);
            }
            if (enabled) continue;
            launchButton.setEnabled(false);
            cancelLaunchButton.setEnabled(false);
        }
        launchPanel.add(Box.createVerticalStrut(5));
        launchPanel.add(table);
        launchPanel.add(Box.createVerticalStrut(15));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        JButton ok = new JButton("Close");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchDialog.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        this.dialog.getRootPane().setDefaultButton(ok);
        this.dialog.getContentPane().add((Component)launchPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.pack();
        this.dialog.setVisible(false);
    }

    public void updateSSDs() {
        this.client.updateSSD();
    }

    public GameEngine getGameEngine() {
        return this.engine;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void OKPressed() {
        this.dialog.setVisible(false);
    }

    private class AbortAction
    implements ActionListener {
        private LaunchAction theLaunchAction;

        AbortAction(LaunchAction la) {
            this.theLaunchAction = la;
        }

        public void actionPerformed(ActionEvent e) {
            LaunchDialog ld = this.theLaunchAction.getParent();
            GameEngine ge = ld.getGameEngine();
            StarMap map = LaunchDialog.this.client.getStarMap();
            SpaceObject sObj = this.theLaunchAction.getSpaceObject();
            if (sObj != null && !(sObj instanceof FighterGroup)) {
                if (sObj instanceof NovaCannonBolt) {
                    this.theLaunchAction.getShip().decrementRestrictedMovementLaunch();
                }
                ge.removeSpaceObject(sObj);
                map.loadAdapters(false);
                if (sObj instanceof Missile) {
                    LaunchDialog.this.client.removeSpaceObject(sObj);
                }
                map.repaint();
                this.theLaunchAction.resetSpaceObject();
                this.theLaunchAction.publishId(" ");
                this.theLaunchAction.publishMessage(" ");
            }
            if (sObj != null && sObj instanceof FighterGroup) {
                FighterGroup fg = (FighterGroup)sObj;
                fg.setOnBoard(true);
                fg.setLaunching(false);
                fg.setPastX(this.theLaunchAction.getShip().getXPosition());
                fg.setPastY(this.theLaunchAction.getShip().getYPosition());
                fg.setXPosition(this.theLaunchAction.getShip().getXPosition());
                fg.setYPosition(this.theLaunchAction.getShip().getYPosition());
                fg.setHeading(this.theLaunchAction.getShip().getHeading());
                ((FighterBay)this.theLaunchAction.getWeapon()).setLandedFighterGroup(fg);
                this.theLaunchAction.resetSpaceObject();
                this.theLaunchAction.publishId(" ");
                this.theLaunchAction.publishMessage(" ");
                this.theLaunchAction.getShip().decrementRestrictedMovementLaunch();
                map.loadAdapters(false);
                map.repaint();
            }
            ld.updateSSDs();
        }
    }

    private class LaunchAction
    implements ActionListener {
        private LaunchDialog parent;
        private Ship theShip;
        private Weapon theWeapon;
        private SpaceObject sObj;
        private SpaceObject sType;
        private JLabel idLabel;
        private JLabel messageLabel;
        private JComboBox cBox;

        LaunchAction(LaunchDialog ld, Ship inShip, Weapon inWeapon, SpaceObject type) {
            this.parent = ld;
            this.theShip = inShip;
            this.theWeapon = inWeapon;
            this.sObj = null;
            this.sType = type;
            this.idLabel = null;
            this.cBox = null;
        }

        public void resetSpaceObject() {
            this.sObj = null;
        }

        public SpaceObject getSpaceObject() {
            return this.sObj;
        }

        public Ship getShip() {
            return this.theShip;
        }

        public Weapon getWeapon() {
            return this.theWeapon;
        }

        public LaunchDialog getParent() {
            return this.parent;
        }

        public void setIdLabel(JLabel id) {
            this.idLabel = id;
        }

        public void setMessageLabel(JLabel ml) {
            this.messageLabel = ml;
        }

        public void setComboBox(JComboBox cb) {
            this.cBox = cb;
        }

        public void publishId(String name) {
            if (this.idLabel != null) {
                this.idLabel.setText(name);
                this.parent.getDialog().pack();
            }
        }

        public void publishMessage(String msg) {
            if (this.messageLabel != null) {
                this.messageLabel.setText(msg);
                this.parent.getDialog().pack();
            }
        }

        public void actionPerformed(ActionEvent e) {
            double[] markPosition;
            GameEngine ge = this.parent.getGameEngine();
            StarMap map = LaunchDialog.this.client.getStarMap();
            MapPanel mPanel = map.getMapPanel();
            double[] msPos = new double[2];
            if (!(this.sType instanceof NovaCannonBolt || this.sType instanceof WaveGunBolt || this.sType instanceof FighterGroup || this.sType instanceof Missile)) {
                if (!mPanel.isMarkDefined()) {
                    this.publishMessage("Mark is undefined");
                    return;
                }
                markPosition = mPanel.getCurrentMark();
            } else {
                markPosition = new double[]{this.theShip.getXPosition(), this.theShip.getYPosition()};
            }
            if (this.sObj == null) {
                Player p;
                Player p2;
                int salvoHeading;
                if (this.sType instanceof MissileSalvo) {
                    MissileSalvo ms = new MissileSalvo();
                    ms.setId(ge.findUniqueId());
                    ms.setName("SM " + ms.getId());
                    ms.setRace(this.theShip.getRace());
                    ms.setTeam(this.theShip.getTeam());
                    ms.setLaunchingShipId(this.theShip.getId());
                    ms.setLauncherId(this.theWeapon.getId());
                    if (this.theWeapon instanceof SalvoMissileRack) {
                        SalvoMissileRack smr = (SalvoMissileRack)this.theWeapon;
                        ms.setSalvoType(smr.getType());
                    } else {
                        String type = (String)this.cBox.getSelectedItem();
                        ms.setSalvoType(type);
                    }
                    msPos = this.theShip.rangeBoundsAlongVector(markPosition[0], markPosition[1], ms.getMaximumRange());
                    int fireArc = this.theShip.arcTo(msPos[0] - this.theShip.getXPosition(), msPos[1] - this.theShip.getYPosition());
                    if (!this.theWeapon.fireAtTargetArc(fireArc)) {
                        this.publishMessage("Out of arc");
                    } else {
                        this.publishMessage(" ");
                    }
                    ms.setXPosition(msPos[0]);
                    ms.setYPosition(msPos[1]);
                    salvoHeading = this.theShip.headingTo(msPos[0], msPos[1]);
                    ms.setHeading(salvoHeading);
                    this.publishId("SM " + ms.getId());
                    p2 = ge.getActivePlayer();
                    ms.setGameEngine(ge);
                    if (p2 != null) {
                        ms.setPlayer(ge.getActivePlayer());
                        p2.SpaceObjects.add(ms);
                    }
                    ge.addObject(ms);
                    this.sObj = ms;
                    map.loadAdapters(false);
                    map.repaint();
                }
                if (this.sType instanceof PlasmaBolt) {
                    PlasmaBolt pb = new PlasmaBolt();
                    pb.setId(ge.findUniqueId());
                    pb.setRace(this.theShip.getRace());
                    pb.setTeam(this.theShip.getTeam());
                    pb.setLaunchingShipId(this.theShip.getId());
                    pb.setLauncherId(this.theWeapon.getId());
                    PlasmaBoltLauncher pbl = (PlasmaBoltLauncher)this.theWeapon;
                    pb.setStrength(pbl.getRating());
                    pb.setName();
                    msPos = this.theShip.rangeBoundsAlongVector(markPosition[0], markPosition[1], pb.getMaximumRange());
                    int fireArc = this.theShip.arcTo(msPos[0] - this.theShip.getXPosition(), msPos[1] - this.theShip.getYPosition());
                    if (!this.theWeapon.fireAtTargetArc(fireArc)) {
                        this.publishMessage("Out of arc");
                    } else {
                        this.publishMessage(" ");
                    }
                    pb.setXPosition(msPos[0]);
                    pb.setYPosition(msPos[1]);
                    salvoHeading = this.theShip.headingTo(msPos[0], msPos[1]);
                    pb.setHeading(salvoHeading);
                    this.publishId(pb.getName());
                    p = ge.getActivePlayer();
                    pb.setGameEngine(ge);
                    if (p != null) {
                        pb.setPlayer(ge.getActivePlayer());
                        p.SpaceObjects.add(pb);
                    }
                    ge.addObject(pb);
                    this.sObj = pb;
                    map.loadAdapters(false);
                    map.repaint();
                }
                if (this.sType instanceof Missile) {
                    Missile m = new Missile();
                    m.setId(ge.findUniqueId());
                    m.setRace(this.theShip.getRace());
                    m.setLaunchingShipId(this.theShip.getId());
                    m.setLauncherId(this.theWeapon.getId());
                    MissileLauncher ml = (MissileLauncher)this.theWeapon;
                    m.setType(ml.getType());
                    m.setName();
                    m.setXPosition(this.theShip.getXPosition());
                    m.setYPosition(this.theShip.getYPosition());
                    m.setHeading(this.theShip.getHeading());
                    this.publishId(m.getName());
                    p2 = this.theShip.getPlayer();
                    m.setGameEngine(ge);
                    m.setPlayer(p2);
                    if (p2 != null) {
                        p2.SpaceObjects.add(m);
                    }
                    ge.addObject(m);
                    this.sObj = m;
                    map.loadAdapters(false);
                    LaunchDialog.this.client.addSpaceObject(m);
                    map.repaint();
                }
                if (this.sType instanceof NovaCannonBolt) {
                    NovaCannonBolt ncb = new NovaCannonBolt();
                    ncb.setId(ge.findUniqueId());
                    ncb.setRace(this.theShip.getRace());
                    ncb.setTeam(this.theShip.getTeam());
                    ncb.setLaunchingShipId(this.theShip.getId());
                    ncb.setLauncherId(this.theWeapon.getId());
                    ncb.setAge(0);
                    ncb.setName();
                    this.theShip.incrementRestrictedMovementLaunch();
                    LaunchDialog.this.ship.setOrders("0");
                    MovementSteps movementSteps = LaunchDialog.this.ship.getMovementSteps();
                    msPos[0] = LaunchDialog.this.ship.getXPosition() + movementSteps.First[0] + movementSteps.Second[0];
                    msPos[1] = LaunchDialog.this.ship.getYPosition() + movementSteps.First[1] + movementSteps.Second[1];
                    msPos[0] = msPos[0] + 6.0 * MathUtil.X(LaunchDialog.this.ship.getHeading());
                    msPos[1] = msPos[1] + 6.0 * MathUtil.Y(LaunchDialog.this.ship.getHeading());
                    ncb.setXPosition(msPos[0]);
                    ncb.setYPosition(msPos[1]);
                    ncb.setHeading(this.theShip.getHeading());
                    this.publishId(ncb.getName());
                    p2 = ge.getActivePlayer();
                    ncb.setGameEngine(ge);
                    if (p2 != null) {
                        ncb.setPlayer(ge.getActivePlayer());
                        p2.SpaceObjects.add(ncb);
                    }
                    ge.addObject(ncb);
                    this.sObj = ncb;
                    map.loadAdapters(false);
                    map.repaint();
                }
                if (this.sType instanceof WaveGunBolt) {
                    int heading;
                    WaveGunBolt wgb = new WaveGunBolt();
                    wgb.setId(ge.findUniqueId());
                    wgb.setRace(this.theShip.getRace());
                    wgb.setTeam(this.theShip.getTeam());
                    wgb.setLaunchingShipId(this.theShip.getId());
                    wgb.setLauncherId(this.theWeapon.getId());
                    wgb.setName();
                    MovementSteps movementSteps = LaunchDialog.this.ship.getMovementSteps();
                    msPos[0] = LaunchDialog.this.ship.getXPosition() + movementSteps.First[0] + movementSteps.Second[0];
                    msPos[1] = LaunchDialog.this.ship.getYPosition() + movementSteps.First[1] + movementSteps.Second[1];
                    msPos[0] = msPos[0] + 0.1 * MathUtil.X(movementSteps.Heading[1]);
                    msPos[1] = msPos[1] + 0.1 * MathUtil.Y(movementSteps.Heading[1]);
                    for (heading = movementSteps.Heading[1]; heading < 0; heading += 12) {
                    }
                    while (heading > 12) {
                        heading -= 12;
                    }
                    wgb.setXPosition(msPos[0]);
                    wgb.setYPosition(msPos[1]);
                    wgb.setHeading(heading);
                    this.publishId(wgb.getName());
                    p = ge.getActivePlayer();
                    wgb.setGameEngine(ge);
                    if (p != null) {
                        wgb.setPlayer(ge.getActivePlayer());
                        p.SpaceObjects.add(wgb);
                    }
                    ge.addObject(wgb);
                    this.sObj = wgb;
                    map.loadAdapters(false);
                    map.repaint();
                }
                if (this.sType instanceof AntiMatterTorpedo) {
                    AntiMatterTorpedo amt = new AntiMatterTorpedo();
                    amt.setId(ge.findUniqueId());
                    amt.setRace(this.theShip.getRace());
                    amt.setTeam(this.theShip.getTeam());
                    amt.setLaunchingShipId(this.theShip.getId());
                    amt.setLauncherId(this.theWeapon.getId());
                    amt.setName();
                    msPos = this.theShip.rangeBoundsAlongVector(markPosition[0], markPosition[1], amt.getMaximumRange());
                    int fireArc = this.theShip.arcTo(msPos[0] - this.theShip.getXPosition(), msPos[1] - this.theShip.getYPosition());
                    if (!this.theWeapon.fireAtTargetArc(fireArc)) {
                        this.publishMessage("Out of arc");
                    } else {
                        this.publishMessage(" ");
                    }
                    amt.setXPosition(msPos[0]);
                    amt.setYPosition(msPos[1]);
                    salvoHeading = this.theShip.headingTo(msPos[0], msPos[1]);
                    amt.setHeading(salvoHeading);
                    this.publishId(amt.getName());
                    Player p3 = ge.getActivePlayer();
                    amt.setGameEngine(ge);
                    if (p3 != null) {
                        amt.setPlayer(ge.getActivePlayer());
                        p3.SpaceObjects.add(amt);
                    }
                    ge.addObject(amt);
                    this.sObj = amt;
                    map.loadAdapters(false);
                    map.repaint();
                }
                if (this.sType instanceof FighterGroup) {
                    FighterGroup theGroup = (FighterGroup)this.sType;
                    boolean defaultOrders = true;
                    double xP = 0.5 - 1.0 * Math.random();
                    double yP = 0.5 - 1.0 * Math.random();
                    double halfX = (this.theShip.getPlottedXPosition(defaultOrders) + this.theShip.getXPosition()) / 2.0;
                    double halfY = (this.theShip.getPlottedYPosition(defaultOrders) + this.theShip.getYPosition()) / 2.0;
                    theGroup.setPastX(halfX + xP);
                    theGroup.setPastY(halfY + yP);
                    theGroup.setXPosition(halfX + xP);
                    theGroup.setYPosition(halfY + yP);
                    theGroup.setHeading(this.theShip.getPlottedHeading(defaultOrders));
                    theGroup.setOnBoard(false);
                    theGroup.setLaunching(true);
                    ((FighterBay)this.theWeapon).setLandedFighterGroup(null);
                    this.theShip.incrementRestrictedMovementLaunch();
                    map.loadAdapters(false);
                    map.repaint();
                    this.sObj = theGroup;
                    this.publishId("" + theGroup.getId());
                    this.publishMessage("Fighter launch");
                }
            } else {
                double maxRange = 0.0;
                if (this.sObj instanceof MissileSalvo) {
                    MissileSalvo ms = (MissileSalvo)this.sObj;
                    String type = (String)this.cBox.getSelectedItem();
                    ms.setSalvoType(type);
                    maxRange = ms.getMaximumRange();
                }
                if (this.sObj instanceof PlasmaBolt) {
                    PlasmaBolt pb = (PlasmaBolt)this.sObj;
                    maxRange = pb.getMaximumRange();
                }
                if (this.sObj instanceof AntiMatterTorpedo) {
                    AntiMatterTorpedo amt = (AntiMatterTorpedo)this.sObj;
                    maxRange = amt.getMaximumRange();
                }
                if (!(this.sObj instanceof NovaCannonBolt || this.sObj instanceof WaveGunBolt || this.sObj instanceof FighterGroup || this.sObj instanceof Missile)) {
                    msPos = this.theShip.rangeBoundsAlongVector(markPosition[0], markPosition[1], maxRange);
                    int fireArc = this.theShip.arcTo(msPos[0] - this.theShip.getXPosition(), msPos[1] - this.theShip.getYPosition());
                    if (!this.theWeapon.fireAtTargetArc(fireArc)) {
                        this.publishMessage("Out of arc");
                    } else {
                        this.publishMessage(" ");
                    }
                    this.sObj.setXPosition(msPos[0]);
                    this.sObj.setYPosition(msPos[1]);
                    int salvoHeading = this.theShip.headingTo(msPos[0], msPos[1]);
                    this.sObj.setHeading(salvoHeading);
                }
                map.repaint();
            }
            this.parent.updateSSDs();
        }
    }
}

