/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.Client;
import ftjava.gui.ShipGUIAdapter;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FTJavaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Font defaultFont;
    protected static Font boldFont;
    protected static Font nonShipFont;
    protected static ImageIcon collapsedIcon;
    protected static ImageIcon expandedIcon;
    protected static ImageIcon tag_dead;
    protected static ImageIcon tag_red;
    protected static ImageIcon tag_yellow;
    protected static ImageIcon tag_green;
    protected static ImageIcon tag_blank;
    protected static ImageIcon tag_jump;
    protected static ImageIcon tag_strike;
    protected static ImageIcon tag_NAC;
    protected static ImageIcon tag_FSE;
    protected static ImageIcon tag_ESU;
    protected static ImageIcon tag_NSL;
    protected static ImageIcon tag_PHALON;
    protected static ImageIcon tag_KRAVAK;
    protected static ImageIcon tag_UNSC;
    protected static ImageIcon tag_IF;
    protected static ImageIcon tag_IJN;
    protected boolean selected;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String status;
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof String) {
            String team = (String)userObject;
            if (team.equals("NAC") || team.equals("New Anglian Confederation")) {
                this.setIcon(Client.TAG_NAC);
            }
            if (team.equals("NSL") || team.equals("Neu Swabian League")) {
                this.setIcon(Client.TAG_NSL);
            }
            if (team.equals("ESU") || team.equals("Eurasian Solar Union")) {
                this.setIcon(Client.TAG_ESU);
            }
            if (team.equals("FSE") || team.equals("Federal Stats Europa")) {
                this.setIcon(Client.TAG_FSE);
            }
            if (team.equals("UNSC") || team.equals("United Nations Space Command")) {
                this.setIcon(Client.TAG_UNSC);
            }
            if (team.equals("Kra'Vak") || team.equals("KraVak")) {
                this.setIcon(Client.TAG_KRAVAK);
            }
            if (team.equals("Phalon") || team.equals("Phalon Conglomerate")) {
                this.setIcon(Client.TAG_PHALON);
            }
            if (team.equals("IJN") || team.equals("Imperial Japanese Navy")) {
                this.setIcon(Client.TAG_IJN);
            }
            if (team.equals("IF") || team.equals("Islamic Federation")) {
                this.setIcon(Client.TAG_IF);
            }
            this.setFont(nonShipFont);
        }
        if (userObject instanceof ShipGUIAdapter) {
            Ship s = ((ShipGUIAdapter)userObject).getShip();
            status = s.getStatus();
            if (status.equals("Ok") || status.equals("Light")) {
                this.setIcon(Client.TAG_GREEN);
            } else if (status.equals("Moderate")) {
                this.setIcon(Client.TAG_YELLOW);
            } else if (status.equals("Heavy") || status.equals("Critical")) {
                this.setIcon(Client.TAG_RED);
            } else if (status.equals("Destroyed")) {
                this.setIcon(Client.TAG_DEAD);
            } else if (status.equals("Jumped") || status.equals("Out of System")) {
                this.setIcon(Client.TAG_JUMP);
            } else if (status.equals("Striking its Colors")) {
                this.setIcon(Client.TAG_STRIKE);
            }
            if (s.hasOrders()) {
                this.setFont(boldFont);
            } else {
                this.setFont(defaultFont);
            }
        }
        if (userObject instanceof SpaceObjectGUIAdapter) {
            SpaceObject so = ((SpaceObjectGUIAdapter)userObject).getSpaceObject();
            status = so.getStatus();
            if (status.equals("Ok") || status.equals("Light")) {
                this.setIcon(tag_green);
            } else if (status.equals("Moderate")) {
                this.setIcon(tag_yellow);
            } else if (status.equals("Heavy") || status.equals("Critical")) {
                this.setIcon(tag_red);
            } else if (status.equals("Destroyed")) {
                this.setIcon(tag_dead);
            } else if (status.equals("Jumped") || status.equals("Out of System")) {
                this.setIcon(tag_jump);
            } else if (status.equals("Striking its Colors")) {
                this.setIcon(tag_strike);
            }
            this.setFont(defaultFont);
        }
        this.setForeground(Color.black);
        this.selected = selected;
        return this;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = ClassLoader.getSystemResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    static {
        try {
            defaultFont = new Font("SansSerif", 0, 12);
            boldFont = new Font("SansSerif", 1, 12);
            nonShipFont = new Font("SansSerif", 1, 12);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            tag_dead = FTJavaTreeCellRenderer.createImageIcon("Images/tag_skull.gif");
            tag_red = FTJavaTreeCellRenderer.createImageIcon("Images/tag_red.gif");
            tag_yellow = FTJavaTreeCellRenderer.createImageIcon("Images/tag_yellow.gif");
            tag_green = FTJavaTreeCellRenderer.createImageIcon("Images/tag_green.gif");
            tag_blank = FTJavaTreeCellRenderer.createImageIcon("Images/tag_blank.gif");
            tag_jump = FTJavaTreeCellRenderer.createImageIcon("Images/tag_jump.gif");
            tag_strike = FTJavaTreeCellRenderer.createImageIcon("Images/tag_white.gif");
            tag_NAC = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/nacIcon.gif");
            tag_FSE = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/fseIcon.gif");
            tag_ESU = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/esuIcon.gif");
            tag_NSL = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/nslIcon.gif");
            tag_KRAVAK = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/kvIcon.gif");
            tag_PHALON = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/phIcon.gif");
            tag_UNSC = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/unscIcon.gif");
            tag_IF = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/ifIcon.gif");
            tag_IJN = FTJavaTreeCellRenderer.createImageIcon("Images/Flags/ijnIcon.gif");
        }
        catch (Exception e) {
            System.out.println("Couldn't load images: " + e);
        }
    }
}

