/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.AboutFTJava;
import ftjava.gui.ClientProgram;
import ftjava.gui.FTJava;
import ftjava.gui.FTJavaTreeCellRenderer;
import ftjava.gui.FighterStatusDisplay;
import ftjava.gui.GUIAdapter;
import ftjava.gui.HTMLWindow;
import ftjava.gui.MainProgram;
import ftjava.gui.MessageComposer;
import ftjava.gui.MessageReader;
import ftjava.gui.MissileStatusDisplay;
import ftjava.gui.PlayerObjectives;
import ftjava.gui.Preferences;
import ftjava.gui.RenderStarmap;
import ftjava.gui.ScenarioBriefing;
import ftjava.gui.ShipGUIAdapter;
import ftjava.gui.ShipStatusDisplay;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.gui.StarMap;
import ftjava.gui.StatusDisplay;
import ftjava.gui.TargetingSummaryDialog;
import ftjava.gui.TextSensorReport;
import ftjava.gui.TurnReport;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.Missile;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.importer.ImportOrders;
import ftjava.util.GameOptions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Client
extends JFrame
implements ClientProgram {
    private static final long serialVersionUID = 1L;
    private JFrame mySelf;
    private GameEngine engine;
    private Client client;
    private StarMap map;
    private TurnReport report;
    private TextSensorReport full;
    private TextSensorReport sensor;
    private MessageComposer mComposer = null;
    private MessageReader mReader = null;
    private boolean SavedOrders = false;
    private boolean isGameMaster = false;
    private ScenarioBriefing briefing;
    private PlayerObjectives objectives;
    private JMenuItem LoadOrders;
    private JMenuItem MoveItem;
    private JMenuItem FireItem;
    private JMenuItem SaveImageItem;
    private JMenuItem SummaryItem;
    private JMenuItem CloseItem;
    private FileDialog chooser;
    private boolean enableAccelerator;
    private File engineFile;
    private MainProgram parentFTJava;
    public TreeSet allAdapters;
    public TreeSet shipAdapters;
    public TreeSet spaceObjectAdapters;
    private GUIAdapter starMapLastValidAdapter = null;
    private HashMap lookupMap;
    private HashMap lookupTreeNodeMap;
    private JTree theTree;
    private DefaultTreeModel theTreeModel;
    private JPanel treePanel;
    private int treeHeight = 325;
    private int treeWidth = 275;
    private JPanel cardPanel;
    private int cardHeight = 325;
    private int cardWidth = 550;
    private JSplitPane theSplitPane;
    private JPopupMenu treePopupMenu;
    public static final int REMOVEDEAD = 101;
    public static Icon TAG_DEAD;
    public static Icon TAG_RED;
    public static Icon TAG_GREEN;
    public static Icon TAG_YELLOW;
    public static Icon TAG_BLANK;
    public static Icon TAG_JUMP;
    public static Icon TAG_STRIKE;
    public static Icon TAG_NAC;
    public static Icon TAG_NSL;
    public static Icon TAG_ESU;
    public static Icon TAG_FSE;
    public static Icon TAG_UNSC;
    public static Icon TAG_KRAVAK;
    public static Icon TAG_PHALON;
    public static Icon TAG_IF;
    public static Icon TAG_IJN;

    public Client(MainProgram parent, File inFile, GameEngine inengine, int id, int turn, String phase) {
        super("Full Thrust - Game " + id + " - Turn " + turn + " - " + phase + " phase");
        this.engineFile = inFile;
        this.parentFTJava = parent;
        this.mySelf = this;
        this.client = this;
        this.engine = inengine;
        this.engine.setCurrentGame(true);
        this.map = new StarMap(this.engine, this);
        this.allAdapters = this.map.getAllAdapters();
        this.shipAdapters = this.map.getShipAdapters();
        this.spaceObjectAdapters = this.map.getSpaceObjectAdapters();
        if (this.engine.getActivePlayer() == null) {
            this.isGameMaster = true;
        }
        this.map.setVisible(true);
        if (phase.equals("Combat")) {
            this.engine.resetFireControls();
        }
        this.setUpReports();
        this.setUpCloseListeners();
        this.setUpIcons();
        JMenuBar MenuBar2 = new JMenuBar();
        this.setJMenuBar(MenuBar2);
        this.setAcceleratorKeys();
        this.createGameMenu(MenuBar2, phase);
        this.createViewMenu(MenuBar2);
        this.createMessageMenu(MenuBar2);
        this.createShipMenu(MenuBar2);
        this.createFriendAndFoeMenu(MenuBar2, this.shipAdapters);
        this.createHelpMenu(MenuBar2);
        this.createCardPanel(phase);
        this.createTreePanel(phase);
        this.createPopupMenu();
        this.theSplitPane = new JSplitPane(1);
        this.theSplitPane.setLeftComponent(this.treePanel);
        this.theSplitPane.setRightComponent(this.cardPanel);
        this.theSplitPane.setDividerLocation(this.treeWidth);
        this.theSplitPane.setPreferredSize(new Dimension(this.treeWidth + this.cardWidth, 325));
        this.getContentPane().add((Component)this.theSplitPane, "Center");
        this.pack();
        this.setVisible(true);
    }

    public StarMap getStarMap() {
        return this.map;
    }

    public MainProgram getMainProgram() {
        return this.parentFTJava;
    }

    public void writeMovePhase() {
        GameOptions.setDebugMode(false);
        this.updateSSD();
        this.map.repaint();
        if (this.engine.getActivePlayer() != null) {
            File d = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"));
            d.mkdirs();
            Player p = this.engine.getActivePlayer();
            File f = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"), this.engine.getSuggestMovementOrdersFilename(p));
            this.engine.saveMovementOrders(p, f);
            this.SavedOrders = true;
        }
    }

    public void movePhase() {
        GameOptions.setDebugMode(false);
        this.updateSSD();
        this.map.repaint();
        if (this.engine.getActivePlayer() != null) {
            File d = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"));
            d.mkdirs();
            File f = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"), this.engine.getSuggestMovementOrdersFilename(this.engine.getActivePlayer()));
            if (f != null) {
                this.engine.saveMovementOrders(this.engine.getActivePlayer(), f);
                this.SavedOrders = true;
                this.parentFTJava.notifyFileProcessed(this.engineFile);
            }
        }
    }

    public void writeCombatPhase() {
        if (this.engine.getActivePlayer() != null) {
            File d = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"));
            d.mkdirs();
            Player p = this.engine.getActivePlayer();
            File f = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"), this.engine.getSuggestCombatOrdersFilename(p));
            this.engine.saveCombatOrders(p, f);
            this.SavedOrders = true;
        }
    }

    public void combatPhase() {
        if (this.engine.getActivePlayer() != null) {
            File d = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"));
            d.mkdirs();
            File f = new File(Preferences.getPreferences().getProperty("Outgoing Games Directory"), this.engine.getSuggestCombatOrdersFilename(this.engine.getActivePlayer()));
            if (f != null) {
                this.engine.saveCombatOrders(this.engine.getActivePlayer(), f);
                this.SavedOrders = true;
                this.parentFTJava.notifyFileProcessed(this.engineFile);
            }
        }
    }

    public MessageComposer createMessageComposer() {
        String name = null;
        Player p = this.engine.getActivePlayer();
        name = p == null ? "Observer" : p.getName();
        Vector<String> v = new Vector<String>();
        v.add("All Players");
        for (int i = 0; i < this.engine.getNumberOfPlayers(); ++i) {
            Player k = this.engine.getPlayer(i);
            if (k == null || k.equals(p)) continue;
            v.add(k.getName());
        }
        HashMap teams = this.engine.getTeams();
        Set keys = teams.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            v.add((String)it.next());
        }
        return new MessageComposer(p, name, v);
    }

    public MessageReader createMessageReader() {
        return new MessageReader(this.engine.getActivePlayer());
    }

    public void updateSSD() {
        Object[] components = this.lookupMap.values().toArray();
        for (int i = 0; i < components.length; ++i) {
            StatusDisplay ssd = (StatusDisplay)components[i];
            ssd.updateData();
        }
    }

    public void setVisible(boolean b) {
        Player p;
        super.setVisible(true);
        if (this.report.hasCurrentReport()) {
            this.report.setVisible(true);
        }
        if ((p = this.engine.getActivePlayer()) != null && p.hasMessages() && this.mReader == null) {
            this.mReader = this.createMessageReader();
            this.mReader.setLocation(0, 300);
            this.mReader.setVisible(true);
        }
    }

    private void setUpIcons() {
        BufferedImage img = ImageUtilities.getImage("Images/tag_skull.gif", this);
        TAG_DEAD = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_red.gif", this);
        TAG_RED = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_yellow.gif", this);
        TAG_YELLOW = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_green.gif", this);
        TAG_GREEN = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_blank.gif", this);
        TAG_BLANK = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_jump.gif", this);
        TAG_JUMP = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/tag_white.gif", this);
        TAG_STRIKE = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/nacIcon.gif", this);
        TAG_NAC = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/nslIcon.gif", this);
        TAG_NSL = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/esuIcon.gif", this);
        TAG_ESU = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/fseIcon.gif", this);
        TAG_FSE = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/ifIcon.gif", this);
        TAG_IF = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/phIcon.gif", this);
        TAG_PHALON = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/unscIcon.gif", this);
        TAG_UNSC = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/Flags/ijnIcon.gif", this);
        TAG_IJN = new ImageIcon(img);
    }

    private void setUpReports() {
        this.report = new TurnReport(this.engine);
        this.full = new TextSensorReport(this.engine, false);
        this.sensor = new TextSensorReport(this.engine, true);
        this.briefing = new ScenarioBriefing(this.engine);
        this.objectives = new PlayerObjectives(this.engine);
    }

    private void setUpCloseListeners() {
        this.map.addWindowListener(new closeListener());
        this.map.setDefaultCloseOperation(0);
        this.addWindowListener(new closeListener());
        this.setDefaultCloseOperation(0);
    }

    private void createGameMenu(JMenuBar MenuBar2, String phase) {
        JMenu GameMenu = new JMenu("Game");
        MenuBar2.add(GameMenu);
        this.LoadOrders = new JMenuItem("Load Orders");
        this.LoadOrders.setEnabled(true);
        this.MoveItem = new JMenuItem("Save Movement Orders as file");
        this.MoveItem.setEnabled(phase.equals("Movement"));
        GameMenu.add(this.MoveItem);
        this.MoveItem.addActionListener(new WriteMovementOrdersAction());
        this.MoveItem = new JMenuItem("Queue Movement Orders for email");
        this.MoveItem.setEnabled(phase.equals("Movement"));
        GameMenu.add(this.MoveItem);
        this.MoveItem.addActionListener(new MovementOrdersAction());
        GameMenu.addSeparator();
        this.SummaryItem = new JMenuItem("Targeting Summary");
        this.SummaryItem.setEnabled(phase.equals("Combat"));
        if (this.isGameMaster) {
            this.SummaryItem.setEnabled(false);
        }
        GameMenu.add(this.SummaryItem);
        this.SummaryItem.addActionListener(new SummaryCombatOrdersAction());
        this.FireItem = new JMenuItem("Save Combat Orders as file");
        this.FireItem.setEnabled(phase.equals("Combat"));
        GameMenu.add(this.FireItem);
        this.FireItem.addActionListener(new WriteCombatOrdersAction());
        this.FireItem = new JMenuItem("Queue Combat Orders for email");
        this.FireItem.setEnabled(phase.equals("Combat"));
        GameMenu.add(this.FireItem);
        this.FireItem.addActionListener(new CombatOrdersAction());
        GameMenu.addSeparator();
        this.SaveImageItem = new JMenuItem("Save StarMap as PNG");
        GameMenu.add(this.SaveImageItem);
        this.SaveImageItem.addActionListener(new SaveAsImageAction(this.mySelf));
        GameMenu.addSeparator();
        this.CloseItem = new JMenuItem("Close");
        GameMenu.add(this.CloseItem);
        this.CloseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean close = true;
                if (!Client.this.SavedOrders && !Client.this.isGameMaster) {
                    int choice = JOptionPane.showConfirmDialog(Client.this.mySelf, "Orders have not been saved or queued, close anyway?", "Exit without saving", 0);
                    boolean bl = close = choice == 0;
                }
                if (close) {
                    Client.this.map.cleanUp();
                    Client.this.map.dispose();
                    Client.this.dispose();
                }
            }
        });
    }

    private void createViewMenu(JMenuBar MenuBar2) {
        JMenu StatusMenu = new JMenu("View");
        MenuBar2.add(StatusMenu);
        JMenuItem item = new JMenuItem("Scenario Briefing");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.briefing.setVisible(true);
            }
        });
        item = new JMenuItem("Player Objectives");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.objectives.setVisible(true);
            }
        });
        StatusMenu.addSeparator();
        item = new JMenuItem("Full Report");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.full.setVisible(true);
            }
        });
        item = new JMenuItem("Sensor Report");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.sensor.setVisible(true);
            }
        });
        StatusMenu.addSeparator();
        item = new JMenuItem("Star Map");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.map.setVisible(true);
            }
        });
        item = new JMenuItem("Turn Report");
        StatusMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.report.setVisible(true);
            }
        });
    }

    private void createMessageMenu(JMenuBar MenuBar2) {
        JMenu MessageMenu = new JMenu("Messages");
        MenuBar2.add(MessageMenu);
        JMenuItem item = new JMenuItem("Message Composer");
        MessageMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Client.this.mComposer = Client.this.createMessageComposer();
                Client.this.mComposer.setLocation(200, 30);
                Client.this.mComposer.setVisible(true);
            }
        });
        item = new JMenuItem("Message Reader");
        MessageMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Client.this.mReader == null) {
                    Client.this.mReader = Client.this.createMessageReader();
                }
                Client.this.mReader.setLocation(0, 300);
                Client.this.mReader.setVisible(true);
            }
        });
    }

    private void setAcceleratorKeys() {
        String accelProp = "Enable Accelerator Keys";
        this.enableAccelerator = Preferences.getPreferences().getProperty(accelProp).equals("true");
    }

    private void createShipMenu(JMenuBar MenuBar2) {
        int sensorRules;
        JMenu display = new JMenu("Ship");
        MenuBar2.add(display);
        JMenu movement = new JMenu("Movement Plots");
        JMenu weapons = new JMenu("Weapon Arcs");
        JMenuItem item = new JMenuItem("Plot Envelope");
        movement.add(item);
        item.addActionListener(new StarMapOption(null, 4));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(69, 0));
        }
        item = new JMenuItem("Ghost Plot");
        movement.add(item);
        item.addActionListener(new StarMapOption(null, 5));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(71, 0));
        }
        item = new JMenuItem("Ghost Trail");
        movement.add(item);
        item.addActionListener(new StarMapOption(null, 8));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        }
        display.add(movement);
        item = new JMenuItem("Beam");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(66, 0));
        }
        item = new JMenuItem("Pulse Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 2));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(80, 0));
        }
        item = new JMenuItem("Salvo Missiles");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 10));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        }
        item = new JMenuItem("Submunition Pack");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 3));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        }
        item = new JMenuItem("Point Defense");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 13));
        weapons.addSeparator();
        item = new JMenuItem("Graser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 16));
        item = new JMenuItem("AntiMatter Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 17));
        weapons.addSeparator();
        item = new JMenuItem("Kinetic Gun");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 9));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(75, 0));
        }
        item = new JMenuItem("Scatterguns");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 14));
        weapons.addSeparator();
        item = new JMenuItem("Plasma Bolts");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 11));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        }
        item = new JMenuItem("Pulser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(null, 12));
        display.add(weapons);
        item = new JMenuItem("Lock Ons");
        display.add(item);
        item.addActionListener(new StarMapOption(null, 7));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        }
        if ((sensorRules = this.engine.getOptions().getSensorRules()) == 2 || sensorRules == 3) {
            item = new JMenuItem("Sensors");
            display.add(item);
            item.addActionListener(new StarMapOption(null, 15));
        }
        item = new JMenuItem("Clear Arcs");
        display.add(item);
        item.addActionListener(new StarMapOption(null, -1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(67, 0));
        }
        item = new JMenuItem("Clear");
        display.add(item);
        item.addActionListener(new StarMapOption(null, 6));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(90, 0));
        }
        item = new JMenuItem("Remove if Dead or Jumped");
        display.add(item);
        item.addActionListener(new ClientUIOption(null, 101));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(88, 0));
        }
    }

    private void createFriendAndFoeMenu(JMenuBar MenuBar2, TreeSet adapters) {
        int sensorRules;
        ArrayList<ShipGUIAdapter> playersOwn = new ArrayList<ShipGUIAdapter>();
        ArrayList<ShipGUIAdapter> friendlies = new ArrayList<ShipGUIAdapter>();
        ArrayList<ShipGUIAdapter> allFriendlies = new ArrayList<ShipGUIAdapter>();
        ArrayList<ShipGUIAdapter> foes = new ArrayList<ShipGUIAdapter>();
        ArrayList<ShipGUIAdapter> allFoes = new ArrayList<ShipGUIAdapter>();
        Player thePlayer = this.engine.getActivePlayer();
        Iterator adapterIterator = adapters.iterator();
        while (adapterIterator.hasNext()) {
            Object obj = adapterIterator.next();
            if (!(obj instanceof ShipGUIAdapter)) continue;
            ShipGUIAdapter s = (ShipGUIAdapter)obj;
            if (this.engine.getActivePlayer() != null) {
                String team = this.engine.getActivePlayer().getTeam();
                if (thePlayer.doesPlayerOwnShip(s.getShip())) {
                    playersOwn.add(s);
                    continue;
                }
                if (team.equals(s.getShip().getPlayer().getTeam())) {
                    if (!s.getShip().isDestroyed()) {
                        friendlies.add(s);
                    }
                    allFriendlies.add(s);
                    continue;
                }
                if (!s.getShip().isDestroyed()) {
                    foes.add(s);
                }
                allFoes.add(s);
                continue;
            }
            if (!s.getShip().isDestroyed()) {
                friendlies.add(s);
            }
            allFriendlies.add(s);
        }
        JMenu display = new JMenu("Squadron");
        MenuBar2.add(display);
        JMenu movement = new JMenu("Movement Plots");
        JMenu weapons = new JMenu("Weapon Arcs");
        JMenuItem item = new JMenuItem("Plot Envelope");
        movement.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 4));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(69, 1));
        }
        item = new JMenuItem("Ghost Plot");
        movement.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 5));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(71, 1));
        }
        item = new JMenuItem("Ghost Trail");
        movement.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 8));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(84, 1));
        }
        display.add(movement);
        item = new JMenuItem("Beam");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(66, 1));
        }
        item = new JMenuItem("Pulse Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 2));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(80, 1));
        }
        item = new JMenuItem("Salvo Missiles");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 10));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(77, 1));
        }
        item = new JMenuItem("Submunition Pack");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 3));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(83, 1));
        }
        item = new JMenuItem("Point Defense");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 13));
        weapons.addSeparator();
        item = new JMenuItem("Graser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 16));
        item = new JMenuItem("AntiMatter Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 17));
        weapons.addSeparator();
        item = new JMenuItem("Kinetic Gun");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 9));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(75, 1));
        }
        item = new JMenuItem("Scatterguns");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 14));
        weapons.addSeparator();
        item = new JMenuItem("Plasma Bolts");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 11));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(65, 1));
        }
        item = new JMenuItem("Pulser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 12));
        display.add(weapons);
        item = new JMenuItem("Lock Ons");
        display.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 7));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(76, 1));
        }
        if ((sensorRules = this.engine.getOptions().getSensorRules()) == 2 || sensorRules == 3) {
            item = new JMenuItem("Sensors");
            display.add(item);
            item.addActionListener(new StarMapOption(playersOwn, 15));
        }
        item = new JMenuItem("Clear Arcs");
        display.add(item);
        item.addActionListener(new StarMapOption(playersOwn, -1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(67, 1));
        }
        item = new JMenuItem("Clear");
        display.add(item);
        item.addActionListener(new StarMapOption(playersOwn, 6));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(90, 1));
        }
        item = new JMenuItem("Remove Dead & Jumped Ships");
        display.add(item);
        item.addActionListener(new ClientUIOption(playersOwn, 101));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(88, 1));
        }
        display = new JMenu("Allies");
        MenuBar2.add(display);
        movement = new JMenu("Movement Plots");
        weapons = new JMenu("Weapon Arcs");
        item = new JMenuItem("Plot Envelope");
        movement.add(item);
        item.addActionListener(new StarMapOption(friendlies, 4));
        item = new JMenuItem("Ghost Plot");
        movement.add(item);
        item.addActionListener(new StarMapOption(friendlies, 5));
        item = new JMenuItem("Ghost Trail");
        movement.add(item);
        item.addActionListener(new StarMapOption(friendlies, 8));
        display.add(movement);
        item = new JMenuItem("Beam");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 1));
        item = new JMenuItem("Pulse Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 2));
        item = new JMenuItem("Salvo Missiles");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 10));
        item = new JMenuItem("Submunition Pack");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 3));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(83, 1));
        }
        item = new JMenuItem("Point Defense");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 13));
        weapons.addSeparator();
        item = new JMenuItem("Graser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 16));
        item = new JMenuItem("AntiMatter Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 17));
        weapons.addSeparator();
        item = new JMenuItem("Kinetic Gun");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 9));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(75, 1));
        }
        item = new JMenuItem("Scatterguns");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 14));
        weapons.addSeparator();
        item = new JMenuItem("Plasma Bolts");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 11));
        item = new JMenuItem("Pulser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(friendlies, 12));
        display.add(weapons);
        if (sensorRules == 2 || sensorRules == 3) {
            item = new JMenuItem("Sensors");
            display.add(item);
            item.addActionListener(new StarMapOption(friendlies, 15));
        }
        item = new JMenuItem("Clear Arcs");
        display.add(item);
        item.addActionListener(new StarMapOption(friendlies, -1));
        item = new JMenuItem("Clear");
        display.add(item);
        item.addActionListener(new StarMapOption(friendlies, 6));
        item = new JMenuItem("Remove Dead & Jumped Ships");
        display.add(item);
        item.addActionListener(new ClientUIOption(allFriendlies, 101));
        display = new JMenu("Enemy");
        MenuBar2.add(display);
        movement = new JMenu("Movement Plots");
        weapons = new JMenu("Weapon Arcs");
        item = new JMenuItem("Plot Envelope");
        movement.add(item);
        item.addActionListener(new StarMapOption(foes, 4));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        }
        item = new JMenuItem("Ghost Plot");
        movement.add(item);
        item.addActionListener(new StarMapOption(foes, 5));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        }
        item = new JMenuItem("Ghost Trail");
        movement.add(item);
        item.addActionListener(new StarMapOption(foes, 8));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        }
        display.add(movement);
        item = new JMenuItem("Beam");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        }
        item = new JMenuItem("Pulse Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 2));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        }
        item = new JMenuItem("Salvo Missiles");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 10));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        }
        item = new JMenuItem("Submunition Pack");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 3));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        }
        item = new JMenuItem("Point Defense");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 13));
        weapons.addSeparator();
        item = new JMenuItem("Graser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 16));
        item = new JMenuItem("AntiMatter Torpedo");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 17));
        weapons.addSeparator();
        item = new JMenuItem("Kinetic Gun");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 9));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        }
        item = new JMenuItem("Scatterguns");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 14));
        weapons.addSeparator();
        item = new JMenuItem("Plasma Bolts");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 11));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        }
        item = new JMenuItem("Pulser");
        weapons.add(item);
        item.addActionListener(new StarMapOption(foes, 12));
        display.add(weapons);
        if (sensorRules == 2 || sensorRules == 3) {
            item = new JMenuItem("Sensors");
            display.add(item);
            item.addActionListener(new StarMapOption(foes, 15));
        }
        item = new JMenuItem("Clear Arcs");
        display.add(item);
        item.addActionListener(new StarMapOption(foes, -1));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        }
        item = new JMenuItem("Clear");
        display.add(item);
        item.addActionListener(new StarMapOption(foes, 6));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        }
        item = new JMenuItem("Remove Dead & Jumped Ships");
        display.add(item);
        item.addActionListener(new ClientUIOption(allFoes, 101));
        if (this.enableAccelerator) {
            item.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        }
    }

    private void createHelpMenu(JMenuBar MenuBar2) {
        MenuBar2.add(Box.createHorizontalGlue());
        JMenu AboutMenu = new JMenu("Help");
        MenuBar2.add(AboutMenu);
        JMenuItem item = new JMenuItem("About FTJava");
        item.addActionListener(new AboutFTJava());
        AboutMenu.add(item);
        item = new JMenuItem("From the Authors");
        item.addActionListener(HTMLWindow.getListener("Statement", "A statement from the authors", 500, 400));
        AboutMenu.add(item);
    }

    private void createCardPanel(String phase) {
        ShipGUIAdapter s;
        GUIAdapter ga;
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.setSize(this.cardWidth, this.cardHeight);
        this.cardPanel.setMinimumSize(new Dimension(this.cardWidth, this.cardHeight));
        this.lookupMap = new HashMap();
        Iterator it = this.shipAdapters.iterator();
        if (this.engine.getActivePlayer() != null && phase.equals("Movement")) {
            while (it.hasNext()) {
                ga = (GUIAdapter)it.next();
                if (ga instanceof SpaceObjectGUIAdapter || (s = (ShipGUIAdapter)ga).getShip().isDestroyed()) continue;
                if (this.engine.getActivePlayer() == s.getShip().getPlayer()) {
                    s.setShowGhostPlot(true);
                    continue;
                }
                s.setShowPlotEnvelope(true);
            }
        }
        it = this.shipAdapters.iterator();
        while (it.hasNext()) {
            ga = (GUIAdapter)it.next();
            if (ga instanceof SpaceObjectGUIAdapter) continue;
            s = (ShipGUIAdapter)ga;
            ShipStatusDisplay ssd = new ShipStatusDisplay(this, this.engine, s);
            this.cardPanel.add((Component)ssd, s.getShip().toString());
            this.lookupMap.put(s.getShip().toString(), ssd);
        }
        it = this.spaceObjectAdapters.iterator();
        while (it.hasNext()) {
            ga = (GUIAdapter)it.next();
            if (ga instanceof ShipGUIAdapter) continue;
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)ga;
            SpaceObject so = soga.getSpaceObject();
            StatusDisplay sd = null;
            if (so instanceof FighterGroup) {
                sd = new FighterStatusDisplay(this, this.engine, soga);
            } else {
                if (!(so instanceof Missile)) continue;
                sd = new MissileStatusDisplay(this, this.engine, soga);
            }
            this.cardPanel.add((Component)sd, soga.getSpaceObject().toString());
            this.lookupMap.put(soga.getSpaceObject().toString(), sd);
        }
    }

    private ShipGUIAdapter getShipAdapter(Ship s) {
        Iterator it = this.shipAdapters.iterator();
        while (it.hasNext()) {
            ShipGUIAdapter sga = (ShipGUIAdapter)it.next();
            if (!sga.getShip().equals(s)) continue;
            return sga;
        }
        return null;
    }

    private SpaceObjectGUIAdapter getFighterAdapter(FighterGroup fg) {
        Iterator it = this.spaceObjectAdapters.iterator();
        while (it.hasNext()) {
            FighterGroup fgt;
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)it.next();
            SpaceObject so = soga.getSpaceObject();
            if (!(so instanceof FighterGroup) || !(fgt = (FighterGroup)so).equals(fg)) continue;
            return soga;
        }
        return null;
    }

    private SpaceObjectGUIAdapter getMissileAdapter(Missile m) {
        Iterator it = this.spaceObjectAdapters.iterator();
        while (it.hasNext()) {
            Missile mt;
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)it.next();
            SpaceObject so = soga.getSpaceObject();
            if (!(so instanceof Missile) || !(mt = (Missile)so).equals(m)) continue;
            return soga;
        }
        return null;
    }

    private void createTreePanel(String phase) {
        int i;
        KeyListener[] aSet;
        DefaultMutableTreeNode teamNode = null;
        DefaultMutableTreeNode playerNode = null;
        DefaultMutableTreeNode shipNode = null;
        DefaultMutableTreeNode firstNode = null;
        TreePath firstPath = null;
        this.lookupTreeNodeMap = new HashMap();
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.setSize(this.treeWidth, this.treeHeight);
        this.treePanel.setMinimumSize(new Dimension(this.treeWidth, this.treeHeight));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.engine.getName());
        this.theTreeModel = new DefaultTreeModel(top);
        this.theTree = new JTree(this.theTreeModel);
        firstPath = new TreePath(top);
        this.theTree.setEditable(false);
        if (!FTJava.isMacOSX() && (aSet = this.theTree.getKeyListeners()).length > 0) {
            this.theTree.removeKeyListener(aSet[0]);
        }
        Player p = this.engine.getActivePlayer();
        String pTeam = null;
        ArrayList players = this.engine.getPlayers();
        ArrayList<Player> treeOrder = new ArrayList<Player>();
        HashSet<String> allTeams = new HashSet<String>();
        for (int i2 = 0; i2 < players.size(); ++i2) {
            allTeams.add(((Player)players.get(i2)).getTeam());
        }
        HashMap<String, DefaultMutableTreeNode> teamMap = new HashMap<String, DefaultMutableTreeNode>();
        if (p != null) {
            pTeam = p.getTeam();
            teamNode = new DefaultMutableTreeNode(pTeam);
            top.add(teamNode);
            teamMap.put(pTeam, teamNode);
        }
        Iterator it = allTeams.iterator();
        while (it.hasNext()) {
            String teamName = (String)it.next();
            if (pTeam != null && pTeam.equals(teamName)) continue;
            DefaultMutableTreeNode tNode = new DefaultMutableTreeNode(teamName);
            top.add(tNode);
            teamMap.put(teamName, tNode);
        }
        Player pI = null;
        if (p != null) {
            treeOrder.add(p);
            for (i = 0; i < players.size(); ++i) {
                pI = (Player)players.get(i);
                if (p.equals(pI)) continue;
                treeOrder.add(pI);
            }
        } else {
            for (i = 0; i < players.size(); ++i) {
                treeOrder.add((Player)players.get(i));
            }
        }
        for (i = 0; i < treeOrder.size(); ++i) {
            SpaceObjectGUIAdapter soga;
            SpaceObject so;
            int j;
            pI = (Player)treeOrder.get(i);
            playerNode = new DefaultMutableTreeNode(pI);
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)teamMap.get(pI.getTeam());
            aNode.add(playerNode);
            ArrayList ownShips = pI.getShips();
            ArrayList ownObjs = pI.getSpaceObjects();
            for (j = 0; j < ownShips.size(); ++j) {
                Ship s = (Ship)ownShips.get(j);
                ShipGUIAdapter sga = this.getShipAdapter(s);
                shipNode = new DefaultMutableTreeNode(sga);
                playerNode.add(shipNode);
                this.lookupTreeNodeMap.put(s.toString(), shipNode);
                if (firstNode != null) continue;
                if (teamNode == null) {
                    teamNode = aNode;
                }
                firstPath = firstPath.pathByAddingChild(teamNode);
                firstPath = firstPath.pathByAddingChild(playerNode);
                firstPath = firstPath.pathByAddingChild(shipNode);
                firstNode = shipNode;
            }
            for (j = 0; j < ownObjs.size(); ++j) {
                so = (SpaceObject)ownObjs.get(j);
                if (!(so instanceof FighterGroup)) continue;
                FighterGroup fg = (FighterGroup)so;
                soga = this.getFighterAdapter(fg);
                shipNode = new DefaultMutableTreeNode(soga);
                if (fg.getCarrierShipId() != 0) {
                    DefaultMutableTreeNode carrierNode = null;
                    Ship carrierShip = this.engine.getShipById(fg.getCarrierShipId());
                    if (carrierShip != null) {
                        carrierNode = (DefaultMutableTreeNode)this.lookupTreeNodeMap.get(carrierShip.toString());
                    }
                    if (carrierNode != null) {
                        carrierNode.add(shipNode);
                    } else {
                        playerNode.add(shipNode);
                    }
                } else {
                    playerNode.add(shipNode);
                }
                this.lookupTreeNodeMap.put(fg.toString(), shipNode);
            }
            for (j = 0; j < ownObjs.size(); ++j) {
                so = (SpaceObject)ownObjs.get(j);
                if (!(so instanceof Missile)) continue;
                Missile m = (Missile)so;
                soga = this.getMissileAdapter(m);
                shipNode = new DefaultMutableTreeNode(soga);
                playerNode.add(shipNode);
                this.lookupTreeNodeMap.put(m.toString(), shipNode);
            }
        }
        this.theTree.setCellRenderer(new FTJavaTreeCellRenderer());
        this.theTree.setSelectionPath(firstPath);
        if (firstNode != null) {
            Object nodeInfo = firstNode.getUserObject();
            if (nodeInfo != null) {
                CardLayout cL = (CardLayout)this.cardPanel.getLayout();
                cL.show(this.cardPanel, nodeInfo.toString());
            }
            this.map.setActiveSelection((GUIAdapter)nodeInfo);
            this.map.repaint();
        }
        JScrollPane pane = new JScrollPane(this.theTree);
        this.treePanel.add((Component)pane, "Center");
        this.treePanel.setVisible(true);
        this.theTree.addTreeSelectionListener(new TreeSelectionListener(){
            private GUIAdapter lastValidAdapter = null;

            public void valueChanged(TreeSelectionEvent evt) {
                GUIAdapter guiA = null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)Client.this.theTree.getLastSelectedPathComponent();
                if (node == null && this.lastValidAdapter == null) {
                    return;
                }
                guiA = this.lastValidAdapter;
                if (node != null) {
                    Object nodeInfo = node.getUserObject();
                    CardLayout cL = (CardLayout)Client.this.cardPanel.getLayout();
                    cL.show(Client.this.cardPanel, nodeInfo.toString());
                    if (nodeInfo instanceof GUIAdapter) {
                        guiA = (GUIAdapter)nodeInfo;
                    }
                }
                Client.this.map.setActiveSelection(guiA);
                Client.this.map.repaint();
                Client.this.updateSSD();
                this.lastValidAdapter = guiA;
            }
        });
    }

    public void addSpaceObject(SpaceObject o) {
        String key = o.toString();
        if (this.lookupMap.containsKey(key)) {
            return;
        }
        Iterator it = this.spaceObjectAdapters.iterator();
        while (it.hasNext()) {
            GUIAdapter ga = (GUIAdapter)it.next();
            if (ga instanceof ShipGUIAdapter) continue;
            SpaceObjectGUIAdapter soga = (SpaceObjectGUIAdapter)ga;
            SpaceObject so = soga.getSpaceObject();
            StatusDisplay sd = null;
            DefaultMutableTreeNode theNode = null;
            DefaultMutableTreeNode parentNode = null;
            if (so != o) continue;
            if (so instanceof FighterGroup) {
                Ship carrierShip;
                FighterGroup fg = (FighterGroup)so;
                sd = new FighterStatusDisplay(this, this.engine, soga);
                if (fg.getCarrierShipId() != 0 && (carrierShip = this.engine.getShipById(fg.getCarrierShipId())) != null) {
                    parentNode = (DefaultMutableTreeNode)this.lookupTreeNodeMap.get(carrierShip.toString());
                }
                if (parentNode == null) {
                    parentNode = this.findPlayerNode(o.getPlayer());
                }
            } else {
                if (!(so instanceof Missile)) continue;
                sd = new MissileStatusDisplay(this, this.engine, soga);
                parentNode = this.findPlayerNode(o.getPlayer());
            }
            if (parentNode == null) {
                parentNode = (DefaultMutableTreeNode)this.theTreeModel.getRoot();
            }
            this.cardPanel.add((Component)sd, soga.getSpaceObject().toString());
            this.lookupMap.put(so.toString(), sd);
            theNode = new DefaultMutableTreeNode(soga);
            this.theTreeModel.insertNodeInto(theNode, parentNode, parentNode.getChildCount());
            this.lookupTreeNodeMap.put(so.toString(), theNode);
        }
    }

    public void removeSpaceObject(SpaceObject o) {
        String key = o.toString();
        if (!this.lookupMap.containsKey(key)) {
            return;
        }
        this.theTreeModel.removeNodeFromParent((DefaultMutableTreeNode)this.lookupTreeNodeMap.get(key));
        this.cardPanel.remove((JPanel)this.lookupMap.get(key));
        this.lookupTreeNodeMap.remove(key);
        this.lookupMap.remove(key);
    }

    private DefaultMutableTreeNode findPlayerNode(Player p) {
        if (p == null) {
            return null;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.theTree.getModel().getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof DefaultMutableTreeNode) || (node = (DefaultMutableTreeNode)o).getUserObject() != p) continue;
            return node;
        }
        return null;
    }

    private void createPopupMenu() {
        this.treePopupMenu = new JPopupMenu();
        JMenu movement = new JMenu("Movement Plots");
        JMenu weapons = new JMenu("Weapon Arcs");
        this.treePopupMenu.add(movement);
        JMenuItem item = new JMenuItem("Plot Envelope");
        item.addActionListener(new StarMapOption(this.theTree, 4, true));
        movement.add(item);
        item = new JMenuItem("Ghost Plot");
        item.addActionListener(new StarMapOption(this.theTree, 5, true));
        movement.add(item);
        item = new JMenuItem("Ghost Trail");
        item.addActionListener(new StarMapOption(this.theTree, 8, true));
        movement.add(item);
        this.treePopupMenu.add(weapons);
        item = new JMenuItem("Beam");
        item.addActionListener(new StarMapOption(this.theTree, 1, true));
        weapons.add(item);
        item = new JMenuItem("Pulse Torpedo");
        item.addActionListener(new StarMapOption(this.theTree, 2, true));
        weapons.add(item);
        item = new JMenuItem("Salvo Missiles");
        item.addActionListener(new StarMapOption(this.theTree, 10, true));
        weapons.add(item);
        item = new JMenuItem("Submunition Pack");
        item.addActionListener(new StarMapOption(this.theTree, 3, true));
        weapons.add(item);
        item = new JMenuItem("Point Defense");
        item.addActionListener(new StarMapOption(this.theTree, 13, true));
        weapons.add(item);
        weapons.addSeparator();
        item = new JMenuItem("Graser");
        item.addActionListener(new StarMapOption(this.theTree, 16, true));
        weapons.add(item);
        item = new JMenuItem("AntiMatter Torpedo");
        item.addActionListener(new StarMapOption(this.theTree, 17, true));
        weapons.add(item);
        weapons.addSeparator();
        item = new JMenuItem("Kinetic Gun");
        item.addActionListener(new StarMapOption(this.theTree, 9, true));
        weapons.add(item);
        item = new JMenuItem("Scatterguns");
        item.addActionListener(new StarMapOption(this.theTree, 14, true));
        weapons.add(item);
        weapons.addSeparator();
        item = new JMenuItem("Plasma Bolts");
        item.addActionListener(new StarMapOption(this.theTree, 11, true));
        weapons.add(item);
        item = new JMenuItem("Pulser");
        item.addActionListener(new StarMapOption(this.theTree, 12, true));
        weapons.add(item);
        item = new JMenuItem("Lock Ons");
        item.addActionListener(new StarMapOption(this.theTree, 7, true));
        this.treePopupMenu.add(item);
        int sensorRules = this.engine.getOptions().getSensorRules();
        if (sensorRules == 2 || sensorRules == 3) {
            item = new JMenuItem("Sensors");
            item.addActionListener(new StarMapOption(this.theTree, 15, true));
            this.treePopupMenu.add(item);
        }
        item = new JMenuItem("Clear Arcs");
        item.addActionListener(new StarMapOption(this.theTree, -1, true));
        this.treePopupMenu.add(item);
        item = new JMenuItem("Clear");
        item.addActionListener(new StarMapOption(this.theTree, 6, true));
        this.treePopupMenu.add(item);
        item = new JMenuItem("Remove if Dead");
        item.addActionListener(new ClientUIOption(null, 101));
        this.treePopupMenu.add(item);
        this.theTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MutableTreeNode parent;
                    FighterGroup fg;
                    SpaceObjectGUIAdapter soga;
                    SpaceObject so;
                    ShipGUIAdapter s;
                    TreePath thePath = Client.this.theTree.getSelectionPath();
                    if (thePath == null) {
                        return;
                    }
                    Object o = thePath.getLastPathComponent();
                    if (!(o instanceof DefaultMutableTreeNode)) {
                        return;
                    }
                    DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)o;
                    if ((o = aNode.getUserObject()) instanceof ShipGUIAdapter && ((s = (ShipGUIAdapter)o).getShip().isDestroyed() || s.getShip().hasJumped())) {
                        s.setRemoved();
                        MutableTreeNode parent2 = (MutableTreeNode)aNode.getParent();
                        if (parent2 != null) {
                            Client.this.theTreeModel.removeNodeFromParent(aNode);
                        }
                    }
                    if (o instanceof SpaceObjectGUIAdapter && (so = (soga = (SpaceObjectGUIAdapter)o).getSpaceObject()) instanceof FighterGroup && (fg = (FighterGroup)so).getCount() == 0 && (parent = (MutableTreeNode)aNode.getParent()) != null) {
                        Client.this.theTreeModel.removeNodeFromParent(aNode);
                    }
                } else if (SwingUtilities.isRightMouseButton(me)) {
                    Client.this.treePopupMenu.show(Client.this.treePanel, me.getX(), me.getY());
                }
            }
        });
    }

    class closeListener
    extends WindowAdapter {
        closeListener() {
        }

        public void windowClosing(WindowEvent e) {
            boolean close = true;
            if (!Client.this.SavedOrders && !Client.this.isGameMaster) {
                int choice = JOptionPane.showConfirmDialog(Client.this.mySelf, "Orders have not been saved or queued, close anyway?", "Exit without saving", 0);
                boolean bl = close = choice == 0;
            }
            if (close) {
                Client.this.map.cleanUp();
                Client.this.map.dispose();
                Client.this.dispose();
            }
        }
    }

    class ClientUIOption
    implements ActionListener {
        ArrayList ships;
        int option;

        ClientUIOption(ArrayList inShips, int inOption) {
            this.ships = inShips;
            this.option = inOption;
        }

        public void actionPerformed(ActionEvent e) {
            Object o;
            int i;
            ArrayList localAdapters = new ArrayList();
            if (this.ships == null) {
                TreePath[] thePaths = Client.this.theTree.getSelectionPaths();
                if (thePaths.length == 0) {
                    return;
                }
                for (i = 0; i < thePaths.length; ++i) {
                    o = thePaths[i].getLastPathComponent();
                    if (!(o instanceof DefaultMutableTreeNode)) continue;
                    DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)o;
                    if ((o = aNode.getUserObject()) instanceof ShipGUIAdapter) {
                        localAdapters.add((ShipGUIAdapter)o);
                    }
                    if (!(o instanceof SpaceObjectGUIAdapter)) continue;
                    localAdapters.add((SpaceObjectGUIAdapter)o);
                }
            } else {
                localAdapters = this.ships;
            }
            TreePath[] expandedPaths = this.getExpandedPaths(Client.this.theTree);
            this.expandAll(Client.this.theTree, Client.this.theTree.getPathForRow(0));
            for (i = 0; i < localAdapters.size(); ++i) {
                DefaultMutableTreeNode aNode;
                MutableTreeNode parent;
                TreePath aPath;
                SpaceObjectGUIAdapter soga;
                SpaceObject so;
                o = localAdapters.get(i);
                if (o instanceof ShipGUIAdapter) {
                    DefaultMutableTreeNode aNode2;
                    MutableTreeNode parent2;
                    ShipGUIAdapter s = (ShipGUIAdapter)localAdapters.get(i);
                    if (this.option != 101 || !s.getShip().isDestroyed() && !s.getShip().hasJumped()) continue;
                    s.setRemoved();
                    TreePath aPath2 = Client.this.theTree.getNextMatch(s.toString(), 0, Position.Bias.Forward);
                    if (aPath2 == null || (parent2 = (MutableTreeNode)(aNode2 = (DefaultMutableTreeNode)aPath2.getLastPathComponent()).getParent()) == null) continue;
                    Client.this.theTreeModel.removeNodeFromParent(aNode2);
                    continue;
                }
                if (!(o instanceof SpaceObjectGUIAdapter) || !((so = (soga = (SpaceObjectGUIAdapter)o).getSpaceObject()) instanceof FighterGroup)) continue;
                FighterGroup fg = (FighterGroup)so;
                if (this.option != 101 || fg.getCount() != 0 || (aPath = Client.this.theTree.getNextMatch(soga.toString(), 0, Position.Bias.Forward)) == null || (parent = (MutableTreeNode)(aNode = (DefaultMutableTreeNode)aPath.getLastPathComponent()).getParent()) == null) continue;
                Client.this.theTreeModel.removeNodeFromParent(aNode);
            }
            this.collapseAll(Client.this.theTree);
            this.setExpandedPaths(Client.this.theTree, expandedPaths);
            Client.this.repaint();
            Client.this.map.repaint();
        }

        public void expandAll(JTree tree, TreePath path) {
            Object node = path.getLastPathComponent();
            TreeModel model = tree.getModel();
            if (model.isLeaf(node)) {
                return;
            }
            tree.expandPath(path);
            int num = model.getChildCount(node);
            for (int i = 0; i < num; ++i) {
                this.expandAll(tree, path.pathByAddingChild(model.getChild(node, i)));
            }
        }

        public void collapseAll(JTree tree) {
            TreePath pathToRoot = new TreePath(tree.getModel().getRoot());
            this.collapseAll(tree, pathToRoot);
            if (!tree.isRootVisible()) {
                tree.expandPath(pathToRoot);
            }
        }

        public void collapseAll(JTree tree, TreePath path) {
            Object node = path.getLastPathComponent();
            TreeModel model = tree.getModel();
            if (model.isLeaf(node)) {
                return;
            }
            int num = model.getChildCount(node);
            for (int i = 0; i < num; ++i) {
                this.collapseAll(tree, path.pathByAddingChild(model.getChild(node, i)));
            }
            tree.collapsePath(path);
        }

        public TreePath[] getExpandedPaths(JTree tree) {
            ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
            TreePath rootPath = new TreePath(tree.getModel().getRoot());
            Enumeration<TreePath> theEnum = tree.getExpandedDescendants(rootPath);
            if (theEnum != null) {
                while (theEnum.hasMoreElements()) {
                    expandedPaths.add(theEnum.nextElement());
                }
            }
            TreePath[] array = new TreePath[expandedPaths.size()];
            expandedPaths.toArray(array);
            return array;
        }

        public void setExpandedPaths(JTree tree, TreePath[] expandedPaths) {
            if (expandedPaths == null) {
                return;
            }
            for (int i = 0; i < expandedPaths.length; ++i) {
                TreePath oldPath = expandedPaths[i];
                TreePath newPath = this.searchPath(tree.getModel(), oldPath);
                if (newPath == null) continue;
                tree.expandPath(newPath);
            }
        }

        public TreePath searchPath(TreeModel model, TreePath oldPath) {
            Object treenode = model.getRoot();
            Object[] oldPathNodes = oldPath.getPath();
            TreePath newPath = new TreePath(treenode);
            for (int i = 0; i < oldPathNodes.length; ++i) {
                Object oldPathNode = oldPathNodes[i];
                if (!treenode.toString().equals(oldPathNode.toString())) continue;
                if (i == oldPathNodes.length - 1) {
                    return newPath;
                }
                if (model.isLeaf(treenode)) {
                    return null;
                }
                int count = model.getChildCount(treenode);
                boolean foundChild = false;
                for (int j = 0; j < count; ++j) {
                    Object child = model.getChild(treenode, j);
                    if (!child.toString().equals(oldPathNodes[i + 1].toString())) continue;
                    newPath = newPath.pathByAddingChild(child);
                    treenode = child;
                    foundChild = true;
                    break;
                }
                if (foundChild) continue;
                return null;
            }
            return null;
        }
    }

    class StarMapOption
    implements ActionListener {
        ArrayList ships;
        int option;
        JTree myTree;

        StarMapOption(ArrayList inShips, int inOption) {
            this.ships = inShips;
            this.option = inOption;
            this.myTree = null;
        }

        StarMapOption(JTree aTree, int inOption, boolean test) {
            this.myTree = aTree;
            this.ships = null;
            this.option = inOption;
        }

        public void actionPerformed(ActionEvent e) {
            JTextField pe;
            GUIAdapter guiA = null;
            ShipStatusDisplay ssd = null;
            ArrayList localShips = new ArrayList();
            DefaultMutableTreeNode node = null;
            Object nodeInfo = null;
            node = (DefaultMutableTreeNode)Client.this.theTree.getLastSelectedPathComponent();
            if (node == null && Client.this.starMapLastValidAdapter == null) {
                return;
            }
            guiA = Client.this.starMapLastValidAdapter;
            if (node != null && (guiA = (nodeInfo = node.getUserObject()) == null || !(nodeInfo instanceof GUIAdapter) ? Client.this.starMapLastValidAdapter : (GUIAdapter)nodeInfo) instanceof SpaceObjectGUIAdapter && this.ships == null) {
                return;
            }
            if (guiA instanceof ShipGUIAdapter && (pe = (ssd = (ShipStatusDisplay)Client.this.lookupMap.get(guiA.toString())).getPlotEntry()) != null && pe.hasFocus() && Client.this.enableAccelerator) {
                return;
            }
            if (this.myTree != null) {
                TreePath[] thePaths = this.myTree.getSelectionPaths();
                if (thePaths.length == 0) {
                    return;
                }
                for (int i = 0; i < thePaths.length; ++i) {
                    DefaultMutableTreeNode aNode;
                    Object o = thePaths[i].getLastPathComponent();
                    if (!(o instanceof DefaultMutableTreeNode) || !((o = (aNode = (DefaultMutableTreeNode)o).getUserObject()) instanceof ShipGUIAdapter)) continue;
                    localShips.add((ShipGUIAdapter)o);
                }
            } else if (this.ships == null) {
                localShips.add(guiA);
                Client.this.starMapLastValidAdapter = guiA;
            } else {
                localShips = this.ships;
            }
            for (int i = 0; i < localShips.size(); ++i) {
                ShipGUIAdapter s = (ShipGUIAdapter)localShips.get(i);
                if (this.option == 6) {
                    s.clearDisplay();
                }
                if (this.option == 4) {
                    s.setShowPlotEnvelope(!s.getShowPlotEnvelope());
                }
                if (this.option == 5) {
                    s.setShowGhostPlot(!s.getShowGhostPlot());
                }
                if (this.option == 8) {
                    s.setShowGhostTrail(!s.getShowGhostTrail());
                }
                if (this.option == 7) {
                    s.setShowLockOns(!s.getShowLockOns());
                }
                if (this.option != -1 && this.option != 0 && this.option != 15 && this.option != 1 && this.option != 3 && this.option != 2 && this.option != 10 && this.option != 11 && this.option != 12 && this.option != 13 && this.option != 14 && this.option != 16 && this.option != 17 && this.option != 9) continue;
                s.setShowArcOption(this.option);
            }
            Client.this.map.repaint();
        }
    }

    class SaveAsImageAction
    implements ActionListener {
        private JFrame theClient;

        public SaveAsImageAction(JFrame parent) {
            this.theClient = parent;
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog chooser = new FileDialog(this.theClient);
            chooser.setMode(1);
            chooser.setTitle("Save PNG Image");
            chooser.setVisible(true);
            String resultPath = chooser.getDirectory();
            String resultFile = chooser.getFile();
            if (resultPath == null || resultPath.length() == 0 || resultFile == null || resultFile.length() == 0) {
                return;
            }
            String fileName = new String(resultPath + resultFile);
            RenderStarmap.execute(Client.this.client, Client.this.engine, fileName);
        }
    }

    class CombatOrdersAction
    implements ActionListener {
        CombatOrdersAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Client.this.combatPhase();
            if (Client.this.isGameMaster) {
                JOptionPane.showMessageDialog(Client.this.mySelf, "No active player!");
            } else {
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(Client.this.mySelf, "Combat Orders saved.");
                }
            }
        }
    }

    class WriteCombatOrdersAction
    implements ActionListener {
        WriteCombatOrdersAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Client.this.writeCombatPhase();
            if (Client.this.isGameMaster) {
                JOptionPane.showMessageDialog(Client.this.mySelf, "No active player!");
            } else {
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(Client.this.mySelf, "Combat Orders saved.");
                }
            }
        }
    }

    class SummaryCombatOrdersAction
    implements ActionListener {
        SummaryCombatOrdersAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TargetingSummaryDialog tsd = new TargetingSummaryDialog(Client.this.engine, Client.this.engine.getActivePlayer());
            tsd.setVisible(true);
        }
    }

    class MovementOrdersAction
    implements ActionListener {
        MovementOrdersAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Client.this.movePhase();
            if (Client.this.isGameMaster) {
                JOptionPane.showMessageDialog(Client.this.mySelf, "No active player!");
            } else {
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(Client.this.mySelf, "Movement Orders queued.");
                }
            }
        }
    }

    class WriteMovementOrdersAction
    implements ActionListener {
        WriteMovementOrdersAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Client.this.writeMovePhase();
            if (Client.this.isGameMaster) {
                JOptionPane.showMessageDialog(Client.this.mySelf, "No active player!");
            } else {
                String prop = "Confirmation Popups";
                if (Preferences.getPreferences().getProperty(prop).equals("true")) {
                    JOptionPane.showMessageDialog(Client.this.mySelf, "Movement Orders saved.");
                }
            }
        }
    }

    class LoadOrdersAction
    implements ActionListener {
        LoadOrdersAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            File theFile = null;
            if (Client.this.chooser == null) {
                Client.this.chooser = new FileDialog(Client.this.mySelf);
                Client.this.chooser.setMode(0);
                Client.this.chooser.setTitle("Orders");
                Client.this.chooser.setDirectory(Preferences.getPreferences().getProperty("Outgoing Games Directory"));
            }
            Client.this.chooser.setVisible(true);
            String resultPath = Client.this.chooser.getDirectory();
            String resultFile = Client.this.chooser.getFile();
            if (resultPath != null && resultPath.length() != 0 && resultFile != null && resultFile.length() != 0) {
                theFile = new File(resultPath + resultFile);
            }
            if (theFile != null) {
                ImportOrders io = new ImportOrders();
                try {
                    io.readOrders(Client.this.engine, theFile);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                    return;
                }
            }
        }
    }
}

