/*
 * Decompiled with CFR 0.152.
 */
package ftjava.ai;

import java.util.ArrayList;

public class CinematicUtilities {
    private CinematicUtilities() {
    }

    public static ArrayList getAvailableOrders(int thrust, boolean advancedDrives) {
        ArrayList result = new ArrayList();
        switch (thrust) {
            case 0: {
                return CinematicUtilities.getAvailableOrdersThrustZero(result);
            }
            case 1: {
                return CinematicUtilities.getAvailableOrdersThrustOne(result);
            }
            case 2: {
                return CinematicUtilities.getAvailableOrdersThrustTwo(result, advancedDrives);
            }
            case 3: {
                return CinematicUtilities.getAvailableOrdersThrustThree(result, advancedDrives);
            }
            case 4: {
                return CinematicUtilities.getAvailableOrdersThrustFour(result, advancedDrives);
            }
            case 5: {
                return CinematicUtilities.getAvailableOrdersThrustFive(result, advancedDrives);
            }
            case 6: {
                return CinematicUtilities.getAvailableOrdersThrustSix(result, advancedDrives);
            }
            case 7: {
                return CinematicUtilities.getAvailableOrdersThrustSix(result, advancedDrives);
            }
            case 8: {
                return CinematicUtilities.getAvailableOrdersThrustSix(result, advancedDrives);
            }
        }
        return CinematicUtilities.getAvailableOrdersThrustZero(result);
    }

    private static ArrayList getAvailableOrdersThrustZero(ArrayList result) {
        result.add("0");
        return result;
    }

    private static ArrayList getAvailableOrdersThrustOne(ArrayList result) {
        result.add("1");
        result.add("-1");
        result.add("P1");
        result.add("S1");
        return CinematicUtilities.getAvailableOrdersThrustZero(result);
    }

    private static ArrayList getAvailableOrdersThrustTwo(ArrayList result, boolean advancedDrives) {
        result.add("2");
        result.add("-2");
        result.add("P1-1");
        result.add("P1+1");
        result.add("S1-1");
        result.add("S1+1");
        if (advancedDrives) {
            result.add("P2");
            result.add("S2");
            result.add("Z1");
            result.add("C1");
        }
        return CinematicUtilities.getAvailableOrdersThrustOne(result);
    }

    private static ArrayList getAvailableOrdersThrustThree(ArrayList result, boolean advancedDrives) {
        result.add("3");
        result.add("-3");
        result.add("P1-2");
        result.add("P1+2");
        result.add("S1-2");
        result.add("S1+2");
        if (advancedDrives) {
            result.add("P3");
            result.add("S3");
            result.add("P2+1");
            result.add("S2+1");
            result.add("P2-1");
            result.add("S2-1");
            result.add("Z1+1");
            result.add("C1+1");
            result.add("Z1-1");
            result.add("C1-1");
        }
        return CinematicUtilities.getAvailableOrdersThrustTwo(result, advancedDrives);
    }

    private static ArrayList getAvailableOrdersThrustFour(ArrayList result, boolean advancedDrives) {
        result.add("4");
        result.add("-4");
        result.add("P2");
        result.add("S2");
        result.add("P2-1");
        result.add("P2+1");
        result.add("S2-1");
        result.add("S2+1");
        result.add("P2-2");
        result.add("P2+2");
        result.add("S2-2");
        result.add("S2+2");
        result.add("P1-3");
        result.add("P1+3");
        result.add("S1-3");
        result.add("S1+3");
        result.add("Z1+2");
        result.add("Z1+1");
        result.add("Z1-1");
        result.add("Z1-2");
        result.add("C1+2");
        result.add("C1+1");
        result.add("C1-1");
        result.add("C1-2");
        if (advancedDrives) {
            result.add("P4");
            result.add("S4");
            result.add("P3+1");
            result.add("S3+1");
            result.add("P3-1");
            result.add("S3-1");
            result.add("P3+1");
            result.add("S3+1");
            result.add("P3-1");
            result.add("S3-1");
            result.add("Z2");
            result.add("C2");
        }
        return CinematicUtilities.getAvailableOrdersThrustThree(result, advancedDrives);
    }

    private static ArrayList getAvailableOrdersThrustFive(ArrayList result, boolean advancedDrives) {
        result.add("5");
        result.add("-5");
        result.add("P2-3");
        result.add("P2+3");
        result.add("S2-3");
        result.add("S2+3");
        result.add("P1-4");
        result.add("P1+4");
        result.add("S1-4");
        result.add("S1+4");
        result.add("Z1+3");
        result.add("Z1-3");
        result.add("C1+3");
        result.add("C1-3");
        if (advancedDrives) {
            result.add("P5");
            result.add("S5");
        }
        return CinematicUtilities.getAvailableOrdersThrustFour(result, advancedDrives);
    }

    private static ArrayList getAvailableOrdersThrustSix(ArrayList result, boolean advancedDrives) {
        result.add("6");
        result.add("-6");
        result.add("P3");
        result.add("S3");
        result.add("P2-4");
        result.add("P2+4");
        result.add("S2-4");
        result.add("S2+4");
        result.add("P1-5");
        result.add("P1+5");
        result.add("S1-5");
        result.add("S1+5");
        result.add("Z1+4");
        result.add("Z1-4");
        result.add("C1+4");
        result.add("C1-4");
        if (advancedDrives) {
            result.add("P6");
            result.add("S6");
        }
        return CinematicUtilities.getAvailableOrdersThrustFive(result, advancedDrives);
    }
}

