/*
 * Decompiled with CFR 0.152.
 */
package ftjava.ai;

import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import java.util.ArrayList;

public class AIUtilities {
    private AIUtilities() {
    }

    public static Ship chooseATarget(Ship s, ArrayList allShips, ArrayList heavenlyBodies) {
        Ship bestCandidate = null;
        double bestRange = 1000.0;
        for (int i = 0; i < allShips.size(); ++i) {
            double range;
            Ship candidate = (Ship)allShips.get(i);
            if (candidate.isDestroyed() || candidate.hasJumped() || !candidate.hasArrived() || !s.isEnemy(candidate)) continue;
            boolean blockedLOS = false;
            for (int j = 0; j < heavenlyBodies.size(); ++j) {
                SpaceObject so = (SpaceObject)heavenlyBodies.get(j);
                if (!so.intersect(s, candidate)) continue;
                blockedLOS = true;
            }
            if (blockedLOS || !((range = s.rangeTo(candidate)) < bestRange)) continue;
            bestRange = range;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }
}

