/*
 * Decompiled with CFR 0.152.
 */
package ftjava.ai;

import ftjava.ai.Bot;
import ftjava.ai.BotAlpha;
import ftjava.ai.BotBeta;
import ftjava.ai.BotDelta;
import ftjava.ai.BotEpsilon;
import ftjava.ai.BotGamma;
import ftjava.ai.BotSigma;
import ftjava.ai.BotTarget;
import ftjava.std.GameEngine;
import ftjava.std.Player;
import java.util.ArrayList;

public class AIDelegator {
    private GameEngine theGame = null;
    private int numberOfAIPlayers;
    private ArrayList aiPlayers = new ArrayList();
    private ArrayList botBrains = new ArrayList();
    private String BOT = "Bot";

    private AIDelegator() {
    }

    public AIDelegator(GameEngine game) {
        this();
        this.theGame = game;
        if (game != null) {
            this.evaluateAIPlayers();
        }
    }

    public GameEngine getGameEngine() {
        return this.theGame;
    }

    private void evaluateAIPlayers() {
        ArrayList allPlayers = this.theGame.getPlayers();
        for (int i = 0; i < allPlayers.size(); ++i) {
            Player p = (Player)allPlayers.get(i);
            if (!p.getName().startsWith(this.BOT)) continue;
            ++this.numberOfAIPlayers;
            this.aiPlayers.add(p);
            Bot newBot = null;
            if (p.getName().indexOf("Alpha") != -1) {
                newBot = new BotAlpha(p);
            }
            if (p.getName().indexOf("Beta") != -1) {
                newBot = new BotBeta(p);
            }
            if (p.getName().indexOf("Gamma") != -1) {
                newBot = new BotGamma(p);
            }
            if (p.getName().indexOf("Delta") != -1) {
                newBot = new BotDelta(p);
            }
            if (p.getName().indexOf("Epsilon") != -1) {
                newBot = new BotEpsilon(p);
            }
            if (p.getName().indexOf("Sigma") != -1) {
                newBot = new BotSigma(p);
            }
            if (newBot == null) {
                newBot = new BotTarget(p);
            }
            newBot.setGameEngine(this.theGame);
            this.botBrains.add(newBot);
        }
    }

    public void movementPhase() {
        for (int i = 0; i < this.botBrains.size(); ++i) {
            Bot aBot = (Bot)this.botBrains.get(i);
            aBot.evaluateMovementOrders();
        }
    }

    public void combatPhase() {
        for (int i = 0; i < this.botBrains.size(); ++i) {
            Bot aBot = (Bot)this.botBrains.get(i);
            aBot.evaluateCombatOrders();
        }
    }
}

