/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.gui.FrostSwingWorker;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableHeader;

public class SortedModelTable
extends ModelTable {
    private int currentSortedColumnNumber = -1;
    private boolean ascending;

    public SortedModelTable(SortedModel newModel) {
        super(newModel.getTableFormat());
        newModel.setTable(this);
        this.setModel(newModel);
        this.initialize();
        this.getTable().setTableHeader(new SortedTableHeader(this));
    }

    void columnClicked(int columnNumber) {
        if (columnNumber != this.currentSortedColumnNumber) {
            this.currentSortedColumnNumber = columnNumber;
            this.ascending = true;
        } else {
            this.ascending = !this.ascending;
        }
        this.resortTable();
    }

    public void setSortedColumn(int col, boolean asc) {
        this.currentSortedColumnNumber = col;
        this.ascending = asc;
        this.resortTable();
    }

    public void resortTable() {
        FrostSwingWorker worker = new FrostSwingWorker(this.table){

            protected void doNonUILogic() throws RuntimeException {
                int index = SortedModelTable.this.convertColumnIndexToFormat(SortedModelTable.this.currentSortedColumnNumber);
                SortedModelTable.this.model.sort(index, SortedModelTable.this.ascending);
            }

            protected void doUIUpdateLogic() throws RuntimeException {
                SortedModelTable.this.table.revalidate();
                SortedModelTable.this.table.repaint();
            }
        };
        worker.start();
    }

    public void refreshView() {
        this.table.revalidate();
        this.table.repaint();
    }

    public int getSortedColumn() {
        return this.currentSortedColumnNumber;
    }

    public boolean isSortedAscending() {
        return this.ascending;
    }

    public ModelItem getItemAt(int rowIndex) {
        return this.model.getItemAt(rowIndex);
    }

    public void setColumnVisible(int index, boolean visible) {
        super.setColumnVisible(index, visible);
        if (!visible) {
            if (index == this.currentSortedColumnNumber) {
                this.currentSortedColumnNumber = -1;
            } else if (index < this.currentSortedColumnNumber) {
                --this.currentSortedColumnNumber;
            }
        }
    }
}

