/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.ModelItem;
import frost.util.model.ModelTableFormat;
import frost.util.model.SortedModel;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ModelTable
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(ModelTable.class.getName());
    protected ModelTableFormat tableFormat;
    protected SortedModel model;
    protected JTable table;
    private JScrollPane scrollPane;
    private final ArrayList<Integer> visibleColumns = new ArrayList();
    private final ArrayList<TableColumn> columns = new ArrayList();

    protected ModelTable(ModelTableFormat newTableFormat) {
        this.tableFormat = newTableFormat;
    }

    protected ModelTable(SortedModel newModel, ModelTableFormat newTableFormat) {
        this.model = newModel;
        this.tableFormat = newTableFormat;
        this.initialize();
    }

    protected void initialize() {
        int columnCount = this.tableFormat.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.visibleColumns.add(new Integer(i));
        }
        this.table = new JTable(this);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setWheelScrollingEnabled(true);
        this.tableFormat.addTable(this.table);
        this.tableFormat.customizeTable(this);
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            this.columns.add(columnModel.getColumn(i));
        }
    }

    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    public int getRowCount() {
        return this.model.getItemCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int index = this.convertColumnIndexToFormat(columnIndex);
        ModelItem mi = this.model.getItemAt(rowIndex);
        if (mi == null) {
            return "ModelTable.getValueAt(): index " + rowIndex + " is null";
        }
        return this.tableFormat.getCellValue(mi, index);
    }

    protected void fireTableRowsDeleted(int[] positions) {
        for (int position : positions) {
            this.fireTableRowsDeleted(position, position);
        }
    }

    public ModelItem[] getSelectedItems() {
        return new SelectionGetter().getSelectedItems();
    }

    public ModelItem getSelectedItem() {
        return new SelectionGetter().getSelectedItem();
    }

    public int getSelectedCount() {
        return this.table.getSelectedRowCount();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public String getColumnName(int column) {
        int index = this.convertColumnIndexToFormat(column);
        return this.tableFormat.getColumnName(index);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setFont(Font font) {
        this.table.setFont(font);
        this.table.setRowHeight(font.getSize() + 5);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int index = this.convertColumnIndexToFormat(columnIndex);
        return this.tableFormat.isColumnEditable(index);
    }

    public boolean isColumnVisible(int columnIndex) {
        int position = this.convertColumnIndexToModel(columnIndex);
        return position != -1;
    }

    public void setColumnVisible(int index, boolean visible) {
        TableColumnModel columnModel = this.getTable().getColumnModel();
        int position = this.convertColumnIndexToModel(index);
        if (visible) {
            if (position == -1) {
                this.visibleColumns.add(new Integer(index));
                TableColumn column = this.columns.get(index);
                column.setModelIndex(this.visibleColumns.size() - 1);
                columnModel.addColumn(column);
            }
        } else if (position != -1) {
            this.visibleColumns.remove(new Integer(index));
            columnModel.removeColumn(this.columns.get(index));
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                int modelIndex = column.getModelIndex();
                if (modelIndex < position) continue;
                column.setModelIndex(modelIndex - 1);
            }
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int index = this.convertColumnIndexToFormat(columnIndex);
        this.tableFormat.setCellValue(aValue, this.model.getItemAt(rowIndex), index);
    }

    protected void setModel(SortedModel newModel) {
        this.model = newModel;
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    public List getColumnsList() {
        return this.columns;
    }

    protected int convertColumnIndexToModel(int formatColumnIndex) {
        return this.visibleColumns.indexOf(new Integer(formatColumnIndex));
    }

    protected int convertColumnIndexToFormat(int modelColumnIndex) {
        Integer index = this.visibleColumns.get(modelColumnIndex);
        return index;
    }

    public ModelTableFormat getTableFormat() {
        return this.tableFormat;
    }

    protected class SelectionGetter
    implements Runnable {
        private final int MODE_SINGLE = 0;
        private final int MODE_MULTIPLE = 1;
        int mode = 0;
        ModelItem[] selectedItems;
        ModelItem selectedItem;

        protected SelectionGetter() {
        }

        public ModelItem[] getSelectedItems() {
            this.mode = 1;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", e);
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", e);
                }
            }
            return this.selectedItems;
        }

        public ModelItem getSelectedItem() {
            this.mode = 0;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", e);
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", e);
                }
            }
            return this.selectedItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SortedModel sortedModel = ModelTable.this.model;
            synchronized (sortedModel) {
                switch (this.mode) {
                    case 1: {
                        int selectionCount = ModelTable.this.table.getSelectedRowCount();
                        this.selectedItems = new ModelItem[selectionCount];
                        int[] selectedRows = ModelTable.this.table.getSelectedRows();
                        for (int i = 0; i < selectedRows.length; ++i) {
                            this.selectedItems[i] = ModelTable.this.model.getItemAt(selectedRows[i]);
                        }
                        break;
                    }
                    case 0: {
                        int selectedRow = ModelTable.this.table.getSelectedRow();
                        if (selectedRow == -1) break;
                        this.selectedItem = ModelTable.this.model.getItemAt(selectedRow);
                    }
                }
            }
        }
    }
}

