/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.tristatecheckbox;

import frost.util.gui.tristatecheckbox.TristateCheckBox;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TristateCheckBoxTest {
    public static void main(String[] args) throws Exception {
        UIManager.LookAndFeelInfo[] lfs;
        JFrame frame = new JFrame("TristateCheckBoxTest");
        frame.setLayout(new GridLayout(0, 1, 15, 15));
        for (UIManager.LookAndFeelInfo lf : lfs = UIManager.getInstalledLookAndFeels()) {
            System.out.println("Look&Feel " + lf.getName());
            UIManager.setLookAndFeel(lf.getClassName());
            frame.add(TristateCheckBoxTest.makePanel(lf));
        }
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private static JPanel makePanel(UIManager.LookAndFeelInfo lf) {
        final TristateCheckBox tristateBox = new TristateCheckBox("Tristate checkbox");
        tristateBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                switch (tristateBox.getState()) {
                    case SELECTED: {
                        System.out.println("Selected");
                        break;
                    }
                    case DESELECTED: {
                        System.out.println("Not Selected");
                        break;
                    }
                    case INDETERMINATE: {
                        System.out.println("Tristate Selected");
                    }
                }
            }
        });
        tristateBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
            }
        });
        final JCheckBox normalBox = new JCheckBox("Normal checkbox");
        normalBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
            }
        });
        final JCheckBox enabledBox = new JCheckBox("Enable", true);
        enabledBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                tristateBox.setEnabled(enabledBox.isSelected());
                normalBox.setEnabled(enabledBox.isSelected());
            }
        });
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        panel.add(new JLabel(UIManager.getLookAndFeel().getName()));
        panel.add(tristateBox);
        panel.add(normalBox);
        panel.add(enabledBox);
        return panel;
    }
}

