/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.Core;
import frost.boards.Board;
import frost.fcp.FcpHandler;
import frost.fcp.fcp05.FecSplitfile;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.gui.Splashscreen;
import frost.messages.FrostMessageObject;
import frost.storage.MessageArchivingCallback;
import frost.storage.perst.IndexSlotsStorage;
import frost.storage.perst.SharedFilesCHKKeyStorage;
import frost.storage.perst.filelist.FileListStorage;
import frost.storage.perst.messagearchive.ArchiveMessageStorage;
import frost.storage.perst.messages.MessageStorage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUp {
    private static final Logger logger = Logger.getLogger(CleanUp.class.getName());
    public static final int DELETE_MESSAGES = 1;
    public static final int ARCHIVE_MESSAGES = 2;
    public static final int KEEP_MESSAGES = 3;
    private static final int MINIMUM_DAYS_OLD = 28;
    private static final int SFCHKKEYS_MINIMUM_DAYS_OLD = 16;
    private static Splashscreen splashScreen;

    public static void runExpirationTasks(Splashscreen sp, List<Board> boardList) {
        long intervalMillis;
        long now;
        splashScreen = sp;
        CleanUp.cleanPerstStorages(boardList);
        if (Core.frostSettings.getBoolValue("removeOldUploadFileChunks") && FcpHandler.isFreenet05()) {
            splashScreen.setText("Removing old upload chunks");
            CleanUp.cleanup05UploadChunks();
        }
        int cleanupDatabaseInterval = Core.frostSettings.getIntValue("database.cleanup.interval");
        long lastCleanupTime = Core.frostSettings.getLongValue("database.cleanup.lastRun");
        if (lastCleanupTime < (now = System.currentTimeMillis()) - (intervalMillis = (long)cleanupDatabaseInterval * 24L * 60L * 60L * 1000L)) {
            CleanUp.cleanStorages(boardList);
            Core.frostSettings.setValue("database.cleanup.lastRun", now);
        }
    }

    private static void cleanPerstStorages(List<Board> boardList) {
        splashScreen.setText("Cleaning index tables");
        CleanUp.cleanupIndexSlotsStorage(boardList);
        splashScreen.setText("Cleaning CHK filelist tables");
        CleanUp.cleanupSharedCHKKeyStorage();
    }

    private static void cleanStorages(List<Board> boardList) {
        String strMode = Core.frostSettings.getValue("messageExpirationMode");
        int mode = strMode.toUpperCase().equals("KEEP") ? 3 : (strMode.toUpperCase().equals("ARCHIVE") ? 2 : (strMode.toUpperCase().equals("DELETE") ? 1 : 3));
        CleanUp.processExpiredMessages(boardList, mode);
        splashScreen.setText("Cleaning file list owners");
        CleanUp.cleanupFileListFileOwners();
        splashScreen.setText("Cleaning file list files");
        CleanUp.cleanupFileListFiles();
    }

    private static void processExpiredMessages(List<Board> boardList, int mode) {
        if (mode == 2) {
            logger.info("Expiration mode is ARCHIVE_MESSAGES.");
        } else if (mode == 1) {
            logger.info("Expiration mode is DELETE_MESSAGES.");
        } else if (mode == 3) {
            logger.info("Expiration mode is KEEP_MESSAGES.");
        } else {
            logger.severe("ERROR: invalid MODE specified: " + mode);
            return;
        }
        if (mode == 3) {
            return;
        }
        int defaultDaysOld = Core.frostSettings.getIntValue("messageExpireDays") + 1;
        if (defaultDaysOld < Core.frostSettings.getIntValue("maxMessageDisplay")) {
            defaultDaysOld = Core.frostSettings.getIntValue("maxMessageDisplay") + 1;
        }
        if (defaultDaysOld < Core.frostSettings.getIntValue("maxMessageDownload")) {
            defaultDaysOld = Core.frostSettings.getIntValue("maxMessageDownload") + 1;
        }
        for (Board board : boardList) {
            int currentDaysOld = defaultDaysOld;
            if (board.isConfigured()) {
                currentDaysOld = Math.max(board.getMaxMessageDisplay(), currentDaysOld);
                currentDaysOld = Math.max(board.getMaxMessageDownload(), currentDaysOld);
            }
            boolean archiveKeepUnread = Core.frostSettings.getBoolValue("archiveKeepUnreadMessages");
            boolean archiveKeepFlaggedAndStarred = Core.frostSettings.getBoolValue("archiveKeepFlaggedOrStarredMessages");
            splashScreen.setText("Archiving messages in board: " + board.getName());
            MessageTableCallback mtCallback = new MessageTableCallback(mode);
            try {
                MessageStorage.inst().retrieveMessagesForArchive(board, currentDaysOld, archiveKeepUnread, archiveKeepFlaggedAndStarred, mtCallback);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception during retrieveMessagesForArchive", t);
                continue;
            }
            if (mtCallback.getCount() > 0) {
                logger.warning("INFO: Processed " + mtCallback.getCount() + " expired messages for board " + board.getName());
            }
            MessageStorage.inst().commit();
            ArchiveMessageStorage.inst().commit();
        }
        MessageStorage.inst().commit();
        ArchiveMessageStorage.inst().commit();
        logger.info("Finished to process expired messages.");
    }

    private static void cleanupIndexSlotsStorage(List<Board> boardList) {
        int maxDaysOld = Core.frostSettings.getIntValue("maxMessageDownload") * 2;
        for (Board board : boardList) {
            if (!board.isConfigured()) continue;
            maxDaysOld = Math.max(board.getMaxMessageDownload(), maxDaysOld);
        }
        if (maxDaysOld < 28) {
            maxDaysOld = 28;
        }
        int deletedCount = 0;
        try {
            deletedCount += IndexSlotsStorage.inst().cleanup(maxDaysOld);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during cleanup of IndexSlots", t);
        }
        if (deletedCount > 0) {
            logger.warning("INFO: Finished to delete expired index slots, deleted " + deletedCount + " rows.");
        }
    }

    private static void cleanupSharedCHKKeyStorage() {
        int deletedCount = 0;
        try {
            deletedCount = SharedFilesCHKKeyStorage.inst().cleanupTable(16);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during cleanup of SharedFilesCHKKeys", t);
        }
        if (deletedCount > 0) {
            logger.warning("INFO: Finished to delete expired SharedFilesCHKKeys, deleted " + deletedCount + " rows.");
        }
    }

    private static void cleanupFileListFileOwners() {
        boolean removeOfflineFilesWithKey = Core.frostSettings.getBoolValue("database.cleanup.removeOfflineFilesWithKey");
        int offlineFilesMaxDaysOld = Core.frostSettings.getIntValue("database.cleanup.offlineFilesMaxDaysOld");
        int deletedCount = 0;
        try {
            deletedCount = FileListStorage.inst().cleanupFileListFileOwners(removeOfflineFilesWithKey, offlineFilesMaxDaysOld);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during cleanup of FileListFileOwners", t);
        }
        if (deletedCount > 0) {
            logger.warning("INFO: Finished to delete expired FileListFileOwners, deleted " + deletedCount + " rows.");
        }
    }

    private static void cleanupFileListFiles() {
        int deletedCount = 0;
        try {
            deletedCount = FileListStorage.inst().cleanupFileListFiles();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during cleanup of FileListFiles", t);
        }
        if (deletedCount > 0) {
            logger.warning("INFO: Finished to delete expired FileListFiles, deleted " + deletedCount + " rows.");
        }
    }

    private static void cleanup05UploadChunks() {
        File[] allUploadChunks;
        List ulItems = Core.getInstance().getFileTransferManager().getUploadManager().getModel().getItems();
        HashSet<String> ulItemFilePaths = new HashSet<String>();
        for (FrostUploadItem ulItem : ulItems) {
            File uploadFile = ulItem.getFile();
            String ulFilename = FecSplitfile.convertUploadFilename(uploadFile);
            File checkBlocksFile = new File(ulFilename + ".checkblocks");
            File redirectFile = new File(ulFilename + ".redirect");
            ulItemFilePaths.add(checkBlocksFile.getAbsolutePath());
            ulItemFilePaths.add(redirectFile.getAbsolutePath());
        }
        File localdataDir = new File(Core.frostSettings.getValue("localdata.dir"));
        FilenameFilter ffilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".checkblocks") || name.endsWith(".redirect");
            }
        };
        int deletedCount = 0;
        long deletedSize = 0L;
        for (File aFile : allUploadChunks = localdataDir.listFiles(ffilter)) {
            if (!aFile.isFile() || ulItemFilePaths.contains(aFile.getAbsolutePath())) continue;
            deletedSize += aFile.length();
            aFile.delete();
            ++deletedCount;
        }
        logger.warning("INFO: Finished to delete old upload file chunks, deleted " + deletedCount + " files, overall size " + deletedSize);
    }

    private static class MessageTableCallback
    implements MessageArchivingCallback {
        int mode;
        int count = 0;

        public MessageTableCallback(int m) {
            this.mode = m;
        }

        public int messageRetrieved(FrostMessageObject mo) {
            int rc;
            if (this.count % 100 == 0) {
                MessageStorage.inst().commit();
                ArchiveMessageStorage.inst().commit();
            }
            if (this.mode == 2 && (rc = ArchiveMessageStorage.inst().insertMessage(mo)) == 3) {
                return 2;
            }
            ++this.count;
            return 3;
        }

        public int getCount() {
            return this.count;
        }
    }
}

