/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultPut;
import frost.fileTransfer.FileListFile;
import frost.fileTransfer.FileListFileContent;
import frost.fileTransfer.FileListManager;
import frost.fileTransfer.FileListManagerFileInfo;
import frost.fileTransfer.SharedFilesCHKKeyManager;
import frost.storage.perst.SharedFilesCHKKey;
import frost.util.FileAccess;
import frost.util.Logging;
import frost.util.Mixed;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileListUploadThread
extends Thread {
    private static final Logger logger = Logger.getLogger(FileListUploadThread.class.getName());
    private final int minutes6 = 360000;
    private long nextStartTime = System.currentTimeMillis() + 300000L;
    private static FileListUploadThread instance = new FileListUploadThread();

    private FileListUploadThread() {
    }

    public static FileListUploadThread getInstance() {
        return instance;
    }

    public boolean cancelThread() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userActionOccured() {
        FileListUploadThread fileListUploadThread = instance;
        synchronized (fileListUploadThread) {
            this.nextStartTime = System.currentTimeMillis() + (long)this.getRandomWaittime();
        }
    }

    private int getRandomWaittime() {
        int sleepTime = 360000 + (int)(360000.0 * Math.random());
        return sleepTime;
    }

    public void run() {
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        do {
            try {
                int waitTimeDelta;
                while ((waitTimeDelta = (int)(this.nextStartTime - System.currentTimeMillis())) > 1000) {
                    Mixed.wait(waitTimeDelta);
                }
                FileListManagerFileInfo fileInfo = FileListManager.getFilesToSend();
                if (fileInfo != null) {
                    File targetFile = FileAccess.createTempFile("flFile_", ".xml.tmp");
                    targetFile.deleteOnExit();
                    FileListFileContent content = new FileListFileContent(System.currentTimeMillis(), fileInfo.getOwner(), fileInfo.getFiles());
                    if (!FileListFile.writeFileListFile(content, targetFile)) {
                        logger.log(Level.SEVERE, "Could'nt write the filelist xml file");
                    } else {
                        if (Logging.inst().doLogFilebaseMessages()) {
                            System.out.println("FileListUploadThread: starting upload of files: " + fileInfo.getFiles().size());
                        }
                        String chkKey = null;
                        try {
                            FcpResultPut result = FcpHandler.inst().putFile(2, "CHK@", targetFile, null, false, true, false);
                            if (result.isSuccess() || result.isKeyCollision()) {
                                chkKey = result.getChkKey();
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, "Exception catched", ex);
                        }
                        if (Logging.inst().doLogFilebaseMessages()) {
                            System.out.println("FileListUploadThread: upload finished, key: " + chkKey);
                        }
                        if (chkKey != null) {
                            SharedFilesCHKKey key = new SharedFilesCHKKey(chkKey);
                            SharedFilesCHKKeyManager.addNewCHKKeyToSend(key);
                            FileListManager.updateFileListWasSuccessfullySent(fileInfo.getFiles());
                        }
                    }
                    targetFile.delete();
                }
                int sleepTime = this.getRandomWaittime();
                this.nextStartTime = System.currentTimeMillis() + (long)sleepTime;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception catched", t);
                ++occuredExceptions;
            }
        } while (occuredExceptions <= 5);
        logger.log(Level.SEVERE, "Stopping FileListUploadThread because of too much exceptions");
    }
}

