/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messages;

import frost.boards.Board;
import frost.messages.Attachment;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostUnsentMessageObject;
import java.io.File;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;

public class PerstFrostUnsentMessageObject
extends Persistent {
    private String messageId;
    private String inReplyTo;
    private String fromName;
    private String subject;
    private String recipientName;
    private int idLinePos;
    private int idLineLen;
    private Link<PerstFrostUnsentBoardAttachment> boardAttachments;
    private Link<PerstFrostUnsentFileAttachment> fileAttachments;
    private String content;
    private long timeAdded;
    private long sendAfterTime;

    public void deallocate() {
        if (this.boardAttachments != null) {
            for (PerstFrostUnsentBoardAttachment perstFrostUnsentBoardAttachment : this.boardAttachments) {
                perstFrostUnsentBoardAttachment.deallocate();
            }
            this.boardAttachments.clear();
            this.boardAttachments = null;
        }
        if (this.fileAttachments != null) {
            for (PerstFrostUnsentFileAttachment perstFrostUnsentFileAttachment : this.fileAttachments) {
                perstFrostUnsentFileAttachment.deallocate();
            }
            this.fileAttachments.clear();
            this.fileAttachments = null;
        }
        super.deallocate();
    }

    public PerstFrostUnsentMessageObject() {
    }

    public PerstFrostUnsentMessageObject(Storage store, FrostUnsentMessageObject umo) {
        Persistent pba;
        this.messageId = umo.getMessageId();
        this.inReplyTo = umo.getInReplyTo();
        this.fromName = umo.getFromName();
        this.subject = umo.getSubject();
        this.recipientName = umo.getRecipientName();
        this.idLinePos = umo.getIdLinePos();
        this.idLineLen = umo.getIdLineLen();
        this.content = umo.getContent();
        this.timeAdded = umo.getTimeAdded();
        this.sendAfterTime = umo.getSendAfterTime();
        AttachmentList files = umo.getAttachmentsOfType(0);
        AttachmentList boards = umo.getAttachmentsOfType(1);
        if (boards != null && boards.size() > 0) {
            this.boardAttachments = store.createLink();
            for (Attachment ba : boards) {
                pba = new PerstFrostUnsentBoardAttachment((BoardAttachment)ba);
                this.boardAttachments.add((PerstFrostUnsentBoardAttachment)pba);
            }
        } else {
            this.boardAttachments = null;
        }
        if (files != null && files.size() > 0) {
            this.fileAttachments = store.createLink();
            for (Attachment ba : files) {
                if (((FileAttachment)ba).getInternalFile() == null) continue;
                pba = new PerstFrostUnsentFileAttachment((FileAttachment)ba);
                this.fileAttachments.add((PerstFrostUnsentFileAttachment)pba);
            }
        } else {
            this.fileAttachments = null;
        }
        umo.setPerstFrostUnsentMessageObject(this);
    }

    public FrostUnsentMessageObject toFrostUnsentMessageObject(Board board) {
        FrostUnsentMessageObject mo = new FrostUnsentMessageObject();
        mo.setPerstFrostUnsentMessageObject(this);
        mo.setMessageId(this.messageId);
        mo.setInReplyTo(this.inReplyTo);
        mo.setIdLinePos(this.idLinePos);
        mo.setIdLineLen(this.idLineLen);
        mo.setFromName(this.fromName);
        mo.setSubject(this.subject);
        mo.setRecipientName(this.recipientName);
        mo.setContent(this.content);
        mo.setHasFileAttachments(this.fileAttachments != null);
        mo.setHasBoardAttachments(this.boardAttachments != null);
        mo.setTimeAdded(this.timeAdded);
        mo.setSendAfterTime(this.sendAfterTime);
        mo.setBoard(board);
        this.retrieveAttachments(mo);
        return mo;
    }

    protected void updateUnsentMessageFileAttachmentKey(FileAttachment fa) {
        if (this.fileAttachments == null) {
            return;
        }
        for (PerstFrostUnsentFileAttachment ufa : this.fileAttachments) {
            if (!ufa.name.equals(fa.getInternalFile().getPath())) continue;
            ufa.chkKey = fa.getKey();
            ufa.modify();
            return;
        }
    }

    private void retrieveAttachments(FrostUnsentMessageObject mo) {
        if (mo.hasFileAttachments() && this.fileAttachments != null) {
            for (PerstFrostUnsentFileAttachment perstFrostUnsentFileAttachment : this.fileAttachments) {
                FileAttachment fa = new FileAttachment(new File(perstFrostUnsentFileAttachment.name), perstFrostUnsentFileAttachment.chkKey, perstFrostUnsentFileAttachment.size);
                mo.addAttachment(fa);
            }
        }
        if (mo.hasBoardAttachments() && this.boardAttachments != null) {
            for (PerstFrostUnsentBoardAttachment perstFrostUnsentBoardAttachment : this.boardAttachments) {
                Board b = new Board(perstFrostUnsentBoardAttachment.name, perstFrostUnsentBoardAttachment.pubKey, perstFrostUnsentBoardAttachment.privKey, perstFrostUnsentBoardAttachment.description);
                BoardAttachment ba = new BoardAttachment(b);
                mo.addAttachment(ba);
            }
        }
    }

    class PerstFrostUnsentFileAttachment
    extends Persistent {
        String name;
        long size;
        String chkKey;

        public PerstFrostUnsentFileAttachment() {
        }

        public PerstFrostUnsentFileAttachment(FileAttachment fa) {
            this.name = fa.getInternalFile().getPath();
            this.size = fa.getFileSize();
            this.chkKey = fa.getKey();
        }
    }

    class PerstFrostUnsentBoardAttachment
    extends Persistent {
        String name;
        String pubKey;
        String privKey;
        String description;

        public PerstFrostUnsentBoardAttachment() {
        }

        public PerstFrostUnsentBoardAttachment(BoardAttachment ba) {
            this.name = ba.getBoardObj().getName();
            this.pubKey = ba.getBoardObj().getPublicKey();
            this.privKey = ba.getBoardObj().getPrivateKey();
            this.description = ba.getBoardObj().getDescription();
        }
    }
}

