/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messagearchive;

import frost.boards.Board;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.storage.perst.messagearchive.PerstFrostArchiveBoardAttachment;
import frost.storage.perst.messagearchive.PerstFrostArchiveFileAttachment;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PerstFrostArchiveMessageObject
extends Persistent {
    String messageId;
    String inReplyTo;
    long dateAndTime;
    int msgIndex;
    String fromName;
    String subject;
    String recipientName;
    int signatureStatus;
    boolean isReplied;
    boolean isFlagged;
    boolean isStarred;
    int idLinePos;
    int idLineLen;
    Link<PerstFrostArchiveBoardAttachment> boardAttachments;
    Link<PerstFrostArchiveFileAttachment> fileAttachments;
    String content;
    String publicKey;

    public boolean recursiveLoading() {
        return false;
    }

    public PerstFrostArchiveMessageObject() {
    }

    public PerstFrostArchiveMessageObject(FrostMessageObject mo, Storage store) {
        AttachmentList files;
        this.messageId = mo.getMessageId();
        this.inReplyTo = mo.getInReplyTo();
        this.dateAndTime = mo.getDateAndTime().getMillis();
        this.msgIndex = mo.getIndex();
        this.fromName = mo.getFromName();
        this.subject = mo.getSubject();
        this.recipientName = mo.getRecipientName() != null && mo.getRecipientName().length() == 0 ? null : mo.getRecipientName();
        this.signatureStatus = mo.getSignatureStatus();
        if (mo.getPublicKey() != null && mo.getPublicKey().length() > 0) {
            this.publicKey = mo.getPublicKey();
        }
        this.isReplied = mo.isReplied();
        this.isFlagged = mo.isFlagged();
        this.isStarred = mo.isStarred();
        this.idLinePos = mo.getIdLinePos();
        this.idLineLen = mo.getIdLineLen();
        AttachmentList boards = mo.getAttachmentsOfType(1);
        if (boards != null && boards.size() > 0) {
            this.boardAttachments = store.createLink(boards.size());
            for (BoardAttachment ba : boards) {
                this.boardAttachments.add(new PerstFrostArchiveBoardAttachment(ba));
            }
        } else {
            this.boardAttachments = null;
        }
        if ((files = mo.getAttachmentsOfType(0)) != null && files.size() > 0) {
            this.fileAttachments = store.createLink(files.size());
            for (FileAttachment ba : files) {
                this.fileAttachments.add(new PerstFrostArchiveFileAttachment(ba));
            }
        } else {
            this.fileAttachments = null;
        }
        this.content = mo.getContent();
    }

    public void retrieveAttachments(FrostMessageObject mo) {
        if (mo.hasFileAttachments() && this.fileAttachments != null) {
            for (PerstFrostArchiveFileAttachment perstFrostArchiveFileAttachment : this.fileAttachments) {
                FileAttachment fa = new FileAttachment(perstFrostArchiveFileAttachment.name, perstFrostArchiveFileAttachment.chkKey, perstFrostArchiveFileAttachment.size);
                mo.addAttachment(fa);
            }
        }
        if (mo.hasBoardAttachments() && this.boardAttachments != null) {
            for (PerstFrostArchiveBoardAttachment perstFrostArchiveBoardAttachment : this.boardAttachments) {
                Board b = new Board(perstFrostArchiveBoardAttachment.name, perstFrostArchiveBoardAttachment.pubKey, perstFrostArchiveBoardAttachment.privKey, perstFrostArchiveBoardAttachment.description);
                BoardAttachment ba = new BoardAttachment(b);
                mo.addAttachment(ba);
            }
        }
    }

    public FrostMessageObject toFrostMessageObject(Board board) {
        FrostMessageObject mo = new FrostMessageObject();
        mo.setBoard(board);
        mo.setValid(true);
        mo.setNew(false);
        mo.setJunk(false);
        mo.setDeleted(false);
        mo.setMessageId(this.messageId);
        mo.setInReplyTo(this.inReplyTo);
        mo.setDateAndTime(new DateTime(this.dateAndTime, DateTimeZone.UTC));
        mo.setIndex(this.msgIndex);
        mo.setFromName(this.fromName);
        mo.setSubject(this.subject);
        if (this.recipientName != null && this.recipientName.length() == 0) {
            this.recipientName = null;
        }
        mo.setRecipientName(this.recipientName);
        mo.setSignatureStatus(this.signatureStatus);
        mo.setReplied(this.isReplied);
        mo.setFlagged(this.isFlagged);
        mo.setStarred(this.isStarred);
        mo.setContent(this.content);
        mo.setPublicKey(this.publicKey);
        mo.setHasFileAttachments(this.fileAttachments != null);
        mo.setHasBoardAttachments(this.boardAttachments != null);
        mo.setIdLinePos(this.idLinePos);
        mo.setIdLineLen(this.idLineLen);
        this.retrieveAttachments(mo);
        return mo;
    }
}

