/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.identities;

import frost.Core;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.filelist.FileListStorage;
import frost.storage.perst.identities.IdentitiesStorageRoot;
import frost.storage.perst.messages.MessageStorage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitiesStorage
extends AbstractFrostStorage
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(IdentitiesStorage.class.getName());
    private static final String STORAGE_FILENAME = "identities.dbs";
    private IdentitiesStorageRoot storageRoot = null;
    private static IdentitiesStorage instance = new IdentitiesStorage();

    protected IdentitiesStorage() {
    }

    public static IdentitiesStorage inst() {
        return instance;
    }

    @Override
    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    @Override
    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.identities");
        this.open(databaseFilePath, pagePoolSize, true, true, false);
        this.storageRoot = (IdentitiesStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new IdentitiesStorageRoot(this.getStorage());
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    @Override
    public void exitSave() throws StorageException {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: IdentitiesStorage closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLocalIdentities(List<LocalIdentity> lids, Hashtable<String, Integer> msgCounts) {
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            for (LocalIdentity li : lids) {
                Integer i = msgCounts.get(li.getUniqueName());
                if (i != null) {
                    li.setReceivedMessageCount(i);
                }
                li.correctUniqueName();
                this.storageRoot.getLocalIdentities().add(li);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importIdentities(List<Identity> ids, Hashtable<String, Integer> msgCounts) {
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            int cnt = 0;
            for (Identity li : ids) {
                Integer i = msgCounts.get(li.getUniqueName());
                if (i != null) {
                    li.setReceivedMessageCount(i);
                }
                li.correctUniqueName();
                this.storageRoot.getIdentities().add(li);
                if (++cnt % 100 != 0) continue;
                System.out.println("Committing after " + cnt + " identities");
                this.endThreadTransaction();
                this.beginExclusiveThreadTransaction();
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Identity> loadIdentities() {
        boolean migrateIdStorage;
        Hashtable<String, Identity> result = new Hashtable<String, Identity>();
        if (this.storageRoot.getMigrationLevel() < 1) {
            migrateIdStorage = true;
            this.beginExclusiveThreadTransaction();
        } else {
            migrateIdStorage = false;
            this.beginCooperativeThreadTransaction();
        }
        try {
            Iterator i = this.storageRoot.getIdentities().iterator();
            while (i.hasNext()) {
                Identity id = (Identity)i.next();
                if (id == null) {
                    logger.severe("Retrieved a null id !!! Please repair identities.dbs.");
                    continue;
                }
                if (migrateIdStorage && !Core.getIdentities().isIdentityValid(id)) {
                    i.remove();
                    logger.severe("Dropped an invalid identity: " + id.getUniqueName());
                    continue;
                }
                result.put(id.getUniqueName(), id);
            }
        }
        finally {
            if (migrateIdStorage) {
                this.storageRoot.setMigrationLevel(1);
            }
            this.endThreadTransaction();
        }
        return result;
    }

    public boolean insertIdentity(Identity id) {
        if (id == null) {
            logger.severe("Rejecting to insert a null id!");
            return false;
        }
        this.storageRoot.getIdentities().add(id);
        return true;
    }

    public boolean removeIdentity(Identity id) {
        if (id.getStorage() == null) {
            logger.severe("id not in store");
            return false;
        }
        boolean isRemoved = this.storageRoot.getIdentities().remove(id);
        if (isRemoved) {
            id.deallocate();
        }
        return isRemoved;
    }

    public int getIdentityCount() {
        return this.storageRoot.getIdentities().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, LocalIdentity> loadLocalIdentities() {
        Hashtable<String, LocalIdentity> result = new Hashtable<String, LocalIdentity>();
        this.beginCooperativeThreadTransaction();
        try {
            for (LocalIdentity id : this.storageRoot.getLocalIdentities()) {
                if (id == null) {
                    logger.severe("Retrieved a null id !!! Please repair identities.dbs.");
                    continue;
                }
                result.put(id.getUniqueName(), id);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return result;
    }

    public boolean insertLocalIdentity(LocalIdentity id) {
        if (id == null) {
            logger.severe("Rejecting to insert a null id!");
            return false;
        }
        this.storageRoot.getLocalIdentities().add(id);
        return true;
    }

    public boolean removeLocalIdentity(LocalIdentity lid) {
        if (lid.getStorage() == null) {
            logger.severe("lid not in store");
            return false;
        }
        boolean isRemoved = this.storageRoot.getLocalIdentities().remove(lid);
        if (isRemoved) {
            lid.deallocate();
        }
        return isRemoved;
    }

    public Hashtable<String, IdentityMsgAndFileCount> retrieveMsgAndFileCountPerIdentity() {
        IdentityMsgAndFileCount s;
        int fileCount;
        int messageCount;
        Hashtable<String, IdentityMsgAndFileCount> data = new Hashtable<String, IdentityMsgAndFileCount>();
        for (Identity identity : Core.getIdentities().getIdentities()) {
            messageCount = MessageStorage.inst().getMessageCount(identity.getUniqueName());
            fileCount = FileListStorage.inst().getFileCount(identity.getUniqueName());
            s = new IdentityMsgAndFileCount(messageCount, fileCount);
            data.put(identity.getUniqueName(), s);
        }
        for (LocalIdentity localIdentity : Core.getIdentities().getLocalIdentities()) {
            messageCount = MessageStorage.inst().getMessageCount(localIdentity.getUniqueName());
            fileCount = FileListStorage.inst().getFileCount(localIdentity.getUniqueName());
            s = new IdentityMsgAndFileCount(messageCount, fileCount);
            data.put(localIdentity.getUniqueName(), s);
        }
        return data;
    }

    public void repairStorage() {
        int progressSteps;
        System.out.println("Repairing identities.dbs (may take some time!)...");
        String databaseFilePath = this.buildStoragePath(STORAGE_FILENAME);
        int pagePoolSize = 0x200000;
        this.open(databaseFilePath, 0x200000, true, true, false);
        this.storageRoot = (IdentitiesStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            System.out.println("No identities.dbs found");
            return;
        }
        int brokenEntries = 0;
        int validEntries = 0;
        ArrayList<Identity> lst = new ArrayList<Identity>();
        int progress = progressSteps = this.storageRoot.getIdentities().size() / 75;
        for (int x = 0; x < this.storageRoot.getIdentities().size(); ++x) {
            Identity sfk;
            if (x > progress) {
                System.out.print('.');
                progress += progressSteps;
            }
            try {
                sfk = (Identity)this.storageRoot.getIdentities().get(x);
            }
            catch (Throwable t) {
                ++brokenEntries;
                continue;
            }
            if (sfk == null) {
                ++brokenEntries;
                continue;
            }
            ++validEntries;
            lst.add(sfk);
        }
        this.storageRoot.getIdentities().clear();
        this.commit();
        for (Identity sfk : lst) {
            this.storageRoot.getIdentities().add(sfk);
        }
        this.commit();
        this.close();
        this.storageRoot = null;
        System.out.println();
        System.out.println("Repair finished, brokenEntries=" + brokenEntries + "; validEntries=" + validEntries);
    }

    public static class IdentityMsgAndFileCount {
        final int fileCount;
        final int messageCount;

        public IdentityMsgAndFileCount(int mc, int fc) {
            this.messageCount = mc;
            this.fileCount = fc;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public int getMessageCount() {
            return this.messageCount;
        }
    }
}

