/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.filelist;

import frost.Core;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.FrostFileListFileObjectOwner;
import frost.storage.ExitSavable;
import frost.storage.FileListCallback;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.filelist.FileListStorageRoot;
import frost.storage.perst.filelist.PerstFileListIndexEntry;
import frost.storage.perst.filelist.PerstHiddenFileOid;
import frost.storage.perst.filelist.PerstIdentitiesFiles;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.garret.perst.IPersistentList;
import org.garret.perst.Index;
import org.garret.perst.PersistentIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListStorage
extends AbstractFrostStorage
implements ExitSavable,
PropertyChangeListener {
    private FileListStorageRoot storageRoot = null;
    private static final String STORAGE_FILENAME = "filelist.dbs";
    private static FileListStorage instance = new FileListStorage();
    private boolean rememberSharedFileDownloaded;
    boolean alwaysUseLatestChkKey = true;

    protected FileListStorage() {
    }

    public static FileListStorage inst() {
        return instance;
    }

    @Override
    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    @Override
    public boolean initStorage() {
        this.rememberSharedFileDownloaded = Core.frostSettings.getBoolValue("rememberSharedFileDownloaded");
        Core.frostSettings.addPropertyChangeListener("rememberSharedFileDownloaded", this);
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.filelist");
        this.open(databaseFilePath, pagePoolSize, true, true, false);
        this.storageRoot = (FileListStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new FileListStorageRoot(this.getStorage());
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        this.storageRoot.createNewFields(this.getStorage());
        return true;
    }

    public void silentClose() {
        this.close();
        this.storageRoot = null;
    }

    @Override
    public void exitSave() {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: FileListStorage closed.");
    }

    public IPersistentList createList() {
        return this.getStorage().createScalableList();
    }

    public boolean insertOrUpdateFileListFileObject(FrostFileListFileObject flf) {
        FrostFileListFileObject pflf = (FrostFileListFileObject)this.storageRoot.getFileListFileObjects().get(flf.getSha());
        if (pflf == null) {
            this.storageRoot.getFileListFileObjects().put(flf.getSha(), flf);
            Iterator<FrostFileListFileObjectOwner> i = flf.getFrostFileListFileObjectOwnerIterator();
            while (i.hasNext()) {
                FrostFileListFileObjectOwner o = i.next();
                this.addFileListFileOwnerToIndices(o);
            }
        } else {
            this.updateFileListFileFromOtherFileListFile(pflf, flf);
        }
        return true;
    }

    private void addFileListFileOwnerToIndices(FrostFileListFileObjectOwner o) {
        PerstIdentitiesFiles pif = (PerstIdentitiesFiles)this.storageRoot.getIdentitiesFiles().get(o.getOwner());
        if (pif == null) {
            pif = new PerstIdentitiesFiles(o.getOwner(), this.getStorage());
            this.storageRoot.getIdentitiesFiles().put(o.getOwner(), pif);
        }
        pif.addFileToIdentity(o);
        this.maybeAddFileListFileInfoToIndex(o.getName(), o, this.storageRoot.getFileNameIndex());
        this.maybeAddFileListFileInfoToIndex(o.getComment(), o, this.storageRoot.getFileCommentIndex());
        this.maybeAddFileListFileInfoToIndex(o.getKeywords(), o, this.storageRoot.getFileKeywordIndex());
        this.maybeAddFileListFileInfoToIndex(o.getOwner(), o, this.storageRoot.getFileOwnerIndex());
    }

    private void maybeAddFileListFileInfoToIndex(String lName, FrostFileListFileObjectOwner o, Index<PerstFileListIndexEntry> ix) {
        if (lName == null || lName.length() == 0) {
            return;
        }
        PerstFileListIndexEntry ie = (PerstFileListIndexEntry)ix.get(lName = lName.toLowerCase());
        if (ie == null) {
            ie = new PerstFileListIndexEntry(this.getStorage());
            ix.put(lName, ie);
        }
        ie.getFileOwnersWithText().add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrostFileListFileObject getFileBySha(String sha) {
        FrostFileListFileObject o;
        if (!this.beginCooperativeThreadTransaction()) {
            return null;
        }
        try {
            o = (FrostFileListFileObject)this.storageRoot.getFileListFileObjects().get(sha);
        }
        finally {
            this.endThreadTransaction();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        int count;
        if (!this.beginCooperativeThreadTransaction()) {
            return 0;
        }
        try {
            count = this.storageRoot.getFileListFileObjects().size();
        }
        finally {
            this.endThreadTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount(String idUniqueName) {
        int count;
        if (!this.beginCooperativeThreadTransaction()) {
            return 0;
        }
        try {
            PerstIdentitiesFiles pif = (PerstIdentitiesFiles)this.storageRoot.getIdentitiesFiles().get(idUniqueName);
            count = pif != null ? pif.getFilesFromIdentity().size() : 0;
        }
        finally {
            this.endThreadTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSharerCount() {
        int count;
        if (!this.beginCooperativeThreadTransaction()) {
            return 0;
        }
        try {
            count = this.storageRoot.getIdentitiesFiles().size();
        }
        finally {
            this.endThreadTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSizes() {
        if (!this.beginCooperativeThreadTransaction()) {
            return 0L;
        }
        long sizes = 0L;
        try {
            for (FrostFileListFileObject fo : this.storageRoot.getFileListFileObjects()) {
                sizes += fo.getSize();
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return sizes;
    }

    public void markFileListFileHidden(FrostFileListFileObject fof) {
        if (!fof.isHidden()) {
            fof.setHidden(true);
            fof.modify();
            this.storageRoot.getHiddenFileOids().add(new PerstHiddenFileOid(fof.getOid()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHiddenFiles() {
        if (this.beginExclusiveThreadTransaction()) {
            try {
                Iterator it = this.storageRoot.getHiddenFileOids().iterator();
                while (it.hasNext()) {
                    PerstHiddenFileOid hf = (PerstHiddenFileOid)it.next();
                    FrostFileListFileObject fof = (FrostFileListFileObject)this.getStorage().getObjectByOID(hf.getHiddenFileOid());
                    if (fof != null && fof.isHidden()) {
                        fof.setHidden(false);
                        fof.modify();
                    }
                    it.remove();
                    hf.deallocate();
                }
            }
            finally {
                this.endThreadTransaction();
            }
        }
    }

    public int getHiddenFilesCount() {
        return this.storageRoot.getHiddenFileOids().size();
    }

    private void maybeRemoveFileListFileInfoFromIndex(String lName, FrostFileListFileObjectOwner o, Index<PerstFileListIndexEntry> ix) {
        String lowerCaseName;
        PerstFileListIndexEntry ie;
        if (lName != null && lName.length() > 0 && (ie = (PerstFileListIndexEntry)ix.get(lowerCaseName = lName.toLowerCase())) != null) {
            ie.getFileOwnersWithText().remove(o);
            if (ie.getFileOwnersWithText().size() == 0 && ix.remove(lowerCaseName) != null) {
                ie.deallocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanupFileListFileOwners(boolean removeOfflineFilesWithKey, int offlineFilesMaxDaysOld) {
        if (!this.beginExclusiveThreadTransaction()) {
            return 0;
        }
        int count = 0;
        try {
            long minVal = System.currentTimeMillis() - (long)offlineFilesMaxDaysOld * 24L * 60L * 60L * 1000L;
            for (PerstIdentitiesFiles pif : this.storageRoot.getIdentitiesFiles()) {
                Iterator i = pif.getFilesFromIdentity().iterator();
                while (i.hasNext()) {
                    FrostFileListFileObjectOwner o = (FrostFileListFileObjectOwner)i.next();
                    boolean remove = false;
                    if (o.getLastReceived() < minVal) {
                        if (o.getKey() != null && o.getKey().length() > 0) {
                            if (removeOfflineFilesWithKey) {
                                remove = true;
                            }
                        } else {
                            remove = true;
                        }
                    }
                    if (!remove) continue;
                    FrostFileListFileObject fof = o.getFileListFileObject();
                    o.setFileListFileObject(null);
                    fof.deleteFrostFileListFileObjectOwner(o);
                    this.maybeRemoveFileListFileInfoFromIndex(o.getName(), o, this.storageRoot.getFileNameIndex());
                    this.maybeRemoveFileListFileInfoFromIndex(o.getComment(), o, this.storageRoot.getFileCommentIndex());
                    this.maybeRemoveFileListFileInfoFromIndex(o.getKeywords(), o, this.storageRoot.getFileKeywordIndex());
                    this.maybeRemoveFileListFileInfoFromIndex(o.getOwner(), o, this.storageRoot.getFileOwnerIndex());
                    i.remove();
                    o.deallocate();
                    fof.modify();
                    ++count;
                }
                if (pif.getFilesFromIdentity().size() != 0 || this.storageRoot.getIdentitiesFiles().remove(pif.getUniqueName()) == null) continue;
                pif.deallocate();
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanupFileListFiles() {
        if (!this.beginExclusiveThreadTransaction()) {
            return 0;
        }
        int count = 0;
        try {
            HashSet<Integer> oidsToRemove = new HashSet<Integer>();
            Iterator i = this.storageRoot.getFileListFileObjects().iterator();
            while (i.hasNext()) {
                FrostFileListFileObject fof = (FrostFileListFileObject)i.next();
                if (fof.getFrostFileListFileObjectOwnerListSize() != 0) continue;
                oidsToRemove.add(new Integer(fof.getOid()));
                i.remove();
                fof.deallocate();
                ++count;
            }
            Iterator it = this.storageRoot.getHiddenFileOids().iterator();
            while (it.hasNext()) {
                PerstHiddenFileOid hf = (PerstHiddenFileOid)it.next();
                if (!oidsToRemove.contains(new Integer(hf.getHiddenFileOid()))) continue;
                it.remove();
                hf.deallocate();
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLastDownloaded() {
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            for (FrostFileListFileObject fof : this.storageRoot.getFileListFileObjects()) {
                fof.setLastDownloaded(0L);
                fof.modify();
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public boolean updateFrostFileListFileObjectAfterRequestSent(String sha, long requestLastSent) {
        FrostFileListFileObject oldSfo = this.getFileBySha(sha);
        if (oldSfo == null) {
            return false;
        }
        oldSfo.setRequestLastSent(requestLastSent);
        oldSfo.setRequestsSentCount(oldSfo.getRequestsSentCount() + 1);
        oldSfo.modify();
        return true;
    }

    public boolean updateFrostFileListFileObjectAfterRequestReceived(String sha, long requestLastReceived) {
        FrostFileListFileObject oldSfo = this.getFileBySha(sha);
        if (oldSfo == null) {
            return false;
        }
        if (oldSfo.getRequestLastReceived() > requestLastReceived) {
            requestLastReceived = oldSfo.getRequestLastReceived();
        }
        oldSfo.setRequestLastReceived(requestLastReceived);
        oldSfo.setRequestsReceivedCount(oldSfo.getRequestsReceivedCount() + 1);
        oldSfo.modify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFrostFileListFileObjectAfterDownload(String sha, long lastDownloaded) {
        if (!this.rememberSharedFileDownloaded) {
            return true;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            FrostFileListFileObject oldSfo = this.getFileBySha(sha);
            if (oldSfo == null) {
                this.endThreadTransaction();
                boolean bl = false;
                return bl;
            }
            oldSfo.setLastDownloaded(lastDownloaded);
            oldSfo.modify();
        }
        finally {
            this.endThreadTransaction();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveFiles(FileListCallback callback, List<String> names, List<String> comments, List<String> keywords, List<String> owners, String[] extensions) {
        if (!this.beginCooperativeThreadTransaction()) {
            return;
        }
        System.out.println("Starting file search...");
        long t = System.currentTimeMillis();
        boolean searchForNames = true;
        boolean searchForComments = true;
        boolean searchForKeywords = true;
        boolean searchForOwners = true;
        boolean searchForExtensions = true;
        if (names == null || names.size() == 0) {
            searchForNames = false;
        }
        if (comments == null || comments.size() == 0) {
            searchForComments = false;
        }
        if (keywords == null || keywords.size() == 0) {
            searchForKeywords = false;
        }
        if (owners == null || owners.size() == 0) {
            searchForOwners = false;
        }
        if (extensions == null || extensions.length == 0) {
            searchForExtensions = false;
        }
        try {
            if (!(searchForNames || searchForComments || searchForKeywords || searchForOwners || searchForExtensions)) {
                for (FrostFileListFileObject o : this.storageRoot.getFileListFileObjects()) {
                    if (!callback.fileRetrieved(o)) continue;
                    return;
                }
                return;
            }
            if (!searchForExtensions) {
                extensions = null;
            }
            HashSet<Integer> ownerOids = new HashSet<Integer>();
            if (searchForNames || searchForExtensions) {
                this.searchForFiles(ownerOids, names, extensions, this.storageRoot.getFileNameIndex());
            }
            if (searchForComments) {
                this.searchForFiles(ownerOids, comments, null, this.storageRoot.getFileCommentIndex());
            }
            if (searchForKeywords) {
                this.searchForFiles(ownerOids, keywords, null, this.storageRoot.getFileKeywordIndex());
            }
            if (searchForOwners) {
                this.searchForFiles(ownerOids, owners, null, this.storageRoot.getFileOwnerIndex());
            }
            HashSet<Integer> foundFileObjectOids = new HashSet<Integer>();
            for (Integer i : ownerOids) {
                FrostFileListFileObjectOwner owner = (FrostFileListFileObjectOwner)this.getStorage().getObjectByOID(i);
                FrostFileListFileObject fileObject = owner.getFileListFileObject();
                if (fileObject == null) continue;
                if (fileObject.isHidden()) continue;
                int oid = fileObject.getOid();
                if (foundFileObjectOids.contains(oid)) continue;
                foundFileObjectOids.add(oid);
                if (!callback.fileRetrieved(fileObject)) continue;
                return;
            }
        }
        finally {
            System.out.println("Finished file search, duration=" + (System.currentTimeMillis() - t));
            this.endThreadTransaction();
        }
    }

    private void searchForFiles(HashSet<Integer> oids, List<String> searchStrings, String[] extensions, Index<PerstFileListIndexEntry> ix) {
        for (Map.Entry entry : ix.entryIterator()) {
            String key = (String)entry.getKey();
            if (searchStrings != null) {
                for (String searchString : searchStrings) {
                    if (key.indexOf(searchString) <= -1) continue;
                    Iterator i = ((PerstFileListIndexEntry)entry.getValue()).getFileOwnersWithText().iterator();
                    while (i.hasNext()) {
                        int oid = ((PersistentIterator)((Object)i)).nextOid();
                        oids.add(oid);
                    }
                }
            }
            if (extensions == null) continue;
            for (String extension : extensions) {
                if (!key.endsWith(extension)) continue;
                Iterator i = ((PerstFileListIndexEntry)entry.getValue()).getFileOwnersWithText().iterator();
                while (i.hasNext()) {
                    int oid = ((PersistentIterator)((Object)i)).nextOid();
                    oids.add(oid);
                }
            }
        }
    }

    private boolean updateFileListFileFromOtherFileListFile(FrostFileListFileObject oldFof, FrostFileListFileObject newFof) {
        boolean doUpdate = false;
        if (oldFof.getKey() == null && newFof.getKey() != null) {
            oldFof.setKey(newFof.getKey());
            doUpdate = true;
        } else if (this.alwaysUseLatestChkKey && oldFof.getLastUploaded() < newFof.getLastUploaded() && oldFof.getKey() != null && newFof.getKey() != null && !oldFof.getKey().equals(newFof.getKey())) {
            oldFof.setKey(newFof.getKey());
            doUpdate = true;
        }
        if (oldFof.getFirstReceived() > newFof.getFirstReceived()) {
            oldFof.setFirstReceived(newFof.getFirstReceived());
            doUpdate = true;
        }
        if (oldFof.getLastReceived() < newFof.getLastReceived()) {
            oldFof.setLastReceived(newFof.getLastReceived());
            doUpdate = true;
        }
        if (oldFof.getLastUploaded() < newFof.getLastUploaded()) {
            oldFof.setLastUploaded(newFof.getLastUploaded());
            doUpdate = true;
        }
        if (oldFof.getLastDownloaded() < newFof.getLastDownloaded()) {
            oldFof.setLastDownloaded(newFof.getLastDownloaded());
            doUpdate = true;
        }
        if (oldFof.getRequestLastReceived() < newFof.getRequestLastReceived()) {
            oldFof.setRequestLastReceived(newFof.getRequestLastReceived());
            doUpdate = true;
        }
        if (oldFof.getRequestLastSent() < newFof.getRequestLastSent()) {
            oldFof.setRequestLastSent(newFof.getRequestLastSent());
            doUpdate = true;
        }
        if (oldFof.getRequestsReceivedCount() < newFof.getRequestsReceivedCount()) {
            oldFof.setRequestsReceivedCount(newFof.getRequestsReceivedCount());
            doUpdate = true;
        }
        if (oldFof.getRequestsSentCount() < newFof.getRequestsSentCount()) {
            oldFof.setRequestsSentCount(newFof.getRequestsSentCount());
            doUpdate = true;
        }
        Iterator<FrostFileListFileObjectOwner> i = newFof.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner obNew = i.next();
            FrostFileListFileObjectOwner obOld = null;
            Iterator<FrostFileListFileObjectOwner> j = oldFof.getFrostFileListFileObjectOwnerIterator();
            while (j.hasNext()) {
                FrostFileListFileObjectOwner o = j.next();
                if (!o.getOwner().equals(obNew.getOwner())) continue;
                obOld = o;
                break;
            }
            if (obOld == null) {
                oldFof.addFrostFileListFileObjectOwner(obNew);
                this.addFileListFileOwnerToIndices(obNew);
                doUpdate = true;
                continue;
            }
            if (obOld.getLastReceived() >= obNew.getLastReceived()) continue;
            this.maybeUpdateFileListInfoInIndex(obOld.getName(), obNew.getName(), obOld, this.storageRoot.getFileNameIndex());
            obOld.setName(obNew.getName());
            this.maybeUpdateFileListInfoInIndex(obOld.getComment(), obNew.getComment(), obOld, this.storageRoot.getFileCommentIndex());
            obOld.setComment(obNew.getComment());
            this.maybeUpdateFileListInfoInIndex(obOld.getKeywords(), obNew.getKeywords(), obOld, this.storageRoot.getFileKeywordIndex());
            obOld.setKeywords(obNew.getKeywords());
            obOld.setLastReceived(obNew.getLastReceived());
            obOld.setLastUploaded(obNew.getLastUploaded());
            obOld.setRating(obNew.getRating());
            obOld.setKey(obNew.getKey());
            obOld.modify();
            doUpdate = true;
        }
        if (doUpdate) {
            oldFof.modify();
        }
        return doUpdate;
    }

    private void maybeUpdateFileListInfoInIndex(String oldValue, String newValue, FrostFileListFileObjectOwner o, Index<PerstFileListIndexEntry> ix) {
        if (oldValue != null) {
            if (newValue != null) {
                if (oldValue.toLowerCase().equals(newValue.toLowerCase())) {
                    return;
                }
                this.maybeAddFileListFileInfoToIndex(newValue, o, ix);
            }
            this.maybeRemoveFileListFileInfoFromIndex(oldValue, o, ix);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.rememberSharedFileDownloaded = Core.frostSettings.getBoolValue("rememberSharedFileDownloaded");
    }
}

