/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.IndexSlot;
import frost.storage.perst.IndexSlotsStorageRoot;
import java.util.logging.Logger;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class IndexSlotsStorage
extends AbstractFrostStorage
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(IndexSlotsStorage.class.getName());
    private static final String STORAGE_FILENAME = "gixSlots.dbs";
    public static final int FILELISTS = -1;
    public static final int REQUESTS = -2;
    private IndexSlotsStorageRoot storageRoot = null;
    private static IndexSlotsStorage instance = new IndexSlotsStorage();
    private static final Long minLongObj = new Long(Long.MIN_VALUE);
    private static final Integer minIntObj = new Integer(Integer.MIN_VALUE);
    private static final Integer maxIntObj = new Integer(Integer.MAX_VALUE);

    protected IndexSlotsStorage() {
    }

    public static IndexSlotsStorage inst() {
        return instance;
    }

    private boolean addToIndices(IndexSlot gis) {
        if (this.getStorage() == null) {
            return false;
        }
        boolean wasOk = this.storageRoot.slotsIndexIL.put(new Key((Object)gis.getIndexName(), gis.getMsgDate()), gis);
        this.storageRoot.slotsIndexLI.put(new Key((Object)gis.getMsgDate(), gis.getIndexName()), gis);
        return wasOk;
    }

    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.indexslots");
        this.open(databaseFilePath, pagePoolSize, false, true, true);
        this.storageRoot = (IndexSlotsStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new IndexSlotsStorageRoot();
            this.storageRoot.slotsIndexIL = this.getStorage().createIndex(new Class[]{Integer.class, Long.class}, true);
            this.storageRoot.slotsIndexLI = this.getStorage().createIndex(new Class[]{Long.class, Integer.class}, true);
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanup(int maxDaysOld) {
        long date = new LocalDate().minusDays(maxDaysOld + 1).toDateTimeAtMidnight(DateTimeZone.UTC).getMillis();
        Long dateObj = new Long(date);
        int deletedCount = 0;
        this.beginExclusiveThreadTransaction();
        try {
            IterableIterator i = this.storageRoot.slotsIndexLI.iterator(new Key(minLongObj, minIntObj, true), new Key(dateObj, maxIntObj, true), 0);
            while (i.hasNext()) {
                IndexSlot gis = (IndexSlot)i.next();
                this.storageRoot.slotsIndexIL.remove(gis);
                i.remove();
                gis.deallocate();
                ++deletedCount;
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return deletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSlot getSlotForDate(int indexName, long date) {
        IndexSlot gis;
        Key dateKey = new Key((Object)indexName, date);
        if (!this.beginCooperativeThreadTransaction()) {
            logger.severe("Failed to gather cooperative storage lock, returning new indexslot!");
            return new IndexSlot(indexName, date);
        }
        try {
            gis = (IndexSlot)this.storageRoot.slotsIndexIL.get(dateKey);
            if (gis == null) {
                gis = new IndexSlot(indexName, date);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return gis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSlot(IndexSlot gis) {
        if (!this.beginExclusiveThreadTransaction()) {
            logger.severe("Failed to gather exclusive storage lock, don't stored the indexslot!");
            return;
        }
        try {
            if (gis.getStorage() == null) {
                gis.makePersistent(this.getStorage());
                this.addToIndices(gis);
            } else {
                gis.modify();
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public void exitSave() throws StorageException {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: GlobalIndexSlotsStorage closed.");
    }
}

