/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.identities.LocalIdentity;
import frost.storage.KnownBoardsXmlDAO;
import frost.util.XMLTools;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalIdentitiesXmlDAO {
    private static final Logger logger = Logger.getLogger(KnownBoardsXmlDAO.class.getName());

    public static List<LocalIdentity> loadLocalidentities(File file) {
        LinkedList<LocalIdentity> localIdentities = new LinkedList<LocalIdentity>();
        if (file.exists()) {
            Document doc = null;
            try {
                doc = XMLTools.parseXmlFile(file, false);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error reading localidentities xml", ex);
                return localIdentities;
            }
            Element rootNode = doc.getDocumentElement();
            if (!rootNode.getTagName().equals("FrostLocalIdentities")) {
                logger.severe("Error - invalid localidentities xml: does not contain the root tag 'FrostLocalIdentities'");
                return null;
            }
            List<Element> localIdentitiesElements = XMLTools.getChildElementsByTagName(rootNode, "MyIdentity");
            for (Element element : localIdentitiesElements) {
                LocalIdentity myId = LocalIdentity.createLocalIdentityFromXmlElement(element);
                if (myId == null) continue;
                localIdentities.add(myId);
            }
        }
        return localIdentities;
    }

    public static boolean saveLocalIdentities(File file, List<LocalIdentity> localIdentities) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - saveLocalIdentities: factory couldn't create XML Document.");
            return false;
        }
        Element rootElement = doc.createElement("FrostLocalIdentities");
        doc.appendChild(rootElement);
        for (LocalIdentity b : localIdentities) {
            Element anAttachment = b.getExportXMLElement(doc);
            rootElement.appendChild(anAttachment);
        }
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, file.getPath());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Exception while writing localidentities xml:", ex);
        }
        if (!writeOK) {
            logger.severe("Error exporting localidentities, file was not saved");
        }
        return writeOK;
    }
}

