/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.AbstractMessageObject;
import frost.messages.Attachment;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.messages.MessageCreationException;
import frost.util.DateFun;
import frost.util.FileAccess;
import frost.util.XMLTools;
import frost.util.XMLizable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class MessageXmlFile
extends AbstractMessageObject
implements XMLizable {
    private static final Logger logger = Logger.getLogger(MessageXmlFile.class.getName());
    private String boardName = "";
    private String dateStr = "";
    private String timeStr = "";
    private DateTime dateAndTime = null;
    protected File file;

    public MessageXmlFile(FrostMessageObject mo) {
        this.setMessageId(mo.getMessageId());
        this.setInReplyTo(mo.getInReplyTo());
        this.setBoardName(mo.getBoard().getName());
        this.setFromName(mo.getFromName());
        Identity id = this.getFromIdentity();
        if (id != null) {
            this.setPublicKey(id.getPublicKey());
        }
        this.setSubject(mo.getSubject());
        this.setRecipientName(mo.getRecipientName());
        this.setContent(mo.getContent());
        this.setIdLinePos(mo.getIdLinePos());
        this.setIdLineLen(mo.getIdLineLen());
        this.setAttachmentList(mo.getAttachmentList());
    }

    public MessageXmlFile(File file) throws MessageCreationException, Throwable {
        if (file == null) {
            throw new MessageCreationException("Invalid input file for MessageObject. File is null.");
        }
        if (!file.exists()) {
            throw new MessageCreationException("Invalid input file '" + file.getName() + "' for MessageObject. File doesn't exist.");
        }
        if (file.length() < 20L) {
            throw new MessageCreationException("Info only: Empty input file '" + file.getName() + "' for MessageObject (size < 20).", true);
        }
        this.file = file;
        this.loadFile();
        if (!this.isValid()) {
            throw new MessageCreationException("Message has invalid or missing fields.", 3);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void signMessageV1(String privateKey) {
        String sig = Core.getCrypto().detachedSign(this.getSignableContentV1(), privateKey);
        this.setSignatureV1(sig);
    }

    public void signMessageV2(String privateKey) {
        String sig = Core.getCrypto().detachedSign(this.getSignableContentV2(), privateKey);
        this.setSignatureV2(sig);
    }

    public boolean verifyMessageSignatureV1(String pubKey) {
        boolean sigIsValid = Core.getCrypto().detachedVerify(this.getSignableContentV1(), pubKey, this.getSignatureV1());
        return sigIsValid;
    }

    public boolean verifyMessageSignatureV2(String pubKey) {
        boolean sigIsValid = Core.getCrypto().detachedVerify(this.getSignableContentV2(), pubKey, this.getSignatureV2());
        return sigIsValid;
    }

    private String getSignableContentV1() {
        StringBuilder allContent = new StringBuilder();
        allContent.append(this.getDateStr());
        allContent.append(this.getTimeStr());
        allContent.append(this.getSubject());
        allContent.append(this.getContent());
        for (Attachment a : this.getAttachmentList()) {
            if (a.getType() == 1) {
                BoardAttachment ba = (BoardAttachment)a;
                allContent.append(ba.getBoardObj().getBoardFilename());
                if (ba.getBoardObj().getPublicKey() != null) {
                    allContent.append(ba.getBoardObj().getPublicKey());
                }
                if (ba.getBoardObj().getPrivateKey() == null) continue;
                allContent.append(ba.getBoardObj().getPrivateKey());
                continue;
            }
            if (a.getType() != 0) continue;
            FileAttachment fa = (FileAttachment)a;
            allContent.append(fa.getFilename());
            allContent.append(fa.getKey());
        }
        return allContent.toString();
    }

    private String getSignableContentV2() {
        String escapeChar = "|";
        StringBuilder allContent = new StringBuilder();
        allContent.append(this.getDateStr()).append("|");
        allContent.append(this.getTimeStr()).append("|");
        allContent.append(this.getBoardName()).append("|");
        allContent.append(this.getFromName()).append("|");
        allContent.append(this.getMessageId()).append("|");
        if (this.getInReplyTo() != null && this.getInReplyTo().length() > 0) {
            allContent.append(this.getInReplyTo()).append("|");
        }
        if (this.getRecipientName() != null && this.getRecipientName().length() > 0) {
            allContent.append(this.getRecipientName()).append("|");
        }
        allContent.append(this.getIdLinePos()).append("|");
        allContent.append(this.getIdLineLen()).append("|");
        allContent.append(this.getSubject()).append("|");
        allContent.append(this.getContent()).append("|");
        for (Attachment a : this.getAttachmentList()) {
            if (a.getType() == 1) {
                BoardAttachment ba = (BoardAttachment)a;
                allContent.append(ba.getBoardObj().getBoardFilename()).append("|");
                if (ba.getBoardObj().getPublicKey() != null) {
                    allContent.append(ba.getBoardObj().getPublicKey()).append("|");
                }
                if (ba.getBoardObj().getPrivateKey() == null) continue;
                allContent.append(ba.getBoardObj().getPrivateKey()).append("|");
                continue;
            }
            if (a.getType() != 0) continue;
            FileAttachment fa = (FileAttachment)a;
            allContent.append(fa.getFilename()).append("|");
            allContent.append(fa.getKey()).append("|");
        }
        return allContent.toString();
    }

    public Element getXMLElement(Document d) {
        CDATASection cdata;
        Element current;
        Element el = d.createElement("FrostMessage");
        if (this.getMessageId() != null) {
            current = d.createElement("MessageId");
            cdata = d.createCDATASection(this.getMessageId());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getInReplyTo() != null) {
            current = d.createElement("InReplyTo");
            cdata = d.createCDATASection(this.getInReplyTo());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getIdLinePos() > -1 && this.getIdLineLen() > -1) {
            current = d.createElement("IdLinePos");
            Text txt = d.createTextNode(Integer.toString(this.getIdLinePos()));
            current.appendChild(txt);
            el.appendChild(current);
            current = d.createElement("IdLineLen");
            txt = d.createTextNode(Integer.toString(this.getIdLineLen()));
            current.appendChild(txt);
            el.appendChild(current);
        }
        current = d.createElement("From");
        cdata = d.createCDATASection(this.getFromName());
        current.appendChild(cdata);
        el.appendChild(current);
        current = d.createElement("Subject");
        cdata = d.createCDATASection(this.getSubject());
        current.appendChild(cdata);
        el.appendChild(current);
        current = d.createElement("Date");
        cdata = d.createCDATASection(this.getDateStr());
        current.appendChild(cdata);
        el.appendChild(current);
        current = d.createElement("Time");
        cdata = d.createCDATASection(this.getTimeStr());
        current.appendChild(cdata);
        el.appendChild(current);
        current = d.createElement("Body");
        cdata = d.createCDATASection(this.getContent());
        current.appendChild(cdata);
        el.appendChild(current);
        current = d.createElement("Board");
        cdata = d.createCDATASection(this.getBoardName());
        current.appendChild(cdata);
        el.appendChild(current);
        if (this.getPublicKey() != null && this.getPublicKey().length() > 0) {
            current = d.createElement("pubKey");
            cdata = d.createCDATASection(this.getPublicKey());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getRecipientName() != null && this.getRecipientName().length() > 0) {
            current = d.createElement("recipient");
            cdata = d.createCDATASection(this.getRecipientName());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getSignatureV1() != null && this.getSignatureV1().length() > 0) {
            current = d.createElement("Signature");
            cdata = d.createCDATASection(this.getSignatureV1());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getSignatureV2() != null && this.getSignatureV2().length() > 0) {
            current = d.createElement("SignatureV2");
            cdata = d.createCDATASection(this.getSignatureV2());
            current.appendChild(cdata);
            el.appendChild(current);
        }
        if (this.getAttachmentList().size() > 0) {
            el.appendChild(this.getAttachmentList().getXMLElement(d));
        }
        return el;
    }

    private boolean isValid() {
        if (this.getDateStr() == null || this.getDateStr().length() == 0 || this.getDateStr().length() > 22) {
            logger.severe("Date validation failed.");
            return false;
        }
        if (this.getTimeStr() == null || this.getTimeStr().length() == 0) {
            logger.severe("Time validation failed.");
            return false;
        }
        if (this.getBoardName() == null || this.getBoardName().length() == 0 || this.getBoardName().length() > 256) {
            logger.severe("Board name validation failed.");
            return false;
        }
        if (this.getFromName() == null || this.getFromName().length() == 0 || this.getFromName().length() > 256) {
            logger.severe("From name validation failed.");
            return false;
        }
        if (this.getSubject() == null) {
            this.setSubject("");
        } else if (this.getSubject().length() > 256) {
            logger.severe("Subject validation failed.");
            return false;
        }
        if (this.getContent() == null) {
            logger.severe("Content validation failed, no content.");
            return false;
        }
        if (this.getContent().length() > 65536) {
            logger.severe("Content validation failed, overlength content.");
            return false;
        }
        String trimmedContent = this.getContent().trim();
        if (trimmedContent.length() == 0) {
            logger.severe("Content validation failed, empty.");
            return false;
        }
        if (trimmedContent.indexOf("\n") < 0 && trimmedContent.startsWith("-----") && trimmedContent.endsWith("-----")) {
            logger.severe("Content validation failed, only id header line.");
            return false;
        }
        return true;
    }

    protected void loadFile() throws Exception {
        File badMessage;
        Document doc;
        block13: {
            doc = null;
            try {
                doc = XMLTools.parseXmlFile(this.file, false);
            }
            catch (Exception ex) {
                badMessage = new File("badmessage.xml");
                if (!this.file.renameTo(badMessage)) break block13;
                logger.log(Level.SEVERE, "Error - send the file badmessage.xml to a dev for analysis, more details below:", ex);
            }
        }
        if (doc == null) {
            throw new Exception("Error - MessageObject.loadFile: couldn't parse XML Document - File name: '" + this.file.getName() + "'");
        }
        Element rootNode = doc.getDocumentElement();
        if (rootNode.getTagName().equals("EncryptedFrostMessage")) {
            block14: {
                this.setRecipientName(XMLTools.getChildElementsCDATAValue(rootNode, "recipient"));
                if (this.getRecipientName() == null) {
                    throw new Exception("Error - encrypted message contains no 'recipient' section.");
                }
                FrostIdentities identities = Core.getIdentities();
                if (!identities.isMySelf(this.getRecipientName())) {
                    throw new MessageCreationException("Info: Encrypted message is not for me.", 1);
                }
                String base64enc = XMLTools.getChildElementsCDATAValue(rootNode, "content");
                if (base64enc == null) {
                    throw new Exception("Error - encrypted message contains no 'content' section.");
                }
                byte[] base64bytes = base64enc.getBytes("ISO-8859-1");
                byte[] encBytes = Base64.decode(base64bytes);
                LocalIdentity receiverId = identities.getLocalIdentity(this.getRecipientName());
                byte[] decContent = Core.getCrypto().decrypt(encBytes, receiverId.getPrivateKey());
                if (decContent == null) {
                    logger.log(Level.SEVERE, "TOFDN: Encrypted message could not be decrypted!");
                    throw new MessageCreationException("Error: Encrypted message could not be decrypted.", 2);
                }
                FileAccess.writeFile(decContent, this.file);
                try {
                    doc = XMLTools.parseXmlFile(this.file, false);
                }
                catch (Exception ex) {
                    File badMessage2 = new File("badmessage.xml");
                    if (!this.file.renameTo(badMessage2)) break block14;
                    logger.log(Level.SEVERE, "Error - send the file badmessage.xml to a dev for analysis, more details below:", ex);
                }
            }
            if (doc == null) {
                throw new Exception("Error - MessageObject.loadFile: couldn't parse XML Document - File name: '" + this.file.getName() + "'");
            }
            rootNode = doc.getDocumentElement();
        }
        if (!rootNode.getTagName().equals("FrostMessage")) {
            badMessage = new File("badmessage.xml");
            if (this.file.renameTo(badMessage)) {
                logger.severe("Error - send the file badmessage.xml to a dev for analysis.");
            }
            throw new Exception("Error - invalid message: does not contain the root tag 'FrostMessage'");
        }
        this.loadXMLElement(rootNode);
    }

    public void loadXMLElement(Element e) throws SAXException {
        List<Element> l;
        this.setMessageId(XMLTools.getChildElementsCDATAValue(e, "MessageId"));
        this.setInReplyTo(XMLTools.getChildElementsCDATAValue(e, "InReplyTo"));
        this.setFromName(XMLTools.getChildElementsCDATAValue(e, "From"));
        this.setSubject(XMLTools.getChildElementsCDATAValue(e, "Subject"));
        this.dateStr = XMLTools.getChildElementsCDATAValue(e, "Date");
        this.timeStr = XMLTools.getChildElementsCDATAValue(e, "Time");
        this.setPublicKey(XMLTools.getChildElementsCDATAValue(e, "pubKey"));
        this.setRecipientName(XMLTools.getChildElementsCDATAValue(e, "recipient"));
        this.setBoardName(XMLTools.getChildElementsCDATAValue(e, "Board"));
        this.setContent(XMLTools.getChildElementsCDATAValue(e, "Body"));
        this.setSignatureV1(XMLTools.getChildElementsCDATAValue(e, "Signature"));
        this.setSignatureV2(XMLTools.getChildElementsCDATAValue(e, "SignatureV2"));
        String idLinePosStr = XMLTools.getChildElementsTextValue(e, "IdLinePos");
        String idLineLenStr = XMLTools.getChildElementsTextValue(e, "IdLineLen");
        this.setIdLinePosLen(idLinePosStr, idLineLenStr, this.getContent() != null ? this.getContent().length() : 0);
        String sigstat = XMLTools.getChildElementsCDATAValue(e, "signatureStatus");
        if (sigstat != null && (sigstat = sigstat.trim()).length() > 0) {
            this.setSignatureStatusFromString(sigstat);
        }
        if ((l = XMLTools.getChildElementsByTagName(e, "AttachmentList")).size() > 0) {
            Element attachmentsElement = l.get(0);
            this.getAttachmentList().loadXMLElement(attachmentsElement);
        }
    }

    private void setIdLinePosLen(String pos, String len, int contentLen) {
        if (pos == null || len == null || pos.length() == 0 || len.length() == 0) {
            return;
        }
        int p = -1;
        int l = -1;
        try {
            p = Integer.parseInt(pos);
            l = Integer.parseInt(len);
        }
        catch (Throwable t) {
            return;
        }
        if (p < 0 || l < 0) {
            return;
        }
        if (p + l > contentLen) {
            return;
        }
        this.setIdLinePos(p);
        this.setIdLineLen(l);
    }

    public void setFile(File f) {
        this.file = f;
    }

    public boolean save() {
        if (this.file == null) {
            logger.log(Level.SEVERE, "Error: internal File pointer is not set");
            return false;
        }
        return this.saveToFile(this.file);
    }

    public boolean saveToFile(File f) {
        File tmpFile = new File(f.getPath() + "sav.tmp");
        boolean success = false;
        try {
            Document doc = XMLTools.createDomDocument();
            doc.appendChild(this.getXMLElement(doc));
            success = XMLTools.writeXmlFile(doc, tmpFile.getPath());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while saving message.", e);
        }
        if (success && tmpFile.length() > 0L) {
            if (f.isFile() && !f.delete()) {
                logger.log(Level.SEVERE, "Error while saving message, delete failed.");
            }
            if (!tmpFile.renameTo(f)) {
                logger.log(Level.SEVERE, "Error while saving message, renameTo failed.");
                return false;
            }
        } else {
            tmpFile.delete();
        }
        return success;
    }

    public static boolean encryptForRecipientAndSaveCopy(File msgFile, Identity recipient, File targetFile) {
        String base64enc;
        byte[] xmlContent = FileAccess.readByteArray(msgFile);
        byte[] encContent = Core.getCrypto().encrypt(xmlContent, recipient.getPublicKey());
        try {
            base64enc = new String(Base64.encode(encContent), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, "ISO-8859-1 encoding is not supported.", ex);
            return false;
        }
        Document doc = XMLTools.createDomDocument();
        Element el = doc.createElement("EncryptedFrostMessage");
        Element current = doc.createElement("recipient");
        CDATASection cdata = doc.createCDATASection(recipient.getUniqueName());
        current.appendChild(cdata);
        el.appendChild(current);
        current = doc.createElement("content");
        cdata = doc.createCDATASection(base64enc);
        current.appendChild(cdata);
        el.appendChild(current);
        doc.appendChild(el);
        return XMLTools.writeXmlFile(doc, targetFile.getPath());
    }

    public boolean compareTo(File otherMsgFile) {
        try {
            MessageXmlFile otherMessage = new MessageXmlFile(otherMsgFile);
            return this.compareTo(otherMessage);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Handled Exception in compareTo(File otherMsgFile)", t);
            return false;
        }
    }

    public boolean compareTo(MessageXmlFile otherMsg) {
        try {
            if (!this.getContent().equals(otherMsg.getContent())) {
                return false;
            }
            if (!this.getSubject().equals(otherMsg.getSubject())) {
                return false;
            }
            if (!this.getFromName().equals(otherMsg.getFromName())) {
                return false;
            }
            AttachmentList attachments1 = otherMsg.getAttachmentList();
            AttachmentList attachments2 = this.getAttachmentList();
            if (attachments1.size() != attachments2.size()) {
                return false;
            }
            Iterator iterator1 = attachments1.iterator();
            Iterator iterator2 = attachments2.iterator();
            while (iterator1.hasNext()) {
                Attachment attachment2;
                Attachment attachment1 = (Attachment)iterator1.next();
                if (attachment1.compareTo(attachment2 = (Attachment)iterator2.next()) == 0) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Handled Exception in compareTo(MessageObject otherMsg)", t);
            return false;
        }
    }

    public String getBoardName() {
        return this.boardName;
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public String getTimeStr() {
        return this.timeStr;
    }

    public void setBoardName(String board) {
        this.boardName = board;
    }

    public boolean isMessageNew() {
        File newMessage = new File(this.getFile().getPath() + ".lck");
        return newMessage.isFile();
    }

    public DateTime getDateAndTime() throws Throwable {
        if (this.dateAndTime == null) {
            long millis = DateFun.FORMAT_DATE.parseDateTime(this.getDateStr()).getMillis() + DateFun.FORMAT_TIME.parseDateTime(this.getTimeStr()).getMillis();
            this.dateAndTime = new DateTime(millis, DateTimeZone.UTC);
        }
        return this.dateAndTime;
    }

    public void setDateAndTime(DateTime dt) {
        this.dateAndTime = dt;
        this.dateStr = DateFun.FORMAT_DATE.print(dt);
        this.timeStr = DateFun.FORMAT_TIME_EXT.print(dt);
    }
}

