/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.messages.Attachment;
import frost.util.XMLTools;
import frost.util.XMLizable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AttachmentList
extends LinkedList
implements XMLizable {
    private static final Logger logger = Logger.getLogger(AttachmentList.class.getName());

    public AttachmentList getAllOfType(int type) {
        assert (type == 0 || type == 1 || type == 2) : "list of unknown type of attachments requested";
        Iterator i = this.iterator();
        AttachmentList result = new AttachmentList();
        while (i.hasNext()) {
            Attachment current = (Attachment)i.next();
            if (current.getType() != type) continue;
            result.add(current);
        }
        return result;
    }

    public synchronized Element getXMLElement(Document d) {
        if (this.size() == 0) {
            return null;
        }
        Element el = d.createElement("AttachmentList");
        for (Attachment current : this) {
            el.appendChild(current.getXMLElement(d));
        }
        return el;
    }

    public void loadXMLElement(Element el) throws SAXException {
        if (el == null) {
            return;
        }
        for (Element current : XMLTools.getChildElementsByTagName(el, "Attachment")) {
            Attachment attachment = Attachment.getInstance(current);
            this.add(attachment);
        }
        if (this.size() == 0) {
            logger.info("empty attachment list upon creation");
        }
    }
}

