/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.sentmessages;

import frost.gui.sentmessages.SentMessagesTableItem;
import frost.messages.FrostMessageObject;
import frost.messages.SentMessagesManager;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.util.LinkedList;
import java.util.List;

public class SentMessagesTableModel
extends SortedModel {
    public SentMessagesTableModel(SortedTableFormat f) {
        super(f);
    }

    public void loadTableModel() {
        List<FrostMessageObject> msgs = SentMessagesManager.retrieveSentMessages();
        for (FrostMessageObject mo : msgs) {
            SentMessagesTableItem item = new SentMessagesTableItem(mo);
            this.addSendMessageItem(item);
        }
    }

    public void addSendMessageItem(SentMessagesTableItem item) {
        this.addItem(item);
    }

    public void addFrostMessageObject(FrostMessageObject mo) {
        SentMessagesTableItem item = new SentMessagesTableItem(mo);
        this.addSendMessageItem(item);
    }

    public boolean removeItems(ModelItem[] selectedItems) {
        LinkedList<FrostMessageObject> itemsToDelete = new LinkedList<FrostMessageObject>();
        for (int x = selectedItems.length - 1; x >= 0; --x) {
            SentMessagesTableItem item = (SentMessagesTableItem)selectedItems[x];
            itemsToDelete.add(item.getFrostMessageObject());
        }
        if (SentMessagesManager.deleteSentMessages(itemsToDelete) == 0) {
            return false;
        }
        boolean retval = super.removeItems(selectedItems);
        return retval;
    }
}

