/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.sentmessages;

import frost.Core;
import frost.MainFrame;
import frost.gui.MessageWindow;
import frost.gui.sentmessages.SentMessagesTableFormat;
import frost.gui.sentmessages.SentMessagesTableItem;
import frost.gui.sentmessages.SentMessagesTableModel;
import frost.messages.FrostMessageObject;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SentMessagesTable
extends SortedModelTable {
    private SentMessagesTableModel tableModel;
    private SentMessagesTableFormat tableFormat;
    private PopupMenuSearch popupMenuSearch = null;
    private Language language = Language.getInstance();

    public SentMessagesTable() {
        this(new SentMessagesTableModel(new SentMessagesTableFormat()));
    }

    private SentMessagesTable(SentMessagesTableModel m) {
        super(m);
        this.tableModel = m;
        this.tableFormat = (SentMessagesTableFormat)m.getTableFormat();
        this.setupTableFont();
        this.getTable().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Listener l = new Listener();
        this.getTable().addMouseListener(l);
        this.getScrollPane().addMouseListener(l);
    }

    public void addSentMessage(FrostMessageObject i) {
        this.tableModel.addFrostMessageObject(i);
        MainFrame.getInstance().getSentMessagesPanel().updateSentMessagesCount();
    }

    public void saveTableFormat() {
        this.tableFormat.saveTableLayout();
    }

    public void loadTableModel() {
        this.tableModel.loadTableModel();
        MainFrame.getInstance().getSentMessagesPanel().updateSentMessagesCount();
    }

    public void clearTableModel() {
        this.tableModel.clear();
    }

    private PopupMenuSearch getPopupMenuSearch() {
        if (this.popupMenuSearch == null) {
            this.popupMenuSearch = new PopupMenuSearch();
            this.language.addLanguageListener(this.popupMenuSearch);
        }
        return this.popupMenuSearch;
    }

    private void setupTableFont() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.getTable().setFont(font);
    }

    private void tableDoubleClick(MouseEvent e) {
        ModelItem item;
        int row = this.getTable().rowAtPoint(e.getPoint());
        if (row > -1 && (item = this.getItemAt(row)) != null) {
            FrostMessageObject sm = ((SentMessagesTableItem)item).getFrostMessageObject();
            MessageWindow messageWindow = new MessageWindow((Window)MainFrame.getInstance(), sm, MainFrame.getInstance().getSentMessagesPanel().getSize(), false);
            messageWindow.setVisible(true);
        }
    }

    private class PopupMenuSearch
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        JMenuItem deleteItem = new JMenuItem();

        public PopupMenuSearch() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.deleteItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.deleteItem.setText(SentMessagesTable.this.language.getString("SentMessages.table.popup.deleteMessage"));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.deleteItem) {
                this.deleteSelectedMessages();
            }
        }

        private void deleteSelectedMessages() {
            ModelItem[] selectedItems = SentMessagesTable.this.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            int answer = selectedItems.length == 1 ? JOptionPane.showConfirmDialog(MainFrame.getInstance(), SentMessagesTable.this.language.getString("SentMessages.confirmDeleteOneMessageDialog.text"), SentMessagesTable.this.language.getString("SentMessages.confirmDeleteOneMessageDialog.title"), 0, 3) : JOptionPane.showConfirmDialog(MainFrame.getInstance(), SentMessagesTable.this.language.formatMessage("SentMessages.confirmDeleteMessagesDialog.text", Integer.toString(selectedItems.length)), SentMessagesTable.this.language.getString("SentMessages.confirmDeleteMessagesDialog.title"), 0, 3);
            if (answer != 0) {
                return;
            }
            SentMessagesTable.this.tableModel.removeItems(selectedItems);
            MainFrame.getInstance().getSentMessagesPanel().updateSentMessagesCount();
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            ModelItem[] selectedItems = SentMessagesTable.this.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            this.add(this.deleteItem);
            super.show(invoker, x, y);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == SentMessagesTable.this.getTable()) {
                    SentMessagesTable.this.tableDoubleClick(e);
                }
            } else if (e.isPopupTrigger() && (e.getSource() == SentMessagesTable.this.getTable() || e.getSource() == SentMessagesTable.this.getScrollPane())) {
                this.showSearchTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == SentMessagesTable.this.getTable() || e.getSource() == SentMessagesTable.this.getScrollPane())) {
                this.showSearchTablePopupMenu(e);
            }
        }

        private void showSearchTablePopupMenu(MouseEvent e) {
            Point p = e.getPoint();
            int y = SentMessagesTable.this.getTable().rowAtPoint(p);
            if (y < 0) {
                return;
            }
            if (!SentMessagesTable.this.getTable().getSelectionModel().isSelectedIndex(y)) {
                SentMessagesTable.this.getTable().getSelectionModel().setSelectionInterval(y, y);
            }
            SentMessagesTable.this.getPopupMenuSearch().show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

