/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.FontChooser;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class DisplayBoardTreePanel
extends JPanel {
    private JDialog owner = null;
    private SettingsClass settings = null;
    private Language language = null;
    private final JCheckBox showBoardDescTooltipsCheckBox = new JCheckBox();
    private final JCheckBox showBoardUpdateCountCheckBox = new JCheckBox();
    private final JCheckBox preventBoardtreeReordering = new JCheckBox();
    private final JCheckBox showFlaggedStarredIndicators = new JCheckBox();
    private final JCheckBox showBoardUpdateVisualizationCheckBox = new JCheckBox();
    private JPanel colorPanel = null;
    private final JButton selectedColorButton = new JButton();
    private final JLabel selectedColorTextLabel = new JLabel();
    private final JLabel selectedColorLabel = new JLabel();
    private final JButton notSelectedColorButton = new JButton();
    private final JLabel notSelectedColorTextLabel = new JLabel();
    private final JLabel notSelectedColorLabel = new JLabel();
    private Color selectedColor = null;
    private Color notSelectedColor = null;
    private final Listener listener = new Listener();
    private final JLabel boardTreeLabel = new JLabel();
    private final JButton boardTreeButton = new JButton();
    private final JLabel selectedBoardTreeFontLabel = new JLabel();
    private final JLabel fontsLabel = new JLabel();
    private Font selectedBodyFont = null;

    protected DisplayBoardTreePanel(JDialog owner, SettingsClass settings) {
        this.owner = owner;
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    public void cancel() {
    }

    private JPanel getColorPanel() {
        if (this.colorPanel == null) {
            this.colorPanel = new JPanel(new GridBagLayout());
            this.colorPanel.setBorder(new EmptyBorder(5, 30, 5, 5));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(0, 5, 5, 5);
            constraints.weighty = 1.0;
            constraints.weightx = 1.0;
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.5;
            this.colorPanel.add((Component)this.selectedColorTextLabel, constraints);
            constraints.fill = 3;
            constraints.gridx = 1;
            constraints.weightx = 0.2;
            this.colorPanel.add((Component)this.selectedColorLabel, constraints);
            constraints.fill = 0;
            constraints.gridx = 2;
            constraints.weightx = 0.5;
            this.colorPanel.add((Component)this.selectedColorButton, constraints);
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 0.5;
            this.colorPanel.add((Component)this.notSelectedColorTextLabel, constraints);
            constraints.fill = 3;
            constraints.gridx = 1;
            constraints.weightx = 0.2;
            this.colorPanel.add((Component)this.notSelectedColorLabel, constraints);
            constraints.fill = 0;
            constraints.gridx = 2;
            constraints.weightx = 0.5;
            this.colorPanel.add((Component)this.notSelectedColorButton, constraints);
            this.selectedColorLabel.setOpaque(true);
            this.notSelectedColorLabel.setOpaque(true);
            this.selectedColorLabel.setBorder(new BevelBorder(1));
            this.notSelectedColorLabel.setBorder(new BevelBorder(1));
            this.selectedColorLabel.setHorizontalAlignment(0);
            this.notSelectedColorLabel.setHorizontalAlignment(0);
        }
        return this.colorPanel;
    }

    private void initialize() {
        Insets inset5511;
        this.setName("DisplayPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets = inset5511 = new Insets(5, 5, 1, 1);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.fontsLabel, constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)this.getFontsPanel(), constraints);
        constraints.fill = 1;
        ++constraints.gridy;
        this.add((Component)this.showBoardUpdateVisualizationCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.getColorPanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.showBoardUpdateCountCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.showBoardDescTooltipsCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.preventBoardtreeReordering, constraints);
        ++constraints.gridy;
        this.add((Component)this.showFlaggedStarredIndicators, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new JLabel(""), constraints);
        this.selectedColorButton.addActionListener(this.listener);
        this.notSelectedColorButton.addActionListener(this.listener);
        this.showBoardUpdateVisualizationCheckBox.addActionListener(this.listener);
        this.boardTreeButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        String fontName = this.settings.getValue("boardTreeFontName");
        int fontSize = this.settings.getIntValue("boardTreeFontSize");
        int fontStyle = this.settings.getIntValue("boardTreeFontStyle");
        this.selectedBodyFont = new Font(fontName, fontStyle, fontSize);
        this.selectedBoardTreeFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        this.showBoardUpdateCountCheckBox.setSelected(this.settings.getBoolValue("showBoardUpdatedCount"));
        this.showBoardDescTooltipsCheckBox.setSelected(this.settings.getBoolValue("showBoardDescriptionTooltips"));
        this.preventBoardtreeReordering.setSelected(this.settings.getBoolValue("preventBoardTreeReordering"));
        this.showFlaggedStarredIndicators.setSelected(this.settings.getBoolValue("showBoardtreeFlaggedStarredIndicators"));
        this.showBoardUpdateVisualizationCheckBox.setSelected(this.settings.getBoolValue("boardUpdateVisualization"));
        this.refreshUpdateState();
        this.selectedColor = (Color)this.settings.getObjectValue("boardUpdatingSelectedBackgroundColor");
        this.notSelectedColor = (Color)this.settings.getObjectValue("boardUpdatingNonSelectedBackgroundColor");
        this.selectedColorLabel.setBackground(this.selectedColor);
        this.notSelectedColorLabel.setBackground(this.notSelectedColor);
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.fontsLabel.setText(this.language.getString("Options.display.fonts"));
        this.boardTreeLabel.setText(this.language.getString("Options.display.boardTree"));
        this.boardTreeButton.setText(this.language.getString("Options.display.choose"));
        this.selectedBoardTreeFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        this.showBoardUpdateCountCheckBox.setText(this.language.getString("Options.display.showBoardUpdateCount"));
        this.showBoardDescTooltipsCheckBox.setText(this.language.getString("Options.display.showTooltipWithBoardDescriptionInBoardTree"));
        this.preventBoardtreeReordering.setText(this.language.getString("Options.display.preventBoardtreeReordering"));
        this.showFlaggedStarredIndicators.setText(this.language.getString("Options.display.showBoardtreeFlaggedStarredIndicators"));
        String on = this.language.getString("Options.common.on");
        String color = this.language.getString("Options.news.3.color");
        String choose = this.language.getString("Options.news.3.choose");
        this.showBoardUpdateVisualizationCheckBox.setText(this.language.getString("Options.news.3.showBoardUpdateVisualization") + " (" + on + ")");
        this.selectedColorTextLabel.setText(this.language.getString("Options.news.3.backgroundColorIfUpdatingBoardIsSelected"));
        this.selectedColorLabel.setText("    " + color + "    ");
        this.selectedColorButton.setText(choose);
        this.notSelectedColorTextLabel.setText(this.language.getString("Options.news.3.backgroundColorIfUpdatingBoardIsNotSelected"));
        this.notSelectedColorLabel.setText("    " + color + "    ");
        this.notSelectedColorButton.setText(choose);
    }

    private void saveSettings() {
        if (this.selectedBodyFont != null) {
            this.settings.setValue("boardTreeFontName", this.selectedBodyFont.getFamily());
            this.settings.setValue("boardTreeFontStyle", this.selectedBodyFont.getStyle());
            this.settings.setValue("boardTreeFontSize", this.selectedBodyFont.getSize());
        }
        this.settings.setValue("showBoardUpdatedCount", this.showBoardUpdateCountCheckBox.isSelected());
        this.settings.setValue("showBoardDescriptionTooltips", this.showBoardDescTooltipsCheckBox.isSelected());
        this.settings.setValue("preventBoardTreeReordering", this.preventBoardtreeReordering.isSelected());
        this.settings.setValue("showBoardtreeFlaggedStarredIndicators", this.showFlaggedStarredIndicators.isSelected());
        this.settings.setValue("boardUpdateVisualization", this.showBoardUpdateVisualizationCheckBox.isSelected());
        this.settings.setObjectValue("boardUpdatingSelectedBackgroundColor", this.selectedColor);
        this.settings.setObjectValue("boardUpdatingNonSelectedBackgroundColor", this.notSelectedColor);
    }

    private void selectedColorPressed() {
        Color newCol = JColorChooser.showDialog(this.getTopLevelAncestor(), this.language.getString("Options.news.3.colorChooserDialog.title.chooseUpdatingColorOfSelectedBoards"), this.selectedColor);
        if (newCol != null) {
            this.selectedColor = newCol;
            this.selectedColorLabel.setBackground(this.selectedColor);
        }
    }

    private void notSelectedColorPressed() {
        Color newCol = JColorChooser.showDialog(this.getTopLevelAncestor(), this.language.getString("Options.news.3.colorChooserDialog.title.chooseUpdatingColorOfUnselectedBoards"), this.notSelectedColor);
        if (newCol != null) {
            this.notSelectedColor = newCol;
            this.notSelectedColorLabel.setBackground(this.notSelectedColor);
        }
    }

    private void refreshUpdateState() {
        MiscToolkit.setContainerEnabled(this.getColorPanel(), this.showBoardUpdateVisualizationCheckBox.isSelected());
    }

    private JPanel getFontsPanel() {
        JPanel fontsPanel = new JPanel(new GridBagLayout());
        fontsPanel.setBorder(new EmptyBorder(5, 20, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        Insets inset1515 = new Insets(1, 5, 1, 5);
        Insets inset1519 = new Insets(1, 5, 1, 9);
        constraints.insets = inset1515;
        constraints.gridx = 0;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.boardTreeLabel, constraints);
        constraints.insets = inset1519;
        constraints.gridx = 1;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.boardTreeButton, constraints);
        constraints.insets = inset1515;
        constraints.gridx = 2;
        constraints.gridy = 0;
        fontsPanel.add((Component)this.selectedBoardTreeFontLabel, constraints);
        return fontsPanel;
    }

    private String getFontLabel(Font font) {
        if (font == null) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append(font.getFamily());
        if (font.isBold()) {
            returnValue.append(" " + this.language.getString("Options.display.fontChooser.bold"));
        }
        if (font.isItalic()) {
            returnValue.append(" " + this.language.getString("Options.display.fontChooser.italic"));
        }
        returnValue.append(", " + font.getSize());
        return returnValue.toString();
    }

    private void boardTreeButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedBodyFont);
        fontChooser.setVisible(true);
        Font selectedFontTemp = fontChooser.getSelectedFont();
        if (selectedFontTemp != null) {
            this.selectedBodyFont = selectedFontTemp;
            this.selectedBoardTreeFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DisplayBoardTreePanel.this.selectedColorButton) {
                DisplayBoardTreePanel.this.selectedColorPressed();
            } else if (e.getSource() == DisplayBoardTreePanel.this.notSelectedColorButton) {
                DisplayBoardTreePanel.this.notSelectedColorPressed();
            } else if (e.getSource() == DisplayBoardTreePanel.this.showBoardUpdateVisualizationCheckBox) {
                DisplayBoardTreePanel.this.refreshUpdateState();
            } else if (e.getSource() == DisplayBoardTreePanel.this.boardTreeButton) {
                DisplayBoardTreePanel.this.boardTreeButtonPressed();
            }
        }
    }
}

