/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.messagetreetable;

import frost.gui.messagetreetable.MessageTreeTable;
import frost.gui.messagetreetable.TreeTableModel;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    final JTree tree;
    final MessageTreeTable treeTable;
    final TreeTableModel treeTableModel;
    private int collapsedToRow = -1;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree, MessageTreeTable tt) {
        this.tree = tree;
        this.treeTable = tt;
        this.treeTableModel = treeTableModel;
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultMutableTreeNode collapsedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                int nodeRow = TreeTableModelAdapter.this.treeTable.getRowForNode(collapsedNode);
                int fromRow = nodeRow + 1;
                int toRow = nodeRow;
                if (collapsedNode.getChildCount() > 0) {
                    toRow += collapsedNode.getChildCount();
                }
                Enumeration<TreePath> e = TreeTableModelAdapter.this.treeTable.getTree().getExpandedDescendants(event.getPath());
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement().getLastPathComponent();
                    toRow += n.getChildCount();
                }
                if (toRow < fromRow) {
                    toRow = fromRow;
                }
                TreeTableModelAdapter.this.collapsedToRow = toRow;
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                int nodeRow = TreeTableModelAdapter.this.treeTable.getRowForNode(expandedNode);
                int fromRow = nodeRow + 1;
                int toRow = nodeRow;
                if (expandedNode.getChildCount() > 0) {
                    toRow += expandedNode.getChildCount();
                }
                Enumeration<TreePath> e = TreeTableModelAdapter.this.treeTable.getTree().getExpandedDescendants(event.getPath());
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement().getLastPathComponent();
                    toRow += n.getChildCount();
                }
                if (toRow < fromRow) {
                    toRow = fromRow;
                }
                TreeTableModelAdapter.this.fireTableRowsInserted(fromRow, toRow);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                DefaultMutableTreeNode collapsedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                int nodeRow = TreeTableModelAdapter.this.treeTable.getRowForNode(collapsedNode);
                int fromRow = nodeRow + 1;
                int toRow = TreeTableModelAdapter.this.collapsedToRow;
                TreeTableModelAdapter.this.fireTableRowsDeleted(fromRow, toRow);
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int[] childIndices = e.getChildIndices();
                if (childIndices.length != 1) {
                    System.out.println("****** FIXME1: more than 1 child: " + childIndices.length + " ********");
                }
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(childIndices[0]);
                final int row = TreeTableModelAdapter.this.treeTable.getRowForNode(childNode);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                    }
                });
            }

            public void treeNodesInserted(TreeModelEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int[] childIndices = e.getChildIndices();
                if (childIndices.length != 1) {
                    System.out.println("****** FIXME2: more than 1 child: " + childIndices.length + " ********");
                }
                boolean offset = false;
                final int row = TreeTableModelAdapter.this.treeTable.getRowForNode(node) + 0 + childIndices[0];
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TreeTableModelAdapter.this.fireTableRowsInserted(row, row);
                    }
                });
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                System.out.println("treeNodesRemoved");
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int[] childIndices = e.getChildIndices();
                if (childIndices.length != 1) {
                    System.out.println("****** FIXME3: more than 1 child: " + childIndices.length + " ********");
                }
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(childIndices[0]);
                final int row = TreeTableModelAdapter.this.treeTable.getRowForNode(childNode);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TreeTableModelAdapter.this.fireTableRowsDeleted(row, row);
                    }
                });
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    public Object getRow(int row) {
        return this.nodeForRow(row);
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }
}

