/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.messagetreetable;

import frost.messages.FrostMessageObject;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTreeTableSortStateBean {
    private static boolean isThreaded;
    private static final int defaultSortedColumn = 7;
    private static final boolean defaultIsAscending = false;
    private static int sortedColumn;
    private static boolean isAscending;
    private static FlaggedComparator flaggedComparatorAscending;
    private static FlaggedComparator flaggedComparatorDescending;
    private static StarredComparator starredComparatorAscending;
    private static StarredComparator starredComparatorDescending;
    private static JunkComparator junkComparatorAscending;
    private static JunkComparator junkComparatorDescending;
    private static SubjectComparator subjectComparatorAscending;
    private static SubjectComparator subjectComparatorDescending;
    private static FromComparator fromComparatorAscending;
    private static FromComparator fromComparatorDescending;
    private static TrustStateComparator trustStateComparatorAscending;
    private static TrustStateComparator trustStateComparatorDescending;
    public static DateComparator dateComparatorAscending;
    public static DateComparator dateComparatorDescending;
    public static IndexComparator indexComparatorAscending;
    public static IndexComparator indexComparatorDescending;
    private static Comparator<FrostMessageObject>[] ascendingComparators;
    private static Comparator<FrostMessageObject>[] descendingComparators;

    public static boolean isAscending() {
        return isAscending;
    }

    public static void setAscending(boolean isAscending) {
        MessageTreeTableSortStateBean.isAscending = isAscending;
    }

    public static boolean isThreaded() {
        return isThreaded;
    }

    public static void setThreaded(boolean isThreaded) {
        MessageTreeTableSortStateBean.isThreaded = isThreaded;
    }

    public static int getSortedColumn() {
        return sortedColumn;
    }

    public static void setSortedColumn(int sortedColumn) {
        MessageTreeTableSortStateBean.sortedColumn = sortedColumn;
    }

    public static void setDefaults() {
        MessageTreeTableSortStateBean.setSortedColumn(7);
        MessageTreeTableSortStateBean.setAscending(false);
    }

    public static Comparator<FrostMessageObject> getComparator(int column, boolean ascending) {
        if (ascending) {
            return ascendingComparators[column];
        }
        return descendingComparators[column];
    }

    static {
        sortedColumn = 7;
        isAscending = false;
        flaggedComparatorAscending = new FlaggedComparator(true);
        flaggedComparatorDescending = new FlaggedComparator(false);
        starredComparatorAscending = new StarredComparator(true);
        starredComparatorDescending = new StarredComparator(false);
        junkComparatorAscending = new JunkComparator(true);
        junkComparatorDescending = new JunkComparator(false);
        subjectComparatorAscending = new SubjectComparator(true);
        subjectComparatorDescending = new SubjectComparator(false);
        fromComparatorAscending = new FromComparator(true);
        fromComparatorDescending = new FromComparator(false);
        trustStateComparatorAscending = new TrustStateComparator(true);
        trustStateComparatorDescending = new TrustStateComparator(false);
        dateComparatorAscending = new DateComparator(true);
        dateComparatorDescending = new DateComparator(false);
        indexComparatorAscending = new IndexComparator(true);
        indexComparatorDescending = new IndexComparator(false);
        ascendingComparators = new Comparator[]{flaggedComparatorAscending, starredComparatorAscending, subjectComparatorAscending, fromComparatorAscending, indexComparatorAscending, junkComparatorAscending, trustStateComparatorAscending, dateComparatorAscending};
        descendingComparators = new Comparator[]{flaggedComparatorDescending, starredComparatorDescending, subjectComparatorDescending, fromComparatorDescending, indexComparatorDescending, junkComparatorDescending, trustStateComparatorDescending, dateComparatorDescending};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JunkComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public JunkComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            boolean s2;
            boolean s1 = t1.isJunk();
            if (s1 == (s2 = t2.isJunk())) {
                return 0;
            }
            if (s1) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public IndexComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            int s2;
            int s1 = t1.getIndex();
            if (s1 == (s2 = t2.getIndex())) {
                return 0;
            }
            if (s1 > s2) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StarredComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public StarredComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            boolean s2;
            boolean s1 = t1.isStarred();
            if (s1 == (s2 = t2.isStarred())) {
                return 0;
            }
            if (s1) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlaggedComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public FlaggedComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            boolean s2;
            boolean s1 = t1.isFlagged();
            if (s1 == (s2 = t2.isFlagged())) {
                return 0;
            }
            if (s1) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrustStateComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public TrustStateComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            String s1 = t1.getMessageStatusString();
            String s2 = t2.getMessageStatusString();
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return -1;
            }
            if (s1 != null && s2 == null) {
                return 1;
            }
            int r = s1.compareTo(s2);
            if (r == 0) {
                return r;
            }
            if (r > 0) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public FromComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            String s1 = t1.getFromName();
            String s2 = t2.getFromName();
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return -1;
            }
            if (s1 != null && s2 == null) {
                return 1;
            }
            int r = s1.compareTo(s2);
            if (r == 0) {
                return r;
            }
            if (r > 0) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubjectComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public SubjectComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            String s1 = t1.getSubject();
            String s2 = t2.getSubject();
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return -1;
            }
            if (s1 != null && s2 == null) {
                return 1;
            }
            int r = s1.toLowerCase().compareTo(s2.toLowerCase());
            if (r == 0) {
                return r;
            }
            if (r > 0) {
                return this.retvalGreater;
            }
            return this.retvalSmaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateComparator
    implements Comparator<FrostMessageObject> {
        private int retvalGreater;
        private int retvalSmaller;

        public DateComparator(boolean ascending) {
            if (ascending) {
                this.retvalGreater = 1;
                this.retvalSmaller = -1;
            } else {
                this.retvalGreater = -1;
                this.retvalSmaller = 1;
            }
        }

        @Override
        public int compare(FrostMessageObject t1, FrostMessageObject t2) {
            long l2;
            long l1 = t1.getDateAndTime().getMillis();
            if (l1 > (l2 = t2.getDateAndTime().getMillis())) {
                return this.retvalGreater;
            }
            if (l1 < l2) {
                return this.retvalSmaller;
            }
            return 0;
        }
    }
}

