/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.help;

import frost.gui.help.HelpHTMLEditorKit;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class HelpBrowser
extends JPanel {
    private static final Logger logger = Logger.getLogger(HelpBrowser.class.getName());
    private static Language language = Language.getInstance();
    private final String url_prefix;
    private final String homePage;
    private BrowserHistory browserHistory = null;
    JFrame parent;
    JButton backButton;
    JButton homeButton;
    JButton forwardButton;
    JTextField TFsearchTxt;
    JButton BfindNext;
    JButton BfindPrev;
    JEditorPane editorPane;
    HelpHTMLEditorKit helpHTMLEditorKit;
    int lastSearchPosStart = 0;
    int lastSearchPosEnd = 0;
    String lastSearchText = null;

    public HelpBrowser(JFrame parent, String locale, String zipfile, String homePage) {
        this.parent = parent;
        this.url_prefix = zipfile;
        this.homePage = homePage;
        this.setHelpLocale(locale);
        this.init();
    }

    private void init() {
        this.browserHistory = new BrowserHistory();
        this.browserHistory.resetToHomepage(this.homePage);
        this.editorPane = new JEditorPane();
        this.editorPane.setCaret(new SelectionPreservingCaret());
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    ((JEditorPane)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    ((JEditorPane)e.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ((JEditorPane)e.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                    HelpBrowser.this.browserHistory.setCurrentPage(e.getURL().toString());
                    HelpBrowser.this.setHelpPage(e.getURL().toString());
                }
            }
        });
        this.editorPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpBrowser.this.showEditorPanePopupMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpBrowser.this.showEditorPanePopupMenu(e);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        scrollPane.setWheelScrollingEnabled(true);
        this.backButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-previous.png"));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HelpBrowser.this.browserHistory.isBackwardPossible()) {
                    HelpBrowser.this.setHelpPage(HelpBrowser.this.browserHistory.backwardPage());
                }
            }
        });
        this.forwardButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-next.png"));
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HelpBrowser.this.browserHistory.isForwardPossible()) {
                    HelpBrowser.this.setHelpPage(HelpBrowser.this.browserHistory.forwardPage());
                }
            }
        });
        this.homeButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-home.png"));
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.browserHistory.resetToHomepage(HelpBrowser.this.homePage);
                HelpBrowser.this.setHelpPage(HelpBrowser.this.homePage);
            }
        });
        JLabel Lsearch = new JLabel(MiscToolkit.loadImageIcon("/data/toolbar/system-search.png"));
        this.TFsearchTxt = new JTextField(15);
        this.BfindNext = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-down.png"));
        this.BfindNext.setDefaultCapable(true);
        this.BfindNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.searchText(true);
            }
        });
        this.BfindPrev = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/go-up.png"));
        this.BfindPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.searchText(false);
            }
        });
        HelpBrowser contentPanel = this;
        contentPanel.setLayout(new BorderLayout());
        JPanel buttonPanelLeft = new JPanel(new FlowLayout(0));
        buttonPanelLeft.add(this.backButton);
        buttonPanelLeft.add(this.homeButton);
        buttonPanelLeft.add(this.forwardButton);
        JPanel buttonPanelRight = new JPanel(new FlowLayout(2));
        buttonPanelRight.add(Lsearch);
        buttonPanelRight.add(this.TFsearchTxt);
        buttonPanelRight.add(this.BfindNext);
        buttonPanelRight.add(this.BfindPrev);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonPanelLeft, "West");
        buttonPanel.add((Component)buttonPanelRight, "East");
        this.editorPane.setEditable(false);
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)buttonPanel, "North");
        this.helpHTMLEditorKit = new HelpHTMLEditorKit(this.url_prefix);
        this.editorPane.setEditorKit(this.helpHTMLEditorKit);
        this.setHelpPage(this.homePage);
    }

    private void showEditorPanePopupMenu(MouseEvent e) {
        PopupMenuTofText p = new PopupMenuTofText(this.editorPane);
        ((JPopupMenu)p).show(e.getComponent(), e.getX(), e.getY());
    }

    private void searchText(boolean forward) {
        int pos;
        String searchTxt = this.TFsearchTxt.getText();
        if (searchTxt == null) {
            return;
        }
        if ((searchTxt = searchTxt.trim()).length() == 0) {
            return;
        }
        searchTxt = searchTxt.toLowerCase();
        if (this.lastSearchText == null) {
            this.lastSearchText = searchTxt;
        } else if (this.lastSearchText != null && !searchTxt.equals(this.lastSearchText)) {
            this.lastSearchPosStart = 0;
            this.lastSearchPosEnd = 0;
            this.lastSearchText = searchTxt;
        }
        String docTxt = null;
        try {
            docTxt = this.helpHTMLEditorKit.getHelpHTMLDocument().getText(0, this.helpHTMLEditorKit.getHelpHTMLDocument().getLength());
            docTxt = docTxt.toLowerCase();
        }
        catch (BadLocationException e1) {
            logger.log(Level.SEVERE, "Could not get text from document.", e1);
            return;
        }
        if (forward) {
            pos = docTxt.indexOf(searchTxt, this.lastSearchPosEnd);
        } else if (this.lastSearchPosStart > 0) {
            String tmpStr = docTxt.substring(0, this.lastSearchPosStart);
            pos = tmpStr.lastIndexOf(searchTxt);
        } else {
            return;
        }
        if (pos > -1) {
            int endPos = pos + searchTxt.length();
            this.editorPane.setCaretPosition(pos);
            this.editorPane.moveCaretPosition(endPos);
            this.lastSearchPosStart = pos;
            this.lastSearchPosEnd = endPos;
        } else {
            this.editorPane.setCaretPosition(0);
            this.lastSearchPosStart = 0;
            this.lastSearchPosEnd = 0;
        }
    }

    void setHelpPage(String url) {
        if (url == null) {
            url = this.homePage;
        }
        if (url.startsWith(this.url_prefix)) {
            url = url.substring(this.url_prefix.length());
        }
        try {
            this.editorPane.setPage(this.url_prefix + url);
            this.lastSearchPosStart = 0;
            this.lastSearchPosEnd = 0;
            this.lastSearchText = null;
            this.editorPane.requestFocus();
        }
        catch (IOException e1) {
            logger.log(Level.INFO, "HELP: Missing file: '" + url + "'");
        }
        this.updateBrowserButtons();
    }

    private void updateBrowserButtons() {
        this.forwardButton.setEnabled(this.browserHistory.isForwardPossible());
        this.backButton.setEnabled(this.browserHistory.isBackwardPossible());
    }

    void setHelpLocale(String newLocale) {
    }

    private class PopupMenuTofText
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener,
    ClipboardOwner {
        private Clipboard clipboard;
        private final JTextComponent sourceTextComponent;
        private final JMenuItem copyItem = new JMenuItem();
        private final JMenuItem cancelItem = new JMenuItem();

        public PopupMenuTofText(JTextComponent sourceTextComponent) {
            this.sourceTextComponent = sourceTextComponent;
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyItem) {
                StringSelection selection = new StringSelection(this.sourceTextComponent.getSelectedText());
                this.clipboard.setContents(selection, this);
            }
        }

        private void initialize() {
            this.languageChanged(null);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.clipboard = toolkit.getSystemClipboard();
            this.copyItem.addActionListener(this);
            this.add(this.copyItem);
            this.addSeparator();
            this.add(this.cancelItem);
        }

        public void languageChanged(LanguageEvent event) {
            this.copyItem.setText(language.getString("Common.copy"));
            this.cancelItem.setText(language.getString("Common.cancel"));
        }

        public void show(Component invoker, int x, int y) {
            if (this.sourceTextComponent.getSelectedText() != null) {
                this.copyItem.setEnabled(true);
            } else {
                this.copyItem.setEnabled(false);
            }
            super.show(invoker, x, y);
        }

        public void lostOwnership(Clipboard tclipboard, Transferable contents) {
        }
    }

    public class SelectionPreservingCaret
    extends DefaultCaret {
        private SelectionPreservingCaret last = null;
        private FocusEvent lastFocusEvent = null;

        public SelectionPreservingCaret() {
            int blinkRate = 500;
            Object o = UIManager.get("TextArea.caretBlinkRate");
            if (o != null && o instanceof Integer) {
                Integer rate = (Integer)o;
                blinkRate = rate;
            }
            this.setBlinkRate(blinkRate);
        }

        public void focusGained(FocusEvent evt) {
            super.focusGained(evt);
            if (this.last != null && this.last != this) {
                this.last.hide();
            }
        }

        public void focusLost(FocusEvent evt) {
            this.setVisible(false);
            this.last = this;
            this.lastFocusEvent = evt;
        }

        protected void hide() {
            if (this.last == this) {
                super.focusLost(this.lastFocusEvent);
                this.last = null;
                this.lastFocusEvent = null;
            }
        }
    }

    private class BrowserHistory {
        private final ArrayList<String> history = new ArrayList();
        private int historypos = -1;

        private BrowserHistory() {
        }

        public boolean isForwardPossible() {
            return this.historypos < this.history.size() - 1;
        }

        public String forwardPage() {
            if (!this.isForwardPossible()) {
                return null;
            }
            ++this.historypos;
            return this.history.get(this.historypos);
        }

        public boolean isBackwardPossible() {
            return this.historypos > 0;
        }

        public String backwardPage() {
            if (!this.isBackwardPossible()) {
                return null;
            }
            --this.historypos;
            return this.history.get(this.historypos);
        }

        public void setCurrentPage(String page) {
            if (this.historypos < this.history.size() - 1) {
                this.history.subList(this.historypos + 1, this.history.size()).clear();
            }
            this.history.add(page);
            ++this.historypos;
        }

        public void resetToHomepage(String homepage) {
            this.history.clear();
            this.history.add(homepage);
            this.historypos = 0;
        }
    }
}

