/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.ScrollButton;
import frost.gui.ScrollableBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class ScrollableBarUI
extends ComponentUI
implements SwingConstants,
MouseListener,
ChangeListener,
PropertyChangeListener {
    private ScrollableBar sb;
    private JViewport scroll;
    private JButton scrollF;
    private JButton scrollB;
    private boolean pressed = false;
    private int inc;

    public static ComponentUI createUI(JComponent c) {
        return new ScrollableBarUI();
    }

    public void installUI(JComponent c) {
        this.sb = (ScrollableBar)c;
        this.inc = this.sb.getIncrement();
        boolean small = this.sb.isSmallArrows();
        Object o = UIManager.get("ScrollBar.width");
        int sbSize = o != null && o instanceof Number ? ((Number)o).intValue() : 24;
        this.scrollB = this.createButton(this.sb.isHorizontal() ? 7 : 1, sbSize, small);
        this.scrollB.setVisible(false);
        this.scrollB.addMouseListener(this);
        this.scrollF = this.createButton(this.sb.isHorizontal() ? 3 : 5, sbSize, small);
        this.scrollF.setVisible(false);
        this.scrollF.addMouseListener(this);
        int axis = this.sb.isHorizontal() ? 0 : 1;
        this.sb.setLayout(new BoxLayout(this.sb, axis));
        this.scroll = new JViewport(){

            protected LayoutManager createLayoutManager() {
                return new ViewportLayout(){

                    public Dimension minimumLayoutSize(Container parent) {
                        Component view = ((JViewport)parent).getView();
                        if (view == null) {
                            return new Dimension(4, 4);
                        }
                        Dimension d = view.getPreferredSize();
                        if (ScrollableBarUI.this.sb.isHorizontal()) {
                            return new Dimension(4, (int)d.getHeight());
                        }
                        return new Dimension((int)d.getWidth(), 4);
                    }
                };
            }
        };
        Component box = this.sb.getComponent();
        this.scroll.setView(box);
        this.sb.add(this.scrollB);
        this.sb.add(this.scroll);
        this.sb.add(this.scrollF);
        this.scroll.addChangeListener(this);
        this.sb.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent c) {
        this.sb.remove(this.scrollB);
        this.sb.remove(this.scroll);
        this.sb.remove(this.scrollF);
        this.scroll.setViewPosition(new Point(0, 0));
        this.scroll.removeChangeListener(this);
        this.sb.removePropertyChangeListener(this);
    }

    protected JButton createButton(int direction, int width, boolean small) {
        ScrollButton button = new ScrollButton(direction, width, small);
        button.setAlignmentX(0.5f);
        button.setAlignmentY(0.5f);
        return button;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("increment".equals(evt.getPropertyName())) {
            this.inc = (Integer)evt.getNewValue();
        } else if ("smallArrows".equals(evt.getPropertyName())) {
            boolean small = (Boolean)evt.getNewValue();
            ((ScrollButton)this.scrollB).setSmallArrows(small);
            ((ScrollButton)this.scrollF).setSmallArrows(small);
        } else if ("component".equals(evt.getPropertyName())) {
            this.scroll.setView((Component)evt.getNewValue());
        }
    }

    public void stateChanged(ChangeEvent e) {
        boolean cond;
        boolean bl = this.sb.isHorizontal() ? this.sb.getWidth() < this.scroll.getViewSize().width : (cond = this.sb.getHeight() < this.scroll.getViewSize().height);
        if (cond) {
            this.scrollB.setVisible(true);
            this.scrollF.setVisible(true);
        } else {
            this.scrollB.setVisible(false);
            this.scrollF.setVisible(false);
            this.sb.doLayout();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.pressed = false;
    }

    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
    }

    public void mousePressed(MouseEvent e) {
        this.pressed = true;
        final Object o = e.getSource();
        Thread scroller = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                int accl = 500;
                while (ScrollableBarUI.this.pressed) {
                    Point p = ScrollableBarUI.this.scroll.getViewPosition();
                    if (ScrollableBarUI.this.sb.isHorizontal()) {
                        if (o == ScrollableBarUI.this.scrollB) {
                            p.x -= ScrollableBarUI.this.inc;
                            if (p.x < 0) {
                                p.x = 0;
                                ScrollableBarUI.this.scroll.setViewPosition(p);
                                return;
                            }
                        } else {
                            if (((ScrollableBarUI)ScrollableBarUI.this).scroll.getViewSize().width - p.x - ((ScrollableBarUI)ScrollableBarUI.this).scroll.getExtentSize().width <= ScrollableBarUI.this.inc) {
                                p.x = ((ScrollableBarUI)ScrollableBarUI.this).scroll.getViewSize().width - ((ScrollableBarUI)ScrollableBarUI.this).scroll.getExtentSize().width;
                                ScrollableBarUI.this.scroll.setViewPosition(p);
                                return;
                            }
                            p.x += ScrollableBarUI.this.inc;
                        }
                    } else if (o == ScrollableBarUI.this.scrollB) {
                        p.y -= ScrollableBarUI.this.inc;
                        if (p.y < 0) {
                            p.y = 0;
                            ScrollableBarUI.this.scroll.setViewPosition(p);
                            return;
                        }
                    } else {
                        if (((ScrollableBarUI)ScrollableBarUI.this).scroll.getViewSize().height - p.y - ((ScrollableBarUI)ScrollableBarUI.this).scroll.getExtentSize().height <= ScrollableBarUI.this.inc) {
                            p.y = ((ScrollableBarUI)ScrollableBarUI.this).scroll.getViewSize().height - ((ScrollableBarUI)ScrollableBarUI.this).scroll.getExtentSize().height;
                            ScrollableBarUI.this.scroll.setViewPosition(p);
                            return;
                        }
                        p.y += ScrollableBarUI.this.inc;
                    }
                    ScrollableBarUI.this.scroll.setViewPosition(p);
                    try {
                        Thread.sleep(accl);
                        if (accl <= 10) {
                            accl = 10;
                            continue;
                        }
                        accl /= 2;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        });
        scroller.start();
    }
}

