/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.JDialogWithDetails;
import frost.util.gui.MiscToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AboutBox
extends JDialogWithDetails {
    private static final String product = "Frost";
    private String version = null;
    private static final String copyright = "Copyright 2009 Frost Project";
    private static final String comments2 = "http://jtcfrost.sourceforge.net/";
    private final JPanel imagePanel = new JPanel();
    private final JPanel messagesPanel = new JPanel();
    private final JLabel imageLabel = new JLabel();
    private final JLabel productLabel = new JLabel();
    private final JLabel versionLabel = new JLabel();
    private final JLabel copyrightLabel = new JLabel();
    private final JLabel licenseLabel = new JLabel();
    private final JLabel websiteLabel = new JLabel();
    private static final ImageIcon frostImage = MiscToolkit.loadImageIcon("/data/jtc.jpg");

    public AboutBox(Frame parent) {
        super(parent);
        this.initialize();
    }

    private void initialize() {
        this.imageLabel.setIcon(frostImage);
        this.setTitle(this.language.getString("AboutBox.title"));
        this.setResizable(false);
        this.imagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.imagePanel.add(this.imageLabel);
        GridLayout gridLayout = new GridLayout(5, 1);
        this.messagesPanel.setLayout(gridLayout);
        this.messagesPanel.setBorder(new EmptyBorder(10, 50, 10, 10));
        this.productLabel.setText(product);
        this.versionLabel.setText(this.getVersion());
        this.copyrightLabel.setText(copyright);
        this.licenseLabel.setText(this.language.getString("AboutBox.label.openSourceProject"));
        this.websiteLabel.setText(comments2);
        this.messagesPanel.add(this.productLabel);
        this.messagesPanel.add(this.versionLabel);
        this.messagesPanel.add(this.copyrightLabel);
        this.messagesPanel.add(this.licenseLabel);
        this.messagesPanel.add(this.websiteLabel);
        this.getUserPanel().setLayout(new BorderLayout());
        this.getUserPanel().add((Component)this.imagePanel, "West");
        this.getUserPanel().add((Component)this.messagesPanel, "Center");
        this.fillDetailsArea();
    }

    private void fillDetailsArea() {
        StringBuilder details = new StringBuilder();
        details.append(this.language.getString("AboutBox.text.development") + "\n");
        details.append("   Karsten Graul\n");
        details.append("   S. Amoako (quit)\n");
        details.append("   Roman Glebov (quit)\n");
        details.append("   Jan-Thomas Czornack (quit)\n");
        details.append("   Thomas Mueller (quit)\n");
        details.append("   Jim Hunziker (quit)\n");
        details.append("   Stefan Majewski (quit)\n");
        details.append("   Edward Louis Severson IV (lazy)\n");
        details.append("   Jos\u00e9 Manuel Arnesto (quit)\n\n");
        details.append(this.language.getString("AboutBox.text.systemTrayExecutables") + "\n");
        details.append("   Ingo Franzki\n\n");
        details.append(this.language.getString("AboutBox.text.splashScreenLogo") + "\n");
        details.append("   Fr\u00e9d\u00e9ric Scheer\n\n");
        this.setDetailsText(details.toString());
    }

    private String getVersion() {
        if (this.version == null) {
            this.version = this.language.getString("AboutBox.label.version") + ": " + this.getClass().getPackage().getSpecificationVersion();
        }
        return this.version;
    }
}

