/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.DateFun;
import frost.util.FormatterUtils;
import frost.util.Mixed;
import frost.util.gui.BooleanCell;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class UploadTableFormat
extends SortedTableFormat
implements LanguageListener,
PropertyChangeListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "UploadTable.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "UploadTable.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "UploadTable.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "UploadTable.columnwidth.modelcolumn.";
    private static ImageIcon isSharedIcon = MiscToolkit.loadImageIcon("/data/shared.png");
    private SortedModelTable modelTable = null;
    private boolean showColoredLines;
    private final Language language = Language.getInstance();
    private static final int COLUMN_COUNT = PersistenceManager.isPersistenceEnabled() ? 10 : 9;
    private String stateDone;
    private String stateFailed;
    private String stateUploading;
    private String stateEncodingRequested;
    private String stateEncoding;
    private String stateWaiting;
    private String unknown;
    private String isSharedTooltip;

    public UploadTableFormat() {
        super(COLUMN_COUNT);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new EnabledComparator(), 0);
        this.setComparator(new IsSharedComparator(), 1);
        this.setComparator(new NameComparator(), 2);
        this.setComparator(new FileSizeComparator(), 3);
        this.setComparator(new StateComparator(), 4);
        this.setComparator(new PathComparator(), 5);
        this.setComparator(new BlocksComparator(), 6);
        this.setComparator(new TriesComparator(), 7);
        this.setComparator(new KeyComparator(), 8);
        if (PersistenceManager.isPersistenceEnabled()) {
            this.setComparator(new PriorityComparator(), 9);
        }
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        Core.frostSettings.addPropertyChangeListener(this);
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("UploadPane.fileTable.enabled"));
        this.setColumnName(1, this.language.getString("UploadPane.fileTable.shared"));
        this.setColumnName(2, this.language.getString("UploadPane.fileTable.filename"));
        this.setColumnName(3, this.language.getString("UploadPane.fileTable.size"));
        this.setColumnName(4, this.language.getString("UploadPane.fileTable.state"));
        this.setColumnName(5, this.language.getString("UploadPane.fileTable.path"));
        this.setColumnName(6, this.language.getString("UploadPane.fileTable.blocks"));
        this.setColumnName(7, this.language.getString("UploadPane.fileTable.tries"));
        this.setColumnName(8, this.language.getString("UploadPane.fileTable.key"));
        if (PersistenceManager.isPersistenceEnabled()) {
            this.setColumnName(9, this.language.getString("UploadPane.fileTable.priority"));
        }
        this.stateDone = this.language.getString("UploadPane.fileTable.state.done");
        this.stateFailed = this.language.getString("UploadPane.fileTable.state.failed");
        this.stateUploading = this.language.getString("UploadPane.fileTable.state.uploading");
        this.stateEncodingRequested = this.language.getString("UploadPane.fileTable.state.encodeRequested");
        this.stateEncoding = this.language.getString("UploadPane.fileTable.state.encodingFile") + "...";
        this.stateWaiting = this.language.getString("UploadPane.fileTable.state.waiting");
        this.unknown = this.language.getString("UploadPane.fileTable.state.unknown");
        this.isSharedTooltip = this.language.getString("UploadPane.fileTable.shared.tooltip");
        this.refreshColumnNames();
    }

    public void setCellValue(Object value, ModelItem item, int columnIndex) {
        FrostUploadItem uploadItem = (FrostUploadItem)item;
        switch (columnIndex) {
            case 0: {
                Boolean valueBoolean = (Boolean)value;
                uploadItem.setEnabled(valueBoolean);
                FileTransferManager.inst().getUploadManager().notifyUploadItemEnabledStateChanged(uploadItem);
                break;
            }
            default: {
                super.setCellValue(value, item, columnIndex);
            }
        }
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        FrostUploadItem uploadItem = (FrostUploadItem)item;
        switch (columnIndex) {
            case 0: {
                return uploadItem.isEnabled();
            }
            case 1: {
                return uploadItem.isSharedFile();
            }
            case 2: {
                return uploadItem.getFile().getName();
            }
            case 3: {
                return FormatterUtils.formatSize(uploadItem.getFileSize());
            }
            case 4: {
                return this.getStateAsString(uploadItem, uploadItem.getState());
            }
            case 5: {
                return uploadItem.getFile().getPath();
            }
            case 6: {
                return this.getUploadProgress(uploadItem);
            }
            case 7: {
                return new Integer(uploadItem.getRetries());
            }
            case 8: {
                if (uploadItem.getKey() == null) {
                    return this.unknown;
                }
                return uploadItem.getKey();
            }
            case 9: {
                int value = uploadItem.getPriority();
                if (value < 0) {
                    return "-";
                }
                return new Integer(value);
            }
        }
        return "**ERROR**";
    }

    private String getStateAsString(FrostUploadItem item, int state) {
        switch (state) {
            case 4: {
                return this.stateUploading;
            }
            case 5: {
                return this.stateEncodingRequested;
            }
            case 6: {
                return this.stateEncoding;
            }
            case 8: {
                return this.stateFailed;
            }
            case 1: {
                return this.stateDone;
            }
            case 7: {
                return this.stateWaiting;
            }
        }
        return "**ERROR**";
    }

    private String getUploadProgress(FrostUploadItem uploadItem) {
        int totalBlocks = uploadItem.getTotalBlocks();
        int doneBlocks = uploadItem.getDoneBlocks();
        Boolean isFinalized = uploadItem.isFinalized();
        if (totalBlocks <= 0) {
            return "";
        }
        int percentDone = 0;
        if (totalBlocks > 0) {
            percentDone = doneBlocks * 100 / totalBlocks;
        }
        if (percentDone > 100) {
            percentDone = 100;
        }
        StringBuilder sb = new StringBuilder();
        if (isFinalized != null && !isFinalized.booleanValue()) {
            sb.append("~");
        }
        sb.append(percentDone).append("% ");
        sb.append(doneBlocks).append("/").append(totalBlocks).append(" [").append(totalBlocks).append("]");
        return sb.toString();
    }

    public void customizeTable(ModelTable lModelTable) {
        super.customizeTable(lModelTable);
        this.modelTable = (SortedModelTable)lModelTable;
        if (Core.frostSettings.getBoolValue("saveSortStates") && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDCOLUMN) != null && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDASCENDING) != null) {
            int sortedColumn = Core.frostSettings.getIntValue(CFGKEY_SORTSTATE_SORTEDCOLUMN);
            boolean isSortedAsc = Core.frostSettings.getBoolValue(CFGKEY_SORTSTATE_SORTEDASCENDING);
            if (sortedColumn > -1) {
                this.modelTable.setSortedColumn(sortedColumn, isSortedAsc);
            }
        } else {
            this.modelTable.setSortedColumn(2, true);
        }
        lModelTable.getTable().setAutoResizeMode(1);
        TableColumnModel columnModel = lModelTable.getTable().getColumnModel();
        columnModel.getColumn(0).setCellRenderer(BooleanCell.RENDERER);
        columnModel.getColumn(0).setCellEditor(BooleanCell.EDITOR);
        this.setColumnEditable(0, true);
        columnModel.getColumn(0).setCellRenderer(new IsEnabledRenderer());
        columnModel.getColumn(0).setMinWidth(20);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(1).setMinWidth(20);
        columnModel.getColumn(1).setMaxWidth(20);
        columnModel.getColumn(1).setPreferredWidth(20);
        columnModel.getColumn(1).setCellRenderer(new IsSharedRenderer());
        if (PersistenceManager.isPersistenceEnabled()) {
            columnModel.getColumn(9).setMinWidth(20);
            columnModel.getColumn(9).setMaxWidth(20);
            columnModel.getColumn(9).setPreferredWidth(20);
        }
        RightAlignRenderer numberRightRenderer = new RightAlignRenderer();
        ShowContentTooltipRenderer showContentTooltipRenderer = new ShowContentTooltipRenderer();
        columnModel.getColumn(2).setCellRenderer(new ShowNameTooltipRenderer());
        columnModel.getColumn(3).setCellRenderer(numberRightRenderer);
        columnModel.getColumn(4).setCellRenderer(new ShowStateContentTooltipRenderer());
        columnModel.getColumn(5).setCellRenderer(showContentTooltipRenderer);
        columnModel.getColumn(6).setCellRenderer(new BlocksProgressRenderer());
        columnModel.getColumn(7).setCellRenderer(numberRightRenderer);
        columnModel.getColumn(8).setCellRenderer(showContentTooltipRenderer);
        if (PersistenceManager.isPersistenceEnabled()) {
            columnModel.getColumn(9).setCellRenderer(numberRightRenderer);
        }
        if (!this.loadTableLayout(columnModel)) {
            int[] newWidths;
            int[] widths = PersistenceManager.isPersistenceEnabled() ? (newWidths = new int[]{20, 20, 200, 65, 30, 60, 50, 15, 70, 20}) : (newWidths = new int[]{20, 20, 200, 65, 30, 60, 50, 15, 70});
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    public void saveTableLayout() {
        TableColumnModel tcm = this.modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && this.modelTable.getSortedColumn() > -1) {
            int sortedColumn = this.modelTable.getSortedColumn();
            boolean isSortedAsc = this.modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x = 0; x < tableToModelIndex.length; ++x) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x;
            String widthKey = CFGKEY_COLUMN_WIDTH + x;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (int x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            if (x == 0 || x == 1) continue;
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (int element : tableToModelIndex) {
            tcm.addColumn(tcms[element]);
        }
        return true;
    }

    public int[] getColumnNumbers(int fieldID) {
        return new int[0];
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
            this.modelTable.fireTableDataChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileSizeComparator
    implements Comparator<FrostUploadItem> {
        private FileSizeComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            return Mixed.compareLong(item1.getFileSize(), item2.getFileSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyComparator
    implements Comparator<FrostUploadItem> {
        private KeyComparator() {
        }

        @Override
        public int compare(FrostUploadItem o1, FrostUploadItem o2) {
            String key1 = o1.getKey();
            String key2 = o2.getKey();
            if (key1 == null) {
                key1 = UploadTableFormat.this.unknown;
            }
            if (key2 == null) {
                key2 = UploadTableFormat.this.unknown;
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnabledComparator
    implements Comparator<FrostUploadItem> {
        private EnabledComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            Boolean b1 = (boolean)item1.isEnabled();
            Boolean b2 = (boolean)item2.isEnabled();
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathComparator
    implements Comparator<FrostUploadItem> {
        private PathComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            return item1.getFile().getPath().compareToIgnoreCase(item2.getFile().getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSharedComparator
    implements Comparator<FrostUploadItem> {
        private IsSharedComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            Boolean b1 = item1.isSharedFile();
            Boolean b2 = item2.isSharedFile();
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriesComparator
    implements Comparator<FrostUploadItem> {
        private TriesComparator() {
        }

        @Override
        public int compare(FrostUploadItem o1, FrostUploadItem o2) {
            int retries1 = o1.getRetries();
            int retries2 = o2.getRetries();
            return Mixed.compareInt(retries1, retries2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlocksComparator
    implements Comparator<FrostUploadItem> {
        private BlocksComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            return Mixed.compareInt(item1.getDoneBlocks(), item2.getDoneBlocks());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateComparator
    implements Comparator<FrostUploadItem> {
        private StateComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            return Mixed.compareInt(item1.getState(), item2.getState());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityComparator
    implements Comparator<FrostUploadItem> {
        private PriorityComparator() {
        }

        @Override
        public int compare(FrostUploadItem o1, FrostUploadItem o2) {
            int prio1 = o1.getPriority();
            int prio2 = o2.getPriority();
            return Mixed.compareInt(prio1, prio2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<FrostUploadItem> {
        private NameComparator() {
        }

        @Override
        public int compare(FrostUploadItem item1, FrostUploadItem item2) {
            return item1.getFile().getName().compareToIgnoreCase(item2.getFile().getName());
        }
    }

    private class RightAlignRenderer
    extends BaseRenderer {
        final EmptyBorder border;

        public RightAlignRenderer() {
            this.border = new EmptyBorder(0, 0, 0, 3);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(this.border);
            return this;
        }
    }

    private class IsSharedRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText("");
            this.setToolTipText(UploadTableFormat.this.isSharedTooltip);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (b.booleanValue()) {
                    this.setIcon(isSharedIcon);
                } else {
                    this.setIcon(null);
                }
            }
            return this;
        }
    }

    private class IsEnabledRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            ModelItem item = UploadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostUploadItem uploadItem = (FrostUploadItem)item;
                if (uploadItem.isExternal()) {
                    this.setEnabled(false);
                    this.setSelected(true);
                } else {
                    this.setEnabled(true);
                    this.setSelected(value != null && value instanceof Boolean && (Boolean)value != false);
                }
            }
            return this;
        }
    }

    private class ShowStateContentTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FrostUploadItem uploadItem;
            String errorCodeDescription;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            ModelItem item = UploadTableFormat.this.modelTable.getItemAt(row);
            if (item != null && (errorCodeDescription = (uploadItem = (FrostUploadItem)item).getErrorCodeDescription()) != null && errorCodeDescription.length() > 0) {
                tooltip = "Last error: " + errorCodeDescription;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class ShowNameTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            ModelItem item = UploadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostUploadItem uploadItem = (FrostUploadItem)item;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>").append(uploadItem.getFilename());
                if (uploadItem.getUploadAddedMillis() > 0L) {
                    sb.append("<br>Added: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(uploadItem.getUploadAddedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(uploadItem.getUploadAddedMillis()));
                }
                if (uploadItem.getUploadStartedMillis() > 0L) {
                    sb.append("<br>Started: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(uploadItem.getUploadStartedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(uploadItem.getUploadStartedMillis()));
                }
                if (uploadItem.getUploadFinishedMillis() > 0L) {
                    sb.append("<br>Finished: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(uploadItem.getUploadFinishedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(uploadItem.getUploadFinishedMillis()));
                }
                sb.append("</html>");
                tooltip = sb.toString();
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class BlocksProgressRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public BlocksProgressRenderer() {
            this.setMinimum(0);
            this.setMaximum(100);
            this.setStringPainted(true);
            this.setBorderPainted(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, UploadTableFormat.this.showColoredLines);
            this.setBackground(newBackground);
            this.setValue(0);
            ModelItem item = UploadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostUploadItem uploadItem = (FrostUploadItem)item;
                int totalBlocks = uploadItem.getTotalBlocks();
                int doneBlocks = uploadItem.getDoneBlocks();
                if (totalBlocks > 0) {
                    int percentDone = 0;
                    percentDone = doneBlocks * 100 / totalBlocks;
                    if (percentDone > 100) {
                        percentDone = 100;
                    }
                    this.setValue(percentDone);
                }
            }
            this.setString(value.toString());
            return this;
        }
    }

    private class BaseRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, UploadTableFormat.this.showColoredLines);
                ModelItem item = UploadTableFormat.this.modelTable.getItemAt(row);
                if (item != null) {
                    FrostUploadItem uploadItem = (FrostUploadItem)item;
                    int itemState = uploadItem.getState();
                    if (itemState == 1) {
                        newBackground = TableBackgroundColors.getBackgroundColorDone(table, row, UploadTableFormat.this.showColoredLines);
                    } else if (itemState == 8) {
                        newBackground = TableBackgroundColors.getBackgroundColorFailed(table, row, UploadTableFormat.this.showColoredLines);
                    }
                }
                this.setBackground(newBackground);
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

