/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.MainFrame;
import frost.SettingsUpdater;
import frost.ext.ExecuteDocument;
import frost.fcp.FcpHandler;
import frost.fcp.FreenetKeys;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.common.FileListFileDetailsDialog;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadTableFormat;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.CopyToClipboard;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.search.TableFindAction;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DownloadPanel
extends JPanel
implements SettingsUpdater {
    private PopupMenuDownload popupMenuDownload = null;
    private final Listener listener = new Listener();
    private static final Logger logger = Logger.getLogger(DownloadPanel.class.getName());
    private DownloadModel model = null;
    private Language language = null;
    private final JToolBar downloadToolBar = new JToolBar();
    private final JButton downloadActivateButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/media-playback-start.png"));
    private final JButton downloadPauseButton = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/media-playback-pause.png"));
    private final JTextField downloadTextField = new JTextField(25);
    private final JLabel downloadItemCountLabel = new JLabel();
    private final JCheckBox removeFinishedDownloadsCheckBox = new JCheckBox();
    private final JCheckBox showExternalGlobalQueueItems = new JCheckBox();
    private SortedModelTable modelTable;
    private boolean initialized = false;
    private boolean downloadingActivated = false;
    private int downloadItemCount = 0;

    public DownloadPanel() {
        Core.frostSettings.addUpdater(this);
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
    }

    public DownloadTableFormat getTableFormat() {
        return (DownloadTableFormat)this.modelTable.getTableFormat();
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            MiscToolkit.configureButton(this.downloadActivateButton);
            MiscToolkit.configureButton(this.downloadPauseButton);
            new TextComponentClipboardMenu(this.downloadTextField, this.language);
            this.downloadToolBar.setRollover(true);
            this.downloadToolBar.setFloatable(false);
            this.removeFinishedDownloadsCheckBox.setOpaque(false);
            this.showExternalGlobalQueueItems.setOpaque(false);
            this.downloadTextField.setMaximumSize(this.downloadTextField.getPreferredSize());
            this.downloadTextField.setToolTipText(this.language.getString("DownloadPane.toolbar.tooltip.addKeys"));
            this.downloadTextField.setDocument(new HandleMultiLineKeysDocument());
            this.downloadToolBar.add(this.downloadTextField);
            this.downloadToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
            this.downloadToolBar.add(this.downloadActivateButton);
            this.downloadToolBar.add(this.downloadPauseButton);
            this.downloadToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
            this.downloadToolBar.add(this.removeFinishedDownloadsCheckBox);
            if (PersistenceManager.isPersistenceEnabled()) {
                this.downloadToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
                this.downloadToolBar.add(this.showExternalGlobalQueueItems);
            }
            this.downloadToolBar.add(Box.createRigidArea(new Dimension(80, 0)));
            this.downloadToolBar.add(Box.createHorizontalGlue());
            this.downloadToolBar.add(this.downloadItemCountLabel);
            this.modelTable = new SortedModelTable(this.model);
            new TableFindAction().install(this.modelTable.getTable());
            this.setLayout(new BorderLayout());
            this.add((Component)this.downloadToolBar, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.modelTable.getTable().setDefaultRenderer(Object.class, new CellRenderer());
            this.downloadTextField.addActionListener(this.listener);
            this.downloadActivateButton.addActionListener(this.listener);
            this.downloadPauseButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addKeyListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            this.removeFinishedDownloadsCheckBox.addItemListener(this.listener);
            this.showExternalGlobalQueueItems.addItemListener(this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontName", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontSize", this.listener);
            Core.frostSettings.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.removeFinishedDownloadsCheckBox.setSelected(Core.frostSettings.getBoolValue("removeFinishedDownloads"));
            this.showExternalGlobalQueueItems.setSelected(Core.frostSettings.getBoolValue("showExternalGlobalQueueDownloads"));
            this.setDownloadingActivated(Core.frostSettings.getBoolValue("downloadingActivated"));
            this.initialized = true;
        }
    }

    private Dimension calculateLabelSize(String text) {
        JLabel dummyLabel = new JLabel(text);
        dummyLabel.doLayout();
        return dummyLabel.getPreferredSize();
    }

    private void refreshLanguage() {
        this.downloadActivateButton.setToolTipText(this.language.getString("DownloadPane.toolbar.tooltip.activateDownloading"));
        this.downloadPauseButton.setToolTipText(this.language.getString("DownloadPane.toolbar.tooltip.pauseDownloading"));
        this.downloadTextField.setToolTipText(this.language.getString("DownloadPane.toolbar.tooltip.addKeys"));
        this.removeFinishedDownloadsCheckBox.setText(this.language.getString("DownloadPane.removeFinishedDownloads"));
        this.showExternalGlobalQueueItems.setText(this.language.getString("DownloadPane.showExternalGlobalQueueItems"));
        String waiting = this.language.getString("DownloadPane.toolbar.waiting");
        Dimension labelSize = this.calculateLabelSize(waiting + ": 00000");
        this.downloadItemCountLabel.setPreferredSize(labelSize);
        this.downloadItemCountLabel.setMinimumSize(labelSize);
        this.downloadItemCountLabel.setText(waiting + ": " + this.downloadItemCount);
    }

    public void setModel(DownloadModel model) {
        this.model = model;
    }

    private void downloadTextField_actionPerformed(ActionEvent e) {
        try {
            String keys = this.downloadTextField.getText().trim();
            if (keys.length() == 0) {
                this.downloadTextField.setText("");
                return;
            }
            String[] keyList = keys.split("[;\n]");
            if (keyList == null || keyList.length == 0) {
                this.downloadTextField.setText("");
                return;
            }
            for (String element : keyList) {
                String string;
                String key = element.trim();
                if (key.length() < 5) continue;
                if (key.indexOf("%") > 0) {
                    try {
                        key = URLDecoder.decode(key, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        logger.log(Level.SEVERE, "Decode of HTML code failed", ex);
                    }
                }
                int pos = -1;
                for (int i = 0; i < FreenetKeys.getFreenetKeyTypes().length && (pos = key.indexOf(string = FreenetKeys.getFreenetKeyTypes()[i])) < 0; ++i) {
                }
                if (pos < 0) {
                    this.showInvalidKeyErrorDialog(key);
                    continue;
                }
                if (pos > 0) {
                    key = key.substring(pos);
                }
                if (key.length() < 5) {
                    this.showInvalidKeyErrorDialog(key);
                    continue;
                }
                int sepIndex = key.lastIndexOf("/");
                String fileName = sepIndex > -1 ? key.substring(sepIndex + 1) : key.substring(4);
                String checkKey = key;
                if (key.startsWith("CHK@") && key.indexOf("/") > -1) {
                    checkKey = key.substring(0, key.indexOf("/"));
                }
                if (FcpHandler.isFreenet05()) {
                    key = checkKey;
                }
                if (!FreenetKeys.isValidKey(checkKey)) {
                    this.showInvalidKeyErrorDialog(key);
                    continue;
                }
                FileTransferManager.inst().getDownloadManager().addNewDownload(key, fileName);
            }
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Unexpected exception", ex);
            this.showInvalidKeyErrorDialog("???");
        }
        this.downloadTextField.setText("");
    }

    private void showInvalidKeyErrorDialog(String invKey) {
        JOptionPane.showMessageDialog(this, this.language.formatMessage("DownloadPane.invalidKeyDialog.body", invKey), this.language.getString("DownloadPane.invalidKeyDialog.title"), 0);
    }

    private void downloadTable_keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == '\u007f' && !this.modelTable.getTable().isEditing()) {
            this.removeSelectedDownloads();
        }
    }

    private void removeSelectedDownloads() {
        ModelItem[] selectedItems = this.modelTable.getSelectedItems();
        final LinkedList<String> externalRequestsToRemove = new LinkedList<String>();
        LinkedList<ModelItem> requestsToRemove = new LinkedList<ModelItem>();
        for (ModelItem mi : selectedItems) {
            FrostDownloadItem i = (FrostDownloadItem)mi;
            requestsToRemove.add(mi);
            if (!i.isExternal()) continue;
            externalRequestsToRemove.add(i.getGqIdentifier());
        }
        ModelItem[] ri = requestsToRemove.toArray(new ModelItem[requestsToRemove.size()]);
        this.model.removeItems(ri);
        this.modelTable.getTable().clearSelection();
        if (FileTransferManager.inst().getPersistenceManager() != null && externalRequestsToRemove.size() > 0) {
            new Thread(){

                public void run() {
                    FileTransferManager.inst().getPersistenceManager().removeRequests(externalRequestsToRemove);
                }
            }.start();
        }
    }

    public boolean isDownloadingActivated() {
        return this.downloadingActivated;
    }

    public void setDownloadingActivated(boolean b) {
        this.downloadingActivated = b;
        this.downloadActivateButton.setEnabled(!this.downloadingActivated);
        this.downloadPauseButton.setEnabled(this.downloadingActivated);
    }

    public void setDownloadItemCount(int newDownloadItemCount) {
        this.downloadItemCount = newDownloadItemCount;
        String s = this.language.getString("DownloadPane.toolbar.waiting") + ": " + this.downloadItemCount;
        this.downloadItemCountLabel.setText(s);
    }

    private PopupMenuDownload getPopupMenuDownload() {
        if (this.popupMenuDownload == null) {
            this.popupMenuDownload = new PopupMenuDownload();
            this.language.addLanguageListener(this.popupMenuDownload);
        }
        return this.popupMenuDownload;
    }

    private void showDownloadTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.modelTable.getTable().rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.modelTable.getTable().getSelectionModel().isSelectedIndex(y)) {
            this.modelTable.getTable().getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenuDownload().show(e.getComponent(), e.getX(), e.getY());
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.modelTable.setFont(font);
    }

    private void downloadActivateButtonPressed(ActionEvent e) {
        this.setDownloadingActivated(true);
    }

    private void downloadPauseButtonPressed(ActionEvent e) {
        this.setDownloadingActivated(false);
    }

    private void downloadTableDoubleClick(MouseEvent e) {
        int clickedCol = this.modelTable.getTable().columnAtPoint(e.getPoint());
        int modelIx = this.modelTable.getTable().getColumnModel().getColumn(clickedCol).getModelIndex();
        if (modelIx == 0) {
            return;
        }
        ModelItem selectedItem = this.modelTable.getSelectedItem();
        if (selectedItem != null) {
            FrostDownloadItem dlItem = (FrostDownloadItem)selectedItem;
            File targetFile = new File(Core.frostSettings.getValue("downloadDirectory") + dlItem.getFilename());
            if (!targetFile.isFile()) {
                return;
            }
            logger.info("Executing: " + targetFile.getAbsolutePath());
            try {
                ExecuteDocument.openDocument(targetFile);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this, "Could not open the file: " + targetFile.getAbsolutePath() + "\n" + t.toString(), "Error", 0);
            }
        }
    }

    public void updateSettings() {
        Core.frostSettings.setValue("downloadingActivated", this.isDownloadingActivated());
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    ActionListener,
    KeyListener,
    MouseListener,
    PropertyChangeListener,
    ItemListener {
        public void languageChanged(LanguageEvent event) {
            DownloadPanel.this.refreshLanguage();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DownloadPanel.this.downloadTextField) {
                DownloadPanel.this.downloadTextField_actionPerformed(e);
            } else if (e.getSource() == DownloadPanel.this.downloadActivateButton) {
                DownloadPanel.this.downloadActivateButtonPressed(e);
            } else if (e.getSource() == DownloadPanel.this.downloadPauseButton) {
                DownloadPanel.this.downloadPauseButtonPressed(e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getSource() == DownloadPanel.this.modelTable.getTable()) {
                DownloadPanel.this.downloadTable_keyPressed(e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == DownloadPanel.this.modelTable.getTable()) {
                    DownloadPanel.this.downloadTableDoubleClick(e);
                }
            } else if (e.isPopupTrigger() && (e.getSource() == DownloadPanel.this.modelTable.getTable() || e.getSource() == DownloadPanel.this.modelTable.getScrollPane())) {
                DownloadPanel.this.showDownloadTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == DownloadPanel.this.modelTable.getTable() || e.getSource() == DownloadPanel.this.modelTable.getScrollPane())) {
                DownloadPanel.this.showDownloadTablePopupMenu(e);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("fileListFontName")) {
                DownloadPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontSize")) {
                DownloadPanel.this.fontChanged();
            }
            if (evt.getPropertyName().equals("fileListFontStyle")) {
                DownloadPanel.this.fontChanged();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (DownloadPanel.this.removeFinishedDownloadsCheckBox.isSelected()) {
                Core.frostSettings.setValue("removeFinishedDownloads", true);
                DownloadPanel.this.model.removeFinishedDownloads();
            } else {
                Core.frostSettings.setValue("removeFinishedDownloads", false);
            }
            if (DownloadPanel.this.showExternalGlobalQueueItems.isSelected()) {
                Core.frostSettings.setValue("showExternalGlobalQueueDownloads", true);
            } else {
                Core.frostSettings.setValue("showExternalGlobalQueueDownloads", false);
                DownloadPanel.this.model.removeExternalDownloads();
            }
        }
    }

    private class PopupMenuDownload
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem detailsItem = new JMenuItem();
        private final JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private final JMenuItem copyKeysItem = new JMenuItem();
        private final JMenuItem copyExtendedInfoItem = new JMenuItem();
        private final JMenuItem disableAllDownloadsItem = new JMenuItem();
        private final JMenuItem disableSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem enableAllDownloadsItem = new JMenuItem();
        private final JMenuItem enableSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem invertEnabledAllItem = new JMenuItem();
        private final JMenuItem invertEnabledSelectedItem = new JMenuItem();
        private final JMenuItem removeSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem restartSelectedDownloadsItem = new JMenuItem();
        private final JMenuItem startSelectedDownloadsNow = new JMenuItem();
        private JMenu changePriorityMenu = null;
        private JMenuItem prio0Item = null;
        private JMenuItem prio1Item = null;
        private JMenuItem prio2Item = null;
        private JMenuItem prio3Item = null;
        private JMenuItem prio4Item = null;
        private JMenuItem prio5Item = null;
        private JMenuItem prio6Item = null;
        private JMenuItem removeFromGqItem = null;
        private JMenuItem retrieveDirectExternalDownloads = null;
        private final JMenu copyToClipboardMenu = new JMenu();

        public PopupMenuDownload() {
            this.initialize();
        }

        private void initialize() {
            if (PersistenceManager.isPersistenceEnabled()) {
                this.changePriorityMenu = new JMenu();
                this.prio0Item = new JMenuItem();
                this.prio1Item = new JMenuItem();
                this.prio2Item = new JMenuItem();
                this.prio3Item = new JMenuItem();
                this.prio4Item = new JMenuItem();
                this.prio5Item = new JMenuItem();
                this.prio6Item = new JMenuItem();
                this.removeFromGqItem = new JMenuItem();
                this.changePriorityMenu.add(this.prio0Item);
                this.changePriorityMenu.add(this.prio1Item);
                this.changePriorityMenu.add(this.prio2Item);
                this.changePriorityMenu.add(this.prio3Item);
                this.changePriorityMenu.add(this.prio4Item);
                this.changePriorityMenu.add(this.prio5Item);
                this.changePriorityMenu.add(this.prio6Item);
                this.prio0Item.addActionListener(this);
                this.prio1Item.addActionListener(this);
                this.prio2Item.addActionListener(this);
                this.prio3Item.addActionListener(this);
                this.prio4Item.addActionListener(this);
                this.prio5Item.addActionListener(this);
                this.prio6Item.addActionListener(this);
                this.removeFromGqItem.addActionListener(this);
                this.retrieveDirectExternalDownloads = new JMenuItem();
                this.retrieveDirectExternalDownloads.addActionListener(this);
            }
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
            }
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.restartSelectedDownloadsItem.addActionListener(this);
            this.removeSelectedDownloadsItem.addActionListener(this);
            this.enableAllDownloadsItem.addActionListener(this);
            this.disableAllDownloadsItem.addActionListener(this);
            this.enableSelectedDownloadsItem.addActionListener(this);
            this.disableSelectedDownloadsItem.addActionListener(this);
            this.invertEnabledAllItem.addActionListener(this);
            this.invertEnabledSelectedItem.addActionListener(this);
            this.detailsItem.addActionListener(this);
            this.startSelectedDownloadsNow.addActionListener(this);
        }

        private void refreshLanguage() {
            this.detailsItem.setText(DownloadPanel.this.language.getString("Common.details"));
            this.copyKeysItem.setText(DownloadPanel.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(DownloadPanel.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyExtendedInfoItem.setText(DownloadPanel.this.language.getString("Common.copyToClipBoard.copyExtendedInfo"));
            this.restartSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.restartSelectedDownloads"));
            this.removeSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.remove.removeSelectedDownloads"));
            this.enableAllDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.enableAllDownloads"));
            this.disableAllDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.disableAllDownloads"));
            this.enableSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.enableSelectedDownloads"));
            this.disableSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.disableSelectedDownloads"));
            this.invertEnabledAllItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.invertEnabledStateForAllDownloads"));
            this.invertEnabledSelectedItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads.invertEnabledStateForSelectedDownloads"));
            this.startSelectedDownloadsNow.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.startSelectedDownloadsNow"));
            this.copyToClipboardMenu.setText(DownloadPanel.this.language.getString("Common.copyToClipBoard") + "...");
            if (PersistenceManager.isPersistenceEnabled()) {
                this.changePriorityMenu.setText(DownloadPanel.this.language.getString("Common.priority.changePriority"));
                this.prio0Item.setText(DownloadPanel.this.language.getString("Common.priority.priority0"));
                this.prio1Item.setText(DownloadPanel.this.language.getString("Common.priority.priority1"));
                this.prio2Item.setText(DownloadPanel.this.language.getString("Common.priority.priority2"));
                this.prio3Item.setText(DownloadPanel.this.language.getString("Common.priority.priority3"));
                this.prio4Item.setText(DownloadPanel.this.language.getString("Common.priority.priority4"));
                this.prio5Item.setText(DownloadPanel.this.language.getString("Common.priority.priority5"));
                this.prio6Item.setText(DownloadPanel.this.language.getString("Common.priority.priority6"));
                this.removeFromGqItem.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.removeFromGlobalQueue"));
                this.retrieveDirectExternalDownloads.setText(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.retrieveDirectExternalDownloads"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(DownloadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(DownloadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.copyExtendedInfoItem) {
                CopyToClipboard.copyExtendedInfo(DownloadPanel.this.modelTable.getSelectedItems());
            } else if (e.getSource() == this.restartSelectedDownloadsItem) {
                this.restartSelectedDownloads();
            } else if (e.getSource() == this.removeSelectedDownloadsItem) {
                DownloadPanel.this.removeSelectedDownloads();
            } else if (e.getSource() == this.enableAllDownloadsItem) {
                this.enableAllDownloads();
            } else if (e.getSource() == this.disableAllDownloadsItem) {
                this.disableAllDownloads();
            } else if (e.getSource() == this.enableSelectedDownloadsItem) {
                this.enableSelectedDownloads();
            } else if (e.getSource() == this.disableSelectedDownloadsItem) {
                this.disableSelectedDownloads();
            } else if (e.getSource() == this.invertEnabledAllItem) {
                this.invertEnabledAll();
            } else if (e.getSource() == this.invertEnabledSelectedItem) {
                this.invertEnabledSelected();
            } else if (e.getSource() == this.detailsItem) {
                this.showDetails();
            } else if (e.getSource() == this.prio0Item) {
                this.changePriority(0);
            } else if (e.getSource() == this.prio1Item) {
                this.changePriority(1);
            } else if (e.getSource() == this.prio2Item) {
                this.changePriority(2);
            } else if (e.getSource() == this.prio3Item) {
                this.changePriority(3);
            } else if (e.getSource() == this.prio4Item) {
                this.changePriority(4);
            } else if (e.getSource() == this.prio5Item) {
                this.changePriority(5);
            } else if (e.getSource() == this.prio6Item) {
                this.changePriority(6);
            } else if (e.getSource() == this.removeFromGqItem) {
                this.removeSelectedUploadsFromGlobalQueue();
            } else if (e.getSource() == this.retrieveDirectExternalDownloads) {
                this.retrieveDirectExternalDownloads();
            } else if (e.getSource() == this.startSelectedDownloadsNow) {
                this.startSelectedDownloadsNow();
            }
        }

        private void removeSelectedUploadsFromGlobalQueue() {
            if (FileTransferManager.inst().getPersistenceManager() == null) {
                return;
            }
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            ArrayList<String> requestsToRemove = new ArrayList<String>();
            ArrayList<FrostDownloadItem> itemsToUpdate = new ArrayList<FrostDownloadItem>();
            for (ModelItem mi : selectedItems) {
                FrostDownloadItem item = (FrostDownloadItem)mi;
                if (!FileTransferManager.inst().getPersistenceManager().isItemInGlobalQueue(item)) continue;
                requestsToRemove.add(item.getGqIdentifier());
                itemsToUpdate.add(item);
                item.setInternalRemoveExpected(true);
            }
            FileTransferManager.inst().getPersistenceManager().removeRequests(requestsToRemove);
            for (FrostDownloadItem item : itemsToUpdate) {
                item.setState(1);
                item.setEnabled(Boolean.FALSE);
                item.setPriority(-1);
                item.fireValueChanged();
            }
        }

        private void retrieveDirectExternalDownloads() {
            ModelItem[] selectedItems;
            if (FileTransferManager.inst().getPersistenceManager() == null) {
                return;
            }
            for (ModelItem mi : selectedItems = DownloadPanel.this.modelTable.getSelectedItems()) {
                FrostDownloadItem item = (FrostDownloadItem)mi;
                if (!item.isExternal() || !item.isDirect() || item.getState() != 3) continue;
                long expectedFileSize = item.getFileSize();
                FileTransferManager.inst().getPersistenceManager().maybeEnqueueDirectGet(item, expectedFileSize);
            }
        }

        private void startSelectedDownloadsNow() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            LinkedList<FrostDownloadItem> itemsToStart = new LinkedList<FrostDownloadItem>();
            for (ModelItem mi : selectedItems) {
                FrostDownloadItem i = (FrostDownloadItem)mi;
                if (i.isExternal() || i.getState() != 1 || i.getKey() == null) continue;
                itemsToStart.add(i);
            }
            for (FrostDownloadItem dlItem : itemsToStart) {
                dlItem.setEnabled(true);
                FileTransferManager.inst().getDownloadManager().startDownload(dlItem);
            }
        }

        private void changePriority(int prio) {
            if (FileTransferManager.inst().getPersistenceManager() == null) {
                return;
            }
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            FileTransferManager.inst().getPersistenceManager().changeItemPriorites(selectedItems, prio);
        }

        private void showDetails() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            if (selectedItems.length != 1) {
                return;
            }
            FrostDownloadItem item = (FrostDownloadItem)selectedItems[0];
            if (!item.isSharedFile()) {
                return;
            }
            new FileListFileDetailsDialog(MainFrame.getInstance()).startDialog(item.getFileListFileObject());
        }

        private void invertEnabledSelected() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(null, selectedItems);
        }

        private void invertEnabledAll() {
            DownloadPanel.this.model.setAllItemsEnabled(null);
        }

        private void disableSelectedDownloads() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(Boolean.FALSE, selectedItems);
        }

        private void enableSelectedDownloads() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(Boolean.TRUE, selectedItems);
        }

        private void disableAllDownloads() {
            DownloadPanel.this.model.setAllItemsEnabled(Boolean.FALSE);
        }

        private void enableAllDownloads() {
            DownloadPanel.this.model.setAllItemsEnabled(Boolean.TRUE);
        }

        private void restartSelectedDownloads() {
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.restartItems(selectedItems);
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            FrostDownloadItem item;
            FrostDownloadItem item2;
            this.removeAll();
            ModelItem[] selectedItems = DownloadPanel.this.modelTable.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            this.add(this.copyToClipboardMenu);
            this.addSeparator();
            this.add(this.startSelectedDownloadsNow);
            this.add(this.restartSelectedDownloadsItem);
            this.addSeparator();
            if (PersistenceManager.isPersistenceEnabled()) {
                this.add(this.changePriorityMenu);
                this.addSeparator();
            }
            JMenu enabledSubMenu = new JMenu(DownloadPanel.this.language.getString("DownloadPane.fileTable.popupmenu.enableDownloads") + "...");
            enabledSubMenu.add(this.enableSelectedDownloadsItem);
            enabledSubMenu.add(this.disableSelectedDownloadsItem);
            enabledSubMenu.add(this.invertEnabledSelectedItem);
            enabledSubMenu.addSeparator();
            enabledSubMenu.add(this.enableAllDownloadsItem);
            enabledSubMenu.add(this.disableAllDownloadsItem);
            enabledSubMenu.add(this.invertEnabledAllItem);
            this.add(enabledSubMenu);
            if (PersistenceManager.isPersistenceEnabled()) {
                for (ModelItem mi : selectedItems) {
                    item2 = (FrostDownloadItem)mi;
                    if (!item2.isExternal() || !item2.isDirect() || item2.getState() != 3) continue;
                    this.add(this.retrieveDirectExternalDownloads);
                    break;
                }
            }
            this.add(this.removeSelectedDownloadsItem);
            if (FileTransferManager.inst().getPersistenceManager() != null && selectedItems != null) {
                for (ModelItem mi : selectedItems) {
                    item2 = (FrostDownloadItem)mi;
                    if (!FileTransferManager.inst().getPersistenceManager().isItemInGlobalQueue(item2)) continue;
                    this.add(this.removeFromGqItem);
                    break;
                }
            }
            if (selectedItems.length == 1 && (item = (FrostDownloadItem)selectedItems[0]).isSharedFile()) {
                this.addSeparator();
                this.add(this.detailsItem);
            }
            super.show(invoker, x, y);
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private final Color col_green = new Color(0, 128, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            FrostDownloadItem item = (FrostDownloadItem)DownloadPanel.this.model.getItemAt(row);
            if (item.getState() == 3) {
                this.setBackground(this.col_green);
            } else {
                this.setBackground(DownloadPanel.this.modelTable.getTable().getBackground());
            }
            return this;
        }
    }

    protected class HandleMultiLineKeysDocument
    extends PlainDocument {
        protected HandleMultiLineKeysDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str = str.replace('\n', ';');
            str = str.replace('\r', ' ');
            super.insertString(offs, str, a);
        }
    }
}

