/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.fileTransfer.FilePointerFileContent;
import frost.storage.perst.SharedFilesCHKKey;
import frost.storage.perst.SharedFilesCHKKeyStorage;
import frost.threads.FileListDownloadThread;
import frost.util.Logging;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesCHKKeyManager {
    private static final Logger logger = Logger.getLogger(SharedFilesCHKKeyManager.class.getName());
    private static final int MAX_DOWNLOAD_RETRIES_1 = 7;
    private static final int MAX_KEYS_TO_SEND = 300;

    public static List<SharedFilesCHKKey> getCHKKeysToSend() {
        try {
            return SharedFilesCHKKeyStorage.inst().getSharedFilesCHKKeysToSend(300);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in SharedFilesCHKKeysDatabaseTable().getSharedFilesCHKKeysToSend", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCHKKeysWereSuccessfullySent(List<SharedFilesCHKKey> chkKeys) {
        long now = System.currentTimeMillis();
        if (!SharedFilesCHKKeyStorage.inst().beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            for (SharedFilesCHKKey key : chkKeys) {
                key.incrementSentCount();
                key.setLastSent(now);
                key.modify();
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during database update", t);
        }
        finally {
            SharedFilesCHKKeyStorage.inst().endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processReceivedCHKKeys(FilePointerFileContent content) {
        if (content == null || content.getChkKeyStrings() == null || content.getChkKeyStrings().size() == 0) {
            return;
        }
        if (!SharedFilesCHKKeyStorage.inst().beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("processReceivedCHKKeys: processing " + content.getChkKeyStrings().size() + " keys");
            }
            int newKeys = 0;
            int seenKeys = 0;
            int newOwnKeys = 0;
            for (String chkStr : content.getChkKeyStrings()) {
                try {
                    SharedFilesCHKKey ck = SharedFilesCHKKeyStorage.inst().retrieveSharedFilesCHKKey(chkStr);
                    if (ck == null) {
                        ++newKeys;
                        ck = new SharedFilesCHKKey(chkStr, content.getTimestamp());
                        SharedFilesCHKKeyStorage.inst().storeItem(ck);
                        FileListDownloadThread.getInstance().enqueueNewKey(chkStr);
                        continue;
                    }
                    boolean isOurOwnKey = ck.getSeenCount() == 0;
                    ck.incrementSeenCount();
                    if (ck.getLastSeen() < content.getTimestamp()) {
                        ck.setLastSeen(content.getTimestamp());
                    }
                    if (ck.getFirstSeen() > content.getTimestamp()) {
                        ck.setFirstSeen(content.getTimestamp());
                    }
                    ck.modify();
                    if (isOurOwnKey && !ck.isDownloaded()) {
                        FileListDownloadThread.getInstance().enqueueNewKey(chkStr);
                        ++newOwnKeys;
                        continue;
                    }
                    ++seenKeys;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Exception in processReceivedCHKKeys", t);
                }
            }
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("processReceivedCHKKeys: finished processing keys, new=" + newKeys + ", seen=" + seenKeys + ", newOwn=" + newOwnKeys);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during chk key processing", t);
        }
        finally {
            SharedFilesCHKKeyStorage.inst().endThreadTransaction();
        }
    }

    public static List<String> getCHKKeyStringsToDownload() {
        try {
            List<String> chkKeys = SharedFilesCHKKeyStorage.inst().retrieveSharedFilesCHKKeysToDownload(7);
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("getCHKKeyStringsToDownload: returning keys: " + (chkKeys == null ? "(none)" : Integer.toString(chkKeys.size())));
            }
            return chkKeys;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in retrieveSharedFilesCHKKeysToDownload", t);
            return null;
        }
    }

    public static boolean updateCHKKeyDownloadSuccessful(String chkKey, long timestamp, boolean isValid) {
        try {
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("updateCHKKeyDownloadSuccessful: key=" + chkKey + ", isValid=" + isValid);
            }
            return SharedFilesCHKKeyStorage.inst().updateSharedFilesCHKKeyAfterDownloadSuccessful(chkKey, timestamp, isValid);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in updateSharedFilesCHKKeyAfterDownloadSuccessful", t);
            return false;
        }
    }

    public static boolean updateCHKKeyDownloadFailed(String chkKey) {
        try {
            boolean doRetry = SharedFilesCHKKeyStorage.inst().updateSharedFilesCHKKeyAfterDownloadFailed(chkKey, 7);
            return doRetry;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in updateCHKKeyDownloadFailed", t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addNewCHKKeyToSend(SharedFilesCHKKey key) {
        try {
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("addNewCHKKeyToSend: " + key);
            }
            if (!SharedFilesCHKKeyStorage.inst().beginExclusiveThreadTransaction()) {
                return false;
            }
            try {
                SharedFilesCHKKeyStorage.inst().storeItem(key);
            }
            finally {
                SharedFilesCHKKeyStorage.inst().endThreadTransaction();
            }
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in addNewCHKKeyToSend", t);
            return false;
        }
    }
}

