/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07.messagetransfer;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.NodeAddress;
import frost.fcp.fcp07.FcpMultiRequestConnection;
import frost.fcp.fcp07.FcpMultiRequestConnectionTools;
import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.NodeMessageListener;
import frost.fcp.fcp07.messagetransfer.MessageTransferTask;
import frost.util.Logging;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageTransferHandler
implements NodeMessageListener {
    private static final Logger logger = Logger.getLogger(MessageTransferHandler.class.getName());
    private final FcpMultiRequestConnectionTools fcpTools;
    private final HashMap<String, MessageTransferTask> taskMap = new HashMap();
    private boolean isConnected = true;

    public MessageTransferHandler() throws Throwable {
        if (FcpHandler.inst().getNodes().isEmpty()) {
            throw new Exception("No freenet nodes defined");
        }
        NodeAddress na = FcpHandler.inst().getNodes().get(0);
        this.fcpTools = new FcpMultiRequestConnectionTools(FcpMultiRequestConnection.createInstance(na));
    }

    public void start() {
        this.fcpTools.getFcpPersistentConnection().addNodeMessageListener(this);
    }

    public synchronized void enqueueTask(MessageTransferTask task) {
        if (!this.isConnected) {
            logger.severe("Rejecting new task, not connected!");
            task.setFailed();
            task.setFinished();
            return;
        }
        this.taskMap.put(task.getIdentifier(), task);
        if (task.isModeDownload()) {
            this.fcpTools.startDirectGet(task.getIdentifier(), task.getKey(), task.getPriority(), task.getMaxSize(), task.getMaxRetries());
        } else {
            this.fcpTools.startDirectPut(task.getIdentifier(), task.getKey(), task.getPriority(), task.getFile());
        }
    }

    protected synchronized void setTaskFinished(MessageTransferTask task) {
        this.taskMap.remove(task.getIdentifier());
        task.setFinished();
    }

    public synchronized void connected() {
        this.isConnected = true;
        logger.severe("now connected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnected() {
        this.isConnected = false;
        int taskCount = 0;
        HashMap<String, MessageTransferTask> hashMap = this.taskMap;
        synchronized (hashMap) {
            for (MessageTransferTask task : this.taskMap.values()) {
                task.setFailed();
                task.setFinished();
                ++taskCount;
            }
            this.taskMap.clear();
        }
        logger.severe("disconnected, set " + taskCount + " tasks failed");
    }

    public void handleNodeMessage(NodeMessage nm) {
    }

    public void handleNodeMessage(String id, NodeMessage nm) {
        MessageTransferTask task;
        if (Logging.inst().doLogFcp2Messages()) {
            System.out.println(">>>RCV>>>>");
            System.out.println("MSG=" + nm);
            System.out.println("<<<<<<<<<<");
        }
        if ((task = this.taskMap.get(id)) == null) {
            logger.severe("No task in list for identifier: " + id);
            return;
        }
        if (nm.isMessageName("AllData")) {
            this.onAllData(task, nm);
        } else if (nm.isMessageName("GetFailed")) {
            this.onGetFailed(task, nm);
        } else if (!nm.isMessageName("DataFound")) {
            if (nm.isMessageName("PutSuccessful")) {
                this.onPutSuccessful(task, nm);
            } else if (nm.isMessageName("PutFailed")) {
                this.onPutFailed(task, nm);
            } else if (!nm.isMessageName("URIGenerated")) {
                if (nm.isMessageName("ProtocolError")) {
                    this.handleError(task, nm);
                } else if (nm.isMessageName("IdentifierCollision")) {
                    this.handleError(task, nm);
                } else if (nm.isMessageName("UnknownNodeIdentifier")) {
                    this.handleError(task, nm);
                } else if (nm.isMessageName("UnknownPeerNoteType")) {
                    this.handleError(task, nm);
                } else {
                    System.out.println("### INFO - Unhandled msg: " + nm);
                }
            }
        }
    }

    protected void onAllData(MessageTransferTask task, NodeMessage nm) {
        if (nm.getMessageEnd() == null || !nm.getMessageEnd().equals("Data")) {
            logger.severe("NodeMessage has invalid end marker: " + nm.getMessageEnd());
            return;
        }
        long dataLength = nm.getLongValue("DataLength");
        long bytesWritten = 0L;
        try {
            int count;
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(task.getFile()));
            byte[] b = new byte[4096];
            long bytesLeft = dataLength;
            BufferedInputStream fcpIn = this.fcpTools.getFcpPersistentConnection().getFcpSocket().getFcpIn();
            while (bytesLeft > 0L && (count = fcpIn.read(b, 0, bytesLeft > (long)b.length ? b.length : (int)bytesLeft)) >= 0) {
                bytesLeft -= (long)count;
                fileOut.write(b, 0, count);
                bytesWritten += (long)count;
            }
            fileOut.close();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Catched exception", e);
        }
        if (Logging.inst().doLogFcp2Messages()) {
            System.out.println("*GET** Wrote " + bytesWritten + " of " + dataLength + " bytes to file.");
        }
        FcpResultGet result = bytesWritten == dataLength ? new FcpResultGet(true) : new FcpResultGet(false);
        task.setFcpResultGet(result);
        this.setTaskFinished(task);
    }

    protected void onGetFailed(MessageTransferTask task, NodeMessage nm) {
        int returnCode = nm.getIntValue("Code");
        String codeDescription = nm.getStringValue("CodeDescription");
        boolean isFatal = nm.getBoolValue("Fatal");
        String redirectURI = nm.getStringValue("RedirectURI");
        FcpResultGet result = new FcpResultGet(false, returnCode, codeDescription, isFatal, redirectURI);
        task.setFcpResultGet(result);
        this.setTaskFinished(task);
    }

    protected void onPutSuccessful(MessageTransferTask task, NodeMessage nm) {
        String chkKey = nm.getStringValue("URI");
        int pos = chkKey.indexOf("CHK@");
        if (pos > -1) {
            chkKey = chkKey.substring(pos).trim();
        }
        task.setFcpResultPut(new FcpResultPut(1, chkKey));
        this.setTaskFinished(task);
    }

    protected void onPutFailed(MessageTransferTask task, NodeMessage nm) {
        int returnCode = nm.getIntValue("Code");
        String codeDescription = nm.getStringValue("CodeDescription");
        boolean isFatal = nm.getBoolValue("Fatal");
        FcpResultPut result = returnCode == 9 ? new FcpResultPut(2, returnCode, codeDescription, isFatal) : (returnCode == 5 ? new FcpResultPut(4, returnCode, codeDescription, isFatal) : new FcpResultPut(3, returnCode, codeDescription, isFatal));
        task.setFcpResultPut(result);
        this.setTaskFinished(task);
    }

    protected void handleError(MessageTransferTask task, NodeMessage nm) {
        int returnCode = nm.getIntValue("Code");
        String codeDescription = nm.getStringValue("CodeDescription");
        boolean isFatal = nm.getBoolValue("Fatal");
        if (task.isModeDownload()) {
            FcpResultGet result = new FcpResultGet(false, returnCode, codeDescription, isFatal, null);
            task.setFcpResultGet(result);
        } else {
            FcpResultPut result = new FcpResultPut(3, returnCode, codeDescription, isFatal);
            task.setFcpResultPut(result);
        }
        this.setTaskFinished(task);
    }
}

