/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07.filepersistence;

import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.filepersistence.FcpPersistentRequest;

public class FcpPersistentPut
extends FcpPersistentRequest {
    private boolean isDirect = false;
    private String filename = null;
    private String uri = null;
    private long fileSize = -1L;
    private int doneBlocks = -1;
    private int totalBlocks = -1;
    private boolean isFinalized = false;

    public FcpPersistentPut(NodeMessage msg, String id) {
        super(msg, id);
        this.filename = msg.getStringValue("Filename");
        this.uri = msg.getStringValue("URI");
        this.fileSize = msg.getLongValue("DataLength");
        String isDirectStr = msg.getStringValue("UploadFrom");
        this.isDirect = !isDirectStr.equalsIgnoreCase("disk");
        if (this.filename == null) {
            this.filename = this.getIdentifier();
        }
    }

    public boolean isPut() {
        return true;
    }

    public void setProgress(NodeMessage msg) {
        this.doneBlocks = msg.getIntValue("Succeeded");
        this.totalBlocks = msg.getIntValue("Total");
        this.isFinalized = msg.getBoolValue("FinalizedTotal");
        super.setProgress();
    }

    public void setSuccess(NodeMessage msg) {
        this.uri = msg.getStringValue("URI");
        int pos = this.uri.indexOf("CHK@");
        if (pos > -1) {
            this.uri = this.uri.substring(pos).trim();
        }
        super.setSuccess();
    }

    public void setFailed(NodeMessage msg) {
        super.setFailed(msg);
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public String getUri() {
        return this.uri;
    }
}

