/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import freenet.support.ArrayBucket;
import freenet.support.Bucket;
import freenet.support.RandomAccessFileBucket;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FecBlock {
    public static final int TYPE_DATABLOCK = 1;
    public static final int TYPE_CHECKBLOCK = 2;
    public static final int STATE_TRANSFER_WAITING = 1;
    public static final int STATE_TRANSFER_RUNNING = 2;
    public static final int STATE_TRANSFER_FINISHED = 3;
    public static final int STATE_TRANSFER_INVALID = 4;
    private static Logger logger = Logger.getLogger(FecBlock.class.getName());
    protected int currentState = -1;
    protected int blockType = -1;
    protected String chkKey = null;
    protected File blockFile;
    protected int blockSize = -1;
    protected int segmentNo;
    protected int indexInSegment;
    protected int indexInFile;
    protected long fileOffset;
    protected RandomAccessFileBucket rafBucket = null;

    public FecBlock(int btype, File f, int segno, int ixInSeg, int ixInFile, int bsize, long foffs) {
        this.blockType = btype;
        this.blockFile = f;
        this.segmentNo = segno;
        this.indexInSegment = ixInSeg;
        this.indexInFile = ixInFile;
        this.blockSize = bsize;
        this.fileOffset = foffs;
        this.currentState = 1;
    }

    public void close() {
        if (this.rafBucket != null) {
            this.rafBucket.release();
            this.rafBucket = null;
        }
    }

    public RandomAccessFileBucket getRandomAccessFileBucket(boolean readOnly) {
        if (this.rafBucket != null) {
            return this.rafBucket;
        }
        try {
            this.rafBucket = new RandomAccessFileBucket(this.blockFile, this.getFileOffset(), this.getBlockSize(), readOnly);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in getRandomAccessFileBucket(boolean readOnly)", e);
            return null;
        }
        return this.rafBucket;
    }

    public Bucket getPaddedMemoryBucket() {
        byte[] data = this.getPaddedMemoryArray();
        if (data != null) {
            return new ArrayBucket(data);
        }
        return null;
    }

    public byte[] getPaddedMemoryArray() {
        byte[] data = null;
        try {
            data = new byte[this.getBlockSize()];
            long filelen = this.blockFile.length();
            if (this.fileOffset > filelen) {
                Arrays.fill(data, (byte)0);
            } else {
                RandomAccessFile f = new RandomAccessFile(this.blockFile, "r");
                f.seek(this.fileOffset);
                int read = f.read(data);
                f.close();
                if (read < 0) {
                    read = 0;
                }
                if (read < this.blockSize) {
                    Arrays.fill(data, read, this.blockSize, (byte)0);
                }
            }
            return data;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error in FecBlock.getPaddedMemoryArray()", ex);
            return null;
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public String getChkKey() {
        return this.chkKey;
    }

    public void setChkKey(String key) {
        this.chkKey = key;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public File getBlockFile() {
        return this.blockFile;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public int getIndexInFile() {
        return this.indexInFile;
    }

    public int getIndexInSegment() {
        return this.indexInSegment;
    }

    public int getSegmentNo() {
        return this.segmentNo;
    }

    public void setCurrentState(int i) {
        this.currentState = i;
    }
}

