/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.Core;
import frost.fcp.BoardKeyPair;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.NodeAddress;
import frost.fcp.fcp07.FcpConnection;
import frost.fcp.fcp07.FcpFactory;
import frost.fcp.fcp07.FcpInsert;
import frost.fcp.fcp07.FcpRequest;
import frost.fcp.fcp07.FcpSocket;
import frost.fcp.fcp07.messagetransfer.MessageTransferHandler;
import frost.fcp.fcp07.messagetransfer.MessageTransferTask;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.Logging;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpHandler07
extends FcpHandler {
    private static final Logger logger = Logger.getLogger(FcpHandler07.class.getName());
    private MessageTransferHandler msgTransferConnection = null;
    int count = 0;

    @Override
    public void initialize(List<String> nodes) {
        FcpFactory.init(nodes);
    }

    @Override
    public void goneOnline() {
        if (Core.frostSettings.getBoolValue("fcp2.useOneConnectionForMessages")) {
            try {
                this.msgTransferConnection = new MessageTransferHandler();
                this.msgTransferConnection.start();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Initialization of MessageTransferConnection failed", e);
            }
        }
    }

    @Override
    public List<NodeAddress> getNodes() {
        return FcpFactory.getNodes();
    }

    @Override
    public FcpResultGet getFile(int type, String key, Long size, File targetFile, boolean doRedirect, boolean fastDownload, int maxSize, int maxRetries, boolean createTempFile, FrostDownloadItem dlItem) {
        FcpResultGet result;
        key = FcpConnection.stripSlashes(key);
        int cnt = this.count++;
        long l = System.currentTimeMillis();
        if (type == 1 && this.msgTransferConnection != null) {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("GET_START(S)(" + cnt + "):" + key);
            }
            String id = "get-" + FcpSocket.getNextFcpId();
            int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityMessageDownload");
            MessageTransferTask task = new MessageTransferTask(id, key, targetFile, prio, maxSize, maxRetries);
            this.msgTransferConnection.enqueueTask(task);
            task.waitForFinished();
            result = task.getFcpResultGet();
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("GET_END(S)(" + cnt + "):" + key + ", duration=" + (System.currentTimeMillis() - l));
            }
        } else {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("GET_START(N)(" + cnt + "):" + key);
            }
            result = FcpRequest.getFile(type, key, size, targetFile, maxSize, maxRetries, createTempFile, dlItem);
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("GET_END(N)(" + cnt + "):" + key + ", duration=" + (System.currentTimeMillis() - l));
            }
        }
        return result;
    }

    @Override
    public FcpResultPut putFile(int type, String key, File sourceFile, byte[] metadata, boolean doRedirect, boolean removeLocalKey, boolean doMime, FrostUploadItem ulItem) {
        FcpResultPut result;
        key = FcpConnection.stripSlashes(key);
        int cnt = this.count++;
        long l = System.currentTimeMillis();
        if (type == 1 && this.msgTransferConnection != null) {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("PUT_START(S)(" + cnt + "):" + key);
            }
            String id = "get-" + FcpSocket.getNextFcpId();
            int prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityMessageUpload");
            MessageTransferTask task = new MessageTransferTask(id, key, sourceFile, prio);
            this.msgTransferConnection.enqueueTask(task);
            task.waitForFinished();
            result = task.getFcpResultPut();
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("PUT_END(S)(" + cnt + "):" + key + ", duration=" + (System.currentTimeMillis() - l));
            }
        } else {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("PUT_START(N)(" + cnt + "):" + key);
            }
            result = FcpInsert.putFile(type, key, sourceFile, doMime, ulItem);
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("PUT_END(N)(" + cnt + "):" + key + ", duration=" + (System.currentTimeMillis() - l));
            }
        }
        if (result == null) {
            return FcpResultPut.ERROR_RESULT;
        }
        return result;
    }

    @Override
    public String generateCHK(File file) throws IOException, ConnectException {
        FcpConnection connection = FcpFactory.getFcpConnectionInstance();
        if (connection == null) {
            return null;
        }
        String chkkey = connection.generateCHK(file);
        return chkkey;
    }

    @Override
    public List<String> getNodeInfo() throws IOException, ConnectException {
        FcpConnection connection = FcpFactory.getFcpConnectionInstance();
        if (connection == null) {
            return null;
        }
        return connection.getNodeInfo();
    }

    @Override
    public BoardKeyPair generateBoardKeyPair() throws IOException, ConnectException {
        FcpConnection connection = FcpFactory.getFcpConnectionInstance();
        if (connection == null) {
            return null;
        }
        String[] keyPair = connection.getKeyPair();
        if (keyPair == null) {
            return null;
        }
        String privKey = keyPair[0];
        String pubKey = keyPair[1];
        return new BoardKeyPair(pubKey, privKey);
    }
}

