/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.MainFrame;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.TofTreeModel;
import frost.gui.KnownBoardsManager;
import frost.gui.messagetreetable.MessageTreeTable;
import frost.gui.messagetreetable.MessageTreeTableSortStateBean;
import frost.identities.Identity;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FrostMessageObject;
import frost.messages.MessageXmlFile;
import frost.storage.MessageCallback;
import frost.storage.perst.messages.MessageStorage;
import frost.util.Mixed;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class TOF
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TOF.class.getName());
    private static final Language language = Language.getInstance();
    private UpdateTofFilesThread updateThread = null;
    private UpdateTofFilesThread nextUpdateThread = null;
    private final TofTreeModel tofTreeModel;
    private static boolean initialized = false;
    private boolean hideJunkMessages;
    private static TOF instance = null;

    public static TOF getInstance() {
        return instance;
    }

    private TOF(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
        this.hideJunkMessages = Core.frostSettings.getBoolValue("junk.hideJunkMessages");
        Core.frostSettings.addPropertyChangeListener("junk.hideJunkMessages", this);
    }

    public static void initialize(TofTreeModel tofTreeModel) {
        if (!initialized) {
            initialized = true;
            instance = new TOF(tofTreeModel);
        }
    }

    public void markAllMessagesRead(AbstractNode node) {
        this.markAllMessagesRead(node, true);
    }

    private void markAllMessagesRead(AbstractNode node, boolean confirm) {
        if (node == null) {
            return;
        }
        if (node.isBoard()) {
            int answer;
            if (confirm && (answer = MiscToolkit.showSuppressableConfirmDialog(MainFrame.getInstance(), language.formatMessage("TOF.markAllReadConfirmation.board.content", node.getName()), language.getString("TOF.markAllReadConfirmation.board.title"), 0, 2, "confirm.markAllMessagesRead", language.getString("Common.suppressConfirmationCheckbox"))) != 0) {
                return;
            }
            this.setAllMessagesRead((Board)node);
        } else if (node.isFolder()) {
            int answer;
            if (confirm && (answer = MiscToolkit.showSuppressableConfirmDialog(MainFrame.getInstance(), language.formatMessage("TOF.markAllReadConfirmation.folder.content", node.getName()), language.getString("TOF.markAllReadConfirmation.folder.title"), 0, 2, "confirm.markAllMessagesRead", language.getString("Common.suppressConfirmationCheckbox"))) != 0) {
                return;
            }
            Enumeration<AbstractNode> leafs = node.children();
            while (leafs.hasMoreElements()) {
                this.markAllMessagesRead(leafs.nextElement(), false);
            }
        }
    }

    private void setAllMessagesRead(final Board board) {
        final int oldUnreadMessageCount = board.getUnreadMessageCount();
        MessageStorage.inst().setAllMessagesRead(board);
        final DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)MainFrame.getInstance().getMessagePanel().getMessageTable().getTree().getModel().getRoot();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int diffNewMsgCount;
                if (MainFrame.getInstance().getTofTreeModel().getSelectedNode() == board) {
                    Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
                    while (e.hasMoreElements()) {
                        FrostMessageObject mo;
                        TreeNode o = e.nextElement();
                        if (!(o instanceof FrostMessageObject) || !(mo = (FrostMessageObject)o).isNew()) continue;
                        mo.setNew(false);
                        int row = MainFrame.getInstance().getMessageTreeTable().getRowForNode(mo);
                        if (row < 0) continue;
                        MainFrame.getInstance().getMessageTableModel().fireTableRowsUpdated(row, row);
                    }
                }
                board.setUnreadMessageCount((diffNewMsgCount = board.getUnreadMessageCount() - oldUnreadMessageCount) < 0 ? 0 : diffNewMsgCount);
                MainFrame.getInstance().updateMessageCountLabels(board);
                MainFrame.getInstance().updateTofTree(board);
            }
        });
    }

    public void receivedInvalidMessage(Board b, DateTime date, int index, String reason) {
        FrostMessageObject invalidMsg = new FrostMessageObject(b, date, index, reason);
        invalidMsg.setNew(false);
        try {
            MessageStorage.inst().insertMessage(invalidMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error inserting invalid message into database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedValidMessage(MessageXmlFile currentMsg, Identity owner, Board board, int index) {
        if (owner != null) {
            Object object = Core.getIdentities().getLockObject();
            synchronized (object) {
                Identity checkOwner = Core.getIdentities().getIdentity(owner.getUniqueName());
                long lastSeenMillis = 0L;
                try {
                    lastSeenMillis = currentMsg.getDateAndTime().getMillis();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Error updating Identities lastSeenTime", t);
                }
                if (checkOwner == null) {
                    owner.setLastSeenTimestampWithoutUpdate(lastSeenMillis);
                    if (!Core.getIdentities().addIdentity(owner)) {
                        logger.severe("Core.getIdentities().addIdentity(owner) returned false for identy: " + owner.getUniqueName());
                        currentMsg.setPublicKey(null);
                        currentMsg.setSignatureStatusOLD();
                        owner = null;
                    }
                } else {
                    owner = checkOwner;
                    if (owner.getLastSeenTimestamp() < lastSeenMillis) {
                        owner.setLastSeenTimestamp(lastSeenMillis);
                    }
                }
            }
        }
        FrostMessageObject newMsg = new FrostMessageObject(currentMsg, owner, board, index);
        this.receivedValidMessage(newMsg, board, index);
    }

    public void receivedValidMessage(FrostMessageObject newMsg, Board board, int index) {
        int messageInsertedRC;
        if (newMsg.isMessageFromME() && Core.frostSettings.getBoolValue("handleOwnMessagesAsNewDisabled")) {
            newMsg.setNew(false);
        } else {
            newMsg.setNew(true);
        }
        boolean isBlocked = this.isBlocked(newMsg, board);
        if (isBlocked) {
            newMsg.setNew(false);
        }
        try {
            messageInsertedRC = MessageStorage.inst().insertMessage(newMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error inserting new message into database", e);
            return;
        }
        if (messageInsertedRC == 2) {
            logger.severe("Duplicate message, not added to storage: " + newMsg.getMessageId());
            return;
        }
        if (messageInsertedRC != 1) {
            return;
        }
        if (newMsg.isSignatureStatusVERIFIED() && newMsg.getFromIdentity() != null) {
            newMsg.getFromIdentity().incReceivedMessageCount();
        }
        this.processNewMessage(newMsg, board, isBlocked);
    }

    private void processNewMessage(FrostMessageObject currentMsg, Board board, boolean isBlocked) {
        DateTime min = new LocalDate(DateTimeZone.UTC).minusDays(board.getMaxMessageDisplay()).toDateTimeAtMidnight();
        DateTime msgDate = new DateTime((Object)currentMsg.getDateAndTime(), DateTimeZone.UTC);
        if (msgDate.getMillis() > min.getMillis()) {
            this.addNewMessageToGui(currentMsg, board, isBlocked);
        }
        this.processAttachedBoards(currentMsg);
    }

    private void addNewMessageToGui(final FrostMessageObject message, final Board board, boolean isBlocked) {
        if (isBlocked) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractNode selectedNode;
                if (message.isNew()) {
                    board.newMessageReceived();
                    board.incUnreadMessageCount();
                    MainFrame.getInstance().updateTofTree(board);
                    MainFrame.getInstance().displayNewMessageIcon(true);
                }
                if ((selectedNode = TOF.this.tofTreeModel.getSelectedNode()).isBoard() && selectedNode.getName().equals(board.getName())) {
                    TOF.this.addNewMessageToModel(message, board);
                    MainFrame.getInstance().updateMessageCountLabels(board);
                }
            }
        });
    }

    private boolean tryToFillDummyMsg(FrostMessageObject newMessage) {
        FrostMessageObject rootNode = (FrostMessageObject)MainFrame.getInstance().getMessageTreeModel().getRoot();
        Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            FrostMessageObject mo = (FrostMessageObject)e.nextElement();
            if (mo == rootNode || mo.getMessageId() == null || !mo.getMessageId().equals(newMessage.getMessageId()) || !mo.isDummy()) continue;
            mo.fillFromOtherMessage(newMessage);
            int row = MainFrame.getInstance().getMessageTreeTable().getRowForNode(mo);
            if (row >= 0) {
                MainFrame.getInstance().getMessageTableModel().fireTableRowsUpdated(row, row);
            }
            return true;
        }
        return false;
    }

    private void addNewMessageToModel(FrostMessageObject newMessage, Board board) {
        FrostMessageObject rootNode = (FrostMessageObject)MainFrame.getInstance().getMessageTreeModel().getRoot();
        boolean showThreads = Core.frostSettings.getBoolValue("MessagePanel.showThreads");
        if (!showThreads || newMessage.getMessageId() == null || newMessage.getInReplyToList().size() == 0) {
            rootNode.add(newMessage, false);
            return;
        }
        if (this.tryToFillDummyMsg(newMessage)) {
            return;
        }
        LinkedList<String> msgParents = new LinkedList<String>(newMessage.getInReplyToList());
        while (msgParents.size() > 0) {
            String directParentId = msgParents.removeLast();
            Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                FrostMessageObject mo = (FrostMessageObject)e.nextElement();
                if (mo.getMessageId() == null || !mo.getMessageId().equals(directParentId)) continue;
                mo.add(newMessage, false);
                return;
            }
            FrostMessageObject dummyMsg = new FrostMessageObject(directParentId, board, null);
            dummyMsg.add(newMessage, true);
            newMessage = dummyMsg;
        }
        rootNode.add(newMessage, false);
    }

    public void updateTofTable(Board board, FrostMessageObject prevSelectedMsg) {
        int daysToRead = board.getMaxMessageDisplay();
        if (this.updateThread != null) {
            if (this.updateThread.toString().equals(board)) {
                return;
            }
            this.updateThread.cancel();
        }
        this.nextUpdateThread = new UpdateTofFilesThread(board, daysToRead, prevSelectedMsg);
        MainFrame.getInstance().activateGlassPane();
        this.nextUpdateThread.start();
    }

    public boolean isBlocked(FrostMessageObject message, Board board) {
        return this.isBlocked(message, board, Core.frostSettings.getBoolValue("blockMessageChecked"), Core.frostSettings.getBoolValue("blockMessageBodyChecked"), Core.frostSettings.getBoolValue("blockMessageBoardChecked"));
    }

    public boolean isBlocked(FrostMessageObject message, Board board, boolean blockMsgSubject, boolean blockMsgBody, boolean blockMsgBoardname) {
        String blockWord;
        StringTokenizer blockWords;
        if (this.hideJunkMessages && message.isJunk()) {
            return true;
        }
        if (board.getShowSignedOnly() && (message.isMessageStatusOLD() || message.isMessageStatusTAMPERED())) {
            return true;
        }
        if (board.getHideBad() && message.isMessageStatusBAD()) {
            return true;
        }
        if (board.getHideCheck() && message.isMessageStatusCHECK()) {
            return true;
        }
        if (board.getHideObserve() && message.isMessageStatusOBSERVE()) {
            return true;
        }
        if (blockMsgSubject) {
            String header = message.getSubject().toLowerCase();
            blockWords = new StringTokenizer(Core.frostSettings.getValue("blockMessage"), ";");
            while (blockWords.hasMoreTokens()) {
                blockWord = blockWords.nextToken().trim();
                if (blockWord.length() <= 0 || header.indexOf(blockWord) < 0) continue;
                return true;
            }
        }
        if (blockMsgBody) {
            String content = message.getContent().toLowerCase();
            blockWords = new StringTokenizer(Core.frostSettings.getValue("blockMessageBody"), ";");
            while (blockWords.hasMoreTokens()) {
                blockWord = blockWords.nextToken().trim();
                if (blockWord.length() <= 0 || content.indexOf(blockWord) < 0) continue;
                return true;
            }
        }
        if (blockMsgBoardname) {
            AttachmentList boards = message.getAttachmentsOfType(1);
            blockWords = new StringTokenizer(Core.frostSettings.getValue("blockMessageBoard"), ";");
            while (blockWords.hasMoreTokens()) {
                blockWord = blockWords.nextToken().trim();
                for (BoardAttachment boardAttachment : boards) {
                    Board boardObject = boardAttachment.getBoardObj();
                    if (blockWord.length() <= 0 || !boardObject.getName().equalsIgnoreCase(blockWord)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processAttachedBoards(FrostMessageObject currentMsg) {
        if (currentMsg.isMessageStatusOLD() && Core.frostSettings.getBoolValue("blockBoardsFromUnsigned")) {
            logger.info("Boards from unsigned message blocked");
        } else if (currentMsg.isMessageStatusBAD() && Core.frostSettings.getBoolValue("blockBoardsFromBad")) {
            logger.info("Boards from BAD message blocked");
        } else if (currentMsg.isMessageStatusCHECK() && Core.frostSettings.getBoolValue("blockBoardsFromCheck")) {
            logger.info("Boards from CHECK message blocked");
        } else if (currentMsg.isMessageStatusOBSERVE() && Core.frostSettings.getBoolValue("blockBoardsFromObserve")) {
            logger.info("Boards from OBSERVE message blocked");
        } else if (currentMsg.isMessageStatusTAMPERED()) {
            logger.info("Boards from TAMPERED message blocked");
        } else {
            LinkedList<Board> addBoards = new LinkedList<Board>();
            for (BoardAttachment ba : currentMsg.getAttachmentsOfType(1)) {
                addBoards.add(ba.getBoardObj());
            }
            KnownBoardsManager.addNewKnownBoards(addBoards);
        }
    }

    public void searchAllUnreadMessages(boolean runWithinThread) {
        if (runWithinThread) {
            new Thread(){

                public void run() {
                    TOF.this.searchAllUnreadMessages();
                }
            }.start();
        } else {
            this.searchAllUnreadMessages();
        }
    }

    public void searchUnreadMessages(final Board board) {
        new Thread(){

            public void run() {
                TOF.this.searchUnreadMessagesInBoard(board);
            }
        }.start();
    }

    private void searchAllUnreadMessages() {
        Enumeration<AbstractNode> e = this.tofTreeModel.getRoot().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractNode node = e.nextElement();
            if (!node.isBoard()) continue;
            this.searchUnreadMessagesInBoard((Board)node);
        }
    }

    private void searchUnreadMessagesInBoard(final Board board) {
        if (!board.isBoard()) {
            return;
        }
        int beforeMessages = board.getUnreadMessageCount();
        int newMessages = 0;
        newMessages = MessageStorage.inst().getUnreadMessageCount(board);
        int arrivedMessages = board.getUnreadMessageCount() - beforeMessages;
        if (arrivedMessages > 0) {
            newMessages += arrivedMessages;
        }
        board.setUnreadMessageCount(newMessages);
        boolean hasFlagged = false;
        boolean hasStarred = false;
        hasFlagged = MessageStorage.inst().hasFlaggedMessages(board);
        hasStarred = MessageStorage.inst().hasStarredMessages(board);
        board.setFlaggedMessages(hasFlagged);
        board.setStarredMessages(hasStarred);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.getInstance().updateTofTree(board);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("junk.hideJunkMessages")) {
            this.hideJunkMessages = Core.frostSettings.getBoolValue("junk.hideJunkMessages");
        }
    }

    private class UpdateTofFilesThread
    extends Thread {
        Board board;
        int daysToRead;
        boolean isCancelled = false;
        String fileSeparator = System.getProperty("file.separator");
        FrostMessageObject previousSelectedMsg;
        List<FrostMessageObject> markAsReadMsgs = new ArrayList<FrostMessageObject>();

        public UpdateTofFilesThread(Board board, int daysToRead, FrostMessageObject prevSelectedMsg) {
            this.board = board;
            this.daysToRead = daysToRead;
            this.previousSelectedMsg = prevSelectedMsg;
        }

        public synchronized void cancel() {
            this.isCancelled = true;
        }

        public synchronized boolean isCancel() {
            return this.isCancelled;
        }

        public String toString() {
            return this.board.getName();
        }

        private void loadMessages(MessageCallback callback) {
            boolean showDeletedMessages = Core.frostSettings.getBoolValue("showDeletedMessages");
            boolean showUnreadOnly = Core.frostSettings.getBoolValue("MessagePanel.showUnreadOnly");
            MessageStorage.inst().retrieveMessagesForShow(this.board, this.daysToRead, false, false, showDeletedMessages, showUnreadOnly, callback);
        }

        public void run() {
            while (TOF.this.updateThread != null) {
                Mixed.wait(150);
                if (TOF.this.nextUpdateThread == this) continue;
                return;
            }
            if (TOF.this.nextUpdateThread != this) {
                return;
            }
            TOF.this.updateThread = this;
            final FrostMessageObject rootNode = new FrostMessageObject(true);
            boolean loadThreads = Core.frostSettings.getBoolValue("MessagePanel.showThreads");
            MessageTreeTableSortStateBean.setThreaded(loadThreads);
            try {
                if (loadThreads) {
                    ThreadedMessageRetrieval tmr = new ThreadedMessageRetrieval(rootNode);
                    long l1 = System.currentTimeMillis();
                    this.loadMessages(tmr);
                    long l2 = System.currentTimeMillis();
                    tmr.buildThreads();
                    long l3 = System.currentTimeMillis();
                    System.out.println("loading board " + this.board.getName() + ": load=" + (l2 - l1) + ", build+subretrieve=" + (l3 - l2));
                } else {
                    FlatMessageRetrieval ffr = new FlatMessageRetrieval(rootNode);
                    this.loadMessages(ffr);
                }
                MessageStorage.inst().setMessagesRead(this.board, this.markAsReadMsgs);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Excpetion during thread load/build", t);
            }
            if (!this.isCancel()) {
                int newMessageCountWork = 0;
                boolean hasStarredWork = false;
                boolean hasFlaggedWork = false;
                Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
                while (e.hasMoreElements()) {
                    FrostMessageObject mo = (FrostMessageObject)e.nextElement();
                    if (mo.isNew()) {
                        ++newMessageCountWork;
                    }
                    if (!hasStarredWork && mo.isStarred()) {
                        hasStarredWork = true;
                    }
                    if (hasFlaggedWork || !mo.isFlagged()) continue;
                    hasFlaggedWork = true;
                }
                final Board innerTargetBoard = this.board;
                final int newMessageCount = newMessageCountWork;
                final boolean newHasFlagged = hasFlaggedWork;
                final boolean newHasStarred = hasStarredWork;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        innerTargetBoard.setUnreadMessageCount(newMessageCount);
                        innerTargetBoard.setFlaggedMessages(newHasFlagged);
                        innerTargetBoard.setStarredMessages(newHasStarred);
                        UpdateTofFilesThread.this.setNewRootNode(innerTargetBoard, rootNode, UpdateTofFilesThread.this.previousSelectedMsg);
                    }
                });
            } else if (TOF.this.nextUpdateThread == null) {
                MainFrame.getInstance().deactivateGlassPane();
            }
            TOF.this.updateThread = null;
        }

        private void setNewRootNode(Board innerTargetBoard, FrostMessageObject rootNode, FrostMessageObject previousSelectedMsg) {
            if (TOF.this.tofTreeModel.getSelectedNode().isBoard() && TOF.this.tofTreeModel.getSelectedNode().getName().equals(innerTargetBoard.getName())) {
                MessageTreeTable treeTable = MainFrame.getInstance().getMessageTreeTable();
                treeTable.setNewRootNode(rootNode);
                if (!Core.frostSettings.getBoolValue("messageTableShowCollapsedThreads")) {
                    treeTable.expandAll(true);
                }
                MainFrame.getInstance().updateTofTree(innerTargetBoard);
                MainFrame.getInstance().updateMessageCountLabels(innerTargetBoard);
                if (previousSelectedMsg != null && previousSelectedMsg.getMessageId() != null) {
                    Enumeration<TreeNode> e = rootNode.breadthFirstEnumeration();
                    while (e.hasMoreElements()) {
                        FrostMessageObject mo = (FrostMessageObject)e.nextElement();
                        if (mo.getMessageId() == null || !mo.getMessageId().equals(previousSelectedMsg.getMessageId())) continue;
                        int row = treeTable.getRowForNode(mo);
                        if (row <= -1) break;
                        treeTable.getSelectionModel().setSelectionInterval(row, row);
                        if (row + 1 < treeTable.getRowCount()) {
                            ++row;
                        }
                        Rectangle r = treeTable.getCellRect(row, 0, true);
                        treeTable.scrollRectToVisible(r);
                        break;
                    }
                }
                MainFrame.getInstance().deactivateGlassPane();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ThreadedMessageRetrieval
        implements MessageCallback {
            final FrostMessageObject rootNode;
            LinkedList<FrostMessageObject> messageList = new LinkedList();

            public ThreadedMessageRetrieval(FrostMessageObject root) {
                this.rootNode = root;
            }

            @Override
            public boolean messageRetrieved(FrostMessageObject mo) {
                this.messageList.add(mo);
                return UpdateTofFilesThread.this.isCancel();
            }

            public void buildThreads() {
                FrostMessageObject mo;
                Enumeration<TreeNode> e;
                boolean blockMsgSubject = Core.frostSettings.getBoolValue("blockMessageChecked");
                boolean blockMsgBody = Core.frostSettings.getBoolValue("blockMessageBodyChecked");
                boolean blockMsgBoardname = Core.frostSettings.getBoolValue("blockMessageBoardChecked");
                HashSet<String> messageIds = new HashSet<String>();
                Iterator i = this.messageList.iterator();
                while (i.hasNext()) {
                    FrostMessageObject mo2 = (FrostMessageObject)i.next();
                    if (mo2.getMessageId() == null) {
                        i.remove();
                        if (!TOF.this.isBlocked(mo2, mo2.getBoard(), blockMsgSubject, blockMsgBody, blockMsgBoardname)) {
                            this.rootNode.add(mo2);
                            continue;
                        }
                        if (!mo2.isNew()) continue;
                        UpdateTofFilesThread.this.markAsReadMsgs.add(mo2);
                        continue;
                    }
                    messageIds.add(mo2.getMessageId());
                }
                boolean showDeletedMessages = Core.frostSettings.getBoolValue("showDeletedMessages");
                LinkedList<FrostMessageObject> newLoadedMsgs = new LinkedList<FrostMessageObject>();
                LinkedList<FrostMessageObject> newLoadedMsgs2 = new LinkedList<FrostMessageObject>();
                this.loadInReplyToMessages(this.messageList, messageIds, showDeletedMessages, newLoadedMsgs);
                while (this.loadInReplyToMessages(newLoadedMsgs, messageIds, showDeletedMessages, newLoadedMsgs2)) {
                    this.messageList.addAll(newLoadedMsgs);
                    newLoadedMsgs = newLoadedMsgs2;
                    newLoadedMsgs2 = new LinkedList();
                }
                this.messageList.addAll(newLoadedMsgs);
                newLoadedMsgs = null;
                messageIds = null;
                HashMap<String, FrostMessageObject> messagesTableById = new HashMap<String, FrostMessageObject>();
                for (FrostMessageObject mo3 : this.messageList) {
                    messagesTableById.put(mo3.getMessageId(), mo3);
                }
                this.messageList = null;
                for (FrostMessageObject mo3 : messagesTableById.values()) {
                    ArrayList<String> l = mo3.getInReplyToList();
                    if (l.size() == 0) {
                        this.rootNode.add(mo3);
                        continue;
                    }
                    String directParentId = l.get(l.size() - 1);
                    if (directParentId == null) {
                        logger.log(Level.SEVERE, "Should never happen: directParentId is null; msg=" + mo3.getMessageId() + "; parentMsg=" + directParentId);
                        continue;
                    }
                    FrostMessageObject parentMo = (FrostMessageObject)messagesTableById.get(directParentId);
                    if (parentMo == null) {
                        logger.log(Level.SEVERE, "Should never happen: parentMo is null; msg=" + mo3.getMessageId() + "; parentMsg=" + directParentId + "; irtl=" + mo3.getInReplyTo());
                        continue;
                    }
                    parentMo.add(mo3);
                }
                ArrayList<FrostMessageObject> itemsToRemove = new ArrayList<FrostMessageObject>();
                HashSet<String> notBlockedMessageIds = new HashSet<String>();
                while (true) {
                    e = this.rootNode.depthFirstEnumeration();
                    while (e.hasMoreElements()) {
                        mo = (FrostMessageObject)e.nextElement();
                        if (!mo.isLeaf() || mo == this.rootNode) continue;
                        if (mo.isDummy()) {
                            itemsToRemove.add(mo);
                            continue;
                        }
                        if (mo.getMessageId() == null) {
                            if (!TOF.this.isBlocked(mo, mo.getBoard(), blockMsgSubject, blockMsgBody, blockMsgBoardname)) continue;
                            itemsToRemove.add(mo);
                            if (!mo.isNew()) continue;
                            UpdateTofFilesThread.this.markAsReadMsgs.add(mo);
                            continue;
                        }
                        if (notBlockedMessageIds.contains(mo.getMessageId())) continue;
                        if (TOF.this.isBlocked(mo, mo.getBoard(), blockMsgSubject, blockMsgBody, blockMsgBoardname)) {
                            itemsToRemove.add(mo);
                            if (!mo.isNew()) continue;
                            UpdateTofFilesThread.this.markAsReadMsgs.add(mo);
                            continue;
                        }
                        notBlockedMessageIds.add(mo.getMessageId());
                    }
                    if (itemsToRemove.size() <= 0) break;
                    for (FrostMessageObject removeMo : itemsToRemove) {
                        removeMo.removeFromParent();
                    }
                    itemsToRemove.clear();
                }
                notBlockedMessageIds.clear();
                e = this.rootNode.children();
                block7: while (e.hasMoreElements()) {
                    mo = (FrostMessageObject)e.nextElement();
                    if (!mo.isDummy()) continue;
                    Enumeration<TreeNode> e2 = mo.breadthFirstEnumeration();
                    while (e2.hasMoreElements()) {
                        FrostMessageObject childMo = (FrostMessageObject)e2.nextElement();
                        if (childMo.isDummy() || childMo.getSubject() == null) continue;
                        StringBuilder sb = new StringBuilder(childMo.getSubject().length() + 2);
                        sb.append("[").append(childMo.getSubject()).append("]");
                        mo.setSubject(sb.toString());
                        continue block7;
                    }
                }
            }

            private boolean loadInReplyToMessages(List<FrostMessageObject> messages, HashSet<String> messageIds, boolean showDeletedMessages, LinkedList<FrostMessageObject> newLoadedMsgs) {
                boolean msgWasMissing = false;
                for (FrostMessageObject mo : messages) {
                    ArrayList<String> l = mo.getInReplyToList();
                    if (l.size() == 0) continue;
                    for (int x = l.size() - 1; x >= 0; --x) {
                        String anId = (String)l.get(x);
                        if (anId == null) {
                            logger.log(Level.SEVERE, "Should never happen: message id is null! msgId=" + mo.getMessageId());
                            continue;
                        }
                        if (messageIds.contains(anId)) continue;
                        FrostMessageObject fmo = MessageStorage.inst().retrieveMessageByMessageId(UpdateTofFilesThread.this.board, anId, false, false, showDeletedMessages);
                        if (fmo == null) {
                            ArrayList<String> ll = new ArrayList<String>(x);
                            if (x > 0) {
                                for (int y = 0; y < x; ++y) {
                                    ll.add((String)l.get(y));
                                }
                            }
                            fmo = new FrostMessageObject(anId, UpdateTofFilesThread.this.board, ll);
                        }
                        newLoadedMsgs.add(fmo);
                        messageIds.add(anId);
                        if (msgWasMissing) continue;
                        msgWasMissing = true;
                    }
                }
                return msgWasMissing;
            }
        }

        private class FlatMessageRetrieval
        implements MessageCallback {
            private final FrostMessageObject rootNode;
            private final boolean blockMsgSubject;
            private final boolean blockMsgBody;
            private final boolean blockMsgBoardname;

            public FlatMessageRetrieval(FrostMessageObject root) {
                this.rootNode = root;
                this.blockMsgSubject = Core.frostSettings.getBoolValue("blockMessageChecked");
                this.blockMsgBody = Core.frostSettings.getBoolValue("blockMessageBodyChecked");
                this.blockMsgBoardname = Core.frostSettings.getBoolValue("blockMessageBoardChecked");
            }

            public boolean messageRetrieved(FrostMessageObject mo) {
                if (!TOF.this.isBlocked(mo, UpdateTofFilesThread.this.board, this.blockMsgSubject, this.blockMsgBody, this.blockMsgBoardname)) {
                    this.rootNode.add(mo);
                } else if (mo.isNew()) {
                    UpdateTofFilesThread.this.markAsReadMsgs.add(mo);
                }
                return UpdateTofFilesThread.this.isCancel();
            }
        }
    }
}

