/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Digest;
import freenet.crypt.JavaSHA1;
import freenet.support.Fields;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class SHA1
implements Digest {
    protected static boolean alwaysThisOne = false;
    private int[] state = new int[5];
    private long count = 0L;
    private boolean digestValid = false;
    private byte[] digestBits;
    private boolean NSA = true;
    private int[] block = new int[16];
    private int blockIndex;
    private int[] dd = new int[5];

    public static Digest getInstance(boolean needProgressive) {
        if (alwaysThisOne) {
            needProgressive = true;
        }
        if (needProgressive) {
            return new SHA1();
        }
        try {
            return new JavaSHA1();
        }
        catch (NoSuchAlgorithmException e) {
            alwaysThisOne = true;
            return new SHA1();
        }
        catch (Exception e) {
            return new SHA1();
        }
    }

    public static Digest getInstance() {
        return SHA1.getInstance(false);
    }

    public final int digestSize() {
        return 160;
    }

    public final void extract(int[] digest, int offset) {
        for (int i = 0; i < 5; ++i) {
            digest[i + offset] = this.digestBits[4 * i + 0] << 24 & 0xFF000000 | this.digestBits[4 * i + 1] << 16 & 0xFF0000 | this.digestBits[4 * i + 2] << 8 & 0xFF00 | this.digestBits[4 * i + 3] & 0xFF;
        }
    }

    public SHA1(boolean b) {
        this.NSA = b;
        this.init();
    }

    public SHA1() {
        this(true);
    }

    private final int rol(int value, int bits) {
        int q = value << bits | value >>> 32 - bits;
        return q;
    }

    private final int blk0(int i) {
        this.block[i] = this.rol(this.block[i], 24) & 0xFF00FF00 | this.rol(this.block[i], 8) & 0xFF00FF;
        return this.block[i];
    }

    private final int blk(int i) {
        this.block[i & 0xF] = this.block[i + 13 & 0xF] ^ this.block[i + 8 & 0xF] ^ this.block[i + 2 & 0xF] ^ this.block[i & 0xF];
        if (this.NSA) {
            this.block[i & 0xF] = this.rol(this.block[i & 0xF], 1);
        }
        return this.block[i & 0xF];
    }

    private final void R0(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + this.blk0(i) + 1518500249 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    private final void R1(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + this.blk(i) + 1518500249 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    private final void R2(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + this.blk(i) + 1859775393 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    private final void R3(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + (((data[w] | data[x]) & data[y] | data[w] & data[x]) + this.blk(i) + -1894007588 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    private final void R4(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + this.blk(i) + -899497514 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    private final void transform() {
        this.dd[0] = this.state[0];
        this.dd[1] = this.state[1];
        this.dd[2] = this.state[2];
        this.dd[3] = this.state[3];
        this.dd[4] = this.state[4];
        this.R0(this.dd, 0, 1, 2, 3, 4, 0);
        this.R0(this.dd, 4, 0, 1, 2, 3, 1);
        this.R0(this.dd, 3, 4, 0, 1, 2, 2);
        this.R0(this.dd, 2, 3, 4, 0, 1, 3);
        this.R0(this.dd, 1, 2, 3, 4, 0, 4);
        this.R0(this.dd, 0, 1, 2, 3, 4, 5);
        this.R0(this.dd, 4, 0, 1, 2, 3, 6);
        this.R0(this.dd, 3, 4, 0, 1, 2, 7);
        this.R0(this.dd, 2, 3, 4, 0, 1, 8);
        this.R0(this.dd, 1, 2, 3, 4, 0, 9);
        this.R0(this.dd, 0, 1, 2, 3, 4, 10);
        this.R0(this.dd, 4, 0, 1, 2, 3, 11);
        this.R0(this.dd, 3, 4, 0, 1, 2, 12);
        this.R0(this.dd, 2, 3, 4, 0, 1, 13);
        this.R0(this.dd, 1, 2, 3, 4, 0, 14);
        this.R0(this.dd, 0, 1, 2, 3, 4, 15);
        this.R1(this.dd, 4, 0, 1, 2, 3, 16);
        this.R1(this.dd, 3, 4, 0, 1, 2, 17);
        this.R1(this.dd, 2, 3, 4, 0, 1, 18);
        this.R1(this.dd, 1, 2, 3, 4, 0, 19);
        this.R2(this.dd, 0, 1, 2, 3, 4, 20);
        this.R2(this.dd, 4, 0, 1, 2, 3, 21);
        this.R2(this.dd, 3, 4, 0, 1, 2, 22);
        this.R2(this.dd, 2, 3, 4, 0, 1, 23);
        this.R2(this.dd, 1, 2, 3, 4, 0, 24);
        this.R2(this.dd, 0, 1, 2, 3, 4, 25);
        this.R2(this.dd, 4, 0, 1, 2, 3, 26);
        this.R2(this.dd, 3, 4, 0, 1, 2, 27);
        this.R2(this.dd, 2, 3, 4, 0, 1, 28);
        this.R2(this.dd, 1, 2, 3, 4, 0, 29);
        this.R2(this.dd, 0, 1, 2, 3, 4, 30);
        this.R2(this.dd, 4, 0, 1, 2, 3, 31);
        this.R2(this.dd, 3, 4, 0, 1, 2, 32);
        this.R2(this.dd, 2, 3, 4, 0, 1, 33);
        this.R2(this.dd, 1, 2, 3, 4, 0, 34);
        this.R2(this.dd, 0, 1, 2, 3, 4, 35);
        this.R2(this.dd, 4, 0, 1, 2, 3, 36);
        this.R2(this.dd, 3, 4, 0, 1, 2, 37);
        this.R2(this.dd, 2, 3, 4, 0, 1, 38);
        this.R2(this.dd, 1, 2, 3, 4, 0, 39);
        this.R3(this.dd, 0, 1, 2, 3, 4, 40);
        this.R3(this.dd, 4, 0, 1, 2, 3, 41);
        this.R3(this.dd, 3, 4, 0, 1, 2, 42);
        this.R3(this.dd, 2, 3, 4, 0, 1, 43);
        this.R3(this.dd, 1, 2, 3, 4, 0, 44);
        this.R3(this.dd, 0, 1, 2, 3, 4, 45);
        this.R3(this.dd, 4, 0, 1, 2, 3, 46);
        this.R3(this.dd, 3, 4, 0, 1, 2, 47);
        this.R3(this.dd, 2, 3, 4, 0, 1, 48);
        this.R3(this.dd, 1, 2, 3, 4, 0, 49);
        this.R3(this.dd, 0, 1, 2, 3, 4, 50);
        this.R3(this.dd, 4, 0, 1, 2, 3, 51);
        this.R3(this.dd, 3, 4, 0, 1, 2, 52);
        this.R3(this.dd, 2, 3, 4, 0, 1, 53);
        this.R3(this.dd, 1, 2, 3, 4, 0, 54);
        this.R3(this.dd, 0, 1, 2, 3, 4, 55);
        this.R3(this.dd, 4, 0, 1, 2, 3, 56);
        this.R3(this.dd, 3, 4, 0, 1, 2, 57);
        this.R3(this.dd, 2, 3, 4, 0, 1, 58);
        this.R3(this.dd, 1, 2, 3, 4, 0, 59);
        this.R4(this.dd, 0, 1, 2, 3, 4, 60);
        this.R4(this.dd, 4, 0, 1, 2, 3, 61);
        this.R4(this.dd, 3, 4, 0, 1, 2, 62);
        this.R4(this.dd, 2, 3, 4, 0, 1, 63);
        this.R4(this.dd, 1, 2, 3, 4, 0, 64);
        this.R4(this.dd, 0, 1, 2, 3, 4, 65);
        this.R4(this.dd, 4, 0, 1, 2, 3, 66);
        this.R4(this.dd, 3, 4, 0, 1, 2, 67);
        this.R4(this.dd, 2, 3, 4, 0, 1, 68);
        this.R4(this.dd, 1, 2, 3, 4, 0, 69);
        this.R4(this.dd, 0, 1, 2, 3, 4, 70);
        this.R4(this.dd, 4, 0, 1, 2, 3, 71);
        this.R4(this.dd, 3, 4, 0, 1, 2, 72);
        this.R4(this.dd, 2, 3, 4, 0, 1, 73);
        this.R4(this.dd, 1, 2, 3, 4, 0, 74);
        this.R4(this.dd, 0, 1, 2, 3, 4, 75);
        this.R4(this.dd, 4, 0, 1, 2, 3, 76);
        this.R4(this.dd, 3, 4, 0, 1, 2, 77);
        this.R4(this.dd, 2, 3, 4, 0, 1, 78);
        this.R4(this.dd, 1, 2, 3, 4, 0, 79);
        this.state[0] = this.state[0] + this.dd[0];
        this.state[1] = this.state[1] + this.dd[1];
        this.state[2] = this.state[2] + this.dd[2];
        this.state[3] = this.state[3] + this.dd[3];
        this.state[4] = this.state[4] + this.dd[4];
    }

    public final void frob() {
        this.count = 0L;
        this.state[4] = 0;
        this.state[3] = 0;
        this.state[2] = 0;
        this.state[1] = 0;
        this.state[0] = 0;
    }

    protected final void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.count = 0L;
        this.digestBits = new byte[20];
        this.digestValid = false;
        this.blockIndex = 0;
    }

    public final void update(byte b) {
        int mask = (this.blockIndex & 3) << 3;
        this.count += 8L;
        int n = this.blockIndex >> 2;
        this.block[n] = this.block[n] & ~(255 << mask);
        int n2 = this.blockIndex >> 2;
        this.block[n2] = this.block[n2] | (b & 0xFF) << mask;
        ++this.blockIndex;
        if (this.blockIndex == 64) {
            this.transform();
            this.blockIndex = 0;
        }
    }

    public final void update(byte[] data, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.update(data[offset + i]);
        }
    }

    public final void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public final void digest(boolean reset, byte[] buffer, int offset) {
        this.finish();
        System.arraycopy(this.digestBits, 0, buffer, offset, this.digestBits.length);
        if (reset) {
            this.init();
        }
    }

    public final byte[] digest(boolean reset) {
        byte[] out = new byte[20];
        this.digest(reset, out, 0);
        return out;
    }

    public final byte[] digest() {
        return this.digest(true);
    }

    protected final void finish() {
        int i;
        byte[] bits = new byte[8];
        for (i = 0; i < 8; ++i) {
            bits[i] = (byte)(this.count >>> (7 - i << 3) & 0xFFL);
        }
        this.update((byte)-128);
        while (this.blockIndex != 56) {
            this.update((byte)0);
        }
        for (i = 0; i < 8; ++i) {
            this.update(bits[i]);
        }
        for (i = 0; i < 20; ++i) {
            this.digestBits[i] = (byte)(this.state[i >> 2] >>> (3 - (i & 3) << 3) & 0xFF);
        }
        this.digestValid = true;
    }

    protected String digout() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            char c1 = (char)(this.digestBits[i] >>> 4 & 0xF);
            char c2 = (char)(this.digestBits[i] & 0xF);
            c1 = (char)(c1 > '\t' ? 65 + (c1 - 10) : 48 + c1);
            c2 = (char)(c2 > '\t' ? 65 + (c2 - 10) : 48 + c2);
            sb.append(c1);
            sb.append(c2);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        SHA1.SHAselfTest();
        SHA1.SHAbenchTest();
    }

    public static void SHAbenchTest() {
        try {
            JavaSHA1 s = new JavaSHA1();
            SHA1.genericBenchTest(s);
            try {
                JavaSHA1 s1 = (JavaSHA1)s.clone();
                System.err.println("Cloned successfully");
                SHA1.genericBenchTest(s1);
            }
            catch (CloneNotSupportedException e) {
                System.err.println("Couldn't clone");
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't run benchmark for JavaSHA1");
        }
        SHA1 sha1 = new SHA1(true);
        SHA1.genericBenchTest(sha1);
    }

    public static void genericBenchTest(Digest sha1) {
        System.out.println("\nBegin benchmark");
        long size = 4096L;
        long count = 100000L;
        byte[] data = SHA1.createDummyData((int)size);
        long startSameUpdate = System.currentTimeMillis();
        int i = 0;
        while ((long)i < count) {
            sha1.update(data);
            ++i;
        }
        long endSameUpdate = System.currentTimeMillis();
        byte[] digested = sha1.digest();
        long afterDigested = System.currentTimeMillis();
        long updateTime = endSameUpdate - startSameUpdate;
        long speed = 0L;
        long eachTime = 0L;
        if (updateTime > 0L) {
            speed = size * count * 1000L / updateTime;
            eachTime = count / updateTime;
        }
        System.out.println("SHA update " + count + " times for the same data block of size " + size + " bytes:");
        System.out.println(updateTime + "ms [" + speed + "bytes/second, " + eachTime + "updates/ms]\n");
        count = 1000L;
        byte[][] data2 = new byte[(int)count][];
        int i2 = 0;
        while ((long)i2 < count) {
            data2[i2] = SHA1.createDummyData((int)size);
            ++i2;
        }
        long differentStartTime = System.currentTimeMillis();
        int i3 = 0;
        while ((long)i3 < count) {
            sha1.update(data2[i3]);
            ++i3;
        }
        long endDifferentUpdate = System.currentTimeMillis();
        digested = sha1.digest();
        afterDigested = System.currentTimeMillis();
        updateTime = endDifferentUpdate - differentStartTime;
        speed = 0L;
        eachTime = 0L;
        if (updateTime > 0L) {
            speed = size * count * 1000L / updateTime;
            eachTime = count / updateTime;
        }
        System.out.println("SHA update " + count + " times for different data blocks of size " + size + " bytes:");
        System.out.println(updateTime + "ms [" + speed + "bytes/second, " + eachTime + "ms/update]");
        System.out.println("\nEnd benchmark");
    }

    private static byte[] createDummyData(int size) {
        Random rand = new Random();
        byte[] buf = new byte[size];
        rand.nextBytes(buf);
        return buf;
    }

    public static void SHAselfTest() {
        System.err.println("Testing JavaSHA1:");
        try {
            JavaSHA1 js = new JavaSHA1();
            SHA1.SHAselfTest(js);
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e + " trying to test JavaSHA1");
        }
        System.err.println("Testing SHA1:");
        SHA1 s = new SHA1(true);
        SHA1.SHAselfTest(s);
    }

    public static void SHAselfTest(Digest s) {
        int i;
        System.out.println("SHA-1 Test PROGRAM.");
        System.out.println("This code runs the test vectors through the code.");
        System.out.println("First test is 'abc'");
        String z = "abc";
        s.update((byte)97);
        s.update((byte)98);
        s.update((byte)99);
        System.out.println(Fields.bytesToHex(s.digest()).toUpperCase());
        System.out.println("A9993E364706816ABA3E25717850C26C9CD0D89D");
        System.out.println("Next Test is 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'");
        z = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
        for (i = 0; i < z.length(); ++i) {
            s.update((byte)z.charAt(i));
        }
        System.out.println(Fields.bytesToHex(s.digest()).toUpperCase());
        System.out.println("84983E441C3BD26EBAAE4AA1F95129E5E54670F1");
        long startTime = 0L - System.currentTimeMillis();
        System.out.println("Last test is 1 million 'a' characters.");
        for (i = 0; i < 1000000; ++i) {
            s.update((byte)97);
        }
        System.out.println(Fields.bytesToHex(s.digest()).toUpperCase());
        System.out.println("34AA973CD4C4DAA4F61EEB2BDBAD27316534016F");
        double d = (double)(startTime += System.currentTimeMillis()) / 1000.0;
        System.out.println(" done, elapsed time = " + d);
    }
}

