/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.KeyException;
import freenet.Storables;
import freenet.crypt.ProgressiveHashInputStream;
import freenet.crypt.SHA1;
import freenet.support.Fields;
import freenet.support.Measurable;
import freenet.support.io.DataNotValidIOException;
import freenet.support.io.VerifyingInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class Key
implements Measurable {
    public static final Key NIL = new Key(new byte[0]);
    public static final int LOG2_MAXSIZE = 62;
    public static final int LOG2_MINSIZE = 10;
    private static final Hashtable keytypes = new Hashtable();
    protected byte[] val;

    public static void addKeyType(int typen, Class c) throws KeyException {
        if (!Key.class.isAssignableFrom(c)) {
            throw new KeyException("Not a subclass of Key");
        }
        try {
            Constructor con = c.getConstructor(byte[].class);
            keytypes.put(new Integer(typen), con);
        }
        catch (NoSuchMethodException e) {
            throw new KeyException("Not constructable from a byte array");
        }
    }

    public static Key readKey(String s) throws KeyException {
        byte[] keyval;
        try {
            keyval = Fields.hexToBytes(s);
        }
        catch (RuntimeException e) {
            throw new KeyException("Key string is not legal hexadecimal");
        }
        return Key.readKey(keyval);
    }

    public static Key readKey(byte[] keyval) throws KeyException {
        Integer type = new Integer(keyval[keyval.length - 2] << 8 | keyval[keyval.length - 1]);
        Constructor con = (Constructor)keytypes.get(type);
        if (con != null) {
            try {
                return (Key)con.newInstance(new Object[]{keyval});
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException() instanceof KeyException ? (KeyException)e.getTargetException() : new KeyException(e.getTargetException().toString());
            }
            catch (Exception e) {
                throw new KeyException(e.toString());
            }
        }
        if (type != 0) {
            // empty if block
        }
        return new Key(keyval);
    }

    public static final int getControlLength() {
        return 21;
    }

    public static final long getTransmissionLength(long dataLength, long partSize) {
        if (dataLength < 0L || partSize <= 0L) {
            return 0L;
        }
        int parts = (int)((dataLength - 1L) / partSize);
        long lastpart = dataLength - (long)parts * partSize;
        return (long)parts * (partSize + (long)Key.getControlLength()) + lastpart + 1L;
    }

    public static final long getDataLength(long transLength, long partSize) {
        if (transLength < 0L || partSize < 0L) {
            return 0L;
        }
        int parts = (int)(transLength / (partSize + (long)Key.getControlLength()));
        long lastpart = transLength - (long)parts * (partSize + (long)Key.getControlLength());
        return (long)parts * partSize + lastpart - 1L;
    }

    public static final long getPartSize(long dataLength) {
        return Math.max(dataLength >> 7, Math.min(dataLength, 16384L));
    }

    public final long getExpectedTransmissionLength() {
        long dlen = this.getExpectedDataLength();
        return dlen == -1L ? -1L : Key.getTransmissionLength(dlen, Key.getPartSize(dlen));
    }

    public final long getExpectedDataLength() {
        return this.val.length - 3 >= 0 ? (long)(1 << this.val[this.val.length - 3]) : -1L;
    }

    public Key(byte[] val) {
        this.val = val;
    }

    public Key(byte[] val, int log2size, int keyNumber) {
        this(val.length, log2size, keyNumber);
        System.arraycopy(val, 0, this.val, 0, val.length);
    }

    protected Key(int valueLen, int log2size, int keyNumber) {
        this.val = new byte[valueLen + 3];
        this.val[this.val.length - 3] = (byte)(0xFF & log2size);
        this.val[this.val.length - 2] = (byte)(0xFF & keyNumber >> 8);
        this.val[this.val.length - 1] = (byte)(0xFF & keyNumber);
    }

    public Key(String s) throws NumberFormatException {
        this(Fields.hexToBytes(s));
    }

    public VerifyingInputStream verifyStream(InputStream data, Storables storables, long transLength) throws DataNotValidIOException {
        return new ProgressiveHashInputStream(data, storables.getPartSize(), transLength, SHA1.getInstance(), storables.getInitialDigest());
    }

    private static final int at(byte[] b, int i) {
        return (i < b.length ? b[i] : (byte)0) & 0xFF;
    }

    public final int compareTo(Object o) {
        return this.compareTo((Key)o);
    }

    public final int compareTo(Key k) {
        int len = Math.max(this.val.length, k.val.length);
        for (int i = 0; i < len; ++i) {
            if (Key.at(this.val, i) < Key.at(k.val, i)) {
                return -1;
            }
            if (Key.at(this.val, i) <= Key.at(k.val, i)) continue;
            return 1;
        }
        return 0;
    }

    public final int compareTo(Object A, Object B) {
        return this.compareTo((Key)A, (Key)B);
    }

    public final int compareTo(Key A, Key B) {
        int ABcmp = A.compareTo(B);
        if (ABcmp < 0) {
            if (this.compareTo(B) > 0) {
                return 1;
            }
            if (this.compareTo(A) > 0) {
                return this.compareToSorted(A, B);
            }
            return -1;
        }
        if (ABcmp > 0) {
            if (this.compareTo(A) > 0) {
                return -1;
            }
            if (this.compareTo(B) > 0) {
                return -1 * this.compareToSorted(B, A);
            }
            return 1;
        }
        return 0;
    }

    public final int compareToSorted(Object A, Object B) {
        return this.compareToSorted((Key)A, (Key)B);
    }

    public final int compareToSorted(Key A, Key B) {
        int len = Math.max(this.val.length, Math.max(A.val.length, B.val.length));
        int diff = 0;
        for (int i = 0; i < len; ++i) {
            if ((diff += Key.at(this.val, i) - Key.at(A.val, i) - (Key.at(B.val, i) - Key.at(this.val, i))) < -1) {
                return -1;
            }
            if (diff > 1) {
                return 1;
            }
            diff *= 256;
        }
        return diff;
    }

    public final boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public final int hashCode() {
        return Fields.hashCode(this.val);
    }

    public final String toString() {
        return Fields.bytesToHex(this.val);
    }

    public final byte[] getVal() {
        return this.val;
    }

    public final int length() {
        return this.val.length;
    }

    public static void main(String[] args) {
        System.out.println("Until we figure out a standardized testing system,");
        System.out.println("edit the source and uncomment whatever you want to test.");
    }
}

