/*
 * Decompiled with CFR 0.152.
 */
package mseries.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Arrays;
import mseries.utils.FormConstraints;
import mseries.utils.FormLayout;

class FormLayoutInfo
implements Serializable {
    public static final String REVISION_ID = "$Id: FormLayout.java 1840 2006-03-14 14:09:45Z bback $";
    public static final String REVISION_TAG = "$Name$";
    int colsNotAtMin;
    boolean[] atMin;
    int width;
    int height;
    int[] colWidth;
    int[] rowHeight;
    int[] minWidth;
    int[] minHeight;
    int[] actualWidth;
    int[] actualHeight;
    boolean doneStatic = false;
    FormLayout master;

    FormLayoutInfo(FormLayout master) {
        this.master = master;
        this.colWidth = new int[20];
        this.rowHeight = new int[20];
        this.actualWidth = new int[20];
        this.actualHeight = new int[20];
        this.minWidth = new int[20];
        this.minHeight = new int[20];
        this.height = 0;
        this.width = 0;
        this.atMin = new boolean[20];
        Arrays.fill(this.atMin, false);
        this.colsNotAtMin = this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateLayoutInfo(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Arrays.fill(this.atMin, false);
            this.setStaticLayoutInfo(parent.getComponents());
        }
    }

    void setStaticLayoutInfo(Component[] components) {
        int curY = -1;
        int curX = -1;
        for (int compindex = 0; compindex < components.length; ++compindex) {
            Dimension dp;
            Component comp = components[compindex];
            if (!comp.isVisible()) continue;
            FormConstraints constraints = this.master.lookupConstraints(comp);
            curX = constraints.gridx == -1 ? curX + 1 : constraints.gridx;
            curY = constraints.gridy == -1 ? curY + 1 : constraints.gridy;
            constraints.tempX = curX;
            constraints.tempY = curY;
            Insets compInsets = constraints.insets;
            this.width = Math.max(curX + 1, this.width);
            this.height = Math.max(curY + 1, this.height);
            if (!constraints.spansColumns) {
                dp = comp.getPreferredSize();
            } else {
                int h = comp.getPreferredSize().height;
                dp = new Dimension(35, h);
            }
            this.colWidth[curX] = Math.max(this.colWidth[curX], dp.width + compInsets.left + compInsets.right);
            this.rowHeight[curY] = Math.max(this.rowHeight[curY], dp.height + compInsets.top + compInsets.bottom);
            Dimension dm = comp.getMinimumSize();
            this.minWidth[curX] = Math.max(this.minWidth[curX], dm.width + compInsets.left + compInsets.right);
            this.minHeight[curY] = Math.max(this.minHeight[curY], dm.height + compInsets.top + compInsets.bottom);
            this.actualWidth[curX] = this.colWidth[curX];
            this.actualHeight[curX] = this.rowHeight[curX];
            this.colsNotAtMin = this.width;
        }
    }

    public String toString() {
        int i;
        String ret = "[" + this.getClass().getName() + ": \n" + "  width=" + this.width + ", height=" + this.height + ", \n";
        ret = ret + "  Preferred Widths \n";
        for (i = 0; i < this.width; ++i) {
            ret = ret + "    [" + i + "] = " + this.colWidth[i] + "\n";
        }
        ret = ret + "  Preferred Heights \n";
        for (i = 0; i < this.height; ++i) {
            ret = ret + "    [" + i + "] = " + this.rowHeight[i] + "\n";
        }
        ret = ret + "  Minimum Widths \n";
        for (i = 0; i < this.width; ++i) {
            ret = ret + "    [" + i + "] = " + this.minWidth[i] + "\n";
        }
        ret = ret + "  Minimum Heights \n";
        for (i = 0; i < this.height; ++i) {
            ret = ret + "    [" + i + "] = " + this.minHeight[i] + "\n";
        }
        return ret;
    }

    Dimension getMinimumSize() {
        int i;
        int t = 0;
        Dimension d = new Dimension(1, 1);
        for (i = 0; i < this.width; ++i) {
            t += this.minWidth[i];
        }
        d.width = t;
        t = 0;
        for (i = 0; i < this.height; ++i) {
            t += this.minHeight[i];
        }
        d.height = t;
        return d;
    }

    Dimension getPreferredSize() {
        int i;
        int t = 0;
        Dimension d = new Dimension(1, 1);
        for (i = 0; i < this.width; ++i) {
            t += this.colWidth[i];
        }
        d.width = t;
        t = 0;
        for (i = 0; i < this.height; ++i) {
            t += this.rowHeight[i];
        }
        d.height = t;
        return d;
    }

    int getColsNotAtMin() {
        int t = 0;
        for (int i = 0; i < this.width; ++i) {
            t += this.atMin[i] ? 0 : 1;
        }
        return t;
    }

    int getActualWidth() {
        int t = 0;
        for (int i = 0; i < this.width; ++i) {
            t += this.actualWidth[i];
        }
        return t;
    }
}

