/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowButton
extends JButton
implements SwingConstants {
    int direction;

    public ArrowButton(int dir) {
        this.setDirection(dir);
        this.setRequestFocusEnabled(false);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public void paint(Graphics g) {
        int h = this.getSize().height;
        this.setMinimumSize(new Dimension(h, h));
        this.setPreferredSize(new Dimension(h, h));
        int w = this.getSize().width;
        boolean isEnabled = this.isEnabled();
        Color origColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        g.setColor(origColor);
        this.paintBorder(g);
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2;
        g.translate(x, y);
        g.setColor(this.isEnabled() ? UIManager.getColor("Button.foreground") : UIManager.getColor("controlShadow"));
        switch (direction) {
            case 1: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isFocusPainted() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.getModel().setRollover(false);
        }
        super.setEnabled(enabled);
    }
}

