/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mseries.Calendar.MDateChanger;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;

public class MSpinnerChanger
extends JPanel
implements MDateChanger {
    private Calendar maxC = Calendar.getInstance();
    private Calendar minC = Calendar.getInstance();
    private int minMonth;
    private int minYear;
    private int maxYear;
    private JSpinner month;
    private JSpinner year;
    private SpinnerNumberModel yearModel;
    private SpinnerListModel monthModel;
    private String[] months;
    private String[] mths;
    protected Vector listeners = new Vector();

    public MSpinnerChanger() {
        this(false);
    }

    public MSpinnerChanger(boolean editable) {
        this.minC.set(1900, 0, 1);
        this.minMonth = this.minC.get(2);
        this.minYear = this.minC.get(1);
        this.maxC.set(2037, 11, 31);
        this.maxYear = this.maxC.get(1);
        this.month = new JSpinner();
        this.month.setBackground(this.getBackground());
        this.month.setMinimumSize(new Dimension(100, 22));
        DateFormatSymbols dfs = new DateFormatSymbols();
        this.mths = dfs.getMonths();
        this.months = new String[12];
        System.arraycopy(this.mths, 0, this.months, 0, 12);
        this.monthModel = new SpinnerListModel(this.months);
        this.month.setModel(this.monthModel);
        JSpinner.ListEditor listEd = new JSpinner.ListEditor(this.month);
        listEd.getTextField().setEditable(false);
        listEd.getTextField().setColumns(6);
        listEd.getTextField().setBorder(null);
        listEd.getTextField().setBackground(UIManager.getColor("TextField.background"));
        this.month.setEditor(listEd);
        this.month.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MSpinnerChanger.this.notifyListeners(0);
            }
        });
        this.yearModel = new SpinnerNumberModel(this.minYear, this.minYear, this.maxYear, 1);
        this.year = new JSpinner(this.yearModel);
        this.year.setBackground(this.getBackground());
        this.year.setMinimumSize(new Dimension(64, 22));
        JSpinner.NumberEditor ed = new JSpinner.NumberEditor(this.year, "0000");
        ed.getTextField().setEditable(false);
        ed.getTextField().setBorder(null);
        ed.getTextField().setBackground(UIManager.getColor("TextField.background"));
        this.year.setEditor(ed);
        this.year.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MSpinnerChanger.this.notifyListeners(0);
            }
        });
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 17;
        this.add((Component)this.month, c);
        c.gridx = 1;
        c.anchor = 13;
        this.add((Component)this.year, c);
    }

    public void setMinimum(Date min) {
        this.minC.setTime(min);
        this.minYear = this.minC.get(1);
        this.minMonth = this.minC.get(2);
        this.yearModel.setMinimum(new Integer(this.minYear));
        this.setValue(min);
    }

    public void setMaximum(Date max) {
        this.maxC.setTime(max);
        this.maxYear = this.maxC.get(1);
        this.yearModel.setMaximum(new Integer(this.maxYear));
        this.setValue(max);
    }

    public void setValue(Date newVal) {
        Calendar valC = Calendar.getInstance();
        valC.setTime(newVal);
        int y = valC.get(1);
        int m = valC.get(2);
        this.monthModel.setValue(this.months[m]);
        this.yearModel.setValue(new Integer(y));
    }

    public int getValue() {
        int m = 0;
        String mon = (String)this.month.getValue();
        for (int i = 0; i < this.months.length; ++i) {
            if (!this.months[i].equals(mon)) continue;
            m = i;
            break;
        }
        int y = (Integer)this.yearModel.getValue();
        int newValue = (y - this.minYear) * 12 + m - this.minMonth;
        return newValue;
    }

    private void notifyListeners(int type) {
        Vector list = (Vector)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            MChangeListener l = (MChangeListener)this.listeners.elementAt(i);
            l.valueChanged(new MChangeEvent(this, new Integer(this.getValue()), type));
        }
    }

    public void addMChangeListener(MChangeListener l) {
        this.listeners.addElement(l);
    }

    public void removeMChangeListener(MChangeListener l) {
        this.listeners.removeElement(l);
    }

    public boolean hasFocus() {
        JSpinner.DefaultEditor monthEditor = (JSpinner.DefaultEditor)this.month.getEditor();
        JSpinner.DefaultEditor yearEditor = (JSpinner.DefaultEditor)this.year.getEditor();
        boolean hasFocus = monthEditor.getTextField().isFocusOwner() || yearEditor.getTextField().isFocusOwner();
        return hasFocus;
    }

    public void addFListener(FocusListener l) {
        this.month.addFocusListener(l);
        this.year.addFocusListener(l);
    }

    public void removeFListener(FocusListener l) {
        this.month.removeFocusListener(l);
        this.year.removeFocusListener(l);
    }

    public void setBground(Color b) {
        super.setBackground(b);
        this.month.setBackground(b);
        this.year.setBackground(b);
    }

    public void setFground(Color b) {
        super.setForeground(b);
        this.month.setForeground(b);
        this.year.setForeground(b);
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame("Test");
        final MSpinnerChanger c = new MSpinnerChanger();
        c.addMChangeListener(new MChangeListener(){

            public void valueChanged(MChangeEvent e) {
                System.out.println(c.getValue());
            }
        });
        f.getContentPane().add(c);
        f.pack();
        f.setVisible(true);
    }
}

