/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentIterator;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RndBtree<T extends IPersistent>
extends PersistentCollection<T>
implements Index<T> {
    int height;
    int type;
    int nElems;
    boolean unique;
    BtreePage root;
    transient int updateCounter;
    static final int op_done = 0;
    static final int op_overflow = 1;
    static final int op_underflow = 2;
    static final int op_not_found = 3;
    static final int op_duplicate = 4;
    static final int op_overwrite = 5;

    RndBtree() {
    }

    static int checkType(Class c) {
        int elemType = ClassDescriptor.getTypeCode(c);
        if (elemType > 10 && elemType != 12 && elemType != 14) {
            throw new StorageError(8, c);
        }
        return elemType;
    }

    RndBtree(Class cls, boolean unique) {
        this.unique = unique;
        this.type = RndBtree.checkType(cls);
    }

    RndBtree(int type, boolean unique) {
        this.type = type;
        this.unique = unique;
    }

    @Override
    public Class[] getKeyTypes() {
        return new Class[]{this.getKeyType()};
    }

    @Override
    public Class getKeyType() {
        return RndBtree.mapKeyType(this.type);
    }

    static Class mapKeyType(int type) {
        switch (type) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return Date.class;
            }
            case 10: {
                return IPersistent.class;
            }
            case 12: {
                return Comparable.class;
            }
            case 14: {
                return Enum.class;
            }
        }
        return null;
    }

    Key checkKey(Key key) {
        if (key != null) {
            if (key.type != this.type) {
                throw new StorageError(9);
            }
            if (this.type == 10 && key.ival == 0 && key.oval != null) {
                IPersistent obj = (IPersistent)key.oval;
                this.getStorage().makePersistent(obj);
                key = new Key(obj, key.inclusion != 0);
            }
            if (key.oval instanceof char[]) {
                key = new Key(new String((char[])key.oval), key.inclusion != 0);
            }
        }
        return key;
    }

    @Override
    public T get(Key key) {
        key = this.checkKey(key);
        if (this.root != null) {
            ArrayList list = new ArrayList();
            this.root.find(key, key, this.height, list);
            if (list.size() > 1) {
                throw new StorageError(4);
            }
            if (list.size() == 0) {
                return null;
            }
            return (T)((IPersistent)list.get(0));
        }
        return null;
    }

    @Override
    public ArrayList<T> prefixSearchList(String key) {
        if (8 != this.type) {
            throw new StorageError(9);
        }
        ArrayList list = new ArrayList();
        if (this.root != null) {
            ((BtreePageOfString)this.root).prefixSearch(key, this.height, list);
        }
        return list;
    }

    @Override
    public IPersistent[] prefixSearch(String key) {
        ArrayList<IPersistent> list = this.prefixSearchList(key);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public ArrayList<T> getList(Key from, Key till) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.checkKey(from), this.checkKey(till), this.height, list);
        }
        return list;
    }

    @Override
    public ArrayList<T> getList(Object from, Object till) {
        return this.getList(Btree.getKeyFromObject(from), Btree.getKeyFromObject(till));
    }

    @Override
    public IPersistent[] get(Key from, Key till) {
        ArrayList<IPersistent> list = this.getList(from, till);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public IPersistent[] get(Object from, Object till) {
        return this.get(Btree.getKeyFromObject(from), Btree.getKeyFromObject(till));
    }

    @Override
    public boolean put(Key key, T obj) {
        return this.insert(key, obj, false) == null;
    }

    @Override
    public T set(Key key, T obj) {
        return this.insert(key, obj, true);
    }

    final void allocateRootPage(BtreeKey ins, int height) {
        Storage s = this.getStorage();
        BtreePage newRoot = null;
        switch (this.type) {
            case 1: {
                newRoot = new BtreePageOfByte(s);
                break;
            }
            case 3: {
                newRoot = new BtreePageOfShort(s);
                break;
            }
            case 2: {
                newRoot = new BtreePageOfChar(s);
                break;
            }
            case 0: {
                newRoot = new BtreePageOfBoolean(s);
                break;
            }
            case 4: 
            case 14: {
                newRoot = new BtreePageOfInt(s);
                break;
            }
            case 5: {
                newRoot = new BtreePageOfLong(s);
                break;
            }
            case 6: {
                newRoot = new BtreePageOfFloat(s);
                break;
            }
            case 7: {
                newRoot = new BtreePageOfDouble(s);
                break;
            }
            case 10: {
                newRoot = new BtreePageOfObject(s);
                break;
            }
            case 8: {
                newRoot = new BtreePageOfString(s);
                break;
            }
            case 12: {
                newRoot = new BtreePageOfRaw(s);
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
        newRoot.insert(ins, 0, height);
        newRoot.items.setObject(1, this.root);
        if (height != 0) {
            newRoot.countChildren(1, height);
        }
        newRoot.nItems = 1;
        this.root = newRoot;
    }

    final T insert(Key key, T obj, boolean overwrite) {
        BtreeKey ins = new BtreeKey(this.checkKey(key), (IPersistent)obj);
        if (this.root == null) {
            this.allocateRootPage(ins, 0);
            this.height = 1;
        } else {
            int result = this.root.insert(ins, this.height, this.unique, overwrite);
            if (result == 1) {
                this.allocateRootPage(ins, this.height);
                ++this.height;
            } else if (result == 4 || result == 5) {
                return (T)ins.oldNode;
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
        return null;
    }

    @Override
    public void remove(Key key, T obj) {
        this.remove(new BtreeKey(this.checkKey(key), (IPersistent)obj));
    }

    void remove(BtreeKey rem) {
        if (!this.removeIfExists(rem)) {
            throw new StorageError(5);
        }
    }

    boolean removeIfExists(BtreeKey rem) {
        if (this.root == null) {
            return false;
        }
        int result = this.root.remove(rem, this.height);
        if (result == 3) {
            return false;
        }
        --this.nElems;
        if (result == 2 && this.root.nItems == 0) {
            BtreePage newRoot = null;
            if (this.height != 1) {
                newRoot = (BtreePage)this.root.items.get(0);
            }
            this.root.deallocate();
            this.root = newRoot;
            --this.height;
        }
        ++this.updateCounter;
        this.modify();
        return true;
    }

    @Override
    public T remove(Key key) {
        if (!this.unique) {
            throw new StorageError(4);
        }
        BtreeKey rk = new BtreeKey(this.checkKey(key), null);
        this.remove(rk);
        return (T)rk.oldNode;
    }

    @Override
    public T get(Object key) {
        return (T)this.get(Btree.getKeyFromObject(key));
    }

    @Override
    public ArrayList<T> getPrefixList(String prefix) {
        return this.getList(new Key(prefix, true), new Key(prefix + '\uffff', false));
    }

    @Override
    public IPersistent[] getPrefix(String prefix) {
        return this.get(new Key(prefix, true), new Key(prefix + '\uffff', false));
    }

    @Override
    public boolean put(Object key, T obj) {
        return this.put(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T set(Object key, T obj) {
        return this.set(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public void remove(Object key, T obj) {
        this.remove(Btree.getKeyFromObject(key), obj);
    }

    @Override
    public T remove(String key) {
        return this.remove(new Key(key));
    }

    @Override
    public T removeKey(Object key) {
        return this.removeKey(Btree.getKeyFromObject(key));
    }

    @Override
    public int size() {
        return this.nElems;
    }

    @Override
    public void clear() {
        if (this.root != null) {
            this.root.purge(this.height);
            this.root = null;
            this.nElems = 0;
            this.height = 0;
            ++this.updateCounter;
            this.modify();
        }
    }

    @Override
    public IPersistent[] toPersistentArray() {
        IPersistent[] arr = new IPersistent[this.nElems];
        if (this.root != null) {
            this.root.traverseForward(this.height, arr, 0);
        }
        return arr;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        if (arr.length < this.nElems) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.nElems);
        }
        if (this.root != null) {
            this.root.traverseForward(this.height, (IPersistent[])arr, 0);
        }
        if (arr.length > this.nElems) {
            arr[this.nElems] = null;
        }
        return arr;
    }

    @Override
    public void deallocate() {
        if (this.root != null) {
            this.root.purge(this.height);
        }
        super.deallocate();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(null, null, 0);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator() {
        return this.entryIterator(null, null, 0);
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return new BtreeSelectionIterator(this.checkKey(from), this.checkKey(till), order);
    }

    @Override
    public IterableIterator<T> iterator(Object from, Object till, int order) {
        return new BtreeSelectionIterator(this.checkKey(Btree.getKeyFromObject(from)), this.checkKey(Btree.getKeyFromObject(till)), order);
    }

    @Override
    public IterableIterator<T> prefixIterator(String prefix) {
        return this.iterator(new Key(prefix), new Key(prefix + '\uffff', false), 0);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return new BtreeSelectionEntryIterator(this.checkKey(from), this.checkKey(till), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Object from, Object till, int order) {
        return new BtreeSelectionEntryIterator(this.checkKey(Btree.getKeyFromObject(from)), this.checkKey(Btree.getKeyFromObject(till)), order);
    }

    @Override
    public T getAt(int i) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("Position " + i + ", index size " + this.nElems);
        }
        return (T)((IPersistent)this.root.getAt(i, this.height));
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(int start, int order) {
        return new BtreeEntryStartFromIterator(start, order);
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    class BtreeEntryStartFromIterator
    extends BtreeSelectionEntryIterator {
        int start;

        BtreeEntryStartFromIterator(int start, int order) {
            super(order);
            this.start = start;
            this.reset();
        }

        void reset() {
            this.sp = 0;
            this.counter = RndBtree.this.updateCounter;
            if (RndBtree.this.height == 0 || this.start >= RndBtree.this.nElems) {
                return;
            }
            BtreePage page = RndBtree.this.root;
            int h = RndBtree.this.height;
            int i = this.start;
            this.pageStack = new BtreePage[h];
            this.posStack = new int[h];
            while (--h > 0) {
                this.pageStack[this.sp] = page;
                int j = 0;
                while (i >= page.nChildren[j]) {
                    i -= page.nChildren[j];
                    ++j;
                }
                this.posStack[this.sp] = j;
                page = (BtreePage)page.items.get(j);
                ++this.sp;
            }
            this.pageStack[this.sp] = page;
            this.posStack[this.sp++] = i;
            this.end = page.nItems;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BtreeSelectionEntryIterator
    extends BtreeSelectionIterator<Map.Entry<Object, T>> {
        BtreeSelectionEntryIterator(Key from, Key till, int order) {
            super(from, till, order);
        }

        BtreeSelectionEntryIterator(int order) {
            super(order);
        }

        @Override
        protected Object getCurrent(BtreePage pg, int pos) {
            return new BtreeEntry(pg, pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BtreeSelectionIterator<E>
    extends IterableIterator<E>
    implements PersistentIterator {
        BtreePage[] pageStack;
        int[] posStack;
        BtreePage currPage;
        int currPos;
        int sp;
        int end;
        Key from;
        Key till;
        int order;
        int counter;
        BtreeKey currKey;
        Key nextKey;
        IPersistent nextObj;

        BtreeSelectionIterator(Key from, Key till, int order) {
            this.from = from;
            this.till = till;
            this.order = order;
            this.reset();
        }

        BtreeSelectionIterator(int order) {
            this.order = order;
        }

        void reset() {
            this.sp = 0;
            this.counter = RndBtree.this.updateCounter;
            if (RndBtree.this.height == 0) {
                return;
            }
            BtreePage page = RndBtree.this.root;
            int h = RndBtree.this.height;
            this.pageStack = new BtreePage[h];
            this.posStack = new int[h];
            if (this.order == 0) {
                if (this.from == null) {
                    while (--h > 0) {
                        this.posStack[this.sp] = 0;
                        this.pageStack[this.sp] = page;
                        page = (BtreePage)page.items.get(0);
                        ++this.sp;
                    }
                    this.posStack[this.sp] = 0;
                    this.pageStack[this.sp] = page;
                    this.end = page.nItems;
                    ++this.sp;
                } else {
                    int i;
                    int r;
                    int l;
                    while (--h > 0) {
                        this.pageStack[this.sp] = page;
                        l = 0;
                        r = page.nItems;
                        while (l < r) {
                            i = l + r >> 1;
                            if (page.compare(this.from, i) >= this.from.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        this.posStack[this.sp] = r;
                        page = (BtreePage)page.items.get(r);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = page;
                    l = 0;
                    r = this.end = page.nItems;
                    while (l < r) {
                        i = l + r >> 1;
                        if (page.compare(this.from, i) >= this.from.inclusion) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    Assert.that(r == l);
                    if (r == this.end) {
                        ++this.sp;
                        this.gotoNextItem(page, r - 1);
                    } else {
                        this.posStack[this.sp++] = r;
                    }
                }
                if (this.sp != 0 && this.till != null && -(page = this.pageStack[this.sp - 1]).compare(this.till, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (this.till == null) {
                    while (--h > 0) {
                        this.pageStack[this.sp] = page;
                        this.posStack[this.sp] = page.nItems;
                        page = (BtreePage)page.items.get(page.nItems);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = page;
                    this.posStack[this.sp++] = page.nItems - 1;
                } else {
                    int i;
                    int r;
                    int l;
                    while (--h > 0) {
                        this.pageStack[this.sp] = page;
                        l = 0;
                        r = page.nItems;
                        while (l < r) {
                            i = l + r >> 1;
                            if (page.compare(this.till, i) >= 1 - this.till.inclusion) {
                                l = i + 1;
                                continue;
                            }
                            r = i;
                        }
                        Assert.that(r == l);
                        this.posStack[this.sp] = r;
                        page = (BtreePage)page.items.get(r);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = page;
                    l = 0;
                    r = page.nItems;
                    while (l < r) {
                        i = l + r >> 1;
                        if (page.compare(this.till, i) >= 1 - this.till.inclusion) {
                            l = i + 1;
                            continue;
                        }
                        r = i;
                    }
                    Assert.that(r == l);
                    if (r == 0) {
                        ++this.sp;
                        this.gotoNextItem(page, r);
                    } else {
                        this.posStack[this.sp++] = r - 1;
                    }
                }
                if (this.sp != 0 && this.from != null && (page = this.pageStack[this.sp - 1]).compare(this.from, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.counter != RndBtree.this.updateCounter) {
                if (((StorageImpl)RndBtree.this.getStorage()).concurrentIterator) {
                    this.refresh();
                } else {
                    throw new ConcurrentModificationException();
                }
            }
            return this.sp != 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int pos = this.posStack[this.sp - 1];
            BtreePage pg = this.pageStack[this.sp - 1];
            this.currPos = pos;
            this.currPage = pg;
            Object curr = this.getCurrent(pg, pos);
            if (((StorageImpl)RndBtree.this.getStorage()).concurrentIterator) {
                this.currKey = new BtreeKey(pg.getKey(pos), pg.items.getRaw(pos));
            }
            this.gotoNextItem(pg, pos);
            return (E)curr;
        }

        @Override
        public int nextOid() {
            int oid;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int pos = this.posStack[this.sp - 1];
            BtreePage pg = this.pageStack[this.sp - 1];
            this.currPos = pos;
            this.currPage = pg;
            IPersistent obj = pg.items.getRaw(pos);
            int n = oid = obj == null ? 0 : obj.getOid();
            if (((StorageImpl)RndBtree.this.getStorage()).concurrentIterator) {
                this.currKey = new BtreeKey(pg.getKey(pos), pg.items.getRaw(pos));
            }
            this.gotoNextItem(pg, pos);
            return oid;
        }

        protected Object getCurrent(BtreePage pg, int pos) {
            return pg.items.get(pos);
        }

        protected final void gotoNextItem(BtreePage pg, int pos) {
            if (this.order == 0) {
                if (++pos == this.end) {
                    while (--this.sp != 0) {
                        pos = this.posStack[this.sp - 1];
                        pg = this.pageStack[this.sp - 1];
                        if (++pos > pg.nItems) continue;
                        this.posStack[this.sp - 1] = pos;
                        do {
                            pg = (BtreePage)pg.items.get(pos);
                            this.end = pg.nItems;
                            this.pageStack[this.sp] = pg;
                            pos = 0;
                            this.posStack[this.sp] = 0;
                        } while (++this.sp < this.pageStack.length);
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = pos;
                }
                if (this.sp != 0 && this.till != null && -pg.compare(this.till, pos) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (--pos < 0) {
                    while (--this.sp != 0) {
                        pos = this.posStack[this.sp - 1];
                        pg = this.pageStack[this.sp - 1];
                        if (--pos < 0) continue;
                        this.posStack[this.sp - 1] = pos;
                        do {
                            this.pageStack[this.sp] = pg = (BtreePage)pg.items.get(pos);
                            pos = pg.nItems;
                            this.posStack[this.sp] = pos--;
                        } while (++this.sp < this.pageStack.length);
                        this.posStack[this.sp - 1] = pos;
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = pos;
                }
                if (this.sp != 0 && this.from != null && pg.compare(this.from, pos) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
            if (((StorageImpl)RndBtree.this.getStorage()).concurrentIterator && this.sp != 0) {
                this.nextKey = pg.getKey(pos);
                this.nextObj = pg.items.getRaw(pos);
            }
        }

        private void refresh() {
            if (this.sp != 0) {
                if (this.nextKey == null) {
                    this.reset();
                } else {
                    if (this.order == 0) {
                        this.from = this.nextKey;
                    } else {
                        this.till = this.nextKey;
                    }
                    IPersistent next = this.nextObj;
                    this.reset();
                    while (true) {
                        int pos = this.posStack[this.sp - 1];
                        BtreePage pg = this.pageStack[this.sp - 1];
                        if (pg.items.getRaw(pos).equals(next)) break;
                        this.gotoNextItem(pg, pos);
                    }
                }
            }
            this.counter = RndBtree.this.updateCounter;
        }

        @Override
        public void remove() {
            if (this.currPage == null) {
                throw new NoSuchElementException();
            }
            StorageImpl db = (StorageImpl)RndBtree.this.getStorage();
            if (!db.concurrentIterator) {
                if (this.counter != RndBtree.this.updateCounter) {
                    throw new ConcurrentModificationException();
                }
                this.currKey = new BtreeKey(this.currPage.getKey(this.currPos), this.currPage.items.getRaw(this.currPos));
                if (this.sp != 0) {
                    int pos = this.posStack[this.sp - 1];
                    BtreePage pg = this.pageStack[this.sp - 1];
                    this.nextKey = pg.getKey(pos);
                    this.nextObj = pg.items.getRaw(pos);
                }
            }
            RndBtree.this.removeIfExists(this.currKey);
            this.refresh();
            this.currPage = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BtreeEntry<T>
    implements Map.Entry<Object, T> {
        private BtreePage pg;
        private int pos;

        @Override
        public Object getKey() {
            return this.pg.getKeyValue(this.pos);
        }

        @Override
        public T getValue() {
            return this.pg.items.get(this.pos);
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        BtreeEntry(BtreePage pg, int pos) {
            this.pg = pg;
            this.pos = pos;
        }
    }

    static class BtreePageOfRaw
    extends BtreePage {
        Object data;
        static final int MAX_ITEMS = 100;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key((Comparable)((Object[])this.data)[i]);
        }

        Object getKeyValue(int i) {
            return ((Object[])this.data)[i];
        }

        void clearKeyValue(int i) {
            ((Object[])this.data)[i] = null;
        }

        BtreePage clonePage() {
            return new BtreePageOfRaw(this.getStorage());
        }

        int compare(Key key, int i) {
            return ((Comparable)key.oval).compareTo(((Object[])this.data)[i]);
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            ((Object[])this.data)[i] = key.key.oval;
        }

        BtreePageOfRaw(Storage s) {
            super(s, 100);
            this.data = new Object[100];
        }

        BtreePageOfRaw() {
        }
    }

    static class BtreePageOfString
    extends BtreePage {
        String[] data;
        static final int MAX_ITEMS = 100;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return this.data[i];
        }

        void clearKeyValue(int i) {
            this.data[i] = null;
        }

        BtreePage clonePage() {
            return new BtreePageOfString(this.getStorage());
        }

        int compare(Key key, int i) {
            return ((String)key.oval).compareTo(this.data[i]);
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = (String)key.key.oval;
        }

        void memset(int i, int len) {
            while (--len >= 0) {
                this.items.setObject(i, null);
                this.data[i] = null;
                ++i;
            }
        }

        boolean prefixSearch(String key, int height, ArrayList result) {
            int n;
            int l = 0;
            int r = n = this.nItems;
            --height;
            while (l < r) {
                int i = l + r >> 1;
                if (!key.startsWith(this.data[i]) && key.compareTo(this.data[i]) > 0) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            Assert.that(r == l);
            if (height == 0) {
                while (l < n) {
                    if (key.compareTo(this.data[l]) < 0) {
                        return false;
                    }
                    result.add(this.items.get(l));
                    ++l;
                }
            } else {
                do {
                    if (!((BtreePageOfString)this.items.get(l)).prefixSearch(key, height, result)) {
                        return false;
                    }
                    if (l != n) continue;
                    return true;
                } while (key.compareTo(this.data[l++]) >= 0);
                return false;
            }
            return true;
        }

        BtreePageOfString(Storage s) {
            super(s, 100);
            this.data = new String[100];
        }

        BtreePageOfString() {
        }
    }

    static class BtreePageOfObject
    extends BtreePage {
        Link data;
        static final int MAX_ITEMS = 339;

        Object getData() {
            return this.data.toRawArray();
        }

        Key getKey(int i) {
            return new Key(this.data.getRaw(i));
        }

        Object getKeyValue(int i) {
            return this.data.get(i);
        }

        BtreePage clonePage() {
            return new BtreePageOfObject(this.getStorage());
        }

        int compare(Key key, int i) {
            IPersistent obj = this.data.getRaw(i);
            int oid = obj == null ? 0 : obj.getOid();
            return key.ival - oid;
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data.setObject(i, (IPersistent)key.key.oval);
        }

        BtreePageOfObject(Storage s) {
            super(s, 339);
            this.data = s.createLink(339);
            this.data.setSize(339);
        }

        BtreePageOfObject() {
        }
    }

    static class BtreePageOfDouble
    extends BtreePage {
        double[] data;
        static final int MAX_ITEMS = 254;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Double(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfDouble(this.getStorage());
        }

        int compare(Key key, int i) {
            return key.dval < this.data[i] ? -1 : (key.dval == this.data[i] ? 0 : 1);
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = key.key.dval;
        }

        BtreePageOfDouble(Storage s) {
            super(s, 254);
            this.data = new double[254];
        }

        BtreePageOfDouble() {
        }
    }

    static class BtreePageOfFloat
    extends BtreePage {
        float[] data;
        static final int MAX_ITEMS = 339;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Float(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfFloat(this.getStorage());
        }

        int compare(Key key, int i) {
            return (float)key.dval < this.data[i] ? -1 : ((float)key.dval == this.data[i] ? 0 : 1);
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = (float)key.key.dval;
        }

        BtreePageOfFloat(Storage s) {
            super(s, 339);
            this.data = new float[339];
        }

        BtreePageOfFloat() {
        }
    }

    static class BtreePageOfLong
    extends BtreePage {
        long[] data;
        static final int MAX_ITEMS = 254;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Long(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfLong(this.getStorage());
        }

        int compare(Key key, int i) {
            return key.lval < this.data[i] ? -1 : (key.lval == this.data[i] ? 0 : 1);
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = key.key.lval;
        }

        BtreePageOfLong(Storage s) {
            super(s, 254);
            this.data = new long[254];
        }

        BtreePageOfLong() {
        }
    }

    static class BtreePageOfInt
    extends BtreePage {
        int[] data;
        static final int MAX_ITEMS = 339;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Integer(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfInt(this.getStorage());
        }

        int compare(Key key, int i) {
            return key.ival - this.data[i];
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = key.key.ival;
        }

        BtreePageOfInt(Storage s) {
            super(s, 339);
            this.data = new int[339];
        }

        BtreePageOfInt() {
        }
    }

    static class BtreePageOfChar
    extends BtreePage {
        char[] data;
        static final int MAX_ITEMS = 407;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Character(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfChar(this.getStorage());
        }

        int compare(Key key, int i) {
            return (char)key.ival - this.data[i];
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = (char)key.key.ival;
        }

        BtreePageOfChar(Storage s) {
            super(s, 407);
            this.data = new char[407];
        }

        BtreePageOfChar() {
        }
    }

    static class BtreePageOfShort
    extends BtreePage {
        short[] data;
        static final int MAX_ITEMS = 407;

        Object getData() {
            return this.data;
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        Object getKeyValue(int i) {
            return new Short(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfShort(this.getStorage());
        }

        int compare(Key key, int i) {
            return (short)key.ival - this.data[i];
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = (short)key.key.ival;
        }

        BtreePageOfShort(Storage s) {
            super(s, 407);
            this.data = new short[407];
        }

        BtreePageOfShort() {
        }
    }

    static class BtreePageOfBoolean
    extends BtreePageOfByte {
        Key getKey(int i) {
            return new Key(this.data[i] != 0);
        }

        Object getKeyValue(int i) {
            return this.data[i] != 0;
        }

        BtreePage clonePage() {
            return new BtreePageOfBoolean(this.getStorage());
        }

        BtreePageOfBoolean() {
        }

        BtreePageOfBoolean(Storage s) {
            super(s);
        }
    }

    static class BtreePageOfByte
    extends BtreePage {
        byte[] data;
        static final int MAX_ITEMS = 452;

        Object getData() {
            return this.data;
        }

        Object getKeyValue(int i) {
            return new Byte(this.data[i]);
        }

        Key getKey(int i) {
            return new Key(this.data[i]);
        }

        BtreePage clonePage() {
            return new BtreePageOfByte(this.getStorage());
        }

        int compare(Key key, int i) {
            return (byte)key.ival - this.data[i];
        }

        void insert(BtreeKey key, int i) {
            this.items.setObject(i, key.node);
            this.data[i] = (byte)key.key.ival;
        }

        BtreePageOfByte(Storage s) {
            super(s, 452);
            this.data = new byte[452];
        }

        BtreePageOfByte() {
        }
    }

    static abstract class BtreePage
    extends Persistent {
        int nItems;
        Link items;
        int[] nChildren;
        static final int BTREE_PAGE_SIZE = 4072;

        abstract Object getData();

        abstract Object getKeyValue(int var1);

        abstract Key getKey(int var1);

        abstract int compare(Key var1, int var2);

        abstract void insert(BtreeKey var1, int var2);

        abstract BtreePage clonePage();

        void clearKeyValue(int i) {
        }

        Object getAt(int i, int height) {
            if (--height == 0) {
                return this.items.get(i);
            }
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            return ((BtreePage)this.items.get(j)).getAt(i, height);
        }

        boolean find(Key firstKey, Key lastKey, int height, ArrayList result) {
            int n;
            int l = 0;
            int r = n = this.nItems;
            --height;
            if (firstKey != null) {
                while (l < r) {
                    int i = l + r >> 1;
                    if (this.compare(firstKey, i) >= firstKey.inclusion) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                Assert.that(r == l);
            }
            if (lastKey != null) {
                if (height == 0) {
                    while (l < n) {
                        if (-this.compare(lastKey, l) >= lastKey.inclusion) {
                            return false;
                        }
                        result.add(this.items.get(l));
                        ++l;
                    }
                    return true;
                }
                do {
                    if (!((BtreePage)this.items.get(l)).find(firstKey, lastKey, height, result)) {
                        return false;
                    }
                    if (l != n) continue;
                    return true;
                } while (this.compare(lastKey, l++) >= 0);
                return false;
            }
            if (height == 0) {
                while (l < n) {
                    result.add(this.items.get(l));
                    ++l;
                }
            } else {
                do {
                    if (((BtreePage)this.items.get(l)).find(firstKey, lastKey, height, result)) continue;
                    return false;
                } while (++l <= n);
            }
            return true;
        }

        static void memcpyData(BtreePage dst_pg, int dst_idx, BtreePage src_pg, int src_idx, int len) {
            System.arraycopy(src_pg.getData(), src_idx, dst_pg.getData(), dst_idx, len);
        }

        static void memcpyItems(BtreePage dst_pg, int dst_idx, BtreePage src_pg, int src_idx, int len) {
            System.arraycopy(src_pg.items.toRawArray(), src_idx, dst_pg.items.toRawArray(), dst_idx, len);
            System.arraycopy(src_pg.nChildren, src_idx, dst_pg.nChildren, dst_idx, len);
        }

        static void memcpy(BtreePage dst_pg, int dst_idx, BtreePage src_pg, int src_idx, int len) {
            BtreePage.memcpyData(dst_pg, dst_idx, src_pg, src_idx, len);
            BtreePage.memcpyItems(dst_pg, dst_idx, src_pg, src_idx, len);
        }

        void memset(int i, int len) {
            while (--len >= 0) {
                this.items.setObject(i++, null);
            }
        }

        private void countChildren(int i, int height) {
            this.nChildren[i] = ((BtreePage)this.items.get(i)).totalCount(height);
        }

        private int totalCount(int height) {
            if (--height == 0) {
                return this.nItems;
            }
            int sum = 0;
            for (int i = this.nItems; i >= 0; --i) {
                sum += this.nChildren[i];
            }
            return sum;
        }

        private void insert(BtreeKey key, int i, int height) {
            this.insert(key, i);
            if (height != 0) {
                this.countChildren(i, height);
            }
        }

        int insert(BtreeKey ins, int height, boolean unique, boolean overwrite) {
            int ahead;
            int n;
            int l = 0;
            int r = n = this.nItems;
            int n2 = ahead = unique ? 1 : 0;
            while (l < r) {
                int i = l + r >> 1;
                if (this.compare(ins.key, i) >= ahead) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            Assert.that(l == r);
            if (--height != 0) {
                int result = ((BtreePage)this.items.get(r)).insert(ins, height, unique, overwrite);
                Assert.that(result != 3);
                if (result != 1) {
                    if (result == 0) {
                        this.modify();
                        int n3 = r;
                        this.nChildren[n3] = this.nChildren[n3] + 1;
                    }
                    return result;
                }
                ++n;
            } else if (r < n && this.compare(ins.key, r) == 0) {
                if (overwrite) {
                    ins.oldNode = this.items.get(r);
                    this.modify();
                    this.items.setObject(r, ins.node);
                    return 5;
                }
                if (unique) {
                    ins.oldNode = this.items.get(r);
                    return 4;
                }
            }
            int max = this.items.size();
            this.modify();
            if (height != 0) {
                this.countChildren(r, height);
            }
            if (n < max) {
                BtreePage.memcpy(this, r + 1, this, r, n - r);
                this.insert(ins, r, height);
                ++this.nItems;
                return 0;
            }
            BtreePage b = this.clonePage();
            Assert.that(n == max);
            int m = max / 2;
            if (r < m) {
                BtreePage.memcpy(b, 0, this, 0, r);
                BtreePage.memcpy(b, r + 1, this, r, m - r - 1);
                BtreePage.memcpy(this, 0, this, m - 1, max - m + 1);
                b.insert(ins, r, height);
            } else {
                BtreePage.memcpy(b, 0, this, 0, m);
                BtreePage.memcpy(this, 0, this, m, r - m);
                BtreePage.memcpy(this, r - m + 1, this, r, max - r);
                this.insert(ins, r - m, height);
            }
            this.memset(max - m + 1, m - 1);
            ins.node = b;
            ins.key = b.getKey(m - 1);
            if (height == 0) {
                this.nItems = max - m + 1;
                b.nItems = m;
            } else {
                b.clearKeyValue(m - 1);
                this.nItems = max - m;
                b.nItems = m - 1;
            }
            return 1;
        }

        int handlePageUnderflow(int r, BtreeKey rem, int height) {
            BtreePage a = (BtreePage)this.items.get(r);
            a.modify();
            this.modify();
            int an = a.nItems;
            if (r < this.nItems) {
                BtreePage b = (BtreePage)this.items.get(r + 1);
                int bn = b.nItems;
                Assert.that(bn >= an);
                if (height != 1) {
                    BtreePage.memcpyData(a, an, this, r, 1);
                    ++an;
                    ++bn;
                }
                if (an + bn > this.items.size()) {
                    int i = bn - (an + bn >> 1);
                    b.modify();
                    BtreePage.memcpy(a, an, b, 0, i);
                    BtreePage.memcpy(b, 0, b, i, bn - i);
                    BtreePage.memcpyData(this, r, a, an + i - 1, 1);
                    if (height != 1) {
                        a.clearKeyValue(an + i - 1);
                    }
                    b.memset(bn - i, i);
                    b.nItems -= i;
                    a.nItems += i;
                    this.countChildren(r, height);
                    this.countChildren(r + 1, height);
                    return 0;
                }
                BtreePage.memcpy(a, an, b, 0, bn);
                b.deallocate();
                int nMergedChildren = this.nChildren[r + 1];
                BtreePage.memcpyData(this, r, this, r + 1, this.nItems - r - 1);
                BtreePage.memcpyItems(this, r + 1, this, r + 2, this.nItems - r - 1);
                this.items.setObject(this.nItems, null);
                a.nItems += bn;
                --this.nItems;
                int n = r;
                this.nChildren[n] = this.nChildren[n] + (nMergedChildren - 1);
                return this.nItems < this.items.size() >> 1 ? 2 : 0;
            }
            BtreePage b = (BtreePage)this.items.get(r - 1);
            int bn = b.nItems;
            Assert.that(bn >= an);
            if (height != 1) {
                ++an;
                ++bn;
            }
            if (an + bn > this.items.size()) {
                int i = bn - (an + bn >> 1);
                b.modify();
                BtreePage.memcpy(a, i, a, 0, an);
                BtreePage.memcpy(a, 0, b, bn - i, i);
                if (height != 1) {
                    BtreePage.memcpyData(a, i - 1, this, r - 1, 1);
                }
                BtreePage.memcpyData(this, r - 1, b, bn - i - 1, 1);
                if (height != 1) {
                    b.clearKeyValue(bn - i - 1);
                }
                b.memset(bn - i, i);
                b.nItems -= i;
                a.nItems += i;
                this.countChildren(r - 1, height);
                this.countChildren(r, height);
                return 0;
            }
            BtreePage.memcpy(a, bn, a, 0, an);
            BtreePage.memcpy(a, 0, b, 0, bn);
            if (height != 1) {
                BtreePage.memcpyData(a, bn - 1, this, r - 1, 1);
            }
            b.deallocate();
            this.items.setObject(r - 1, a);
            this.items.setObject(this.nItems, null);
            int n = r - 1;
            this.nChildren[n] = this.nChildren[n] + (this.nChildren[r] - 1);
            a.nItems += bn;
            --this.nItems;
            return this.nItems < this.items.size() >> 1 ? 2 : 0;
        }

        int remove(BtreeKey rem, int height) {
            int n = this.nItems;
            int l = 0;
            int r = n;
            while (l < r) {
                int i = l + r >> 1;
                if (this.compare(rem.key, i) > 0) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            if (--height == 0) {
                IPersistent node = rem.node;
                while (r < n && this.compare(rem.key, r) == 0) {
                    if (node == null || this.items.containsElement(r, node)) {
                        rem.oldNode = this.items.get(r);
                        this.modify();
                        BtreePage.memcpy(this, r, this, r + 1, n - r - 1);
                        this.nItems = --n;
                        this.memset(n, 1);
                        return n < this.items.size() >> 1 ? 2 : 0;
                    }
                    ++r;
                }
                return 3;
            }
            do {
                switch (((BtreePage)this.items.get(r)).remove(rem, height)) {
                    case 2: {
                        return this.handlePageUnderflow(r, rem, height);
                    }
                    case 0: {
                        this.modify();
                        int n2 = r;
                        this.nChildren[n2] = this.nChildren[n2] - 1;
                        return 0;
                    }
                }
            } while (++r <= n);
            return 3;
        }

        void purge(int height) {
            if (--height != 0) {
                int n = this.nItems;
                do {
                    ((BtreePage)this.items.get(n)).purge(height);
                } while (--n >= 0);
            }
            super.deallocate();
        }

        int traverseForward(int height, IPersistent[] result, int pos) {
            int n = this.nItems;
            if (--height != 0) {
                for (int i = 0; i <= n; ++i) {
                    pos = ((BtreePage)this.items.get(i)).traverseForward(height, result, pos);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    result[pos++] = this.items.get(i);
                }
            }
            return pos;
        }

        BtreePage(Storage s, int n) {
            super(s);
            this.items = s.createLink(n);
            this.items.setSize(n);
            this.nChildren = new int[n];
        }

        BtreePage() {
        }
    }

    static class BtreeKey {
        Key key;
        IPersistent node;
        IPersistent oldNode;

        BtreeKey(Key key, IPersistent node) {
            this.key = key;
            this.node = node;
        }
    }
}

