/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Iterator;
import java.util.Map;
import org.garret.perst.Assert;
import org.garret.perst.Blob;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentResource;
import org.garret.perst.RandomAccessInputStream;
import org.garret.perst.RandomAccessOutputStream;
import org.garret.perst.Storage;

public class RandomAccessBlobImpl
extends PersistentResource
implements Blob {
    long size;
    Index chunks;
    static final int CHUNK_SIZE = 4088;

    public RandomAccessInputStream getInputStream() {
        return this.getInputStream(0);
    }

    public RandomAccessInputStream getInputStream(int flags) {
        return new BlobInputStream();
    }

    public RandomAccessOutputStream getOutputStream() {
        return this.getOutputStream(0);
    }

    public RandomAccessOutputStream getOutputStream(boolean multisession) {
        return this.getOutputStream(0);
    }

    public RandomAccessOutputStream getOutputStream(long position, boolean multisession) {
        RandomAccessOutputStream stream = this.getOutputStream(multisession);
        stream.setPosition(position);
        return stream;
    }

    public RandomAccessOutputStream getOutputStream(int flags) {
        return new BlobOutputStream(flags);
    }

    public void deallocate() {
        Iterator iterator = this.chunks.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.chunks.clear();
        super.deallocate();
    }

    RandomAccessBlobImpl(Storage storage) {
        super(storage);
        this.chunks = storage.createIndex(Long.TYPE, true);
    }

    RandomAccessBlobImpl() {
    }

    class BlobOutputStream
    extends RandomAccessOutputStream {
        protected Chunk currChunk;
        protected long currPos;
        protected long currChunkPos;
        protected Iterator iterator;

        public void write(int b) {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        public void write(byte[] b, int off, int len) {
            while (len > 0) {
                int chunkOffs;
                boolean newChunk = false;
                if (this.currPos >= this.currChunkPos + 4088L) {
                    if (this.iterator.hasNext()) {
                        Map.Entry e = (Map.Entry)this.iterator.next();
                        this.currChunkPos = (Long)e.getKey();
                        this.currChunk = (Chunk)e.getValue();
                        Assert.that(this.currPos < this.currChunkPos + 4088L);
                    } else {
                        this.currChunk = new Chunk(RandomAccessBlobImpl.this.getStorage());
                        this.currChunkPos = this.currPos / 4088L * 4088L;
                        newChunk = true;
                    }
                }
                if (this.currPos < this.currChunkPos) {
                    this.currChunk = new Chunk(RandomAccessBlobImpl.this.getStorage());
                    this.currChunkPos = this.currPos / 4088L * 4088L;
                    newChunk = true;
                }
                int copy = len < 4088 - (chunkOffs = (int)(this.currPos - this.currChunkPos)) ? len : 4088 - chunkOffs;
                System.arraycopy(b, off, this.currChunk.body, chunkOffs, copy);
                len -= copy;
                this.currPos += (long)copy;
                off += copy;
                if (newChunk) {
                    RandomAccessBlobImpl.this.chunks.put(new Key(this.currChunkPos), this.currChunk);
                    this.iterator = RandomAccessBlobImpl.this.chunks.entryIterator(new Key(this.currChunkPos + 4088L), null, 0);
                    continue;
                }
                this.currChunk.modify();
            }
            if (this.currPos > RandomAccessBlobImpl.this.size) {
                RandomAccessBlobImpl.this.size = this.currPos;
                RandomAccessBlobImpl.this.modify();
            }
        }

        public long setPosition(long newPos) {
            if (newPos < 0L) {
                return -1L;
            }
            this.currPos = newPos;
            this.iterator = RandomAccessBlobImpl.this.chunks.entryIterator(new Key(this.currPos / 4088L * 4088L), null, 0);
            this.currChunkPos = Long.MIN_VALUE;
            this.currChunk = null;
            return this.currPos;
        }

        public long getPosition() {
            return this.currPos;
        }

        public long size() {
            return RandomAccessBlobImpl.this.size;
        }

        public long skip(long offs) {
            return this.setPosition(this.currPos + offs);
        }

        public void close() {
            this.currChunk = null;
            this.iterator = null;
        }

        protected BlobOutputStream(int flags) {
            this.setPosition((flags & 8) != 0 ? RandomAccessBlobImpl.this.size : 0L);
        }
    }

    class BlobInputStream
    extends RandomAccessInputStream {
        protected Chunk currChunk;
        protected long currPos;
        protected long currChunkPos;
        protected Iterator iterator;

        public int read() {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == 1 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) {
            if (this.currPos >= RandomAccessBlobImpl.this.size) {
                return -1;
            }
            long rest = RandomAccessBlobImpl.this.size - this.currPos;
            if ((long)len > rest) {
                len = (int)rest;
            }
            int rc = len;
            while (len > 0) {
                int chunkOffs;
                if (this.currPos >= this.currChunkPos + 4088L) {
                    Map.Entry e = (Map.Entry)this.iterator.next();
                    this.currChunkPos = (Long)e.getKey();
                    this.currChunk = (Chunk)e.getValue();
                    Assert.that(this.currPos < this.currChunkPos + 4088L);
                }
                if (this.currPos < this.currChunkPos) {
                    int fill = (long)len < this.currChunkPos - this.currPos ? len : (int)(this.currChunkPos - this.currPos);
                    len -= fill;
                    this.currPos += (long)fill;
                    while (--fill >= 0) {
                        b[off++] = 0;
                    }
                }
                int copy = len < 4088 - (chunkOffs = (int)(this.currPos - this.currChunkPos)) ? len : 4088 - chunkOffs;
                System.arraycopy(this.currChunk.body, chunkOffs, b, off, copy);
                len -= copy;
                off += copy;
                this.currPos += (long)copy;
            }
            return rc;
        }

        public long setPosition(long newPos) {
            if (newPos < 0L) {
                return -1L;
            }
            this.currPos = newPos > RandomAccessBlobImpl.this.size ? RandomAccessBlobImpl.this.size : newPos;
            this.iterator = RandomAccessBlobImpl.this.chunks.entryIterator(new Key(this.currPos / 4088L * 4088L), null, 0);
            this.currChunkPos = Long.MIN_VALUE;
            this.currChunk = null;
            return this.currPos;
        }

        public long getPosition() {
            return this.currPos;
        }

        public long size() {
            return RandomAccessBlobImpl.this.size;
        }

        public long skip(long offs) {
            return this.setPosition(this.currPos + offs);
        }

        public int available() {
            return (int)(RandomAccessBlobImpl.this.size - this.currPos);
        }

        public void close() {
            this.currChunk = null;
            this.iterator = null;
        }

        protected BlobInputStream() {
            this.setPosition(0L);
        }
    }

    static class Chunk
    extends Persistent {
        byte[] body;

        Chunk() {
        }

        Chunk(Storage db) {
            super(db);
            this.body = new byte[4088];
        }
    }
}

