/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;

public class OSFile
implements IFile {
    protected RandomAccessFile file;
    protected boolean noFlush;
    private FileLock lck;

    public void write(long pos, byte[] buf) {
        try {
            this.file.seek(pos);
            this.file.write(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public int read(long pos, byte[] buf) {
        try {
            this.file.seek(pos);
            return this.file.read(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public void sync() {
        if (!this.noFlush) {
            try {
                this.file.getFD().sync();
            }
            catch (IOException x) {
                throw new StorageError(3, x);
            }
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public boolean tryLock(boolean shared) {
        try {
            this.lck = this.file.getChannel().tryLock(0L, Long.MAX_VALUE, shared);
            return this.lck != null;
        }
        catch (IOException x) {
            return true;
        }
    }

    public void lock(boolean shared) {
        try {
            this.lck = this.file.getChannel().lock(0L, Long.MAX_VALUE, shared);
        }
        catch (IOException x) {
            throw new StorageError(21, x);
        }
    }

    public void unlock() {
        try {
            this.lck.release();
        }
        catch (IOException x) {
            throw new StorageError(21, x);
        }
    }

    public OSFile(String filePath, boolean readOnly, boolean noFlush) {
        this.noFlush = noFlush;
        try {
            this.file = new RandomAccessFile(filePath, readOnly ? "r" : "rw");
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException x) {
            return -1L;
        }
    }
}

