/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLExporter;

class BtreePage {
    static final int firstKeyOffs = 4;
    static final int keySpace = 4092;
    static final int strKeySize = 8;
    static final int maxItems = 1023;

    BtreePage() {
    }

    static int getnItems(Page pg) {
        return Bytes.unpack2(pg.data, 0);
    }

    static int getSize(Page pg) {
        return Bytes.unpack2(pg.data, 2);
    }

    static int getKeyStrOid(Page pg, int index) {
        return Bytes.unpack4(pg.data, 4 + index * 8);
    }

    static int getKeyStrSize(Page pg, int index) {
        return Bytes.unpack2(pg.data, 4 + index * 8 + 4);
    }

    static int getKeyStrOffs(Page pg, int index) {
        return Bytes.unpack2(pg.data, 4 + index * 8 + 6);
    }

    static int getReference(Page pg, int index) {
        return Bytes.unpack4(pg.data, 4 + index * 4);
    }

    static void setnItems(Page pg, int nItems) {
        Bytes.pack2(pg.data, 0, (short)nItems);
    }

    static void setSize(Page pg, int size) {
        Bytes.pack2(pg.data, 2, (short)size);
    }

    static void setKeyStrOid(Page pg, int index, int oid) {
        Bytes.pack4(pg.data, 4 + index * 8, oid);
    }

    static void setKeyStrSize(Page pg, int index, int size) {
        Bytes.pack2(pg.data, 4 + index * 8 + 4, (short)size);
    }

    static void setKeyStrOffs(Page pg, int index, int offs) {
        Bytes.pack2(pg.data, 4 + index * 8 + 6, (short)offs);
    }

    static void setKeyStrChars(Page pg, int offs, char[] str) {
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            Bytes.pack2(pg.data, 4 + offs, (short)str[i]);
            offs += 2;
        }
    }

    static void setKeyBytes(Page pg, int offs, byte[] bytes) {
        System.arraycopy(bytes, 0, pg.data, 4 + offs, bytes.length);
    }

    static void setReference(Page pg, int index, int oid) {
        Bytes.pack4(pg.data, 4 + index * 4, oid);
    }

    static final int compare(Key key, Page pg, int i) {
        switch (key.type) {
            case 0: 
            case 1: {
                return (byte)key.ival - pg.data[4 + i];
            }
            case 3: {
                return (short)key.ival - Bytes.unpack2(pg.data, 4 + i * 2);
            }
            case 2: {
                return (char)key.ival - (char)Bytes.unpack2(pg.data, 4 + i * 2);
            }
            case 4: 
            case 10: 
            case 14: {
                int i4 = Bytes.unpack4(pg.data, 4 + i * 4);
                return key.ival < i4 ? -1 : (key.ival == i4 ? 0 : 1);
            }
            case 5: 
            case 9: {
                long i8 = Bytes.unpack8(pg.data, 4 + i * 8);
                return key.lval < i8 ? -1 : (key.lval == i8 ? 0 : 1);
            }
            case 6: {
                float r4 = Float.intBitsToFloat(Bytes.unpack4(pg.data, 4 + i * 4));
                return key.dval < (double)r4 ? -1 : (key.dval == (double)r4 ? 0 : 1);
            }
            case 7: {
                double r8 = Double.longBitsToDouble(Bytes.unpack8(pg.data, 4 + i * 8));
                return key.dval < r8 ? -1 : (key.dval == r8 ? 0 : 1);
            }
        }
        Assert.failed("Invalid type");
        return 0;
    }

    static final int compareStr(Key key, Page pg, int i) {
        char[] chars = (char[])key.oval;
        int alen = chars.length;
        int blen = BtreePage.getKeyStrSize(pg, i);
        int minlen = alen < blen ? alen : blen;
        int offs = BtreePage.getKeyStrOffs(pg, i) + 4;
        byte[] b = pg.data;
        for (int j = 0; j < minlen; ++j) {
            int diff = chars[j] - (char)Bytes.unpack2(b, offs);
            if (diff != 0) {
                return diff;
            }
            offs += 2;
        }
        return alen - blen;
    }

    static final int comparePrefix(char[] key, Page pg, int i) {
        int alen = key.length;
        int blen = BtreePage.getKeyStrSize(pg, i);
        int minlen = alen < blen ? alen : blen;
        int offs = BtreePage.getKeyStrOffs(pg, i) + 4;
        byte[] b = pg.data;
        for (int j = 0; j < minlen; ++j) {
            int diff = key[j] - (char)Bytes.unpack2(b, offs);
            if (diff != 0) {
                return diff;
            }
            offs += 2;
        }
        return minlen - blen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean find(StorageImpl db, int pageId, Key firstKey, Key lastKey, Btree tree, int height, ArrayList result) {
        int n;
        Page pg = db.getPage(pageId);
        int l = 0;
        int r = n = BtreePage.getnItems(pg);
        --height;
        try {
            boolean bl;
            block66: {
                block64: {
                    block65: {
                        block63: {
                            block53: {
                                block54: {
                                    int i;
                                    block62: {
                                        block60: {
                                            block61: {
                                                block59: {
                                                    block51: {
                                                        block52: {
                                                            int i2;
                                                            block58: {
                                                                block56: {
                                                                    block57: {
                                                                        block55: {
                                                                            block48: {
                                                                                block49: {
                                                                                    block50: {
                                                                                        block47: {
                                                                                            if (tree.type != 8) break block47;
                                                                                            if (firstKey == null) break block48;
                                                                                            break block49;
                                                                                        }
                                                                                        if (tree.type != 21) break block50;
                                                                                        if (firstKey == null) break block51;
                                                                                        break block52;
                                                                                    }
                                                                                    if (firstKey == null) break block53;
                                                                                    break block54;
                                                                                }
                                                                                while (l < r) {
                                                                                    i2 = l + r >> 1;
                                                                                    if (BtreePage.compareStr(firstKey, pg, i2) >= firstKey.inclusion) {
                                                                                        l = i2 + 1;
                                                                                        continue;
                                                                                    }
                                                                                    r = i2;
                                                                                }
                                                                                Assert.that(r == l);
                                                                            }
                                                                            if (lastKey == null) break block55;
                                                                            if (height != 0) break block56;
                                                                            break block57;
                                                                        }
                                                                        if (height == 0) {
                                                                            while (l < n) {
                                                                                int oid = BtreePage.getKeyStrOid(pg, l);
                                                                                result.add(db.lookupObject(oid, null));
                                                                                ++l;
                                                                            }
                                                                            return true;
                                                                        }
                                                                        break block58;
                                                                    }
                                                                    while (l < n) {
                                                                        if (-BtreePage.compareStr(lastKey, pg, l) >= lastKey.inclusion) {
                                                                            i2 = 0;
                                                                            return i2 != 0;
                                                                        }
                                                                        int oid = BtreePage.getKeyStrOid(pg, l);
                                                                        result.add(db.lookupObject(oid, null));
                                                                        ++l;
                                                                    }
                                                                    return true;
                                                                }
                                                                do {
                                                                    if (!BtreePage.find(db, BtreePage.getKeyStrOid(pg, l), firstKey, lastKey, tree, height, result)) {
                                                                        i2 = 0;
                                                                        return i2 != 0;
                                                                    }
                                                                    if (l != n) continue;
                                                                    i2 = 1;
                                                                    return i2 != 0;
                                                                } while (BtreePage.compareStr(lastKey, pg, l++) >= 0);
                                                                i2 = 0;
                                                                return i2 != 0;
                                                            }
                                                            do {
                                                                if (BtreePage.find(db, BtreePage.getKeyStrOid(pg, l), firstKey, lastKey, tree, height, result)) continue;
                                                                i2 = 0;
                                                                return i2 != 0;
                                                            } while (++l <= n);
                                                            return true;
                                                        }
                                                        while (l < r) {
                                                            i = l + r >> 1;
                                                            if (tree.compareByteArrays(firstKey, pg, i) >= firstKey.inclusion) {
                                                                l = i + 1;
                                                                continue;
                                                            }
                                                            r = i;
                                                        }
                                                        Assert.that(r == l);
                                                    }
                                                    if (lastKey == null) break block59;
                                                    if (height != 0) break block60;
                                                    break block61;
                                                }
                                                if (height == 0) {
                                                    while (l < n) {
                                                        int oid = BtreePage.getKeyStrOid(pg, l);
                                                        result.add(db.lookupObject(oid, null));
                                                        ++l;
                                                    }
                                                    return true;
                                                }
                                                break block62;
                                            }
                                            while (l < n) {
                                                if (-tree.compareByteArrays(lastKey, pg, l) >= lastKey.inclusion) {
                                                    i = 0;
                                                    return i != 0;
                                                }
                                                int oid = BtreePage.getKeyStrOid(pg, l);
                                                result.add(db.lookupObject(oid, null));
                                                ++l;
                                            }
                                            return true;
                                        }
                                        do {
                                            if (!BtreePage.find(db, BtreePage.getKeyStrOid(pg, l), firstKey, lastKey, tree, height, result)) {
                                                i = 0;
                                                return i != 0;
                                            }
                                            if (l != n) continue;
                                            i = 1;
                                            return i != 0;
                                        } while (tree.compareByteArrays(lastKey, pg, l++) >= 0);
                                        i = 0;
                                        return i != 0;
                                    }
                                    do {
                                        if (BtreePage.find(db, BtreePage.getKeyStrOid(pg, l), firstKey, lastKey, tree, height, result)) continue;
                                        i = 0;
                                        return i != 0;
                                    } while (++l <= n);
                                    return true;
                                }
                                while (l < r) {
                                    int i = l + r >> 1;
                                    if (BtreePage.compare(firstKey, pg, i) >= firstKey.inclusion) {
                                        l = i + 1;
                                        continue;
                                    }
                                    r = i;
                                }
                                Assert.that(r == l);
                            }
                            if (lastKey == null) break block63;
                            if (height != 0) break block64;
                            break block65;
                        }
                        if (height == 0) {
                            while (l < n) {
                                int oid = BtreePage.getReference(pg, 1022 - l);
                                result.add(db.lookupObject(oid, null));
                                ++l;
                            }
                            return true;
                        }
                        break block66;
                    }
                    while (true) {
                        if (l >= n) {
                            bl = true;
                            return bl;
                        }
                        if (-BtreePage.compare(lastKey, pg, l) >= lastKey.inclusion) {
                            bl = false;
                            return bl;
                        }
                        int oid = BtreePage.getReference(pg, 1022 - l);
                        result.add(db.lookupObject(oid, null));
                        ++l;
                    }
                }
                do {
                    if (!BtreePage.find(db, BtreePage.getReference(pg, 1022 - l), firstKey, lastKey, tree, height, result)) {
                        bl = false;
                        return bl;
                    }
                    if (l != n) continue;
                    bl = true;
                    return bl;
                } while (BtreePage.compare(lastKey, pg, l++) >= 0);
                bl = false;
                return bl;
            }
            do {
                if (BtreePage.find(db, BtreePage.getReference(pg, 1022 - l), firstKey, lastKey, tree, height, result)) continue;
                bl = false;
                return bl;
            } while (++l <= n);
            return true;
        }
        finally {
            db.pool.unfix(pg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prefixSearch(StorageImpl db, int pageId, char[] key, int height, ArrayList result) {
        block13: {
            int n;
            Page pg = db.getPage(pageId);
            int l = 0;
            int r = n = BtreePage.getnItems(pg);
            --height;
            try {
                boolean bl;
                while (l < r) {
                    int i = l + r >> 1;
                    if (BtreePage.comparePrefix(key, pg, i) > 0) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                Assert.that(r == l);
                if (height == 0) {
                    while (l < n) {
                        if (BtreePage.comparePrefix(key, pg, l) < 0) {
                            bl = false;
                            return bl;
                        }
                        int oid = BtreePage.getKeyStrOid(pg, l);
                        result.add(db.lookupObject(oid, null));
                        ++l;
                    }
                    break block13;
                }
                do {
                    if (!BtreePage.prefixSearch(db, BtreePage.getKeyStrOid(pg, l), key, height, result)) {
                        bl = false;
                        return bl;
                    }
                    if (l != n) continue;
                    bl = true;
                    return bl;
                } while (BtreePage.comparePrefix(key, pg, l++) >= 0);
                bl = false;
                return bl;
            }
            finally {
                db.pool.unfix(pg);
            }
        }
        return true;
    }

    static int allocate(StorageImpl db, int root, int type, BtreeKey ins) {
        int pageId = db.allocatePage();
        Page pg = db.putPage(pageId);
        BtreePage.setnItems(pg, 1);
        if (type == 8) {
            char[] sval = (char[])ins.key.oval;
            int len = sval.length;
            BtreePage.setSize(pg, len * 2);
            BtreePage.setKeyStrOffs(pg, 0, 4092 - len * 2);
            BtreePage.setKeyStrSize(pg, 0, len);
            BtreePage.setKeyStrOid(pg, 0, ins.oid);
            BtreePage.setKeyStrOid(pg, 1, root);
            BtreePage.setKeyStrChars(pg, 4092 - len * 2, sval);
        } else if (type == 21) {
            byte[] bval = (byte[])ins.key.oval;
            int len = bval.length;
            BtreePage.setSize(pg, len);
            BtreePage.setKeyStrOffs(pg, 0, 4092 - len);
            BtreePage.setKeyStrSize(pg, 0, len);
            BtreePage.setKeyStrOid(pg, 0, ins.oid);
            BtreePage.setKeyStrOid(pg, 1, root);
            BtreePage.setKeyBytes(pg, 4092 - len, bval);
        } else {
            ins.pack(pg, 0);
            BtreePage.setReference(pg, 1021, root);
        }
        db.pool.unfix(pg);
        return pageId;
    }

    static void memcpy(Page dst_pg, int dst_idx, Page src_pg, int src_idx, int len, int itemSize) {
        System.arraycopy(src_pg.data, 4 + src_idx * itemSize, dst_pg.data, 4 + dst_idx * itemSize, len * itemSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int insert(StorageImpl db, int pageId, Btree tree, BtreeKey ins, int height, boolean unique, boolean overwrite) {
        int n;
        Page pg = db.getPage(pageId);
        int l = 0;
        int r = n = BtreePage.getnItems(pg);
        int ahead = unique ? 1 : 0;
        try {
            int i;
            if (tree.type == 8) {
                int i2;
                while (l < r) {
                    i2 = l + r >> 1;
                    if (BtreePage.compareStr(ins.key, pg, i2) >= ahead) {
                        l = i2 + 1;
                        continue;
                    }
                    r = i2;
                }
                Assert.that(l == r);
                if (--height != 0) {
                    int result = BtreePage.insert(db, BtreePage.getKeyStrOid(pg, r), tree, ins, height, unique, overwrite);
                    Assert.that(result != 3);
                    if (result != 1) {
                        i2 = result;
                        return i2;
                    }
                } else if (r < n && BtreePage.compareStr(ins.key, pg, r) == 0) {
                    if (overwrite) {
                        db.pool.unfix(pg);
                        pg = null;
                        pg = db.putPage(pageId);
                        ins.oldOid = BtreePage.getKeyStrOid(pg, r);
                        BtreePage.setKeyStrOid(pg, r, ins.oid);
                        i2 = 5;
                        return i2;
                    }
                    if (unique) {
                        i2 = 4;
                        return i2;
                    }
                }
                db.pool.unfix(pg);
                pg = null;
                pg = db.putPage(pageId);
                i2 = BtreePage.insertStrKey(db, pg, r, ins, height);
                return i2;
            }
            if (tree.type == 21) {
                int i3;
                while (l < r) {
                    i3 = l + r >> 1;
                    if (tree.compareByteArrays(ins.key, pg, i3) >= ahead) {
                        l = i3 + 1;
                        continue;
                    }
                    r = i3;
                }
                Assert.that(l == r);
                if (--height != 0) {
                    int result = BtreePage.insert(db, BtreePage.getKeyStrOid(pg, r), tree, ins, height, unique, overwrite);
                    Assert.that(result != 3);
                    if (result != 1) {
                        i3 = result;
                        return i3;
                    }
                } else if (r < n && tree.compareByteArrays(ins.key, pg, r) == 0) {
                    if (overwrite) {
                        db.pool.unfix(pg);
                        pg = null;
                        pg = db.putPage(pageId);
                        ins.oldOid = BtreePage.getKeyStrOid(pg, r);
                        BtreePage.setKeyStrOid(pg, r, ins.oid);
                        i3 = 5;
                        return i3;
                    }
                    if (unique) {
                        i3 = 4;
                        return i3;
                    }
                }
                db.pool.unfix(pg);
                pg = null;
                pg = db.putPage(pageId);
                i3 = BtreePage.insertByteArrayKey(db, pg, r, ins, height);
                return i3;
            }
            while (l < r) {
                i = l + r >> 1;
                if (BtreePage.compare(ins.key, pg, i) >= ahead) {
                    l = i + 1;
                    continue;
                }
                r = i;
            }
            Assert.that(l == r);
            if (--height != 0) {
                int result = BtreePage.insert(db, BtreePage.getReference(pg, 1023 - r - 1), tree, ins, height, unique, overwrite);
                Assert.that(result != 3);
                if (result != 1) {
                    i = result;
                    return i;
                }
                ++n;
            } else if (r < n && BtreePage.compare(ins.key, pg, r) == 0) {
                if (overwrite) {
                    db.pool.unfix(pg);
                    pg = null;
                    pg = db.putPage(pageId);
                    ins.oldOid = BtreePage.getReference(pg, 1023 - r - 1);
                    BtreePage.setReference(pg, 1023 - r - 1, ins.oid);
                    i = 5;
                    return i;
                }
                if (unique) {
                    i = 4;
                    return i;
                }
            }
            db.pool.unfix(pg);
            pg = null;
            pg = db.putPage(pageId);
            int itemSize = ClassDescriptor.sizeof[tree.type];
            int max = 4092 / (4 + itemSize);
            if (n < max) {
                BtreePage.memcpy(pg, r + 1, pg, r, n - r, itemSize);
                BtreePage.memcpy(pg, 1023 - n - 1, pg, 1023 - n, n - r, 4);
                ins.pack(pg, r);
                BtreePage.setnItems(pg, BtreePage.getnItems(pg) + 1);
                int n2 = 0;
                return n2;
            }
            pageId = db.allocatePage();
            Page b = db.putPage(pageId);
            Assert.that(n == max);
            int m = max / 2;
            if (r < m) {
                BtreePage.memcpy(b, 0, pg, 0, r, itemSize);
                BtreePage.memcpy(b, r + 1, pg, r, m - r - 1, itemSize);
                BtreePage.memcpy(pg, 0, pg, m - 1, max - m + 1, itemSize);
                BtreePage.memcpy(b, 1023 - r, pg, 1023 - r, r, 4);
                ins.pack(b, r);
                BtreePage.memcpy(b, 1023 - m, pg, 1023 - m + 1, m - r - 1, 4);
                BtreePage.memcpy(pg, 1023 - max + m - 1, pg, 1023 - max, max - m + 1, 4);
            } else {
                BtreePage.memcpy(b, 0, pg, 0, m, itemSize);
                BtreePage.memcpy(pg, 0, pg, m, r - m, itemSize);
                BtreePage.memcpy(pg, r - m + 1, pg, r, max - r, itemSize);
                BtreePage.memcpy(b, 1023 - m, pg, 1023 - m, m, 4);
                BtreePage.memcpy(pg, 1023 - r + m, pg, 1023 - r, r - m, 4);
                ins.pack(pg, r - m);
                BtreePage.memcpy(pg, 1023 - max + m - 1, pg, 1023 - max, max - r, 4);
            }
            ins.oid = pageId;
            ins.extract(b, 4 + (m - 1) * itemSize, tree.type);
            if (height == 0) {
                BtreePage.setnItems(pg, max - m + 1);
                BtreePage.setnItems(b, m);
            } else {
                BtreePage.setnItems(pg, max - m);
                BtreePage.setnItems(b, m - 1);
            }
            db.pool.unfix(b);
            int n3 = 1;
            return n3;
        }
        finally {
            if (pg != null) {
                db.pool.unfix(pg);
            }
        }
    }

    static int insertStrKey(StorageImpl db, Page pg, int r, BtreeKey ins, int height) {
        int n;
        char[] sval;
        int len;
        int nItems = BtreePage.getnItems(pg);
        int size = BtreePage.getSize(pg);
        if (size + (len = (sval = (char[])ins.key.oval).length) * 2 + ((n = height != 0 ? nItems + 1 : nItems) + 1) * 8 > 4092) {
            int pageId = db.allocatePage();
            Page b = db.putPage(pageId);
            int moved = 0;
            int inserted = len * 2 + 8;
            int prevDelta = -2147483647;
            int bn = 0;
            int i = 0;
            while (true) {
                int subSize;
                int addSize;
                int j = nItems - i - 1;
                int keyLen = BtreePage.getKeyStrSize(pg, i);
                if (bn == r) {
                    keyLen = len;
                    inserted = 0;
                    addSize = len;
                    if (height == 0) {
                        subSize = 0;
                        ++j;
                    } else {
                        subSize = BtreePage.getKeyStrSize(pg, i);
                    }
                } else {
                    addSize = subSize = keyLen;
                    if (height != 0) {
                        if (i + 1 != r) {
                            subSize += BtreePage.getKeyStrSize(pg, i + 1);
                            --j;
                        } else {
                            inserted = 0;
                        }
                    }
                }
                int delta = moved + addSize * 2 + (bn + 1) * 8 - (j * 8 + size - subSize * 2 + inserted);
                if (delta >= -prevDelta) {
                    if (height == 0) {
                        ins.getStr(b, bn - 1);
                    } else {
                        Assert.that("String fits in the B-Tree page", moved + (bn + 1) * 8 <= 4092);
                        if (bn != r) {
                            ins.getStr(pg, i);
                            BtreePage.setKeyStrOid(b, bn, BtreePage.getKeyStrOid(pg, i));
                            size -= keyLen * 2;
                            ++i;
                        } else {
                            BtreePage.setKeyStrOid(b, bn, ins.oid);
                        }
                    }
                    nItems = BtreePage.compactifyStrings(pg, i);
                    if (bn < r || bn == r && height == 0) {
                        BtreePage.memcpy(pg, r - i + 1, pg, r - i, n - r, 8);
                        ++nItems;
                        Assert.that("String fits in the B-Tree page", (size += len * 2) + (n - i + 1) * 8 <= 4092);
                        BtreePage.setKeyStrOffs(pg, r - i, 4092 - size);
                        BtreePage.setKeyStrSize(pg, r - i, len);
                        BtreePage.setKeyStrOid(pg, r - i, ins.oid);
                        BtreePage.setKeyStrChars(pg, 4092 - size, sval);
                    }
                    BtreePage.setnItems(b, bn);
                    BtreePage.setSize(b, moved);
                    BtreePage.setSize(pg, size);
                    BtreePage.setnItems(pg, nItems);
                    ins.oid = pageId;
                    db.pool.unfix(b);
                    return 1;
                }
                prevDelta = delta;
                Assert.that("String fits in the B-Tree page", (moved += keyLen * 2) + (bn + 1) * 8 <= 4092);
                BtreePage.setKeyStrSize(b, bn, keyLen);
                BtreePage.setKeyStrOffs(b, bn, 4092 - moved);
                if (bn == r) {
                    BtreePage.setKeyStrOid(b, bn, ins.oid);
                    BtreePage.setKeyStrChars(b, 4092 - moved, sval);
                } else {
                    BtreePage.setKeyStrOid(b, bn, BtreePage.getKeyStrOid(pg, i));
                    BtreePage.memcpy(b, 4092 - moved, pg, BtreePage.getKeyStrOffs(pg, i), keyLen * 2, 1);
                    size -= keyLen * 2;
                    ++i;
                }
                ++bn;
            }
        }
        BtreePage.memcpy(pg, r + 1, pg, r, n - r, 8);
        BtreePage.setKeyStrOffs(pg, r, 4092 - (size += len * 2));
        BtreePage.setKeyStrSize(pg, r, len);
        BtreePage.setKeyStrOid(pg, r, ins.oid);
        BtreePage.setKeyStrChars(pg, 4092 - size, sval);
        BtreePage.setnItems(pg, ++nItems);
        BtreePage.setSize(pg, size);
        return size + 8 * (nItems + 1) < 2046 ? 2 : 0;
    }

    static int insertByteArrayKey(StorageImpl db, Page pg, int r, BtreeKey ins, int height) {
        int n;
        byte[] bval;
        int len;
        int nItems = BtreePage.getnItems(pg);
        int size = BtreePage.getSize(pg);
        if (size + (len = (bval = (byte[])ins.key.oval).length) + ((n = height != 0 ? nItems + 1 : nItems) + 1) * 8 > 4092) {
            int pageId = db.allocatePage();
            Page b = db.putPage(pageId);
            int moved = 0;
            int inserted = len + 8;
            int prevDelta = -2147483647;
            int bn = 0;
            int i = 0;
            while (true) {
                int subSize;
                int addSize;
                int j = nItems - i - 1;
                int keyLen = BtreePage.getKeyStrSize(pg, i);
                if (bn == r) {
                    keyLen = len;
                    inserted = 0;
                    addSize = len;
                    if (height == 0) {
                        subSize = 0;
                        ++j;
                    } else {
                        subSize = BtreePage.getKeyStrSize(pg, i);
                    }
                } else {
                    addSize = subSize = keyLen;
                    if (height != 0) {
                        if (i + 1 != r) {
                            subSize += BtreePage.getKeyStrSize(pg, i + 1);
                            --j;
                        } else {
                            inserted = 0;
                        }
                    }
                }
                int delta = moved + addSize + (bn + 1) * 8 - (j * 8 + size - subSize + inserted);
                if (delta >= -prevDelta) {
                    if (height == 0) {
                        ins.getByteArray(b, bn - 1);
                    } else {
                        Assert.that("String fits in the B-Tree page", moved + (bn + 1) * 8 <= 4092);
                        if (bn != r) {
                            ins.getByteArray(pg, i);
                            BtreePage.setKeyStrOid(b, bn, BtreePage.getKeyStrOid(pg, i));
                            size -= keyLen;
                            ++i;
                        } else {
                            BtreePage.setKeyStrOid(b, bn, ins.oid);
                        }
                    }
                    nItems = BtreePage.compactifyByteArrays(pg, i);
                    if (bn < r || bn == r && height == 0) {
                        BtreePage.memcpy(pg, r - i + 1, pg, r - i, n - r, 8);
                        ++nItems;
                        Assert.that("String fits in the B-Tree page", (size += len) + (n - i + 1) * 8 <= 4092);
                        BtreePage.setKeyStrOffs(pg, r - i, 4092 - size);
                        BtreePage.setKeyStrSize(pg, r - i, len);
                        BtreePage.setKeyStrOid(pg, r - i, ins.oid);
                        BtreePage.setKeyBytes(pg, 4092 - size, bval);
                    }
                    BtreePage.setnItems(b, bn);
                    BtreePage.setSize(b, moved);
                    BtreePage.setSize(pg, size);
                    BtreePage.setnItems(pg, nItems);
                    ins.oid = pageId;
                    db.pool.unfix(b);
                    return 1;
                }
                prevDelta = delta;
                Assert.that("String fits in the B-Tree page", (moved += keyLen) + (bn + 1) * 8 <= 4092);
                BtreePage.setKeyStrSize(b, bn, keyLen);
                BtreePage.setKeyStrOffs(b, bn, 4092 - moved);
                if (bn == r) {
                    BtreePage.setKeyStrOid(b, bn, ins.oid);
                    BtreePage.setKeyBytes(b, 4092 - moved, bval);
                } else {
                    BtreePage.setKeyStrOid(b, bn, BtreePage.getKeyStrOid(pg, i));
                    BtreePage.memcpy(b, 4092 - moved, pg, BtreePage.getKeyStrOffs(pg, i), keyLen, 1);
                    size -= keyLen;
                    ++i;
                }
                ++bn;
            }
        }
        BtreePage.memcpy(pg, r + 1, pg, r, n - r, 8);
        BtreePage.setKeyStrOffs(pg, r, 4092 - (size += len));
        BtreePage.setKeyStrSize(pg, r, len);
        BtreePage.setKeyStrOid(pg, r, ins.oid);
        BtreePage.setKeyBytes(pg, 4092 - size, bval);
        BtreePage.setnItems(pg, ++nItems);
        BtreePage.setSize(pg, size);
        return size + 8 * (nItems + 1) < 2046 ? 2 : 0;
    }

    static int compactifyStrings(Page pg, int m) {
        int offs;
        int len;
        int i;
        int n = BtreePage.getnItems(pg);
        int[] size = new int[2047];
        int[] index = new int[2047];
        if (m == 0) {
            return n;
        }
        int nZeroLengthStrings = 0;
        if (m < 0) {
            m = -m;
            for (i = 0; i < n - m; ++i) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i) >>> 1;
                    size[offs + len] = len;
                    index[offs + len] = i;
                    continue;
                }
                ++nZeroLengthStrings;
            }
            while (i < n) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i) >>> 1;
                    size[offs + len] = len;
                    index[offs + len] = -1;
                }
                ++i;
            }
        } else {
            for (i = 0; i < m; ++i) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len == 0) continue;
                offs = BtreePage.getKeyStrOffs(pg, i) >>> 1;
                size[offs + len] = len;
                index[offs + len] = -1;
            }
            while (i < n) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i) >>> 1;
                    size[offs + len] = len;
                    index[offs + len] = i - m;
                } else {
                    ++nZeroLengthStrings;
                }
                BtreePage.setKeyStrOid(pg, i - m, BtreePage.getKeyStrOid(pg, i));
                BtreePage.setKeyStrSize(pg, i - m, len);
                ++i;
            }
            BtreePage.setKeyStrOid(pg, i - m, BtreePage.getKeyStrOid(pg, i));
        }
        int nItems = n -= m;
        n -= nZeroLengthStrings;
        i = offs = 2046;
        while (n != 0) {
            len = size[i];
            int j = index[i];
            if (j >= 0) {
                --n;
                BtreePage.setKeyStrOffs(pg, j, (offs -= len) * 2);
                if (offs != i - len) {
                    BtreePage.memcpy(pg, offs, pg, i - len, len, 2);
                }
            }
            i -= len;
        }
        return nItems;
    }

    static int compactifyByteArrays(Page pg, int m) {
        int offs;
        int len;
        int i;
        int n = BtreePage.getnItems(pg);
        int[] size = new int[4093];
        int[] index = new int[4093];
        if (m == 0) {
            return n;
        }
        int nZeroLengthArrays = 0;
        if (m < 0) {
            m = -m;
            for (i = 0; i < n - m; ++i) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i);
                    size[offs + len] = len;
                    index[offs + len] = i;
                    continue;
                }
                ++nZeroLengthArrays;
            }
            while (i < n) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i);
                    size[offs + len] = len;
                    index[offs + len] = -1;
                }
                ++i;
            }
        } else {
            for (i = 0; i < m; ++i) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len == 0) continue;
                offs = BtreePage.getKeyStrOffs(pg, i);
                size[offs + len] = len;
                index[offs + len] = -1;
            }
            while (i < n) {
                len = BtreePage.getKeyStrSize(pg, i);
                if (len != 0) {
                    offs = BtreePage.getKeyStrOffs(pg, i);
                    size[offs + len] = len;
                    index[offs + len] = i - m;
                } else {
                    ++nZeroLengthArrays;
                }
                BtreePage.setKeyStrOid(pg, i - m, BtreePage.getKeyStrOid(pg, i));
                BtreePage.setKeyStrSize(pg, i - m, len);
                ++i;
            }
            BtreePage.setKeyStrOid(pg, i - m, BtreePage.getKeyStrOid(pg, i));
        }
        int nItems = n -= m;
        n -= nZeroLengthArrays;
        i = offs = 4092;
        while (n != 0) {
            len = size[i];
            int j = index[i];
            if (j >= 0) {
                --n;
                BtreePage.setKeyStrOffs(pg, j, offs -= len);
                if (offs != i - len) {
                    BtreePage.memcpy(pg, offs, pg, i - len, len, 1);
                }
            }
            i -= len;
        }
        return nItems;
    }

    static int removeStrKey(Page pg, int r) {
        int len = BtreePage.getKeyStrSize(pg, r) * 2;
        int offs = BtreePage.getKeyStrOffs(pg, r);
        int size = BtreePage.getSize(pg);
        int nItems = BtreePage.getnItems(pg);
        if ((nItems + 1) * 8 >= 4092) {
            BtreePage.memcpy(pg, r, pg, r + 1, nItems - r - 1, 8);
        } else {
            BtreePage.memcpy(pg, r, pg, r + 1, nItems - r, 8);
        }
        if (len != 0) {
            BtreePage.memcpy(pg, 4092 - size + len, pg, 4092 - size, size - 4092 + offs, 1);
            int i = nItems;
            while (--i >= 0) {
                if (BtreePage.getKeyStrOffs(pg, i) >= offs) continue;
                BtreePage.setKeyStrOffs(pg, i, BtreePage.getKeyStrOffs(pg, i) + len);
            }
            BtreePage.setSize(pg, size -= len);
        }
        BtreePage.setnItems(pg, nItems - 1);
        return size + 8 * nItems < 2046 ? 2 : 0;
    }

    static int removeByteArrayKey(Page pg, int r) {
        int len = BtreePage.getKeyStrSize(pg, r);
        int offs = BtreePage.getKeyStrOffs(pg, r);
        int size = BtreePage.getSize(pg);
        int nItems = BtreePage.getnItems(pg);
        if ((nItems + 1) * 8 >= 4092) {
            BtreePage.memcpy(pg, r, pg, r + 1, nItems - r - 1, 8);
        } else {
            BtreePage.memcpy(pg, r, pg, r + 1, nItems - r, 8);
        }
        if (len != 0) {
            BtreePage.memcpy(pg, 4092 - size + len, pg, 4092 - size, size - 4092 + offs, 1);
            int i = nItems;
            while (--i >= 0) {
                if (BtreePage.getKeyStrOffs(pg, i) >= offs) continue;
                BtreePage.setKeyStrOffs(pg, i, BtreePage.getKeyStrOffs(pg, i) + len);
            }
            BtreePage.setSize(pg, size -= len);
        }
        BtreePage.setnItems(pg, nItems - 1);
        return size + 8 * nItems < 2046 ? 2 : 0;
    }

    static int replaceStrKey(StorageImpl db, Page pg, int r, BtreeKey ins, int height) {
        ins.oid = BtreePage.getKeyStrOid(pg, r);
        BtreePage.removeStrKey(pg, r);
        return BtreePage.insertStrKey(db, pg, r, ins, height);
    }

    static int replaceByteArrayKey(StorageImpl db, Page pg, int r, BtreeKey ins, int height) {
        ins.oid = BtreePage.getKeyStrOid(pg, r);
        BtreePage.removeByteArrayKey(pg, r);
        return BtreePage.insertByteArrayKey(db, pg, r, ins, height);
    }

    static int handlePageUnderflow(StorageImpl db, Page pg, int r, int type, BtreeKey rem, int height) {
        int merged_size;
        int nItems = BtreePage.getnItems(pg);
        if (type == 8) {
            Page a = db.putPage(BtreePage.getKeyStrOid(pg, r));
            int an = BtreePage.getnItems(a);
            if (r < nItems) {
                Page b = db.getPage(BtreePage.getKeyStrOid(pg, r + 1));
                int bn = BtreePage.getnItems(b);
                int merged_size2 = (an + bn) * 8 + BtreePage.getSize(a) + BtreePage.getSize(b);
                if (height != 1) {
                    merged_size2 += BtreePage.getKeyStrSize(pg, r) * 2 + 16;
                }
                if (merged_size2 > 4092) {
                    int subSize;
                    int addSize;
                    db.pool.unfix(b);
                    b = db.putPage(BtreePage.getKeyStrOid(pg, r + 1));
                    int size_a = BtreePage.getSize(a);
                    int size_b = BtreePage.getSize(b);
                    if (height != 1) {
                        addSize = BtreePage.getKeyStrSize(pg, r);
                        subSize = BtreePage.getKeyStrSize(b, 0);
                    } else {
                        addSize = subSize = BtreePage.getKeyStrSize(b, 0);
                    }
                    int i = 0;
                    int prevDelta = an * 8 + size_a - (bn * 8 + size_b);
                    while (true) {
                        int delta;
                        if ((delta = (an + ++i) * 8 + size_a + addSize * 2 - ((bn - i) * 8 + size_b - subSize * 2)) >= 0) {
                            if (delta < -prevDelta) break;
                            --i;
                            break;
                        }
                        size_a += addSize * 2;
                        size_b -= subSize * 2;
                        prevDelta = delta;
                        if (height != 1) {
                            addSize = subSize;
                            subSize = BtreePage.getKeyStrSize(b, i);
                            continue;
                        }
                        addSize = subSize = BtreePage.getKeyStrSize(b, i);
                    }
                    int result = 0;
                    if (i > 0) {
                        int len;
                        int k = i;
                        if (height != 1) {
                            len = BtreePage.getKeyStrSize(pg, r);
                            BtreePage.setSize(a, BtreePage.getSize(a) + len * 2);
                            BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                            BtreePage.setKeyStrSize(a, an, len);
                            BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), pg, BtreePage.getKeyStrOffs(pg, r), len * 2, 1);
                            BtreePage.setKeyStrOid(a, ++an + --k, BtreePage.getKeyStrOid(b, k));
                            BtreePage.setSize(b, BtreePage.getSize(b) - BtreePage.getKeyStrSize(b, k) * 2);
                        }
                        for (int j = 0; j < k; ++j) {
                            len = BtreePage.getKeyStrSize(b, j);
                            BtreePage.setSize(a, BtreePage.getSize(a) + len * 2);
                            BtreePage.setSize(b, BtreePage.getSize(b) - len * 2);
                            BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                            BtreePage.setKeyStrSize(a, an, len);
                            BtreePage.setKeyStrOid(a, an, BtreePage.getKeyStrOid(b, j));
                            BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), b, BtreePage.getKeyStrOffs(b, j), len * 2, 1);
                            ++an;
                        }
                        rem.getStr(b, i - 1);
                        result = BtreePage.replaceStrKey(db, pg, r, rem, height);
                        BtreePage.setnItems(a, an);
                        BtreePage.setnItems(b, BtreePage.compactifyStrings(b, i));
                    }
                    db.pool.unfix(a);
                    db.pool.unfix(b);
                    return result;
                }
                if (height != 1) {
                    int r_len = BtreePage.getKeyStrSize(pg, r);
                    BtreePage.setKeyStrSize(a, an, r_len);
                    BtreePage.setSize(a, BtreePage.getSize(a) + r_len * 2);
                    BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                    BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), pg, BtreePage.getKeyStrOffs(pg, r), r_len * 2, 1);
                    BtreePage.setKeyStrOid(a, ++an + bn, BtreePage.getKeyStrOid(b, bn));
                }
                int i = 0;
                while (i < bn) {
                    BtreePage.setKeyStrSize(a, an, BtreePage.getKeyStrSize(b, i));
                    BtreePage.setKeyStrOffs(a, an, BtreePage.getKeyStrOffs(b, i) - BtreePage.getSize(a));
                    BtreePage.setKeyStrOid(a, an, BtreePage.getKeyStrOid(b, i));
                    ++i;
                    ++an;
                }
                BtreePage.setSize(a, BtreePage.getSize(a) + BtreePage.getSize(b));
                BtreePage.setnItems(a, an);
                BtreePage.memcpy(a, 4092 - BtreePage.getSize(a), b, 4092 - BtreePage.getSize(b), BtreePage.getSize(b), 1);
                db.pool.unfix(a);
                db.pool.unfix(b);
                db.freePage(BtreePage.getKeyStrOid(pg, r + 1));
                BtreePage.setKeyStrOid(pg, r + 1, BtreePage.getKeyStrOid(pg, r));
                return BtreePage.removeStrKey(pg, r);
            }
            Page b = db.getPage(BtreePage.getKeyStrOid(pg, r - 1));
            int bn = BtreePage.getnItems(b);
            int merged_size3 = (an + bn) * 8 + BtreePage.getSize(a) + BtreePage.getSize(b);
            if (height != 1) {
                merged_size3 += BtreePage.getKeyStrSize(pg, r - 1) * 2 + 16;
            }
            if (merged_size3 > 4092) {
                int subSize;
                int addSize;
                db.pool.unfix(b);
                b = db.putPage(BtreePage.getKeyStrOid(pg, r - 1));
                int size_a = BtreePage.getSize(a);
                int size_b = BtreePage.getSize(b);
                if (height != 1) {
                    addSize = BtreePage.getKeyStrSize(pg, r - 1);
                    subSize = BtreePage.getKeyStrSize(b, bn - 1);
                } else {
                    addSize = subSize = BtreePage.getKeyStrSize(b, bn - 1);
                }
                int i = 0;
                int prevDelta = an * 8 + size_a - (bn * 8 + size_b);
                while (true) {
                    int delta;
                    if ((delta = (an + ++i) * 8 + size_a + addSize * 2 - ((bn - i) * 8 + size_b - subSize * 2)) >= 0) {
                        if (delta < -prevDelta) break;
                        --i;
                        break;
                    }
                    prevDelta = delta;
                    size_a += addSize * 2;
                    size_b -= subSize * 2;
                    if (height != 1) {
                        addSize = subSize;
                        subSize = BtreePage.getKeyStrSize(b, bn - i - 1);
                        continue;
                    }
                    addSize = subSize = BtreePage.getKeyStrSize(b, bn - i - 1);
                }
                int result = 0;
                if (i > 0) {
                    int len;
                    int k = i;
                    Assert.that(i < bn);
                    if (height != 1) {
                        BtreePage.setSize(b, BtreePage.getSize(b) - BtreePage.getKeyStrSize(b, bn - k) * 2);
                        BtreePage.memcpy(a, i, a, 0, an + 1, 8);
                        BtreePage.setKeyStrOid(a, --k, BtreePage.getKeyStrOid(b, bn));
                        len = BtreePage.getKeyStrSize(pg, r - 1);
                        BtreePage.setKeyStrSize(a, k, len);
                        BtreePage.setSize(a, BtreePage.getSize(a) + len * 2);
                        BtreePage.setKeyStrOffs(a, k, 4092 - BtreePage.getSize(a));
                        BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, k), pg, BtreePage.getKeyStrOffs(pg, r - 1), len * 2, 1);
                    } else {
                        BtreePage.memcpy(a, i, a, 0, an, 8);
                    }
                    for (int j = 0; j < k; ++j) {
                        len = BtreePage.getKeyStrSize(b, bn - k + j);
                        BtreePage.setSize(a, BtreePage.getSize(a) + len * 2);
                        BtreePage.setSize(b, BtreePage.getSize(b) - len * 2);
                        BtreePage.setKeyStrOffs(a, j, 4092 - BtreePage.getSize(a));
                        BtreePage.setKeyStrSize(a, j, len);
                        BtreePage.setKeyStrOid(a, j, BtreePage.getKeyStrOid(b, bn - k + j));
                        BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, j), b, BtreePage.getKeyStrOffs(b, bn - k + j), len * 2, 1);
                    }
                    BtreePage.setnItems(a, an += i);
                    rem.getStr(b, bn - k - 1);
                    result = BtreePage.replaceStrKey(db, pg, r - 1, rem, height);
                    BtreePage.setnItems(b, BtreePage.compactifyStrings(b, -i));
                }
                db.pool.unfix(a);
                db.pool.unfix(b);
                return result;
            }
            if (height != 1) {
                BtreePage.memcpy(a, bn + 1, a, 0, an + 1, 8);
                int len = BtreePage.getKeyStrSize(pg, r - 1);
                BtreePage.setKeyStrSize(a, bn, len);
                BtreePage.setSize(a, BtreePage.getSize(a) + len * 2);
                BtreePage.setKeyStrOffs(a, bn, 4092 - BtreePage.getSize(a));
                BtreePage.setKeyStrOid(a, bn, BtreePage.getKeyStrOid(b, bn));
                BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, bn), pg, BtreePage.getKeyStrOffs(pg, r - 1), len * 2, 1);
                ++an;
            } else {
                BtreePage.memcpy(a, bn, a, 0, an, 8);
            }
            for (int i = 0; i < bn; ++i) {
                BtreePage.setKeyStrOid(a, i, BtreePage.getKeyStrOid(b, i));
                BtreePage.setKeyStrSize(a, i, BtreePage.getKeyStrSize(b, i));
                BtreePage.setKeyStrOffs(a, i, BtreePage.getKeyStrOffs(b, i) - BtreePage.getSize(a));
            }
            BtreePage.setnItems(a, an += bn);
            BtreePage.setSize(a, BtreePage.getSize(a) + BtreePage.getSize(b));
            BtreePage.memcpy(a, 4092 - BtreePage.getSize(a), b, 4092 - BtreePage.getSize(b), BtreePage.getSize(b), 1);
            db.pool.unfix(a);
            db.pool.unfix(b);
            db.freePage(BtreePage.getKeyStrOid(pg, r - 1));
            return BtreePage.removeStrKey(pg, r - 1);
        }
        if (type == 21) {
            Page a = db.putPage(BtreePage.getKeyStrOid(pg, r));
            int an = BtreePage.getnItems(a);
            if (r < nItems) {
                Page b = db.getPage(BtreePage.getKeyStrOid(pg, r + 1));
                int bn = BtreePage.getnItems(b);
                int merged_size4 = (an + bn) * 8 + BtreePage.getSize(a) + BtreePage.getSize(b);
                if (height != 1) {
                    merged_size4 += BtreePage.getKeyStrSize(pg, r) + 16;
                }
                if (merged_size4 > 4092) {
                    int subSize;
                    int addSize;
                    db.pool.unfix(b);
                    b = db.putPage(BtreePage.getKeyStrOid(pg, r + 1));
                    int size_a = BtreePage.getSize(a);
                    int size_b = BtreePage.getSize(b);
                    if (height != 1) {
                        addSize = BtreePage.getKeyStrSize(pg, r);
                        subSize = BtreePage.getKeyStrSize(b, 0);
                    } else {
                        addSize = subSize = BtreePage.getKeyStrSize(b, 0);
                    }
                    int i = 0;
                    int prevDelta = an * 8 + size_a - (bn * 8 + size_b);
                    while (true) {
                        int delta;
                        if ((delta = (an + ++i) * 8 + size_a + addSize - ((bn - i) * 8 + size_b - subSize)) >= 0) {
                            if (delta < -prevDelta) break;
                            --i;
                            break;
                        }
                        size_a += addSize;
                        size_b -= subSize;
                        prevDelta = delta;
                        if (height != 1) {
                            addSize = subSize;
                            subSize = BtreePage.getKeyStrSize(b, i);
                            continue;
                        }
                        addSize = subSize = BtreePage.getKeyStrSize(b, i);
                    }
                    int result = 0;
                    if (i > 0) {
                        int len;
                        int k = i;
                        if (height != 1) {
                            len = BtreePage.getKeyStrSize(pg, r);
                            BtreePage.setSize(a, BtreePage.getSize(a) + len);
                            BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                            BtreePage.setKeyStrSize(a, an, len);
                            BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), pg, BtreePage.getKeyStrOffs(pg, r), len, 1);
                            BtreePage.setKeyStrOid(a, ++an + --k, BtreePage.getKeyStrOid(b, k));
                            BtreePage.setSize(b, BtreePage.getSize(b) - BtreePage.getKeyStrSize(b, k));
                        }
                        for (int j = 0; j < k; ++j) {
                            len = BtreePage.getKeyStrSize(b, j);
                            BtreePage.setSize(a, BtreePage.getSize(a) + len);
                            BtreePage.setSize(b, BtreePage.getSize(b) - len);
                            BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                            BtreePage.setKeyStrSize(a, an, len);
                            BtreePage.setKeyStrOid(a, an, BtreePage.getKeyStrOid(b, j));
                            BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), b, BtreePage.getKeyStrOffs(b, j), len, 1);
                            ++an;
                        }
                        rem.getByteArray(b, i - 1);
                        result = BtreePage.replaceByteArrayKey(db, pg, r, rem, height);
                        BtreePage.setnItems(a, an);
                        BtreePage.setnItems(b, BtreePage.compactifyByteArrays(b, i));
                    }
                    db.pool.unfix(a);
                    db.pool.unfix(b);
                    return result;
                }
                if (height != 1) {
                    int r_len = BtreePage.getKeyStrSize(pg, r);
                    BtreePage.setKeyStrSize(a, an, r_len);
                    BtreePage.setSize(a, BtreePage.getSize(a) + r_len);
                    BtreePage.setKeyStrOffs(a, an, 4092 - BtreePage.getSize(a));
                    BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, an), pg, BtreePage.getKeyStrOffs(pg, r), r_len, 1);
                    BtreePage.setKeyStrOid(a, ++an + bn, BtreePage.getKeyStrOid(b, bn));
                }
                int i = 0;
                while (i < bn) {
                    BtreePage.setKeyStrSize(a, an, BtreePage.getKeyStrSize(b, i));
                    BtreePage.setKeyStrOffs(a, an, BtreePage.getKeyStrOffs(b, i) - BtreePage.getSize(a));
                    BtreePage.setKeyStrOid(a, an, BtreePage.getKeyStrOid(b, i));
                    ++i;
                    ++an;
                }
                BtreePage.setSize(a, BtreePage.getSize(a) + BtreePage.getSize(b));
                BtreePage.setnItems(a, an);
                BtreePage.memcpy(a, 4092 - BtreePage.getSize(a), b, 4092 - BtreePage.getSize(b), BtreePage.getSize(b), 1);
                db.pool.unfix(a);
                db.pool.unfix(b);
                db.freePage(BtreePage.getKeyStrOid(pg, r + 1));
                BtreePage.setKeyStrOid(pg, r + 1, BtreePage.getKeyStrOid(pg, r));
                return BtreePage.removeByteArrayKey(pg, r);
            }
            Page b = db.getPage(BtreePage.getKeyStrOid(pg, r - 1));
            int bn = BtreePage.getnItems(b);
            int merged_size5 = (an + bn) * 8 + BtreePage.getSize(a) + BtreePage.getSize(b);
            if (height != 1) {
                merged_size5 += BtreePage.getKeyStrSize(pg, r - 1) + 16;
            }
            if (merged_size5 > 4092) {
                int subSize;
                int addSize;
                db.pool.unfix(b);
                b = db.putPage(BtreePage.getKeyStrOid(pg, r - 1));
                int size_a = BtreePage.getSize(a);
                int size_b = BtreePage.getSize(b);
                if (height != 1) {
                    addSize = BtreePage.getKeyStrSize(pg, r - 1);
                    subSize = BtreePage.getKeyStrSize(b, bn - 1);
                } else {
                    addSize = subSize = BtreePage.getKeyStrSize(b, bn - 1);
                }
                int i = 0;
                int prevDelta = an * 8 + size_a - (bn * 8 + size_b);
                while (true) {
                    int delta;
                    if ((delta = (an + ++i) * 8 + size_a + addSize - ((bn - i) * 8 + size_b - subSize)) >= 0) {
                        if (delta < -prevDelta) break;
                        --i;
                        break;
                    }
                    prevDelta = delta;
                    size_a += addSize;
                    size_b -= subSize;
                    if (height != 1) {
                        addSize = subSize;
                        subSize = BtreePage.getKeyStrSize(b, bn - i - 1);
                        continue;
                    }
                    addSize = subSize = BtreePage.getKeyStrSize(b, bn - i - 1);
                }
                int result = 0;
                if (i > 0) {
                    int len;
                    int k = i;
                    Assert.that(i < bn);
                    if (height != 1) {
                        BtreePage.setSize(b, BtreePage.getSize(b) - BtreePage.getKeyStrSize(b, bn - k));
                        BtreePage.memcpy(a, i, a, 0, an + 1, 8);
                        BtreePage.setKeyStrOid(a, --k, BtreePage.getKeyStrOid(b, bn));
                        len = BtreePage.getKeyStrSize(pg, r - 1);
                        BtreePage.setKeyStrSize(a, k, len);
                        BtreePage.setSize(a, BtreePage.getSize(a) + len);
                        BtreePage.setKeyStrOffs(a, k, 4092 - BtreePage.getSize(a));
                        BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, k), pg, BtreePage.getKeyStrOffs(pg, r - 1), len, 1);
                    } else {
                        BtreePage.memcpy(a, i, a, 0, an, 8);
                    }
                    for (int j = 0; j < k; ++j) {
                        len = BtreePage.getKeyStrSize(b, bn - k + j);
                        BtreePage.setSize(a, BtreePage.getSize(a) + len);
                        BtreePage.setSize(b, BtreePage.getSize(b) - len);
                        BtreePage.setKeyStrOffs(a, j, 4092 - BtreePage.getSize(a));
                        BtreePage.setKeyStrSize(a, j, len);
                        BtreePage.setKeyStrOid(a, j, BtreePage.getKeyStrOid(b, bn - k + j));
                        BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, j), b, BtreePage.getKeyStrOffs(b, bn - k + j), len, 1);
                    }
                    BtreePage.setnItems(a, an += i);
                    rem.getByteArray(b, bn - k - 1);
                    result = BtreePage.replaceByteArrayKey(db, pg, r - 1, rem, height);
                    BtreePage.setnItems(b, BtreePage.compactifyByteArrays(b, -i));
                }
                db.pool.unfix(a);
                db.pool.unfix(b);
                return result;
            }
            if (height != 1) {
                BtreePage.memcpy(a, bn + 1, a, 0, an + 1, 8);
                int len = BtreePage.getKeyStrSize(pg, r - 1);
                BtreePage.setKeyStrSize(a, bn, len);
                BtreePage.setSize(a, BtreePage.getSize(a) + len);
                BtreePage.setKeyStrOffs(a, bn, 4092 - BtreePage.getSize(a));
                BtreePage.setKeyStrOid(a, bn, BtreePage.getKeyStrOid(b, bn));
                BtreePage.memcpy(a, BtreePage.getKeyStrOffs(a, bn), pg, BtreePage.getKeyStrOffs(pg, r - 1), len, 1);
                ++an;
            } else {
                BtreePage.memcpy(a, bn, a, 0, an, 8);
            }
            for (int i = 0; i < bn; ++i) {
                BtreePage.setKeyStrOid(a, i, BtreePage.getKeyStrOid(b, i));
                BtreePage.setKeyStrSize(a, i, BtreePage.getKeyStrSize(b, i));
                BtreePage.setKeyStrOffs(a, i, BtreePage.getKeyStrOffs(b, i) - BtreePage.getSize(a));
            }
            BtreePage.setnItems(a, an += bn);
            BtreePage.setSize(a, BtreePage.getSize(a) + BtreePage.getSize(b));
            BtreePage.memcpy(a, 4092 - BtreePage.getSize(a), b, 4092 - BtreePage.getSize(b), BtreePage.getSize(b), 1);
            db.pool.unfix(a);
            db.pool.unfix(b);
            db.freePage(BtreePage.getKeyStrOid(pg, r - 1));
            return BtreePage.removeByteArrayKey(pg, r - 1);
        }
        Page a = db.putPage(BtreePage.getReference(pg, 1023 - r - 1));
        int an = BtreePage.getnItems(a);
        int itemSize = ClassDescriptor.sizeof[type];
        if (r < nItems) {
            int merged_size6;
            Page b = db.getPage(BtreePage.getReference(pg, 1023 - r - 2));
            int bn = BtreePage.getnItems(b);
            Assert.that(bn >= an);
            if (height != 1) {
                BtreePage.memcpy(a, an, pg, r, 1, itemSize);
                ++an;
                ++bn;
            }
            if ((merged_size6 = (an + bn) * (4 + itemSize)) > 4092) {
                int i = bn - (an + bn >> 1);
                db.pool.unfix(b);
                b = db.putPage(BtreePage.getReference(pg, 1023 - r - 2));
                BtreePage.memcpy(a, an, b, 0, i, itemSize);
                BtreePage.memcpy(b, 0, b, i, bn - i, itemSize);
                BtreePage.memcpy(a, 1023 - an - i, b, 1023 - i, i, 4);
                BtreePage.memcpy(b, 1023 - bn + i, b, 1023 - bn, bn - i, 4);
                BtreePage.memcpy(pg, r, a, an + i - 1, 1, itemSize);
                BtreePage.setnItems(b, BtreePage.getnItems(b) - i);
                BtreePage.setnItems(a, BtreePage.getnItems(a) + i);
                db.pool.unfix(a);
                db.pool.unfix(b);
                return 0;
            }
            BtreePage.memcpy(a, an, b, 0, bn, itemSize);
            BtreePage.memcpy(a, 1023 - an - bn, b, 1023 - bn, bn, 4);
            db.freePage(BtreePage.getReference(pg, 1023 - r - 2));
            BtreePage.memcpy(pg, 1023 - nItems, pg, 1023 - nItems - 1, nItems - r - 1, 4);
            BtreePage.memcpy(pg, r, pg, r + 1, nItems - r - 1, itemSize);
            BtreePage.setnItems(a, BtreePage.getnItems(a) + bn);
            BtreePage.setnItems(pg, nItems - 1);
            db.pool.unfix(a);
            db.pool.unfix(b);
            return nItems * (itemSize + 4) < 2046 ? 2 : 0;
        }
        Page b = db.getPage(BtreePage.getReference(pg, 1023 - r));
        int bn = BtreePage.getnItems(b);
        Assert.that(bn >= an);
        if (height != 1) {
            ++an;
            ++bn;
        }
        if ((merged_size = (an + bn) * (4 + itemSize)) > 4092) {
            int i = bn - (an + bn >> 1);
            db.pool.unfix(b);
            b = db.putPage(BtreePage.getReference(pg, 1023 - r));
            BtreePage.memcpy(a, i, a, 0, an, itemSize);
            BtreePage.memcpy(a, 0, b, bn - i, i, itemSize);
            BtreePage.memcpy(a, 1023 - an - i, a, 1023 - an, an, 4);
            BtreePage.memcpy(a, 1023 - i, b, 1023 - bn, i, 4);
            if (height != 1) {
                BtreePage.memcpy(a, i - 1, pg, r - 1, 1, itemSize);
            }
            BtreePage.memcpy(pg, r - 1, b, bn - i - 1, 1, itemSize);
            BtreePage.setnItems(b, BtreePage.getnItems(b) - i);
            BtreePage.setnItems(a, BtreePage.getnItems(a) + i);
            db.pool.unfix(a);
            db.pool.unfix(b);
            return 0;
        }
        BtreePage.memcpy(a, bn, a, 0, an, itemSize);
        BtreePage.memcpy(a, 0, b, 0, bn, itemSize);
        BtreePage.memcpy(a, 1023 - an - bn, a, 1023 - an, an, 4);
        BtreePage.memcpy(a, 1023 - bn, b, 1023 - bn, bn, 4);
        if (height != 1) {
            BtreePage.memcpy(a, bn - 1, pg, r - 1, 1, itemSize);
        }
        db.freePage(BtreePage.getReference(pg, 1023 - r));
        BtreePage.setReference(pg, 1023 - r, BtreePage.getReference(pg, 1023 - r - 1));
        BtreePage.setnItems(a, BtreePage.getnItems(a) + bn);
        BtreePage.setnItems(pg, nItems - 1);
        db.pool.unfix(a);
        db.pool.unfix(b);
        return nItems * (itemSize + 4) < 2046 ? 2 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int remove(StorageImpl db, int pageId, Btree tree, BtreeKey rem, int height) {
        Page pg = db.getPage(pageId);
        try {
            int oid2;
            int n = BtreePage.getnItems(pg);
            int l = 0;
            int r = n;
            if (tree.type == 8) {
                while (l < r) {
                    int i = l + r >> 1;
                    if (BtreePage.compareStr(rem.key, pg, i) > 0) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                if (--height != 0) {
                    do {
                        switch (BtreePage.remove(db, BtreePage.getKeyStrOid(pg, r), tree, rem, height)) {
                            case 2: {
                                db.pool.unfix(pg);
                                pg = null;
                                pg = db.putPage(pageId);
                                int n2 = BtreePage.handlePageUnderflow(db, pg, r, tree.type, rem, height);
                                return n2;
                            }
                            case 0: {
                                int n3 = 0;
                                return n3;
                            }
                            case 1: {
                                db.pool.unfix(pg);
                                pg = null;
                                pg = db.putPage(pageId);
                                int n4 = BtreePage.insertStrKey(db, pg, r, rem, height);
                                return n4;
                            }
                        }
                    } while (++r <= n);
                } else {
                    while (r < n && BtreePage.compareStr(rem.key, pg, r) == 0) {
                        oid2 = BtreePage.getKeyStrOid(pg, r);
                        if (oid2 == rem.oid || rem.oid == 0) {
                            rem.oldOid = oid2;
                            db.pool.unfix(pg);
                            pg = null;
                            pg = db.putPage(pageId);
                            int n5 = BtreePage.removeStrKey(pg, r);
                            return n5;
                        }
                        ++r;
                    }
                }
            } else if (tree.type == 21) {
                while (l < r) {
                    int i = l + r >> 1;
                    if (tree.compareByteArrays(rem.key, pg, i) > 0) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                if (--height != 0) {
                    do {
                        switch (BtreePage.remove(db, BtreePage.getKeyStrOid(pg, r), tree, rem, height)) {
                            case 2: {
                                db.pool.unfix(pg);
                                pg = null;
                                pg = db.putPage(pageId);
                                int oid2 = BtreePage.handlePageUnderflow(db, pg, r, tree.type, rem, height);
                                return oid2;
                            }
                            case 0: {
                                int oid2 = 0;
                                return oid2;
                            }
                            case 1: {
                                db.pool.unfix(pg);
                                pg = null;
                                pg = db.putPage(pageId);
                                int oid2 = BtreePage.insertByteArrayKey(db, pg, r, rem, height);
                                return oid2;
                            }
                        }
                    } while (++r <= n);
                } else {
                    while (r < n && tree.compareByteArrays(rem.key, pg, r) == 0) {
                        oid2 = BtreePage.getKeyStrOid(pg, r);
                        if (oid2 == rem.oid || rem.oid == 0) {
                            rem.oldOid = oid2;
                            db.pool.unfix(pg);
                            pg = null;
                            pg = db.putPage(pageId);
                            int n6 = BtreePage.removeByteArrayKey(pg, r);
                            return n6;
                        }
                        ++r;
                    }
                }
            } else {
                int itemSize = ClassDescriptor.sizeof[tree.type];
                while (l < r) {
                    int i = l + r >> 1;
                    if (BtreePage.compare(rem.key, pg, i) > 0) {
                        l = i + 1;
                        continue;
                    }
                    r = i;
                }
                if (--height == 0) {
                    int oid3 = rem.oid;
                    while (r < n && BtreePage.compare(rem.key, pg, r) == 0) {
                        if (BtreePage.getReference(pg, 1023 - r - 1) == oid3 || oid3 == 0) {
                            rem.oldOid = BtreePage.getReference(pg, 1023 - r - 1);
                            db.pool.unfix(pg);
                            pg = null;
                            pg = db.putPage(pageId);
                            BtreePage.memcpy(pg, r, pg, r + 1, n - r - 1, itemSize);
                            BtreePage.memcpy(pg, 1023 - n + 1, pg, 1023 - n, n - r - 1, 4);
                            BtreePage.setnItems(pg, --n);
                            int n7 = n * (itemSize + 4) < 2046 ? 2 : 0;
                            return n7;
                        }
                        ++r;
                    }
                    int n8 = 3;
                    return n8;
                }
                do {
                    switch (BtreePage.remove(db, BtreePage.getReference(pg, 1023 - r - 1), tree, rem, height)) {
                        case 2: {
                            db.pool.unfix(pg);
                            pg = null;
                            pg = db.putPage(pageId);
                            int n9 = BtreePage.handlePageUnderflow(db, pg, r, tree.type, rem, height);
                            return n9;
                        }
                        case 0: {
                            int n10 = 0;
                            return n10;
                        }
                    }
                } while (++r <= n);
            }
            int n11 = 3;
            return n11;
        }
        finally {
            if (pg != null) {
                db.pool.unfix(pg);
            }
        }
    }

    static void purge(StorageImpl db, int pageId, int type, int height) {
        if (--height != 0) {
            Page pg = db.getPage(pageId);
            int n = BtreePage.getnItems(pg) + 1;
            if (type == 8 || type == 21) {
                while (--n >= 0) {
                    BtreePage.purge(db, BtreePage.getKeyStrOid(pg, n), type, height);
                }
            } else {
                while (--n >= 0) {
                    BtreePage.purge(db, BtreePage.getReference(pg, 1023 - n - 1), type, height);
                }
            }
            db.pool.unfix(pg);
        }
        db.freePage(pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int traverseForward(StorageImpl db, int pageId, int type, int height, IPersistent[] result, int pos) {
        Page pg = db.getPage(pageId);
        try {
            int n = BtreePage.getnItems(pg);
            if (--height != 0) {
                if (type == 8 || type == 21) {
                    for (int i = 0; i <= n; ++i) {
                        pos = BtreePage.traverseForward(db, BtreePage.getKeyStrOid(pg, i), type, height, result, pos);
                    }
                } else {
                    for (int i = 0; i <= n; ++i) {
                        pos = BtreePage.traverseForward(db, BtreePage.getReference(pg, 1023 - i - 1), type, height, result, pos);
                    }
                }
            } else if (type == 8 || type == 21) {
                for (int i = 0; i < n; ++i) {
                    int oid = BtreePage.getKeyStrOid(pg, i);
                    result[pos++] = db.lookupObject(oid, null);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int oid = BtreePage.getReference(pg, 1022 - i);
                    result[pos++] = db.lookupObject(oid, null);
                }
            }
            int n2 = pos;
            return n2;
        }
        finally {
            db.pool.unfix(pg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int markPage(StorageImpl db, int pageId, int type, int height) {
        int nPages = 1;
        Page pg = db.getGCPage(pageId);
        try {
            int n = BtreePage.getnItems(pg);
            if (--height != 0) {
                if (type == 8 || type == 21) {
                    for (int i = 0; i <= n; ++i) {
                        nPages += BtreePage.markPage(db, BtreePage.getKeyStrOid(pg, i), type, height);
                    }
                } else {
                    for (int i = 0; i <= n; ++i) {
                        nPages += BtreePage.markPage(db, BtreePage.getReference(pg, 1023 - i - 1), type, height);
                    }
                }
            } else if (type == 8 || type == 21) {
                for (int i = 0; i < n; ++i) {
                    db.markOid(BtreePage.getKeyStrOid(pg, i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    db.markOid(BtreePage.getReference(pg, 1022 - i));
                }
            }
        }
        finally {
            db.pool.unfix(pg);
        }
        return nPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exportPage(StorageImpl db, XMLExporter exporter, int pageId, int type, int height) throws IOException {
        Page pg = db.getPage(pageId);
        try {
            int n = BtreePage.getnItems(pg);
            if (--height != 0) {
                if (type == 8 || type == 21) {
                    for (int i = 0; i <= n; ++i) {
                        BtreePage.exportPage(db, exporter, BtreePage.getKeyStrOid(pg, i), type, height);
                    }
                } else {
                    for (int i = 0; i <= n; ++i) {
                        BtreePage.exportPage(db, exporter, BtreePage.getReference(pg, 1023 - i - 1), type, height);
                    }
                }
            } else if (type == 8 || type == 21) {
                for (int i = 0; i < n; ++i) {
                    exporter.exportAssoc(BtreePage.getKeyStrOid(pg, i), pg.data, 4 + BtreePage.getKeyStrOffs(pg, i), BtreePage.getKeyStrSize(pg, i), type);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    exporter.exportAssoc(BtreePage.getReference(pg, 1022 - i), pg.data, 4 + i * ClassDescriptor.sizeof[type], ClassDescriptor.sizeof[type], type);
                }
            }
        }
        finally {
            db.pool.unfix(pg);
        }
    }
}

