/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.IResource;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;

public class PersistentResource
extends Persistent
implements IResource {
    private transient Thread owner;
    private transient int nReaders;
    private transient int nWriters;

    public synchronized void sharedLock() {
        Thread currThread = Thread.currentThread();
        try {
            while (true) {
                if (this.owner == currThread) {
                    ++this.nWriters;
                    break;
                }
                if (this.nWriters == 0) {
                    if (this.storage == null || this.storage.lockObject(this)) {
                        ++this.nReaders;
                    }
                    break;
                }
                this.wait();
            }
        }
        catch (InterruptedException x) {
            throw new StorageError(21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sharedLock(long timeout) {
        Thread currThread = Thread.currentThread();
        long startTime = System.currentTimeMillis();
        PersistentResource persistentResource = this;
        synchronized (persistentResource) {
            try {
                while (true) {
                    if (this.owner == currThread) {
                        ++this.nWriters;
                        return true;
                    }
                    if (this.nWriters == 0) {
                        if (this.storage == null || this.storage.lockObject(this)) {
                            ++this.nReaders;
                        }
                        return true;
                    }
                    long currTime = System.currentTimeMillis();
                    if (currTime < startTime) {
                        currTime = startTime;
                    }
                    if (startTime + timeout <= currTime) {
                        return false;
                    }
                    this.wait(startTime + timeout - currTime);
                }
            }
            catch (InterruptedException x) {
                return false;
            }
        }
    }

    public synchronized void exclusiveLock() {
        Thread currThread = Thread.currentThread();
        try {
            while (true) {
                if (this.owner == currThread) {
                    ++this.nWriters;
                    break;
                }
                if (this.nReaders == 0 && this.nWriters == 0) {
                    this.nWriters = 1;
                    this.owner = currThread;
                    if (this.storage != null) {
                        this.storage.lockObject(this);
                    }
                    break;
                }
                this.wait();
            }
        }
        catch (InterruptedException x) {
            throw new StorageError(21);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exclusiveLock(long timeout) {
        Thread currThread = Thread.currentThread();
        long startTime = System.currentTimeMillis();
        PersistentResource persistentResource = this;
        synchronized (persistentResource) {
            try {
                while (true) {
                    if (this.owner == currThread) {
                        ++this.nWriters;
                        return true;
                    }
                    if (this.nReaders == 0 && this.nWriters == 0) {
                        this.nWriters = 1;
                        this.owner = currThread;
                        if (this.storage != null) {
                            this.storage.lockObject(this);
                        }
                        return true;
                    }
                    long currTime = System.currentTimeMillis();
                    if (currTime < startTime) {
                        currTime = startTime;
                    }
                    if (startTime + timeout <= currTime) {
                        return false;
                    }
                    this.wait(startTime + timeout - currTime);
                }
            }
            catch (InterruptedException x) {
                return false;
            }
        }
    }

    public synchronized void unlock() {
        if (this.nWriters != 0) {
            if (--this.nWriters == 0) {
                this.owner = null;
                this.notifyAll();
            }
        } else if (this.nReaders != 0 && --this.nReaders == 0) {
            this.notifyAll();
        }
    }

    public synchronized void reset() {
        if (this.nWriters > 0) {
            this.nWriters = 0;
            this.nReaders = 0;
            this.owner = null;
        } else if (this.nReaders > 0) {
            --this.nReaders;
        }
        this.notifyAll();
    }

    public PersistentResource() {
    }

    public PersistentResource(Storage storage) {
        super(storage);
    }
}

